/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.mask;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.AbstractExtentMask;
import com.sk89q.worldedit.function.mask.Mask2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class BlockMask
extends AbstractExtentMask {
    private final Set<BaseBlock> blocks = new HashSet<BaseBlock>();

    public BlockMask(Extent extent, Collection<BaseBlock> blocks) {
        super(extent);
        Preconditions.checkNotNull(blocks);
        this.blocks.addAll(blocks);
    }

    public BlockMask(Extent extent, BaseBlock ... block) {
        this(extent, Arrays.asList((Object[])Preconditions.checkNotNull((Object)block)));
    }

    public void add(Collection<BaseBlock> blocks) {
        Preconditions.checkNotNull(blocks);
        this.blocks.addAll(blocks);
    }

    public void add(BaseBlock ... block) {
        this.add(Arrays.asList((Object[])Preconditions.checkNotNull((Object)block)));
    }

    public Collection<BaseBlock> getBlocks() {
        return this.blocks;
    }

    @Override
    public boolean test(Vector vector) {
        BaseBlock block = this.getExtent().getBlock(vector);
        return this.blocks.contains(block) || this.blocks.contains(new BaseBlock(block.getType(), -1));
    }

    @Override
    @Nullable
    public Mask2D toMask2D() {
        return null;
    }
}

