/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.AbstractPlatform;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.MultiUserPlatform;
import com.sk89q.worldedit.extension.platform.Preference;
import com.sk89q.worldedit.forge.ForgeConfiguration;
import com.sk89q.worldedit.forge.ForgePlayer;
import com.sk89q.worldedit.forge.ForgeWorld;
import com.sk89q.worldedit.forge.ForgeWorldEdit;
import com.sk89q.worldedit.util.command.CommandMapping;
import com.sk89q.worldedit.util.command.Description;
import com.sk89q.worldedit.util.command.Dispatcher;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

class ForgePlatform
extends AbstractPlatform
implements MultiUserPlatform {
    private final ForgeWorldEdit mod;
    private final MinecraftServer server;
    private boolean hookingEvents = false;

    ForgePlatform(ForgeWorldEdit mod) {
        this.mod = mod;
        this.server = FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    boolean isHookingEvents() {
        return this.hookingEvents;
    }

    @Override
    public int resolveItem(String name) {
        Block block;
        if (name == null) {
            return 0;
        }
        int index = name.indexOf(58);
        if (index != -1 && index != 0 && index != name.length() - 1 && (block = Block.func_149684_b((String)name)) != null) {
            return Block.func_149682_b((Block)block);
        }
        for (Object itemObj : Item.field_150901_e) {
            Item item = (Item)itemObj;
            if (item == null || item.func_77658_a() == null) continue;
            if (item.func_77658_a().startsWith("item.") && item.func_77658_a().equalsIgnoreCase("item." + name)) {
                return Item.func_150891_b((Item)item);
            }
            if (item.func_77658_a().startsWith("tile.") && item.func_77658_a().equalsIgnoreCase("tile." + name)) {
                return Item.func_150891_b((Item)item);
            }
            if (!item.func_77658_a().equalsIgnoreCase(name)) continue;
            return Item.func_150891_b((Item)item);
        }
        return 0;
    }

    @Override
    public boolean isValidMobType(String type) {
        return EntityList.field_75625_b.containsKey(type);
    }

    @Override
    public void reload() {
    }

    @Override
    public int schedule(long delay, long period, Runnable task) {
        return -1;
    }

    @Override
    public List<? extends com.sk89q.worldedit.world.World> getWorlds() {
        List<WorldServer> worlds = Arrays.asList(DimensionManager.getWorlds());
        ArrayList<ForgeWorld> ret = new ArrayList<ForgeWorld>(worlds.size());
        for (WorldServer world : worlds) {
            ret.add(new ForgeWorld((World)world));
        }
        return ret;
    }

    @Override
    @Nullable
    public Player matchPlayer(Player player) {
        if (player instanceof ForgePlayer) {
            return player;
        }
        EntityPlayerMP entity = this.server.func_71203_ab().func_152612_a(player.getName());
        return entity != null ? new ForgePlayer(this, entity) : null;
    }

    @Override
    @Nullable
    public com.sk89q.worldedit.world.World matchWorld(com.sk89q.worldedit.world.World world) {
        if (world instanceof ForgeWorld) {
            return world;
        }
        for (WorldServer ws : DimensionManager.getWorlds()) {
            if (!ws.func_72912_H().func_76065_j().equals(world.getName())) continue;
            return new ForgeWorld((World)ws);
        }
        return null;
    }

    @Override
    public void registerCommands(Dispatcher dispatcher) {
        if (this.server == null) {
            return;
        }
        ServerCommandManager mcMan = (ServerCommandManager)this.server.func_71187_D();
        for (final CommandMapping command : dispatcher.getCommands()) {
            final Description description = command.getDescription();
            mcMan.func_71560_a((ICommand)new CommandBase(){

                public String func_71517_b() {
                    return command.getPrimaryAlias();
                }

                public List<String> func_71514_a() {
                    return Arrays.asList(command.getAllAliases());
                }

                public void func_71515_b(ICommandSender var1, String[] var2) {
                }

                public String func_71518_a(ICommandSender icommandsender) {
                    return "/" + command.getPrimaryAlias() + " " + description.getUsage();
                }

                public int func_82362_a() {
                    return 0;
                }

                public boolean func_71519_b(ICommandSender sender) {
                    return true;
                }

                public int compareTo(@Nullable Object o) {
                    if (o == null) {
                        return 0;
                    }
                    if (o instanceof ICommand) {
                        return super.compareTo((ICommand)o);
                    }
                    return 0;
                }
            });
        }
    }

    @Override
    public void registerGameHooks() {
        this.hookingEvents = true;
    }

    @Override
    public ForgeConfiguration getConfiguration() {
        return this.mod.getConfig();
    }

    @Override
    public String getVersion() {
        return this.mod.getInternalVersion();
    }

    @Override
    public String getPlatformName() {
        return "Forge-Official";
    }

    @Override
    public String getPlatformVersion() {
        return this.mod.getInternalVersion();
    }

    @Override
    public Map<Capability, Preference> getCapabilities() {
        EnumMap<Capability, Preference> capabilities = new EnumMap<Capability, Preference>(Capability.class);
        capabilities.put(Capability.CONFIGURATION, Preference.PREFER_OTHERS);
        capabilities.put(Capability.WORLDEDIT_CUI, Preference.NORMAL);
        capabilities.put(Capability.GAME_HOOKS, Preference.NORMAL);
        capabilities.put(Capability.PERMISSIONS, Preference.PREFER_OTHERS);
        capabilities.put(Capability.USER_COMMANDS, Preference.NORMAL);
        capabilities.put(Capability.WORLD_EDITING, Preference.PREFERRED);
        return capabilities;
    }

    @Override
    public Collection<Actor> getConnectedUsers() {
        ArrayList<Actor> users = new ArrayList<Actor>();
        ServerConfigurationManager scm = this.server.func_71203_ab();
        for (String name : scm.func_72369_d()) {
            EntityPlayerMP entity = scm.func_152612_a(name);
            if (entity == null) continue;
            users.add(new ForgePlayer(this, entity));
        }
        return users;
    }
}

