/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.gen.component;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockBobble;
import com.hbm.lib.HbmChestContents;
import com.hbm.util.LootGenerator;
import com.hbm.world.gen.component.Component;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemDoor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class CivilianFeatures {
    public static void registerComponents() {
        MapGenStructureIO.func_143031_a(NTMHouse1.class, (String)"NTMHouse1");
        MapGenStructureIO.func_143031_a(NTMHouse2.class, (String)"NTMHouse2");
        MapGenStructureIO.func_143031_a(NTMLab1.class, (String)"NTMLab1");
        MapGenStructureIO.func_143031_a(NTMLab2.class, (String)"NTMLab2");
        MapGenStructureIO.func_143031_a(NTMWorkshop1.class, (String)"NTMWorkshop1");
    }

    public static class NTMWorkshop1
    extends Component {
        private static Component.SuperConcrete RandomSuperConcrete = new Component.SuperConcrete();
        private boolean hasPlacedLoot;

        public NTMWorkshop1() {
        }

        public NTMWorkshop1(Random rand, int minX, int minY, int minZ) {
            super(rand, minX, minY, minZ, 10, 6, 8);
            this.hasPlacedLoot = false;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74757_a("hasLoot", this.hasPlacedLoot);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt) {
            super.func_143011_b(nbt);
            this.hasPlacedLoot = nbt.func_74767_n("hasLoot");
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (!this.setAverageHeight(world, box, this.field_74887_e.field_78895_b)) {
                return false;
            }
            this.placeFoundationUnderneath(world, Blocks.field_150417_aV, 0, 1, 0, this.sizeX - 3, this.sizeZ, -1, box);
            this.placeFoundationUnderneath(world, Blocks.field_150346_d, 0, 8, 1, this.sizeX, 6, -1, box);
            this.func_74878_a(world, box, 1, 0, 0, this.sizeX - 3, this.sizeY - 2, this.sizeZ);
            this.func_74878_a(world, box, this.sizeX - 2, 0, 2, this.sizeX - 1, 2, 5);
            if (this.func_151548_a(world, 0, 0, 5, box).func_149688_o().func_76222_j() || this.func_151548_a(world, 0, 0, 5, box) == Blocks.field_150350_a) {
                int stairMeta = this.func_151555_a(Blocks.field_150390_bg, 1);
                this.func_151550_a(world, Blocks.field_150390_bg, stairMeta, 0, 0, 5, box);
                this.placeFoundationUnderneath(world, Blocks.field_150417_aV, 0, 0, 1, 0, this.sizeZ - 1, -1, box);
                this.func_151556_a(world, box, 0, 0, 1, 0, 0, this.sizeZ - 1, (Block)Blocks.field_150333_U, 5, Blocks.field_150350_a, 0, false);
            }
            int pillarMetaWE = this.getPillarMeta(4);
            int pillarMetaNS = this.getPillarMeta(8);
            this.func_151549_a(world, box, 1, 0, 0, 1, 3, 0, ModBlocks.concrete_pillar, Blocks.field_150350_a, false);
            this.func_151550_a(world, ModBlocks.concrete, 0, 1, 4, 0, box);
            this.func_151556_a(world, box, 2, 4, 0, this.sizeX - 4, 4, 0, ModBlocks.concrete_pillar, pillarMetaWE, Blocks.field_150350_a, 0, false);
            this.func_151550_a(world, ModBlocks.concrete, 0, this.sizeX - 3, 4, 0, box);
            this.func_151549_a(world, box, this.sizeX - 3, 0, 0, this.sizeX - 3, 3, 0, ModBlocks.concrete_pillar, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 2, 0, 0, this.sizeX - 4, 1, 0, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, 2, 2, 0, 2, 2, 0, false, rand, RandomSuperConcrete);
            this.func_151549_a(world, box, 3, 2, 0, 5, 2, 0, ModBlocks.reinforced_glass, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, this.sizeX - 4, 2, 0, this.sizeX - 4, 2, 0, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, 2, 3, 0, this.sizeX - 4, 3, 0, false, rand, RandomSuperConcrete);
            this.func_151556_a(world, box, 1, 4, 1, 1, 4, this.sizeZ - 1, ModBlocks.concrete_pillar, pillarMetaNS, Blocks.field_150350_a, 0, false);
            this.func_151550_a(world, ModBlocks.concrete, 0, 1, 4, this.sizeZ, box);
            this.func_151549_a(world, box, 1, 0, this.sizeZ, 1, 3, this.sizeZ, ModBlocks.concrete_pillar, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 1, 0, 1, 1, 1, 4, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, 1, 2, 1, 1, 2, 1, false, rand, RandomSuperConcrete);
            this.func_151549_a(world, box, 1, 2, 2, 1, 2, 3, ModBlocks.reinforced_glass, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 1, 2, 4, 1, 2, 4, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, 1, 3, 1, 1, 3, this.sizeZ - 1, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, 1, 0, this.sizeZ - 2, 1, 3, this.sizeZ - 1, false, rand, RandomSuperConcrete);
            this.func_151556_a(world, box, 2, 4, this.sizeZ, this.sizeX - 4, 4, this.sizeZ, ModBlocks.concrete_pillar, pillarMetaWE, Blocks.field_150350_a, 0, false);
            this.func_151550_a(world, ModBlocks.concrete, 0, this.sizeX - 3, 4, this.sizeZ, box);
            this.func_151549_a(world, box, this.sizeX - 3, 0, this.sizeZ, this.sizeX - 3, 3, this.sizeZ, ModBlocks.concrete_pillar, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 2, 0, this.sizeZ, this.sizeX - 4, 1, this.sizeZ, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, 2, 2, this.sizeZ, 2, 2, this.sizeZ, false, rand, RandomSuperConcrete);
            this.func_151549_a(world, box, 3, 2, this.sizeZ, 5, 2, this.sizeZ, ModBlocks.reinforced_glass, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, this.sizeX - 4, 2, this.sizeZ, this.sizeX - 4, 2, this.sizeZ, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, 2, 3, this.sizeZ, this.sizeX - 4, 3, this.sizeZ, false, rand, RandomSuperConcrete);
            this.func_151556_a(world, box, this.sizeX - 3, 4, 1, this.sizeX - 3, 4, this.sizeZ - 1, ModBlocks.concrete_pillar, pillarMetaNS, Blocks.field_150350_a, 0, false);
            this.func_74882_a(world, box, this.sizeX - 3, 0, 1, this.sizeX - 3, 3, this.sizeZ - 1, false, rand, RandomSuperConcrete);
            pillarMetaWE = this.getPillarMeta(5);
            pillarMetaNS = this.getPillarMeta(9);
            this.func_151556_a(world, box, this.sizeX - 2, 2, 1, this.sizeX - 1, 2, 1, Blocks.field_150364_r, pillarMetaWE, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, this.sizeX, 0, 1, this.sizeX, 2, 1, Blocks.field_150364_r, 1, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, this.sizeX - 2, 0, 1, this.sizeX - 1, 1, 1, Blocks.field_150344_f, 1, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, this.sizeX, 2, 2, this.sizeX, 2, 5, Blocks.field_150364_r, pillarMetaNS, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, this.sizeX, 0, 6, this.sizeX, 2, 6, Blocks.field_150364_r, 1, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, this.sizeX, 0, 3, this.sizeX, 1, 5, Blocks.field_150344_f, 1, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, this.sizeX - 2, 2, 6, this.sizeX - 1, 2, 6, Blocks.field_150364_r, pillarMetaWE, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, this.sizeX - 2, 0, 6, this.sizeX - 1, 1, 6, Blocks.field_150344_f, 1, Blocks.field_150350_a, 0, false);
            this.func_151549_a(world, box, 2, 0, 1, 6, 0, this.sizeZ - 1, ModBlocks.brick_light, Blocks.field_150350_a, false);
            this.func_151550_a(world, ModBlocks.brick_light, 0, 1, 0, 5, box);
            this.func_74882_a(world, box, 2, 4, 1, 6, 4, 3, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, 2, 4, 4, 2, 4, 4, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, 5, 4, 4, 6, 4, 4, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, 2, 4, this.sizeZ - 3, 6, 4, this.sizeZ - 1, false, rand, RandomSuperConcrete);
            this.func_151549_a(world, box, this.sizeX - 2, 2, 2, this.sizeX - 1, 2, 5, ModBlocks.deco_steel, Blocks.field_150350_a, false);
            int southMeta = this.getDecoMeta(2);
            int eastMeta = this.getDecoMeta(5);
            this.func_151550_a(world, ModBlocks.pole_satellite_receiver, eastMeta, 2, this.sizeY - 1, 1, box);
            this.func_151549_a(world, box, 3, this.sizeY - 1, 1, 4, this.sizeY - 1, 1, ModBlocks.deco_steel, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 2, this.sizeY - 1, 2, 4, this.sizeY - 1, 2, ModBlocks.deco_steel, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 2, this.sizeY, 1, 4, this.sizeY, 2, ModBlocks.steel_roof, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 2, 1, 1, 2, 3, 1, ModBlocks.deco_red_copper, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 3, 1, 1, 3, 1, 2, ModBlocks.deco_beryllium, Blocks.field_150350_a, false);
            this.func_151550_a(world, ModBlocks.machine_generator, 0, 4, 1, 1, box);
            this.func_151550_a(world, ModBlocks.machine_detector, 0, 4, 1, 2, box);
            this.func_151549_a(world, box, 5, 1, 1, 5, 1, 2, ModBlocks.deco_beryllium, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 6, 1, 1, 6, 3, 1, ModBlocks.deco_red_copper, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 3, 1, 4, 4, 1, 4, ModBlocks.concrete_super_broken, Blocks.field_150350_a, false);
            this.func_151556_a(world, box, 6, 1, 4, 6, 3, 4, ModBlocks.steel_scaffold, eastMeta < 4 ? 0 : 8, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 6, 1, 5, 6, 1, 7, ModBlocks.steel_grate, 7, Blocks.field_150350_a, 0, false);
            this.func_151550_a(world, ModBlocks.radiorec, eastMeta, 6, 2, this.sizeZ - 1, box);
            this.func_151556_a(world, box, 2, 1, this.sizeZ - 1, 3, 1, this.sizeZ - 1, ModBlocks.machine_electric_furnace_off, southMeta, Blocks.field_150350_a, 0, false);
            if (!this.hasPlacedLoot) {
                this.hasPlacedLoot = this.generateInvContents(world, box, rand, ModBlocks.crate_iron, 4, 1, this.sizeZ - 1, HbmChestContents.machineParts, 11);
            }
            this.func_151550_a(world, Blocks.field_150321_G, 0, 5, 3, 1, box);
            this.func_151550_a(world, Blocks.field_150321_G, 0, 2, 1, 2, box);
            this.func_151550_a(world, Blocks.field_150321_G, 0, 6, 1, 2, box);
            this.func_151550_a(world, Blocks.field_150321_G, 0, 6, 2, 5, box);
            this.func_151556_a(world, box, this.sizeX - 2, 0, 5, this.sizeX - 1, 0, 5, ModBlocks.steel_grate, 7, Blocks.field_150350_a, 0, false);
            this.func_151550_a(world, ModBlocks.tape_recorder, southMeta, this.sizeX - 2, 1, 5, box);
            this.func_151550_a(world, ModBlocks.bobblehead, rand.nextInt(16), this.sizeX - 1, 1, 5, box);
            BlockBobble.TileEntityBobble bobble = (BlockBobble.TileEntityBobble)world.func_147438_o(this.func_74865_a(this.sizeX - 1, 5), this.func_74862_a(1), this.func_74873_b(this.sizeX - 1, 5));
            if (bobble != null) {
                bobble.type = BlockBobble.BobbleType.values()[rand.nextInt(BlockBobble.BobbleType.values().length - 1) + 1];
                bobble.func_70296_d();
            }
            this.func_151556_a(world, box, this.sizeX - 2, 0, 2, this.sizeX - 2, 0, 3, Blocks.field_150364_r, pillarMetaWE, Blocks.field_150350_a, 0, false);
            this.func_151550_a(world, Blocks.field_150364_r, pillarMetaWE, this.sizeX - 2, 1, 2, box);
            this.func_151550_a(world, Blocks.field_150321_G, 0, this.sizeX - 2, 1, 3, box);
            return true;
        }
    }

    public static class NTMLab2
    extends Component {
        private static Component.SuperConcrete RandomSuperConcrete = new Component.SuperConcrete();
        private static Component.ConcreteBricks RandomConcreteBricks = new Component.ConcreteBricks();
        private static Component.LabTiles RandomLabTiles = new Component.LabTiles();
        private boolean[] hasPlacedLoot = new boolean[2];

        public NTMLab2() {
        }

        public NTMLab2(Random rand, int minX, int minY, int minZ) {
            super(rand, minX, minY, minZ, 12, 11, 8);
            this.hasPlacedLoot[0] = false;
            this.hasPlacedLoot[1] = false;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74757_a("hasLoot1", this.hasPlacedLoot[0]);
            nbt.func_74757_a("hasLoot2", this.hasPlacedLoot[1]);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt) {
            super.func_143011_b(nbt);
            this.hasPlacedLoot[0] = nbt.func_74767_n("hasLoot1");
            this.hasPlacedLoot[1] = nbt.func_74767_n("hasLoot2");
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (!this.setAverageHeight(world, box, this.field_74887_e.field_78895_b)) {
                return false;
            }
            this.field_74887_e.func_78886_a(0, -7, 0);
            this.placeFoundationUnderneath(world, Blocks.field_150417_aV, 0, 0, 0, this.sizeX, this.sizeZ - 2, 6, box);
            this.placeFoundationUnderneath(world, Blocks.field_150417_aV, 0, 0, 7, 6, this.sizeZ, 6, box);
            if (this.func_151548_a(world, this.sizeX - 3, this.sizeY - 4, 7, box).func_149688_o().func_76222_j() || this.func_151548_a(world, this.sizeX - 3, this.sizeY - 4, 7, box) == Blocks.field_150350_a) {
                int stairMeta = this.func_151555_a(Blocks.field_150390_bg, 2);
                this.placeFoundationUnderneath(world, Blocks.field_150417_aV, 0, this.sizeX - 3, 7, this.sizeX - 2, 7, this.sizeY - 4, box);
                this.func_151556_a(world, box, this.sizeX - 3, this.sizeY - 4, 7, this.sizeX - 2, this.sizeY - 4, 7, Blocks.field_150390_bg, stairMeta, Blocks.field_150350_a, 0, false);
            }
            this.func_74878_a(world, box, 1, this.sizeY - 4, 1, this.sizeX - 1, this.sizeY, this.sizeZ - 3);
            this.func_74878_a(world, box, 1, this.sizeY - 4, this.sizeZ - 2, 5, this.sizeY, this.sizeZ - 1);
            this.func_74878_a(world, box, this.sizeX - 3, this.sizeY - 3, this.sizeZ - 2, this.sizeX - 2, this.sizeY - 2, this.sizeZ - 2);
            this.func_74878_a(world, box, 5, 5, 1, 6, 6, 2);
            this.func_74878_a(world, box, 2, 0, 2, this.sizeX - 2, 3, this.sizeZ - 2);
            this.func_74882_a(world, box, 0, this.sizeY - 4, 0, this.sizeX, this.sizeY, 0, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, 0, this.sizeY - 4, 0, 0, this.sizeY, this.sizeZ, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, 1, this.sizeY - 4, this.sizeZ, 5, this.sizeY - 4, this.sizeZ, false, rand, RandomSuperConcrete);
            this.func_151549_a(world, box, 1, this.sizeY - 3, this.sizeZ, 1, this.sizeY - 1, this.sizeZ, ModBlocks.reinforced_glass, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 2, this.sizeY - 4, this.sizeZ, 2, this.sizeY - 1, this.sizeZ, false, rand, RandomSuperConcrete);
            this.func_151549_a(world, box, 3, this.sizeY - 3, this.sizeZ, 3, this.sizeY - 1, this.sizeZ, ModBlocks.reinforced_glass, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 4, this.sizeY - 4, this.sizeZ, 4, this.sizeY - 1, this.sizeZ, false, rand, RandomSuperConcrete);
            this.func_151549_a(world, box, 5, this.sizeY - 3, this.sizeZ, 5, this.sizeY - 1, this.sizeZ, ModBlocks.reinforced_glass, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 1, this.sizeY, this.sizeZ, 5, this.sizeY, this.sizeZ, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, 6, this.sizeY - 4, this.sizeZ - 1, 6, this.sizeY, this.sizeZ, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, 6, this.sizeY - 4, this.sizeZ - 2, 7, this.sizeY - 2, this.sizeZ - 2, false, rand, RandomSuperConcrete);
            this.func_151549_a(world, box, 6, this.sizeY - 1, this.sizeZ - 2, 7, this.sizeY - 1, this.sizeZ - 2, ModBlocks.concrete_super_broken, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, this.sizeX - 4, this.sizeY - 4, this.sizeZ - 2, this.sizeX, this.sizeY - 4, this.sizeZ - 2, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, this.sizeX - 4, this.sizeY - 3, this.sizeZ - 2, this.sizeX - 4, this.sizeY, this.sizeZ - 2, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, this.sizeX - 3, this.sizeY - 1, this.sizeZ - 2, this.sizeX - 2, this.sizeY, this.sizeZ - 2, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, this.sizeX - 1, this.sizeY - 4, this.sizeZ - 2, this.sizeX, this.sizeY, this.sizeZ - 2, false, rand, RandomSuperConcrete);
            this.func_74882_a(world, box, this.sizeX, this.sizeY - 4, 1, this.sizeX, this.sizeY - 4, this.sizeZ - 3, false, rand, RandomSuperConcrete);
            this.func_151549_a(world, box, this.sizeX, this.sizeY - 3, this.sizeZ - 3, this.sizeX, this.sizeY - 1, this.sizeZ - 3, ModBlocks.reinforced_glass, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, this.sizeX, this.sizeY - 3, 4, this.sizeX, this.sizeY - 1, 4, false, rand, RandomSuperConcrete);
            this.func_151549_a(world, box, this.sizeX, this.sizeY - 3, 3, this.sizeX, this.sizeY - 1, 3, ModBlocks.reinforced_glass, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, this.sizeX, this.sizeY - 3, 2, this.sizeX, this.sizeY - 1, 2, false, rand, RandomSuperConcrete);
            this.func_151549_a(world, box, this.sizeX, this.sizeY - 3, 1, this.sizeX, this.sizeY - 1, 1, ModBlocks.reinforced_glass, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, this.sizeX, this.sizeY, 1, this.sizeX, this.sizeY, this.sizeZ - 3, false, rand, RandomSuperConcrete);
            this.func_151549_a(world, box, 1, 0, 1, this.sizeX - 1, 3, 1, ModBlocks.reinforced_stone, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 1, 0, 2, 1, 3, this.sizeZ - 2, ModBlocks.reinforced_stone, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 1, 0, this.sizeZ - 1, this.sizeX - 1, 3, this.sizeZ - 1, ModBlocks.reinforced_stone, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, this.sizeX - 1, 0, 2, this.sizeX - 1, 3, this.sizeZ - 2, ModBlocks.reinforced_stone, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 6, 0, 3, 6, 3, this.sizeZ - 2, ModBlocks.reinforced_stone, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 1, this.sizeY - 4, 1, 3, this.sizeY - 4, this.sizeZ - 1, false, rand, RandomLabTiles);
            this.func_74882_a(world, box, 4, this.sizeY - 4, this.sizeZ - 2, 5, this.sizeY - 4, this.sizeZ - 1, false, rand, RandomLabTiles);
            this.func_74882_a(world, box, this.sizeX - 4, this.sizeY - 4, 1, this.sizeX - 1, this.sizeY - 4, this.sizeZ - 3, false, rand, RandomLabTiles);
            this.func_74882_a(world, box, this.sizeX - 3, this.sizeY - 4, this.sizeZ - 2, this.sizeX - 2, this.sizeY - 4, this.sizeZ - 2, false, rand, RandomLabTiles);
            this.func_151549_a(world, box, 4, this.sizeY - 4, 1, 7, this.sizeY - 4, 1, ModBlocks.tile_lab_broken, Blocks.field_150350_a, false);
            this.func_151550_a(world, ModBlocks.tile_lab_broken, 0, 4, this.sizeY - 4, 2, box);
            this.func_151549_a(world, box, 4, this.sizeY - 4, 3, 4, this.sizeY - 4, 5, ModBlocks.tile_lab_cracked, Blocks.field_150350_a, false);
            this.func_151550_a(world, ModBlocks.tile_lab_broken, 0, 5, this.sizeY - 4, 3, box);
            this.func_151549_a(world, box, 5, this.sizeY - 4, 4, 5, this.sizeY - 4, 5, ModBlocks.tile_lab_cracked, Blocks.field_150350_a, false);
            this.func_151550_a(world, ModBlocks.tile_lab_broken, 0, 6, this.sizeY - 4, 4, box);
            this.func_151550_a(world, ModBlocks.tile_lab_cracked, 0, 6, this.sizeY - 4, 5, box);
            this.func_151549_a(world, box, 7, this.sizeY - 4, 2, 7, this.sizeY - 4, 3, ModBlocks.tile_lab_broken, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 7, this.sizeY - 4, 4, 7, this.sizeY - 4, 5, ModBlocks.tile_lab_cracked, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 1, this.sizeY, 1, 2, this.sizeY, this.sizeZ - 1, ModBlocks.brick_light, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 3, this.sizeY, this.sizeZ - 2, 4, this.sizeY, this.sizeZ - 1, ModBlocks.brick_light, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, this.sizeX - 3, this.sizeY, 1, this.sizeX - 1, this.sizeY, this.sizeZ - 3, ModBlocks.brick_light, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 3, this.sizeY, 1, 8, this.sizeY, 1, ModBlocks.waste_planks, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 3, this.sizeY, 2, 4, this.sizeY, 2, ModBlocks.waste_planks, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 7, this.sizeY, 2, 8, this.sizeY, 2, ModBlocks.waste_planks, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 3, this.sizeY, 3, 3, this.sizeY, 5, ModBlocks.waste_planks, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 4, this.sizeY, 4, 4, this.sizeY, 5, ModBlocks.waste_planks, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 5, this.sizeY, 6, 5, this.sizeY, this.sizeZ - 1, ModBlocks.waste_planks, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 8, this.sizeY, 3, 8, this.sizeY, 5, ModBlocks.waste_planks, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 2, 0, 2, 5, 0, this.sizeZ - 2, false, rand, RandomLabTiles);
            this.func_74882_a(world, box, 6, 0, 2, 6, 0, 3, false, rand, RandomLabTiles);
            this.func_74882_a(world, box, 7, 0, 2, this.sizeX - 2, 0, this.sizeZ - 2, false, rand, RandomLabTiles);
            this.func_74882_a(world, box, 1, 4, 1, this.sizeX - 1, 4, this.sizeZ - 1, false, rand, RandomConcreteBricks);
            int eastMeta = this.getDecoMeta(4);
            int westMeta = this.getDecoMeta(5);
            int northMeta = this.getDecoMeta(3);
            int southMeta = this.getDecoMeta(2);
            this.func_151550_a(world, ModBlocks.crashed_balefire, southMeta, 6, this.sizeY - 2, 3, box);
            int doorMeta = this.func_151555_a(Blocks.field_150466_ao, 1);
            this.func_151550_a(world, ModBlocks.door_office, doorMeta, this.sizeX - 3, this.sizeY - 3, this.sizeZ - 2, box);
            ItemDoor.func_150924_a((World)world, (int)this.func_74865_a(this.sizeX - 3, this.sizeZ - 2), (int)this.func_74862_a(this.sizeY - 3), (int)this.func_74873_b(this.sizeX - 3, this.sizeZ - 2), (int)doorMeta, (Block)ModBlocks.door_office);
            this.func_151550_a(world, ModBlocks.door_office, doorMeta, this.sizeX - 2, this.sizeY - 3, this.sizeZ - 2, box);
            ItemDoor.func_150924_a((World)world, (int)this.func_74865_a(this.sizeX - 2, this.sizeZ - 2), (int)this.func_74862_a(this.sizeY - 3), (int)this.func_74873_b(this.sizeX - 2, this.sizeZ - 2), (int)doorMeta, (Block)ModBlocks.door_office);
            this.func_151549_a(world, box, 1, this.sizeY - 3, 1, 1, this.sizeY - 1, 1, ModBlocks.deco_steel, Blocks.field_150350_a, false);
            this.func_151556_a(world, box, 1, this.sizeY - 3, 2, 1, this.sizeY - 2, 3, ModBlocks.steel_grate, 7, Blocks.field_150350_a, 0, false);
            this.func_151550_a(world, ModBlocks.tape_recorder, westMeta, 1, this.sizeY - 1, 2, box);
            this.func_151550_a(world, ModBlocks.steel_beam, 0, 1, this.sizeY - 1, 3, box);
            this.func_151549_a(world, box, 1, this.sizeY - 3, 6, 1, this.sizeY - 1, 6, ModBlocks.deco_pipe_framed_rusted, Blocks.field_150350_a, false);
            this.func_151556_a(world, box, this.sizeX - 4, this.sizeY - 3, 1, this.sizeX - 4, this.sizeY - 1, 1, ModBlocks.steel_wall, eastMeta, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, this.sizeX - 3, this.sizeY - 1, 1, this.sizeX - 2, this.sizeY - 1, 1, ModBlocks.steel_grate, 0, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, this.sizeX - 3, this.sizeY - 2, 1, this.sizeX - 2, this.sizeY - 2, 1, ModBlocks.tape_recorder, northMeta, Blocks.field_150350_a, 0, false);
            this.func_151549_a(world, box, this.sizeX - 3, this.sizeY - 3, 1, this.sizeX - 2, this.sizeY - 3, 1, ModBlocks.deco_steel, Blocks.field_150350_a, false);
            this.func_151556_a(world, box, this.sizeX - 1, this.sizeY - 3, 1, this.sizeX - 1, this.sizeY - 1, 1, ModBlocks.steel_wall, westMeta, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 2, 1, 2, 2, 1, this.sizeZ - 2, ModBlocks.steel_grate, 7, Blocks.field_150350_a, 0, false);
            this.func_151550_a(world, ModBlocks.vitrified_barrel, 0, 2, 2, 2, box);
            this.func_151556_a(world, box, 3, 1, 2, 3, 3, 2, ModBlocks.steel_wall, westMeta, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 3, 1, 4, 3, 3, 4, ModBlocks.steel_wall, westMeta, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 3, 1, this.sizeZ - 2, 3, 3, this.sizeZ - 2, ModBlocks.steel_wall, westMeta, Blocks.field_150350_a, 0, false);
            this.func_151550_a(world, ModBlocks.crate, 0, 4, 1, this.sizeZ - 2, box);
            this.func_151550_a(world, ModBlocks.crate_lead, 0, 4, 2, this.sizeZ - 2, box);
            if (!this.hasPlacedLoot[0]) {
                this.hasPlacedLoot[0] = this.generateInvContents(world, box, rand, ModBlocks.crate_iron, 5, 1, this.sizeZ - 2, HbmChestContents.nuclearFuel, 10);
            }
            this.func_151549_a(world, box, 4, 1, this.sizeZ - 3, 5, 1, this.sizeZ - 3, ModBlocks.crate_lead, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, this.sizeX - 5, 1, this.sizeZ - 2, this.sizeX - 5, 3, this.sizeZ - 2, ModBlocks.deco_steel, Blocks.field_150350_a, false);
            this.func_151556_a(world, box, this.sizeX - 4, 1, this.sizeZ - 2, this.sizeX - 2, 1, this.sizeZ - 2, ModBlocks.steel_grate, 7, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, this.sizeX - 4, 2, this.sizeZ - 2, this.sizeX - 3, 2, this.sizeZ - 2, ModBlocks.tape_recorder, southMeta, Blocks.field_150350_a, 0, false);
            this.func_151550_a(world, ModBlocks.steel_beam, 0, this.sizeX - 2, 2, this.sizeZ - 2, box);
            this.func_151549_a(world, box, this.sizeX - 4, 3, this.sizeZ - 2, this.sizeX - 2, 3, this.sizeZ - 2, ModBlocks.steel_roof, Blocks.field_150350_a, false);
            if (!this.hasPlacedLoot[1]) {
                this.hasPlacedLoot[1] = this.generateInvContents(world, box, rand, ModBlocks.crate_iron, this.sizeX - 2, 1, 3, HbmChestContents.nukeTrash, 9);
                if (rand.nextInt(2) == 0) {
                    this.generateLoreBook(world, box, this.sizeX - 2, 1, 3, 1, HbmChestContents.generateOfficeBook(rand));
                }
            }
            return true;
        }
    }

    public static class NTMLab1
    extends Component {
        private static Component.ConcreteBricks RandomConcreteBricks = new Component.ConcreteBricks();
        private static Component.LabTiles RandomLabTiles = new Component.LabTiles();
        private boolean[] hasPlacedLoot = new boolean[2];

        public NTMLab1() {
        }

        public NTMLab1(Random rand, int minX, int minY, int minZ) {
            super(rand, minX, minY, minZ, 9, 4, 7);
            this.hasPlacedLoot[0] = false;
            this.hasPlacedLoot[1] = false;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74757_a("hasLoot1", this.hasPlacedLoot[0]);
            nbt.func_74757_a("hasLoot2", this.hasPlacedLoot[1]);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt) {
            super.func_143011_b(nbt);
            this.hasPlacedLoot[0] = nbt.func_74767_n("hasLoot1");
            this.hasPlacedLoot[1] = nbt.func_74767_n("hasLoot2");
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (!this.setAverageHeight(world, box, this.field_74887_e.field_78895_b)) {
                return false;
            }
            this.placeFoundationUnderneath(world, Blocks.field_150417_aV, 0, 0, 0, this.sizeX, this.sizeZ - 2, -1, box);
            this.placeFoundationUnderneath(world, Blocks.field_150417_aV, 0, 3, 6, this.sizeX, this.sizeZ, -1, box);
            if (this.func_151548_a(world, 2, 0, this.sizeZ - 1, box).func_149688_o().func_76222_j() || this.func_151548_a(world, 2, 0, this.sizeZ - 1, box) == Blocks.field_150350_a) {
                this.placeFoundationUnderneath(world, Blocks.field_150417_aV, 0, 2, this.sizeZ - 1, 2, this.sizeZ - 1, -1, box);
                this.func_151550_a(world, Blocks.field_150390_bg, this.getStairMeta(0), 2, 0, this.sizeZ - 1, box);
            }
            this.func_74878_a(world, box, 1, 0, 1, this.sizeX - 1, this.sizeY, 4);
            this.func_74878_a(world, box, 4, 0, 4, this.sizeX - 1, this.sizeY, this.sizeZ - 1);
            this.func_74878_a(world, box, 3, 1, this.sizeZ - 1, 3, 2, this.sizeZ - 1);
            int pillarMeta = this.getPillarMeta(8);
            this.func_151549_a(world, box, 0, 0, 0, 0, 3, 0, ModBlocks.concrete_pillar, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, this.sizeX, 0, 0, this.sizeX, 3, 0, ModBlocks.concrete_pillar, Blocks.field_150350_a, false);
            this.func_151556_a(world, box, 0, 0, 1, 0, 0, 4, ModBlocks.concrete_pillar, pillarMeta, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, this.sizeX, 0, 1, this.sizeX, 0, this.sizeZ - 1, ModBlocks.concrete_pillar, pillarMeta, Blocks.field_150350_a, 0, false);
            this.func_151549_a(world, box, 0, 0, this.sizeZ - 2, 0, 3, this.sizeZ - 2, ModBlocks.concrete_pillar, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 3, 0, this.sizeZ - 2, 3, 3, this.sizeZ - 2, ModBlocks.concrete_pillar, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 3, 0, this.sizeZ, 3, 3, this.sizeZ, ModBlocks.concrete_pillar, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, this.sizeX, 0, this.sizeZ, this.sizeX, 3, this.sizeZ, ModBlocks.concrete_pillar, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 1, 0, 0, this.sizeX - 1, this.sizeY - 1, 0, false, rand, RandomConcreteBricks);
            this.func_74882_a(world, box, 0, this.sizeY, 0, this.sizeX, this.sizeY, 0, false, rand, RandomConcreteBricks);
            this.func_74882_a(world, box, 0, 1, 1, 0, this.sizeY - 1, 4, false, rand, RandomConcreteBricks);
            this.func_74882_a(world, box, 0, this.sizeY, 0, 0, this.sizeY, this.sizeZ - 2, false, rand, RandomConcreteBricks);
            this.func_74882_a(world, box, 1, 0, this.sizeZ - 2, 2, this.sizeY, this.sizeZ - 2, false, rand, RandomConcreteBricks);
            this.func_151550_a(world, ModBlocks.brick_concrete_broken, 0, 3, this.sizeY, this.sizeZ - 2, box);
            this.func_74882_a(world, box, 3, this.sizeY - 1, this.sizeZ - 1, 3, this.sizeY, this.sizeZ - 1, false, rand, RandomConcreteBricks);
            this.func_74882_a(world, box, 4, 0, this.sizeZ, this.sizeX - 1, 1, this.sizeZ, false, rand, RandomConcreteBricks);
            this.func_74882_a(world, box, 4, 2, this.sizeZ, 4, 3, this.sizeZ, false, rand, RandomConcreteBricks);
            this.func_74882_a(world, box, this.sizeX - 1, 2, this.sizeZ, this.sizeX - 1, 3, this.sizeZ, false, rand, RandomConcreteBricks);
            this.func_151551_a(world, box, rand, 0.75f, 5, 2, this.sizeZ, this.sizeX - 2, 3, this.sizeZ, Blocks.field_150410_aZ, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 3, this.sizeY, this.sizeZ, this.sizeX, this.sizeY, this.sizeZ, false, rand, RandomConcreteBricks);
            this.func_74882_a(world, box, this.sizeX, 1, 1, this.sizeX, this.sizeY, this.sizeZ - 1, false, rand, RandomConcreteBricks);
            this.func_74882_a(world, box, 1, 0, 1, this.sizeX - 1, 0, 4, false, rand, RandomLabTiles);
            this.func_74882_a(world, box, 4, 0, this.sizeZ - 2, this.sizeX - 1, 0, this.sizeZ - 1, false, rand, RandomLabTiles);
            this.func_151550_a(world, ModBlocks.tile_lab_cracked, 0, 3, 0, this.sizeZ - 1, box);
            this.func_151549_a(world, box, 1, this.sizeY - 1, 1, 1, this.sizeY, 4, ModBlocks.reinforced_glass, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 2, this.sizeY, 1, this.sizeX - 1, this.sizeY, 4, ModBlocks.brick_light, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 4, this.sizeY, this.sizeZ - 2, this.sizeX - 1, this.sizeY, this.sizeZ - 1, ModBlocks.brick_light, Blocks.field_150350_a, false);
            this.func_151556_a(world, box, 1, 1, 1, 1, 1, 4, Blocks.field_150346_d, 2, Blocks.field_150350_a, 0, false);
            int westDecoMeta = this.getDecoMeta(5);
            this.func_151556_a(world, box, 2, 1, 1, 2, 1, 4, ModBlocks.steel_wall, westDecoMeta, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 2, this.sizeY - 1, 1, 2, this.sizeY - 1, 4, ModBlocks.steel_wall, westDecoMeta, Blocks.field_150350_a, 0, false);
            for (int i = 0; i < 4; i = (int)((byte)(i + 1))) {
                this.func_151550_a(world, ModBlocks.plant_flower, i, 1, 2, 1 + i, box);
            }
            int doorMeta = this.func_151555_a(Blocks.field_150466_ao, 2);
            this.func_151550_a(world, ModBlocks.door_office, doorMeta, 3, 1, this.sizeZ - 1, box);
            ItemDoor.func_150924_a((World)world, (int)this.func_74865_a(3, this.sizeZ - 1), (int)this.func_74862_a(1), (int)this.func_74873_b(3, this.sizeZ - 1), (int)doorMeta, (Block)ModBlocks.door_office);
            int northDecoMeta = this.getDecoMeta(3);
            this.func_151556_a(world, box, 5, this.sizeY - 1, 1, this.sizeX - 1, this.sizeY - 1, 1, ModBlocks.steel_scaffold, westDecoMeta < 4 ? 0 : 8, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 5, this.sizeY - 1, 2, this.sizeX - 1, this.sizeY - 1, 2, ModBlocks.steel_wall, northDecoMeta, Blocks.field_150350_a, 0, false);
            this.func_151550_a(world, ModBlocks.machine_electric_furnace_off, northDecoMeta, 5, 1, 1, box);
            this.func_151550_a(world, ModBlocks.machine_microwave, northDecoMeta, 5, 2, 1, box);
            this.func_151550_a(world, ModBlocks.deco_titanium, 0, 6, 1, 1, box);
            this.func_151550_a(world, ModBlocks.machine_shredder, 0, this.sizeX - 2, 1, 1, box);
            this.func_151550_a(world, ModBlocks.deco_titanium, 0, this.sizeX - 1, 1, 1, box);
            this.func_151549_a(world, box, 5, 1, 3, this.sizeX - 1, 1, 3, ModBlocks.deco_titanium, Blocks.field_150350_a, false);
            if (!this.hasPlacedLoot[0]) {
                this.func_151550_a(world, ModBlocks.deco_loot, 0, 6, 2, 3, box);
                LootGenerator.lootMedicine(world, this.func_74865_a(6, 3), this.func_74862_a(2), this.func_74873_b(6, 3));
                this.hasPlacedLoot[0] = true;
            }
            this.func_151550_a(world, ModBlocks.crate_can, 0, this.sizeX - 1, 1, this.sizeZ - 2, box);
            if (!this.hasPlacedLoot[1]) {
                this.hasPlacedLoot[1] = this.generateInvContents(world, box, rand, ModBlocks.crate_iron, this.sizeX - 1, 1, this.sizeZ - 1, HbmChestContents.modGeneric, 8);
            }
            return true;
        }
    }

    public static class NTMHouse2
    extends Component {
        private static Component.Sandstone RandomSandstone = new Component.Sandstone();
        private boolean[] hasPlacedLoot = new boolean[2];

        public NTMHouse2() {
        }

        public NTMHouse2(Random rand, int minX, int minY, int minZ) {
            super(rand, minX, minY, minZ, 15, 5, 9);
            this.hasPlacedLoot[0] = false;
            this.hasPlacedLoot[1] = false;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74757_a("hasLoot1", this.hasPlacedLoot[0]);
            nbt.func_74757_a("hasLoot2", this.hasPlacedLoot[1]);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt) {
            super.func_143011_b(nbt);
            this.hasPlacedLoot[0] = nbt.func_74767_n("hasLoot1");
            this.hasPlacedLoot[1] = nbt.func_74767_n("hasLoot2");
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (!this.setAverageHeight(world, box, this.field_74887_e.field_78895_b)) {
                return false;
            }
            this.placeFoundationUnderneath(world, Blocks.field_150322_A, 0, 0, 0, 6, this.sizeZ, -1, box);
            this.placeFoundationUnderneath(world, Blocks.field_150322_A, 0, 9, 0, this.sizeX, this.sizeZ, -1, box);
            this.func_74878_a(world, box, 1, 0, 1, 5, this.sizeY, this.sizeZ - 1);
            this.func_74882_a(world, box, 0, 0, 0, 6, 1, 0, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 0, 2, 0, 1, 2, 0, false, rand, RandomSandstone);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 2, 2, 0, box);
            this.func_74882_a(world, box, 3, 2, 0, 3, 2, 0, false, rand, RandomSandstone);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 2, 0, box);
            this.func_74882_a(world, box, 5, 2, 0, 6, 2, 0, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 0, 3, 0, 6, 3, 0, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 0, 0, 1, 0, 3, this.sizeZ, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 1, 0, this.sizeZ, 6, 1, this.sizeZ, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 1, 2, this.sizeZ, 1, 2, this.sizeZ, false, rand, RandomSandstone);
            this.func_151549_a(world, box, 2, 2, this.sizeZ, 4, 2, this.sizeZ, Blocks.field_150422_aJ, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 5, 2, this.sizeZ, 6, 2, this.sizeZ, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 1, 3, this.sizeZ, 6, 3, this.sizeZ, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 6, 0, this.sizeZ - 1, 6, 3, this.sizeZ - 1, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 6, 0, this.sizeZ - 2, 6, 0, this.sizeZ - 2, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 6, 3, this.sizeZ - 2, 6, 3, this.sizeZ - 2, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 6, 0, 1, 6, 3, this.sizeZ - 3, false, rand, RandomSandstone);
            this.func_151549_a(world, box, 1, 0, 1, 5, 0, this.sizeZ - 1, Blocks.field_150322_A, Blocks.field_150350_a, false);
            this.func_151549_a(world, box, 1, this.sizeY - 1, 0, 5, this.sizeY - 1, this.sizeZ, Blocks.field_150322_A, Blocks.field_150350_a, false);
            this.func_151556_a(world, box, 0, this.sizeY - 1, 0, 0, this.sizeY - 1, this.sizeZ, (Block)Blocks.field_150333_U, 1, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 6, this.sizeY - 1, 0, 6, this.sizeY - 1, this.sizeZ, (Block)Blocks.field_150333_U, 1, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 2, this.sizeY, 0, 4, this.sizeY, 0, (Block)Blocks.field_150333_U, 1, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 3, this.sizeY, 1, 3, this.sizeY, 2, (Block)Blocks.field_150333_U, 1, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 3, this.sizeY, 4, 3, this.sizeY, 6, (Block)Blocks.field_150333_U, 1, Blocks.field_150350_a, 0, false);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 1, 3, this.sizeY, this.sizeZ - 1, box);
            this.func_151556_a(world, box, 2, this.sizeY, this.sizeZ, 4, this.sizeY, this.sizeZ, (Block)Blocks.field_150333_U, 1, Blocks.field_150350_a, 0, false);
            this.func_74882_a(world, box, this.sizeX - 6, 0, 0, this.sizeX, 0, 0, false, rand, RandomSandstone);
            this.func_74882_a(world, box, this.sizeX - 6, 1, 0, this.sizeX - 2, 1, 0, false, rand, RandomSandstone);
            this.func_74882_a(world, box, this.sizeX - 6, 2, 0, this.sizeX - 6, 2, 0, false, rand, RandomSandstone);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 1, this.sizeX - 6, 2, 0, box);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 1, this.sizeX - 3, 2, 0, box);
            this.func_74882_a(world, box, this.sizeX - 6, 0, 1, this.sizeX - 6, 3, 1, false, rand, RandomSandstone);
            this.func_74882_a(world, box, this.sizeX - 6, 0, 2, this.sizeX - 6, 0, 2, false, rand, RandomSandstone);
            this.func_74882_a(world, box, this.sizeX - 6, 3, 2, this.sizeX - 6, 3, this.sizeZ - 1, false, rand, RandomSandstone);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 1, this.sizeX - 6, this.sizeY - 1, 2, box);
            this.func_151556_a(world, box, this.sizeX - 6, this.sizeY - 1, 4, this.sizeX - 6, this.sizeY - 1, this.sizeZ - 2, (Block)Blocks.field_150333_U, 1, Blocks.field_150350_a, 0, false);
            this.func_74882_a(world, box, this.sizeX - 6, 0, 3, this.sizeX - 6, 1, this.sizeZ, false, rand, RandomSandstone);
            this.func_74882_a(world, box, this.sizeX - 6, 0, 2, this.sizeX - 6, 0, 2, false, rand, RandomSandstone);
            this.func_74882_a(world, box, this.sizeX - 6, 2, 3, this.sizeX - 6, 2, 3, false, rand, RandomSandstone);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, this.sizeX - 6, 2, 4, box);
            this.func_74882_a(world, box, this.sizeX - 6, 2, 5, this.sizeX - 6, 2, 5, false, rand, RandomSandstone);
            this.func_151549_a(world, box, this.sizeX - 6, 2, this.sizeZ - 3, this.sizeX - 6, 2, this.sizeZ - 2, Blocks.field_150422_aJ, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, this.sizeX - 6, 2, this.sizeZ - 1, this.sizeX - 6, 2, this.sizeZ, false, rand, RandomSandstone);
            this.func_74882_a(world, box, this.sizeX - 5, 0, this.sizeZ, this.sizeX, 1, this.sizeZ, false, rand, RandomSandstone);
            this.func_74882_a(world, box, this.sizeX - 5, 2, this.sizeZ, this.sizeX - 5, 2, this.sizeZ, false, rand, RandomSandstone);
            this.func_74882_a(world, box, this.sizeX - 1, 2, this.sizeZ, this.sizeX, 2, this.sizeZ, false, rand, RandomSandstone);
            this.func_74882_a(world, box, this.sizeX, 0, 1, this.sizeX, 0, this.sizeZ - 1, false, rand, RandomSandstone);
            this.func_74882_a(world, box, this.sizeX, 1, 3, this.sizeX, 1, 3, false, rand, RandomSandstone);
            this.func_151556_a(world, box, this.sizeX, 1, 4, this.sizeX, 1, 5, (Block)Blocks.field_150333_U, 1, Blocks.field_150350_a, 0, false);
            this.func_74882_a(world, box, this.sizeX, 1, this.sizeZ - 1, this.sizeX, 1, this.sizeZ - 3, false, rand, RandomSandstone);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 1, this.sizeX, 1, this.sizeZ - 1, box);
            this.func_151549_a(world, box, this.sizeX - 5, 0, 1, this.sizeX - 1, 0, this.sizeZ - 1, Blocks.field_150322_A, Blocks.field_150350_a, false);
            int eastMeta = this.getDecoMeta(4);
            this.func_151550_a(world, ModBlocks.machine_boiler_off, 4, 1, 1, 1, box);
            this.func_151549_a(world, box, 1, 2, 1, 1, 3, 1, ModBlocks.deco_pipe_quad_rusted, Blocks.field_150350_a, false);
            this.func_151550_a(world, ModBlocks.deco_pipe_rim_rusted, 0, 1, this.sizeY, 1, box);
            this.func_151550_a(world, ModBlocks.crate, 0, 2, 1, 3, box);
            this.func_151550_a(world, ModBlocks.crate_can, 0, 1, 1, this.sizeZ - 4, box);
            if (!this.hasPlacedLoot[0]) {
                this.func_151550_a(world, (Block)Blocks.field_150486_ae, this.func_151555_a((Block)Blocks.field_150486_ae, 3), 1, 1, this.sizeZ - 2, box);
                WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.machineParts, (IInventory)((TileEntityChest)world.func_147438_o(this.func_74865_a(1, this.sizeZ - 2), this.func_74862_a(1), this.func_74873_b(1, this.sizeZ - 2))), (int)10);
                this.hasPlacedLoot[0] = true;
            }
            this.func_151549_a(world, box, 4, 1, this.sizeZ - 1, 5, 1, this.sizeZ - 1, ModBlocks.crate, Blocks.field_150350_a, false);
            this.func_151556_a(world, box, 5, 1, 4, 5, 3, 4, ModBlocks.steel_scaffold, eastMeta < 4 ? 0 : 8, Blocks.field_150350_a, 0, false);
            this.func_151556_a(world, box, 5, 1, 6, 5, 3, 6, ModBlocks.steel_scaffold, eastMeta < 4 ? 0 : 8, Blocks.field_150350_a, 0, false);
            this.func_151550_a(world, ModBlocks.steel_grate, 7, 5, 1, 5, box);
            this.func_151550_a(world, ModBlocks.crate_weapon, 0, 5, 2, 5, box);
            if (!this.hasPlacedLoot[1]) {
                this.func_151550_a(world, (Block)Blocks.field_150486_ae, this.func_151555_a((Block)Blocks.field_150486_ae, 3), this.sizeX - 5, 1, 1, box);
                WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])HbmChestContents.antenna, (IInventory)((TileEntityChest)world.func_147438_o(this.func_74865_a(this.sizeX - 5, 1), this.func_74862_a(1), this.func_74873_b(this.sizeX - 5, 1))), (int)10);
                this.hasPlacedLoot[1] = true;
            }
            this.func_151550_a(world, ModBlocks.bobblehead, rand.nextInt(16), this.sizeX - 5, 1, 4, box);
            BlockBobble.TileEntityBobble bobble = (BlockBobble.TileEntityBobble)world.func_147438_o(this.func_74865_a(this.sizeX - 5, 4), this.func_74862_a(1), this.func_74873_b(this.sizeX - 5, 4));
            if (bobble != null) {
                bobble.type = BlockBobble.BobbleType.values()[rand.nextInt(BlockBobble.BobbleType.values().length - 1) + 1];
                bobble.func_70296_d();
            }
            this.func_151551_a(world, box, rand, 0.25f, this.sizeX - 4, 1, 1, this.sizeX - 1, 1, this.sizeZ - 1, (Block)Blocks.field_150354_m, Blocks.field_150350_a, false);
            return true;
        }
    }

    public static class NTMHouse1
    extends Component {
        private boolean hasPlacedChest;
        private static Component.Sandstone RandomSandstone = new Component.Sandstone();

        public NTMHouse1() {
        }

        public NTMHouse1(Random rand, int minX, int minY, int minZ) {
            super(rand, minX, minY, minZ, 9, 4, 6);
            this.hasPlacedChest = false;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74757_a("hasChest", this.hasPlacedChest);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt) {
            super.func_143011_b(nbt);
            this.hasPlacedChest = nbt.func_74767_n("hasChest");
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (!this.setAverageHeight(world, box, this.field_74887_e.field_78895_b)) {
                return false;
            }
            this.placeFoundationUnderneath(world, Blocks.field_150322_A, 0, 0, 0, this.sizeX, this.sizeZ, -1, box);
            this.func_74882_a(world, box, 0, 0, 0, this.sizeX, 0, 0, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 0, 1, 0, 1, 1, 0, false, rand, RandomSandstone);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 2, 1, 0, box);
            this.func_74882_a(world, box, 3, 1, 0, 5, 1, 0, false, rand, RandomSandstone);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 6, 1, 0, box);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 7, 1, 0, box);
            this.func_74882_a(world, box, this.sizeX - 1, 1, 0, this.sizeX, 1, 0, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 0, 2, 0, this.sizeX - 2, 2, 0, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 0, 0, 0, 0, 1, this.sizeZ, false, rand, RandomSandstone);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 1, 0, 2, 1, box);
            this.func_151556_a(world, box, 0, 2, 3, 0, 2, this.sizeZ, (Block)Blocks.field_150333_U, 1, Blocks.field_150350_a, 0, false);
            this.func_74882_a(world, box, 1, 0, this.sizeZ, 1, 1, this.sizeZ, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 3, 0, this.sizeZ, this.sizeX, 1, this.sizeZ, false, rand, RandomSandstone);
            this.func_74882_a(world, box, 1, 2, this.sizeZ, 3, 2, this.sizeZ, false, rand, RandomSandstone);
            this.func_151556_a(world, box, 4, 2, this.sizeZ, 5, 2, this.sizeZ, (Block)Blocks.field_150333_U, 1, Blocks.field_150350_a, 0, false);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 1, this.sizeX - 2, 2, this.sizeZ, box);
            this.func_74882_a(world, box, this.sizeX, 0, 0, this.sizeX, 0, this.sizeZ, false, rand, RandomSandstone);
            this.func_151551_a(world, box, rand, 0.65f, this.sizeX, 1, 1, this.sizeX, 1, this.sizeZ - 1, (Block)Blocks.field_150354_m, Blocks.field_150350_a, false);
            this.func_74882_a(world, box, 4, 0, 1, 4, 1, 3, false, rand, RandomSandstone);
            this.func_151550_a(world, ModBlocks.reinforced_sand, 0, 4, 0, 4, box);
            this.func_151550_a(world, ModBlocks.crate_weapon, 0, 1, 0, 1, box);
            if (!this.hasPlacedChest) {
                this.hasPlacedChest = this.func_74879_a(world, box, rand, 3, 0, 1, HbmChestContents.modGeneric, rand.nextInt(2) + 8);
            }
            this.func_151549_a(world, box, 5, 0, 1, 6, 0, 1, ModBlocks.crate, Blocks.field_150350_a, false);
            this.func_151550_a(world, (Block)Blocks.field_150354_m, 0, 7, 0, 1, box);
            if ((double)rand.nextFloat() <= 0.25) {
                this.func_151550_a(world, ModBlocks.crate_metal, 0, this.sizeX - 1, 0, 1, box);
            }
            this.func_151551_a(world, box, rand, 0.25f, 1, 0, 2, 3, 0, this.sizeZ - 1, (Block)Blocks.field_150354_m, Blocks.field_150350_a, false);
            this.func_151551_a(world, box, rand, 0.25f, 5, 0, 2, this.sizeX - 1, 0, this.sizeZ - 1, (Block)Blocks.field_150354_m, Blocks.field_150350_a, false);
            return true;
        }
    }
}

