/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.gen.component;

import com.hbm.blocks.ModBlocks;
import com.hbm.lib.HbmChestContents;
import com.hbm.world.gen.ProceduralStructureStart;
import com.hbm.world.gen.component.Component;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public class BunkerComponents {
    private static Component.ConcreteBricks ConcreteBricks = new Component.ConcreteBricks();

    public static void registerComponents() {
        MapGenStructureIO.func_143031_a(StartingHub.class, (String)"NTMBStartingHub");
        MapGenStructureIO.func_143031_a(Corridor.class, (String)"NTMBCorridor");
        MapGenStructureIO.func_143031_a(BedroomL.class, (String)"NTMBBedroomL");
        MapGenStructureIO.func_143031_a(FunJunction.class, (String)"NTMBFunJunction");
        MapGenStructureIO.func_143031_a(BathroomL.class, (String)"NTMBBathroomL");
        MapGenStructureIO.func_143031_a(Laboratory.class, (String)"NTMBLaboratory");
        MapGenStructureIO.func_143031_a(PowerRoom.class, (String)"NTMBPowerRoom");
    }

    public static class PowerRoom
    extends Component
    implements ProceduralStructureStart.ProceduralComponent {
        private boolean path;
        private int powerType;

        public PowerRoom() {
        }

        public PowerRoom(int componentType, StructureBoundingBox box, int coordMode, Random rand) {
            super(componentType);
            this.field_74887_e = box;
            this.field_74885_f = coordMode;
            float chance = rand.nextFloat();
            this.powerType = (double)chance < 0.2 ? 2 : ((double)chance < 0.6 ? 1 : 0);
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74757_a("p", this.path);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt) {
            super.func_143011_b(nbt);
            this.path = nbt.func_74767_n("p");
        }

        @Override
        public void buildComponent(ProceduralStructureStart start, Random rand) {
            this.path = this.getNextComponentEast(start, this, this.field_74885_f, rand, 4, 1) != null;
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            int i;
            this.func_74878_a(world, box, 1, 1, 1, 10, 3, 10);
            this.fillWithMetadataBlocks(world, box, 1, 0, 1, 10, 0, 10, ModBlocks.vinyl_tile, 1);
            this.fillWithBlocks(world, box, 1, 4, 1, 10, 4, 10, ModBlocks.vinyl_tile);
            this.fillWithBlocks(world, box, 0, 5, 0, 11, 5, 11, ModBlocks.reinforced_stone);
            this.fillWithRandomizedBlocks(world, box, 0, 0, 0, 11, 4, 0, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 0, 0, 1, 0, 4, 10, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 0, 0, 11, 11, 4, 11, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 11, 0, 1, 11, 4, 10, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 5, 1, 1, 5, 3, 6, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 6, 1, 6, 10, 3, 6, rand, ConcreteBricks);
            this.func_151550_a(world, ModBlocks.reinforced_lamp_off, 0, 3, 5, 2, box);
            this.func_151550_a(world, ModBlocks.reinforced_lamp_off, 0, 3, 5, 5, box);
            this.func_151550_a(world, ModBlocks.reinforced_lamp_off, 0, 3, 5, 8, box);
            this.func_151550_a(world, ModBlocks.reinforced_lamp_off, 0, 6, 5, 8, box);
            this.func_151550_a(world, ModBlocks.reinforced_lamp_off, 0, 9, 5, 8, box);
            this.func_151550_a(world, ModBlocks.fan, 0, 3, 4, 2, box);
            this.func_151550_a(world, ModBlocks.fan, 0, 3, 4, 5, box);
            this.func_151550_a(world, ModBlocks.fan, 0, 3, 4, 8, box);
            this.func_151550_a(world, ModBlocks.fan, 0, 6, 4, 8, box);
            this.func_151550_a(world, ModBlocks.fan, 0, 9, 4, 8, box);
            this.fillWithBlocks(world, box, 7, 2, 6, 9, 2, 6, ModBlocks.reinforced_glass);
            int decoMetaE = this.getDecoMeta(5);
            int decoMetaW = this.getDecoMeta(4);
            int decoMetaN = this.getDecoMeta(3);
            int decoMetaS = this.getDecoMeta(2);
            int stairMetaS = this.getStairMeta(3);
            int stairMetaN = this.getStairMeta(2);
            int stairMetaW = this.getStairMeta(1);
            int stairMetaE = this.getStairMeta(0);
            switch (this.powerType) {
                default: {
                    this.fillWithBlocks(world, box, 6, 1, 1, 6, 3, 1, ModBlocks.deco_pipe_framed_rusted);
                    for (i = 7; i <= 9; i += 2) {
                        this.func_151550_a(world, ModBlocks.machine_coal_off, decoMetaN, i, 1, 1, box);
                        this.func_151550_a(world, ModBlocks.steel_beam, 2, i, 2, 1, box);
                        this.func_151550_a(world, ModBlocks.machine_coal_off, decoMetaN, i, 3, 1, box);
                    }
                    this.func_151550_a(world, ModBlocks.deco_red_copper, 0, 8, 1, 1, box);
                    this.func_151550_a(world, ModBlocks.concrete_colored_ext, 5, 8, 2, 1, box);
                    this.func_151550_a(world, ModBlocks.deco_red_copper, 0, 8, 3, 1, box);
                    this.placeLever(world, box, 3, rand.nextBoolean(), 8, 2, 2);
                    for (i = 1; i <= 3; i += 2) {
                        this.func_151550_a(world, ModBlocks.deco_steel, 0, 10, i, 1, box);
                        this.fillWithMetadataBlocks(world, box, 10, i, 2, 10, i, 4, ModBlocks.deco_pipe_quad_rusted, this.getPillarMeta(8));
                        this.func_151550_a(world, ModBlocks.deco_steel, 0, 10, i, 5, box);
                    }
                    this.func_151550_a(world, ModBlocks.deco_pipe_framed_rusted, 0, 10, 2, 1, box);
                    this.func_151550_a(world, ModBlocks.fluid_duct_gauge, decoMetaW, 10, 2, 5, box);
                    this.func_151550_a(world, ModBlocks.barrel_plastic, 0, 6, 1, 5, box);
                    this.generateInvContents(world, box, rand, (Block)Blocks.field_150486_ae, decoMetaS, 7, 1, 5, HbmChestContents.solidFuel, 5);
                    this.generateInvContents(world, box, rand, (Block)Blocks.field_150486_ae, decoMetaS, 9, 1, 5, HbmChestContents.solidFuel, 6);
                    break;
                }
                case 1: {
                    this.func_151550_a(world, ModBlocks.concrete_colored_ext, 5, 6, 1, 1, box);
                    this.func_151550_a(world, ModBlocks.cable_detector, 0, 6, 2, 1, box);
                    this.func_151550_a(world, ModBlocks.concrete_colored_ext, 5, 6, 3, 1, box);
                    this.placeLever(world, box, 3, false, 6, 2, 2);
                    for (i = 7; i <= 9; i += 2) {
                        this.func_151550_a(world, ModBlocks.steel_scaffold, 8, i, 1, 1, box);
                        this.func_151550_a(world, ModBlocks.machine_diesel, decoMetaE, i, 2, 1, box);
                    }
                    this.func_151550_a(world, ModBlocks.deco_pipe_rim_rusted, this.getPillarMeta(4), 8, 2, 1, box);
                    this.func_151550_a(world, ModBlocks.deco_pipe_rim_rusted, this.getPillarMeta(4), 8, 2, 1, box);
                    this.fillWithMetadataBlocks(world, box, 7, 3, 1, 9, 3, 1, ModBlocks.concrete_smooth_stairs, stairMetaS);
                    this.fillWithBlocks(world, box, 10, 1, 1, 10, 1, 3, ModBlocks.deco_steel);
                    this.func_151550_a(world, ModBlocks.deco_red_copper, 0, 10, 2, 1, box);
                    this.func_151550_a(world, ModBlocks.deco_steel, 0, 10, 3, 1, box);
                    this.func_151550_a(world, ModBlocks.steel_grate, 7, 10, 2, 2, box);
                    this.func_151550_a(world, ModBlocks.deco_computer, this.getDecoModelMeta(2), 10, 3, 2, box);
                    this.fillWithMetadataBlocks(world, box, 10, 2, 3, 10, 3, 3, ModBlocks.tape_recorder, decoMetaW);
                    this.fillWithMetadataBlocks(world, box, 9, 1, 2, 9, 1, 3, ModBlocks.steel_grate, 7);
                    this.fillWithBlocks(world, box, 9, 1, 5, 10, 1, 5, ModBlocks.barrel_iron);
                    this.func_151550_a(world, ModBlocks.barrel_iron, 0, 10, 2, 5, box);
                    this.fillWithBlocks(world, box, 6, 1, 5, 6, 2, 5, ModBlocks.barrel_iron);
                    this.func_151550_a(world, ModBlocks.barrel_iron, 0, 6, 1, 2, box);
                    break;
                }
                case 2: {
                    for (i = 7; i <= 9; i += 2) {
                        this.fillWithBlocks(world, box, i, 1, 2, i, 1, 4, ModBlocks.deco_lead);
                        this.fillWithBlocks(world, box, i, 2, 2, i, 2, 4, ModBlocks.block_lead);
                        this.fillWithBlocks(world, box, i, 3, 2, i, 3, 4, ModBlocks.deco_lead);
                    }
                    this.func_151550_a(world, ModBlocks.concrete_colored_ext, 5, 8, 1, 4, box);
                    this.func_151550_a(world, ModBlocks.reactor_computer, 0, 8, 2, 4, box);
                    this.func_151550_a(world, ModBlocks.concrete_colored_ext, 5, 8, 3, 4, box);
                    this.placeLever(world, box, 3, rand.nextBoolean(), 8, 2, 5);
                    this.func_151550_a(world, ModBlocks.reactor_element, 0, 8, 1, 3, box);
                    this.func_151550_a(world, ModBlocks.reactor_control, 0, 8, 2, 3, box);
                    this.func_151550_a(world, ModBlocks.reactor_element, 0, 8, 3, 3, box);
                    this.func_151550_a(world, ModBlocks.block_copper, 0, 8, 1, 2, box);
                    this.func_151550_a(world, ModBlocks.block_lead, 0, 8, 2, 2, box);
                    this.func_151550_a(world, ModBlocks.block_copper, 0, 8, 3, 2, box);
                    this.func_151550_a(world, ModBlocks.reactor_conductor, 0, 8, 1, 1, box);
                    this.func_151550_a(world, ModBlocks.machine_turbine, 0, 8, 2, 1, box);
                    this.func_151550_a(world, ModBlocks.reactor_conductor, 0, 8, 3, 1, box);
                    this.fillWithBlocks(world, box, 9, 1, 1, 9, 3, 1, ModBlocks.deco_steel);
                    this.func_151550_a(world, ModBlocks.steel_grate, 7, 10, 1, 1, box);
                    this.func_151550_a(world, ModBlocks.deco_computer, this.getDecoModelMeta(1), 10, 2, 1, box);
                    this.func_151550_a(world, ModBlocks.tape_recorder, decoMetaN, 10, 3, 1, box);
                    this.fillWithMetadataBlocks(world, box, 6, 1, 1, 7, 1, 1, ModBlocks.deco_pipe_quad_rusted, this.getPillarMeta(4));
                    this.func_151550_a(world, ModBlocks.deco_pipe_quad_rusted, this.getPillarMeta(4), 7, 3, 1, box);
                    this.func_151550_a(world, ModBlocks.fluid_duct_gauge, decoMetaN, 6, 3, 1, box);
                    this.generateInvContents(world, box, rand, (Block)Blocks.field_150486_ae, decoMetaN, 6, 1, 2, HbmChestContents.nuclearFuel, 8);
                }
            }
            this.fillWithMetadataBlocks(world, box, 1, 1, 1, 1, 1, 5, ModBlocks.concrete_smooth_stairs, stairMetaW | 4);
            this.fillWithBlocks(world, box, 1, 1, 6, 1, 3, 6, ModBlocks.concrete_pillar);
            this.fillWithMetadataBlocks(world, box, 1, 3, 1, 1, 3, 5, ModBlocks.concrete_smooth_stairs, stairMetaW);
            this.func_151550_a(world, ModBlocks.machine_transformer_20, 0, 1, 2, 1, box);
            this.func_151550_a(world, ModBlocks.cable_diode, decoMetaN, 1, 2, 2, box);
            this.func_151550_a(world, ModBlocks.machine_battery, decoMetaE, 1, 2, 3, box);
            this.func_151550_a(world, ModBlocks.deco_red_copper, 0, 1, 2, 4, box);
            this.func_151550_a(world, ModBlocks.cable_switch, 0, 1, 2, 5, box);
            for (i = 1; i <= 5; i += 4) {
                this.func_151550_a(world, ModBlocks.deco_beryllium, 0, i, 1, 10, box);
                this.func_151550_a(world, ModBlocks.steel_scaffold, 0, i, 2, 10, box);
                this.func_151550_a(world, ModBlocks.deco_beryllium, 0, i, 3, 10, box);
            }
            this.func_151550_a(world, ModBlocks.steel_scaffold, 0, 2, 1, 10, box);
            this.func_151550_a(world, ModBlocks.deco_tungsten, 0, 3, 1, 10, box);
            this.func_151550_a(world, ModBlocks.steel_scaffold, 0, 4, 1, 10, box);
            this.func_151550_a(world, ModBlocks.tape_recorder, decoMetaS, 2, 2, 10, box);
            this.func_151550_a(world, ModBlocks.deco_computer, this.getDecoModelMeta(0), 3, 2, 10, box);
            this.func_151550_a(world, ModBlocks.tape_recorder, decoMetaS, 4, 2, 10, box);
            this.fillWithMetadataBlocks(world, box, 2, 3, 10, 4, 3, 10, ModBlocks.tape_recorder, decoMetaS);
            this.fillWithMetadataBlocks(world, box, 8, 1, 10, 10, 1, 10, ModBlocks.concrete_smooth_stairs, stairMetaN | 4);
            this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, stairMetaE | 4, 10, 1, 9, box);
            this.func_151550_a(world, Blocks.field_150476_ad, stairMetaS, 9, 1, 9, box);
            this.func_151550_a(world, Blocks.field_150457_bL, 0, 8, 2, 10, box);
            this.func_151550_a(world, ModBlocks.deco_computer, this.getDecoModelMeta(0), 9, 2, 10, box);
            this.generateInvContents(world, box, rand, (Block)Blocks.field_150486_ae, decoMetaE, 1, 1, 7, HbmChestContents.machineParts, 6);
            this.generateInvContents(world, box, rand, ModBlocks.filing_cabinet, this.getDecoModelMeta(0), 7, 1, 10, HbmChestContents.filingCabinet, 4);
            this.placeDoor(world, box, ModBlocks.door_bunker, 1, true, rand.nextBoolean(), 3, 1, 0);
            this.placeDoor(world, box, ModBlocks.door_bunker, 1, false, rand.nextBoolean(), 4, 1, 0);
            this.placeDoor(world, box, ModBlocks.door_bunker, 0, false, false, 5, 1, 3);
            if (this.path) {
                this.func_74878_a(world, box, 11, 1, 7, 11, 2, 8);
            }
            return true;
        }

        public static StructureComponent findValidPlacement(List components, Random rand, int x, int y, int z, int coordMode, int type) {
            StructureBoundingBox box = ProceduralStructureStart.getComponentToAddBoundingBox(x, y, z, -4, -1, 0, 12, 6, 12, coordMode);
            return box.field_78895_b > 10 && StructureComponent.func_74883_a((List)components, (StructureBoundingBox)box) == null ? new PowerRoom(type, box, coordMode, rand) : null;
        }
    }

    public static class Laboratory
    extends Component
    implements ProceduralStructureStart.ProceduralComponent {
        private boolean[] paths = new boolean[2];

        public Laboratory() {
        }

        public Laboratory(int componentType, StructureBoundingBox box, int coordMode) {
            super(componentType);
            this.field_74887_e = box;
            this.field_74885_f = coordMode;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            for (int i = 0; i < this.paths.length; ++i) {
                nbt.func_74757_a("p" + i, this.paths[i]);
            }
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt) {
            super.func_143011_b(nbt);
            for (int i = 0; i < this.paths.length; ++i) {
                this.paths[i] = nbt.func_74767_n("p" + i);
            }
        }

        @Override
        public void buildComponent(ProceduralStructureStart start, Random rand) {
            this.paths[0] = this.getNextComponentWest(start, this, this.field_74885_f, rand, 3, 1) != null;
            this.paths[1] = this.getNextComponentNormal(start, this, this.field_74885_f, rand, 6, 1) != null;
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            this.func_74878_a(world, box, 1, 1, 1, 7, 3, 11);
            this.fillWithMetadataBlocks(world, box, 1, 0, 1, 7, 0, 11, ModBlocks.vinyl_tile, 1);
            this.fillWithBlocks(world, box, 1, 4, 1, 7, 4, 11, ModBlocks.vinyl_tile);
            this.fillWithBlocks(world, box, 0, 5, 0, 8, 5, 12, ModBlocks.reinforced_stone);
            this.fillWithBlocks(world, box, 0, 0, 0, 0, 4, 12, ModBlocks.brick_concrete);
            this.fillWithBlocks(world, box, 1, 0, 12, 7, 4, 12, ModBlocks.brick_concrete);
            this.fillWithBlocks(world, box, 8, 0, 0, 8, 4, 12, ModBlocks.brick_concrete);
            this.fillWithBlocks(world, box, 1, 0, 0, 7, 4, 0, ModBlocks.brick_concrete);
            for (int x = 3; x <= 5; x += 2) {
                for (int z = 3; z <= 9; z += 3) {
                    this.func_151550_a(world, ModBlocks.reinforced_lamp_off, 0, x, 5, z, box);
                    this.func_151550_a(world, ModBlocks.fan, 0, x, 4, z, box);
                }
            }
            int stairMetaW = this.getStairMeta(0);
            int stairMetaE = this.getStairMeta(1);
            int stairMetaN = this.getStairMeta(2);
            int stairMetaS = this.getStairMeta(3);
            this.func_151550_a(world, Blocks.field_150476_ad, stairMetaE, 1, 1, 1, box);
            this.func_151550_a(world, Blocks.field_150476_ad, stairMetaS, 2, 1, 1, box);
            this.func_151550_a(world, Blocks.field_150476_ad, stairMetaW, 3, 1, 1, box);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 4, 1, 1, box);
            this.func_151550_a(world, Blocks.field_150452_aw, 0, 4, 2, 1, box);
            int decoMetaE = this.getDecoMeta(4);
            int decoMetaW = this.getDecoMeta(5);
            int decoModelMetaW = this.getDecoModelMeta(2);
            int decoModelMetaE = this.getDecoModelMeta(3);
            this.fillWithBlocks(world, box, 1, 1, 5, 1, 3, 5, ModBlocks.deco_tungsten);
            this.func_151550_a(world, ModBlocks.deco_steel, 0, 1, 1, 6, box);
            this.func_151550_a(world, ModBlocks.deco_computer, decoModelMetaE, 1, 2, 6, box);
            this.func_151550_a(world, ModBlocks.tape_recorder, decoMetaW, 1, 3, 6, box);
            this.fillWithMetadataBlocks(world, box, 1, 1, 7, 1, 3, 7, ModBlocks.tape_recorder, decoMetaW);
            this.fillWithBlocks(world, box, 1, 1, 8, 1, 3, 8, ModBlocks.deco_tungsten);
            this.fillWithMetadataBlocks(world, box, 1, 1, 9, 1, 1, 10, ModBlocks.tape_recorder, decoMetaW);
            this.fillWithMetadataBlocks(world, box, 1, 2, 9, 1, 2, 10, ModBlocks.concrete_smooth_stairs, stairMetaE | 4);
            this.fillWithMetadataBlocks(world, box, 1, 3, 9, 1, 3, 10, ModBlocks.tape_recorder, decoMetaW);
            this.fillWithBlocks(world, box, 1, 1, 11, 1, 3, 11, ModBlocks.deco_tungsten);
            this.generateInvContents(world, box, rand, (Block)Blocks.field_150486_ae, this.getDecoMeta(2), 3, 1, 4, HbmChestContents.machineParts, 6);
            this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, stairMetaS | 4, 3, 1, 5, box);
            this.fillWithMetadataBlocks(world, box, 4, 1, 5, 4, 1, 7, ModBlocks.concrete_smooth_stairs, stairMetaW | 4);
            this.func_151550_a(world, Blocks.field_150476_ad, stairMetaN, 3, 1, 7, box);
            this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, stairMetaS | 4, 3, 1, 9, box);
            this.fillWithMetadataBlocks(world, box, 4, 1, 9, 4, 1, 11, ModBlocks.concrete_smooth_stairs, stairMetaW | 4);
            this.func_151550_a(world, Blocks.field_150476_ad, stairMetaN, 3, 1, 11, box);
            this.func_151550_a(world, Blocks.field_150457_bL, 0, 3, 2, 5, box);
            this.func_151550_a(world, ModBlocks.deco_computer, decoModelMetaW, 4, 2, 6, box);
            this.func_151550_a(world, ModBlocks.deco_computer, decoModelMetaW, 4, 2, 10, box);
            this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, stairMetaW | 4, 7, 1, 3, box);
            this.func_151550_a(world, ModBlocks.deco_red_copper, 0, 7, 2, 3, box);
            this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, stairMetaW, 7, 3, 3, box);
            this.placeLever(world, box, 2, rand.nextBoolean(), 6, 2, 3);
            this.fillWithMetadataBlocks(world, box, 7, 1, 4, 7, 2, 4, ModBlocks.steel_poles, decoMetaE);
            this.func_151550_a(world, ModBlocks.deco_steel, 0, 7, 3, 4, box);
            this.func_151550_a(world, ModBlocks.deco_tungsten, 0, 7, 1, 5, box);
            this.func_151550_a(world, ModBlocks.tape_recorder, decoMetaE, 7, 1, 6, box);
            this.func_151550_a(world, ModBlocks.deco_tungsten, 0, 7, 1, 7, box);
            this.fillWithMetadataBlocks(world, box, 7, 2, 5, 7, 2, 7, ModBlocks.concrete_smooth_stairs, stairMetaW | 4);
            this.fillWithMetadataBlocks(world, box, 7, 3, 5, 7, 3, 7, ModBlocks.tape_recorder, decoMetaE);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 7, 1, 9, box);
            this.func_151550_a(world, Blocks.field_150452_aw, 0, 7, 2, 9, box);
            this.generateInvContents(world, box, rand, (Block)Blocks.field_150486_ae, this.getDecoMeta(4), 7, 1, 10, HbmChestContents.labVault, 8);
            this.placeDoor(world, box, ModBlocks.door_bunker, 1, true, rand.nextBoolean(), 5, 1, 0);
            this.placeDoor(world, box, ModBlocks.door_bunker, 1, false, rand.nextBoolean(), 6, 1, 0);
            if (this.paths[0]) {
                this.func_74878_a(world, box, 0, 1, 2, 0, 2, 3);
            }
            if (this.paths[1]) {
                this.func_74878_a(world, box, 5, 1, 12, 6, 2, 12);
            }
            return true;
        }

        public static StructureComponent findValidPlacement(List components, Random rand, int x, int y, int z, int coordMode, int type) {
            StructureBoundingBox box = ProceduralStructureStart.getComponentToAddBoundingBox(x, y, z, -6, -1, 0, 9, 6, 12, coordMode);
            return box.field_78895_b > 10 && StructureComponent.func_74883_a((List)components, (StructureBoundingBox)box) == null ? new Laboratory(type, box, coordMode) : null;
        }
    }

    public static class BathroomL
    extends Component
    implements ProceduralStructureStart.ProceduralComponent {
        private boolean path;

        public BathroomL() {
        }

        public BathroomL(int componentType, StructureBoundingBox box, int coordMode) {
            super(componentType);
            this.field_74887_e = box;
            this.field_74885_f = coordMode;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74757_a("p", this.path);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt) {
            super.func_143011_b(nbt);
            this.path = nbt.func_74767_n("p");
        }

        @Override
        public void buildComponent(ProceduralStructureStart start, Random rand) {
            this.path = this.getNextComponentEast(start, this, this.field_74885_f, rand, 3, 1) != null;
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            int i;
            this.func_74878_a(world, box, 1, 1, 1, 7, 3, 9);
            this.fillWithMetadataBlocks(world, box, 1, 0, 1, 7, 0, 9, ModBlocks.vinyl_tile, 1);
            this.fillWithBlocks(world, box, 1, 4, 1, 7, 4, 9, ModBlocks.vinyl_tile);
            this.fillWithBlocks(world, box, 0, 5, 0, 8, 5, 10, ModBlocks.reinforced_stone);
            this.fillWithRandomizedBlocks(world, box, 0, 0, 0, 0, 4, 10, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 0, 10, 7, 4, 10, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 8, 0, 0, 8, 4, 10, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 0, 0, 7, 4, 0, rand, ConcreteBricks);
            this.func_151550_a(world, ModBlocks.reinforced_lamp_off, 0, 2, 5, 3, box);
            this.func_151550_a(world, ModBlocks.reinforced_lamp_off, 0, 2, 5, 7, box);
            this.func_151550_a(world, ModBlocks.reinforced_lamp_off, 0, 5, 5, 7, box);
            this.func_151550_a(world, ModBlocks.reinforced_lamp_off, 0, 5, 5, 3, box);
            this.func_151550_a(world, ModBlocks.fan, 0, 2, 4, 3, box);
            this.func_151550_a(world, ModBlocks.fan, 0, 2, 4, 7, box);
            this.func_151550_a(world, ModBlocks.fan, 0, 5, 4, 7, box);
            this.func_151550_a(world, ModBlocks.fan, 0, 5, 4, 3, box);
            for (i = 2; i <= 8; i += 2) {
                this.func_151550_a(world, (Block)Blocks.field_150383_bp, rand.nextInt(4), 1, 1, i, box);
                this.func_151550_a(world, ModBlocks.concrete_slab, 8, 1, 1, i + 1, box);
                this.func_151550_a(world, (Block)Blocks.field_150479_bC, this.getTripwireMeta(3), 1, 2, i, box);
            }
            this.func_151550_a(world, ModBlocks.steel_beam, 3, 4, 1, 9, box);
            this.func_151550_a(world, ModBlocks.fan, this.getDecoMeta(2), 4, 2, 9, box);
            this.func_151550_a(world, Blocks.field_150430_aB, this.getButtonMeta(2), 3, 2, 9, box);
            this.func_151550_a(world, ModBlocks.steel_beam, 3, 6, 1, 9, box);
            this.func_151550_a(world, ModBlocks.fan, this.getDecoMeta(2), 6, 2, 9, box);
            this.func_151550_a(world, Blocks.field_150430_aB, this.getButtonMeta(1), 7, 2, 9, box);
            for (i = 1; i <= 5; i += 2) {
                this.placeDoor(world, box, ModBlocks.door_metal, 0, false, rand.nextBoolean(), 5, 1, i);
                this.fillWithMetadataBlocks(world, box, 5, 1, i + 1, 5, 2, i + 1, ModBlocks.steel_corner, this.getDecoMeta(2));
                this.fillWithMetadataBlocks(world, box, 6, 1, i + 1, 7, 2, i + 1, ModBlocks.steel_wall, this.getDecoMeta(2));
                this.func_151550_a(world, ModBlocks.deco_pipe_rim, 0, 7, 1, i, box);
                this.func_151550_a(world, Blocks.field_150415_aT, this.getDecoModelMeta(2) >> 2, 7, 2, i, box);
            }
            this.placeDoor(world, box, ModBlocks.door_bunker, 1, true, rand.nextBoolean(), 2, 1, 0);
            this.placeDoor(world, box, ModBlocks.door_bunker, 1, false, rand.nextBoolean(), 3, 1, 0);
            if (this.path) {
                this.func_74878_a(world, box, 8, 1, 7, 8, 2, 8);
            }
            return true;
        }

        public static StructureComponent findValidPlacement(List components, Random rand, int x, int y, int z, int coordMode, int type) {
            StructureBoundingBox box = ProceduralStructureStart.getComponentToAddBoundingBox(x, y, z, -3, -1, 0, 9, 6, 11, coordMode);
            return box.field_78895_b > 10 && StructureComponent.func_74883_a((List)components, (StructureBoundingBox)box) == null ? new BathroomL(type, box, coordMode) : null;
        }
    }

    public static class FunJunction
    extends Component
    implements ProceduralStructureStart.ProceduralComponent {
        private boolean[] paths = new boolean[2];

        public FunJunction() {
        }

        public FunJunction(int componentType, StructureBoundingBox box, int coordMode) {
            super(componentType);
            this.field_74887_e = box;
            this.field_74885_f = coordMode;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            for (int i = 0; i < this.paths.length; ++i) {
                nbt.func_74757_a("p" + i, this.paths[i]);
            }
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt) {
            super.func_143011_b(nbt);
            for (int i = 0; i < this.paths.length; ++i) {
                this.paths[i] = nbt.func_74767_n("p" + i);
            }
        }

        @Override
        public void buildComponent(ProceduralStructureStart start, Random rand) {
            this.paths[0] = this.getNextComponentEast(start, this, this.field_74885_f, rand, 6, 1) != null;
            this.paths[1] = this.getNextComponentNormal(start, this, this.field_74885_f, rand, 5, 1) != null;
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            this.func_74878_a(world, box, 1, 1, 1, 6, 3, 10);
            this.fillWithMetadataBlocks(world, box, 1, 0, 1, 6, 0, 10, ModBlocks.vinyl_tile, 1);
            this.fillWithBlocks(world, box, 1, 4, 1, 6, 4, 10, ModBlocks.vinyl_tile);
            this.fillWithBlocks(world, box, 0, 5, 0, 7, 5, 11, ModBlocks.reinforced_stone);
            this.fillWithRandomizedBlocks(world, box, 0, 0, 0, 0, 4, 11, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 0, 11, 6, 4, 11, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 7, 0, 0, 7, 4, 11, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 0, 0, 6, 4, 0, rand, ConcreteBricks);
            this.func_151550_a(world, ModBlocks.reinforced_lamp_off, 0, 2, 5, 3, box);
            this.fillWithBlocks(world, box, 5, 5, 5, 5, 5, 6, ModBlocks.reinforced_lamp_off);
            this.func_151550_a(world, ModBlocks.reinforced_lamp_off, 0, 2, 5, 8, box);
            this.func_151550_a(world, ModBlocks.fan, 0, 2, 4, 3, box);
            this.fillWithBlocks(world, box, 5, 4, 5, 5, 4, 6, ModBlocks.fan);
            this.func_151550_a(world, ModBlocks.fan, 0, 2, 4, 8, box);
            int stairMetaW = this.getStairMeta(0);
            int stairMetaE = this.getStairMeta(1);
            int stairMetaN = this.getStairMeta(2);
            int stairMetaS = this.getStairMeta(3);
            this.func_151550_a(world, Blocks.field_150476_ad, stairMetaE, 1, 1, 1, box);
            this.func_151550_a(world, Blocks.field_150476_ad, stairMetaS, 2, 1, 1, box);
            this.func_151550_a(world, Blocks.field_150476_ad, stairMetaW, 3, 1, 1, box);
            this.func_151550_a(world, Blocks.field_150476_ad, stairMetaS, 1, 1, 4, box);
            this.func_151550_a(world, Blocks.field_150476_ad, stairMetaE, 1, 1, 5, box);
            this.fillWithMetadataBlocks(world, box, 1, 1, 6, 2, 1, 6, Blocks.field_150476_ad, stairMetaN);
            this.func_151550_a(world, Blocks.field_150476_ad, stairMetaW, 3, 1, 6, box);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 1, 1, 3, box);
            this.func_151550_a(world, Blocks.field_150452_aw, 0, 1, 2, 3, box);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 3, 1, 4, box);
            this.func_151550_a(world, Blocks.field_150452_aw, 0, 3, 2, 4, box);
            this.func_151550_a(world, Blocks.field_150422_aJ, 0, 6, 1, 2, box);
            this.func_151550_a(world, Blocks.field_150452_aw, 0, 6, 2, 2, box);
            this.generateInvContents(world, box, rand, (Block)Blocks.field_150486_ae, this.getDecoMeta(4), 6, 1, 3, HbmChestContents.lockersVault, 8);
            this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, stairMetaS | 4, 1, 1, 8, box);
            this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, stairMetaE | 4, 1, 1, 9, box);
            this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, stairMetaN | 4, 1, 1, 10, box);
            this.func_151550_a(world, Blocks.field_150476_ad, stairMetaS, 2, 1, 8, box);
            this.func_151550_a(world, ModBlocks.deco_computer, this.getDecoModelMeta(3), 1, 2, 9, box);
            if (rand.nextBoolean()) {
                this.placeRandomBobble(world, box, rand, 1, 2, 8);
            }
            this.fillWithBlocks(world, box, 6, 1, 8, 6, 2, 8, Blocks.field_150323_B);
            this.func_151550_a(world, ModBlocks.deco_tungsten, 0, 6, 1, 9, box);
            this.func_151550_a(world, ModBlocks.tape_recorder, this.getDecoMeta(4), 6, 2, 9, box);
            this.fillWithBlocks(world, box, 6, 3, 8, 6, 3, 9, ModBlocks.concrete_slab);
            this.placeLever(world, box, 2, rand.nextBoolean(), 5, 1, 9);
            this.placeDoor(world, box, ModBlocks.door_bunker, 1, true, rand.nextBoolean(), 4, 1, 0);
            this.placeDoor(world, box, ModBlocks.door_bunker, 1, false, rand.nextBoolean(), 5, 1, 0);
            if (this.paths[0]) {
                this.func_74878_a(world, box, 7, 1, 5, 7, 2, 6);
            }
            if (this.paths[1]) {
                this.func_74878_a(world, box, 4, 1, 11, 5, 2, 11);
            }
            return true;
        }

        public static StructureComponent findValidPlacement(List components, Random rand, int x, int y, int z, int coordMode, int type) {
            StructureBoundingBox box = ProceduralStructureStart.getComponentToAddBoundingBox(x, y, z, -5, -1, 0, 8, 6, 12, coordMode);
            return box.field_78895_b > 10 && StructureComponent.func_74883_a((List)components, (StructureBoundingBox)box) == null ? new FunJunction(type, box, coordMode) : null;
        }
    }

    public static class BedroomL
    extends Component
    implements ProceduralStructureStart.ProceduralComponent {
        private boolean path;

        public BedroomL() {
        }

        public BedroomL(int componentType, StructureBoundingBox box, int coordMode) {
            super(componentType);
            this.field_74887_e = box;
            this.field_74885_f = coordMode;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74757_a("p", this.path);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt) {
            super.func_143011_b(nbt);
            this.path = nbt.func_74767_n("p");
        }

        @Override
        public void buildComponent(ProceduralStructureStart start, Random rand) {
            this.path = this.getNextComponentWest(start, this, this.field_74885_f, rand, 9, 1) != null;
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            this.func_74878_a(world, box, 4, 1, 1, 8, 3, 4);
            this.func_74878_a(world, box, 1, 1, 5, 8, 3, 9);
            this.fillWithMetadataBlocks(world, box, 4, 0, 1, 8, 0, 4, ModBlocks.vinyl_tile, 1);
            this.fillWithMetadataBlocks(world, box, 1, 0, 5, 8, 0, 9, ModBlocks.vinyl_tile, 1);
            this.fillWithBlocks(world, box, 4, 4, 1, 8, 4, 4, ModBlocks.vinyl_tile);
            this.fillWithBlocks(world, box, 1, 4, 5, 8, 4, 9, ModBlocks.vinyl_tile);
            this.fillWithBlocks(world, box, 3, 5, 0, 9, 5, 3, ModBlocks.reinforced_stone);
            this.fillWithBlocks(world, box, 0, 5, 4, 9, 5, 10, ModBlocks.reinforced_stone);
            this.fillWithRandomizedBlocks(world, box, 0, 0, 4, 0, 4, 10, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 0, 10, 8, 4, 10, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 9, 0, 0, 9, 4, 10, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 4, 0, 0, 8, 4, 0, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 3, 0, 0, 3, 4, 4, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 0, 4, 2, 4, 4, rand, ConcreteBricks);
            this.func_151550_a(world, ModBlocks.reinforced_lamp_off, 0, 3, 5, 7, box);
            this.func_151550_a(world, ModBlocks.reinforced_lamp_off, 0, 6, 5, 7, box);
            this.func_151550_a(world, ModBlocks.reinforced_lamp_off, 0, 6, 5, 3, box);
            this.func_151550_a(world, ModBlocks.fan, 0, 3, 4, 7, box);
            this.func_151550_a(world, ModBlocks.fan, 0, 6, 4, 7, box);
            this.func_151550_a(world, ModBlocks.fan, 0, 6, 4, 3, box);
            int stairMetaW = this.getStairMeta(0);
            int stairMetaE = this.getStairMeta(1);
            int stairMetaN = this.getStairMeta(2);
            int stairMetaS = this.getStairMeta(3);
            this.placeBed(world, box, 1, 5, 1, 1);
            this.placeBed(world, box, 1, 5, 1, 3);
            this.placeBed(world, box, 2, 3, 1, 6);
            this.placeBed(world, box, 2, 1, 1, 6);
            this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, stairMetaE | 4, 4, 1, 2, box);
            this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, stairMetaE | 4, 4, 1, 4, box);
            this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, stairMetaS | 4, 4, 1, 5, box);
            this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, stairMetaS | 4, 2, 1, 5, box);
            this.func_151550_a(world, ModBlocks.radiorec, this.getDecoMeta(4), 4, 2, 4, box);
            this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, stairMetaS | 4, 8, 1, 3, box);
            this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, stairMetaN | 4, 8, 1, 4, box);
            this.func_151550_a(world, Blocks.field_150323_B, 0, 8, 1, 5, box);
            this.func_151550_a(world, ModBlocks.machine_microwave, this.getDecoMeta(4), 8, 2, 4, box);
            this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, stairMetaW | 4, 6, 1, 9, box);
            this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, stairMetaN | 4, 5, 1, 9, box);
            this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, stairMetaE | 4, 4, 1, 9, box);
            this.func_151550_a(world, Blocks.field_150476_ad, stairMetaS, 5, 1, 8, box);
            this.func_151550_a(world, ModBlocks.deco_computer, this.getDecoModelMeta(0), 5, 2, 9, box);
            this.generateInvContents(world, box, rand, ModBlocks.filing_cabinet, this.getDecoModelMeta(0), 3, 1, 9, HbmChestContents.filingCabinet, 5);
            this.generateInvContents(world, box, rand, (Block)Blocks.field_150486_ae, this.getDecoMeta(4), 8, 1, 7, HbmChestContents.lockersVault, 3);
            this.generateInvContents(world, box, rand, (Block)Blocks.field_150486_ae, this.getDecoMeta(4), 8, 2, 7, HbmChestContents.lockersVault, 5);
            this.fillWithBlocks(world, box, 8, 1, 8, 8, 2, 8, ModBlocks.deco_tungsten);
            this.generateInvContents(world, box, rand, (Block)Blocks.field_150486_ae, this.getDecoMeta(4), 8, 1, 9, HbmChestContents.lockersVault, 4);
            this.generateInvContents(world, box, rand, (Block)Blocks.field_150486_ae, this.getDecoMeta(4), 8, 2, 9, HbmChestContents.lockersVault, 5);
            this.fillWithMetadataBlocks(world, box, 8, 3, 7, 8, 3, 9, Blocks.field_150415_aT, this.getDecoModelMeta(2) >> 2);
            this.placeDoor(world, box, ModBlocks.door_bunker, 1, true, rand.nextBoolean(), 7, 1, 0);
            this.placeDoor(world, box, ModBlocks.door_bunker, 1, false, rand.nextBoolean(), 8, 1, 0);
            if (this.path) {
                this.func_74878_a(world, box, 0, 1, 8, 0, 2, 9);
            }
            return true;
        }

        public static StructureComponent findValidPlacement(List components, Random rand, int x, int y, int z, int coordMode, int type) {
            StructureBoundingBox box = ProceduralStructureStart.getComponentToAddBoundingBox(x, y, z, -8, -1, 0, 10, 6, 11, coordMode);
            return box.field_78895_b > 10 && StructureComponent.func_74883_a((List)components, (StructureBoundingBox)box) == null ? new BedroomL(type, box, coordMode) : null;
        }
    }

    public static class Corridor
    extends Component
    implements ProceduralStructureStart.ProceduralComponent {
        private boolean path;
        private int[] decorations = new int[2];

        public Corridor() {
        }

        public Corridor(int componentType, StructureBoundingBox box, int coordMode, Random rand) {
            super(componentType);
            this.field_74887_e = box;
            this.field_74885_f = coordMode;
            this.decorations[0] = rand.nextInt(6);
            this.decorations[1] = rand.nextInt(6);
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            nbt.func_74757_a("p", this.path);
            nbt.func_74783_a("d", this.decorations);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt) {
            super.func_143011_b(nbt);
            this.path = nbt.func_74767_n("p");
            this.decorations = nbt.func_74759_k("d");
        }

        @Override
        public void buildComponent(ProceduralStructureStart start, Random rand) {
            this.path = this.getNextComponentNormal(start, this, this.field_74885_f, rand, 3, 1) != null;
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            this.func_74878_a(world, box, 1, 1, 1, 4, 3, 5);
            this.fillWithMetadataBlocks(world, box, 1, 0, 1, 4, 0, 5, ModBlocks.vinyl_tile, 1);
            this.fillWithBlocks(world, box, 1, 4, 1, 4, 4, 5, ModBlocks.vinyl_tile);
            this.fillWithBlocks(world, box, 0, 5, 0, 5, 5, 6, ModBlocks.reinforced_stone);
            this.fillWithRandomizedBlocks(world, box, 0, 0, 0, 0, 4, 6, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 0, 6, 4, 4, 6, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 5, 0, 0, 5, 4, 6, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 0, 0, 4, 4, 0, rand, ConcreteBricks);
            this.fillWithBlocks(world, box, 2, 5, 3, 3, 5, 3, ModBlocks.reinforced_lamp_off);
            this.fillWithBlocks(world, box, 2, 4, 3, 3, 4, 3, ModBlocks.fan);
            int stairMetaW = this.getStairMeta(0);
            int stairMetaE = this.getStairMeta(1);
            int stairMetaN = this.getStairMeta(2);
            int stairMetaS = this.getStairMeta(3);
            int decoMetaE = this.getDecoMeta(4);
            int decoMetaW = this.getDecoMeta(5);
            block7: for (int i = 0; i <= 1; ++i) {
                int x = 1 + i * 3;
                switch (this.decorations[i]) {
                    default: {
                        this.func_151550_a(world, Blocks.field_150476_ad, stairMetaS, x, 1, 2, box);
                        this.func_151550_a(world, Blocks.field_150476_ad, stairMetaN, x, 1, 4, box);
                        this.func_151550_a(world, Blocks.field_150422_aJ, 0, x, 1, 3, box);
                        this.func_151550_a(world, Blocks.field_150452_aw, 1, x, 2, 3, box);
                        continue block7;
                    }
                    case 1: {
                        this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, stairMetaS | 4, x, 1, 2, box);
                        this.func_151550_a(world, Blocks.field_150476_ad, stairMetaN, x, 1, 4, box);
                        this.func_151550_a(world, ModBlocks.deco_computer, this.getDecoModelMeta(1), x, 2, 2, box);
                        continue block7;
                    }
                    case 2: {
                        this.func_151550_a(world, Blocks.field_150476_ad, stairMetaS, x, 1, 2, box);
                        this.func_151550_a(world, Blocks.field_150476_ad, i < 1 ? stairMetaE : stairMetaW, x, 1, 3, box);
                        this.func_151550_a(world, Blocks.field_150476_ad, stairMetaN, x, 1, 4, box);
                        continue block7;
                    }
                    case 3: {
                        this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, stairMetaS | 4, x, 1, 2, box);
                        this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, (i < 1 ? stairMetaE : stairMetaW) | 4, x, 1, 3, box);
                        this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, stairMetaN | 4, x, 1, 4, box);
                        this.func_151550_a(world, Blocks.field_150457_bL, 0, x, 2, 2, box);
                        continue block7;
                    }
                    case 4: {
                        this.fillWithBlocks(world, box, x, 1, 1, x, 3, 1, ModBlocks.deco_tungsten);
                        this.func_151550_a(world, ModBlocks.deco_tungsten, 0, x, 1, 3, box);
                        this.fillWithMetadataBlocks(world, box, x, 3, 2, x, 3, 4, ModBlocks.concrete_smooth_stairs, i < 1 ? stairMetaE : stairMetaW);
                        this.fillWithBlocks(world, box, x, 1, 5, x, 3, 5, ModBlocks.deco_tungsten);
                        this.fillWithMetadataBlocks(world, box, x, 1, 2, x, 2, 2, ModBlocks.tape_recorder, i < 1 ? decoMetaW : decoMetaE);
                        this.fillWithMetadataBlocks(world, box, x, 1, 4, x, 2, 4, ModBlocks.tape_recorder, i < 1 ? decoMetaW : decoMetaE);
                        this.func_151550_a(world, ModBlocks.deco_computer, i < 1 ? this.getDecoModelMeta(3) : this.getDecoModelMeta(2), x, 2, 3, box);
                        continue block7;
                    }
                    case 5: {
                        this.func_151550_a(world, Blocks.field_150422_aJ, 0, x, 1, 1, box);
                        this.func_151550_a(world, Blocks.field_150452_aw, 0, x, 2, 1, box);
                        this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, stairMetaS | 4, x, 1, 3, box);
                        this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, stairMetaN | 4, x, 1, 4, box);
                        this.func_151550_a(world, ModBlocks.radiorec, i < 1 ? decoMetaE : decoMetaW, x, 2, 3, box);
                    }
                }
            }
            this.placeDoor(world, box, ModBlocks.door_bunker, 1, true, rand.nextBoolean(), 2, 1, 0);
            this.placeDoor(world, box, ModBlocks.door_bunker, 1, false, rand.nextBoolean(), 3, 1, 0);
            if (this.path) {
                this.func_74878_a(world, box, 2, 1, 6, 3, 2, 6);
            }
            return true;
        }

        public static StructureComponent findValidPlacement(List components, Random rand, int x, int y, int z, int coordMode, int type) {
            StructureBoundingBox box = ProceduralStructureStart.getComponentToAddBoundingBox(x, y, z, -3, -1, 0, 6, 6, 7, coordMode);
            return box.field_78895_b > 10 && StructureComponent.func_74883_a((List)components, (StructureBoundingBox)box) == null ? new Corridor(type, box, coordMode, rand) : null;
        }
    }

    public static class StartingHub
    extends Component
    implements ProceduralStructureStart.ProceduralComponent {
        private boolean[] paths = new boolean[3];

        public StartingHub() {
        }

        public StartingHub(Random rand, int x, int z) {
            super(rand, x, 64, z, 7, 5, 7);
        }

        public StartingHub(int componentType, StructureBoundingBox box, int coordMode) {
            super(componentType);
            this.field_74887_e = box;
            this.field_74885_f = coordMode;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbt) {
            super.func_143012_a(nbt);
            for (int i = 0; i < this.paths.length; ++i) {
                nbt.func_74757_a("p" + i, this.paths[i]);
            }
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbt) {
            super.func_143011_b(nbt);
            for (int i = 0; i < this.paths.length; ++i) {
                this.paths[i] = nbt.func_74767_n("p" + i);
            }
        }

        @Override
        public void buildComponent(ProceduralStructureStart start, Random rand) {
            this.paths[0] = this.getNextComponentEast(start, this, this.field_74885_f, rand, 5, 1) != null;
            this.paths[1] = this.getNextComponentAntiNormal(start, this, this.field_74885_f, rand, 4, 1) != null;
            this.paths[2] = this.getNextComponentWest(start, this, this.field_74885_f, rand, 3, 1) != null;
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            this.func_74878_a(world, box, 1, 1, 1, 6, 3, 6);
            this.fillWithMetadataBlocks(world, box, 1, 0, 1, 6, 0, 6, ModBlocks.vinyl_tile, 1);
            this.fillWithBlocks(world, box, 1, 4, 1, 6, 4, 6, ModBlocks.vinyl_tile);
            this.fillWithBlocks(world, box, 1, 4, 4, 3, 4, 6, ModBlocks.reinforced_stone);
            this.fillWithBlocks(world, box, 0, 5, 0, 7, 5, 7, ModBlocks.reinforced_stone);
            this.fillWithRandomizedBlocks(world, box, 0, 0, 0, 0, 4, 7, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 0, 7, 6, 4, 7, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 7, 0, 0, 7, 4, 7, rand, ConcreteBricks);
            this.fillWithRandomizedBlocks(world, box, 1, 0, 0, 6, 4, 0, rand, ConcreteBricks);
            int hpos = Component.getAverageHeight(world, this.field_74887_e, box, this.field_74887_e.field_78894_e) - this.field_74887_e.field_78895_b;
            this.func_151550_a(world, ModBlocks.concrete_slab, 1, 0, hpos, 5, box);
            this.fillWithMetadataBlocks(world, box, 1, hpos, 4, 1, hpos, 6, ModBlocks.concrete_smooth_stairs, this.getStairMeta(0));
            this.func_151550_a(world, ModBlocks.concrete_slab, 1, 2, hpos, 3, box);
            this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, this.getStairMeta(2), 2, hpos, 4, box);
            this.func_151550_a(world, Blocks.field_150415_aT, this.getDecoModelMeta(8) >> 2, 2, hpos, 5, box);
            this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, this.getStairMeta(3), 2, hpos, 6, box);
            this.func_151550_a(world, ModBlocks.concrete_slab, 1, 2, hpos, 7, box);
            this.fillWithMetadataBlocks(world, box, 3, hpos, 4, 3, hpos, 6, ModBlocks.concrete_smooth_stairs, this.getStairMeta(1));
            this.func_151550_a(world, ModBlocks.concrete_slab, 1, 4, hpos, 5, box);
            this.fillWithBlocks(world, box, 1, 6, 4, 1, hpos - 1, 6, ModBlocks.reinforced_stone);
            this.fillWithBlocks(world, box, 2, 1, 6, 2, hpos - 1, 6, ModBlocks.reinforced_stone);
            this.fillWithBlocks(world, box, 3, 6, 4, 3, hpos - 1, 6, ModBlocks.reinforced_stone);
            this.fillWithBlocks(world, box, 2, 6, 4, 2, hpos - 1, 4, ModBlocks.reinforced_stone);
            this.fillWithMetadataBlocks(world, box, 2, 1, 5, 2, hpos - 1, 5, ModBlocks.ladder_sturdy, this.getDecoMeta(2));
            this.func_151550_a(world, ModBlocks.reinforced_lamp_off, 0, 2, 5, 2, box);
            this.func_151550_a(world, ModBlocks.reinforced_lamp_off, 0, 5, 5, 2, box);
            this.func_151550_a(world, ModBlocks.reinforced_lamp_off, 0, 5, 5, 5, box);
            this.func_151550_a(world, ModBlocks.fan, 0, 2, 4, 2, box);
            this.func_151550_a(world, ModBlocks.fan, 0, 5, 4, 2, box);
            this.func_151550_a(world, ModBlocks.fan, 0, 5, 4, 5, box);
            this.func_151550_a(world, ModBlocks.deco_tungsten, 0, 3, 1, 6, box);
            this.generateInvContents(world, box, rand, (Block)Blocks.field_150486_ae, this.getDecoMeta(3), 4, 1, 6, HbmChestContents.antenna, 5);
            this.func_151550_a(world, ModBlocks.deco_tungsten, 0, 5, 1, 6, box);
            this.fillWithMetadataBlocks(world, box, 3, 2, 6, 5, 2, 6, ModBlocks.concrete_smooth_stairs, this.getStairMeta(2) | 4);
            this.fillWithMetadataBlocks(world, box, 3, 3, 6, 5, 3, 6, ModBlocks.tape_recorder, this.getDecoMeta(2));
            this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, this.getStairMeta(1) | 4, 3, 1, 4, box);
            this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, this.getStairMeta(3) | 4, 4, 1, 4, box);
            this.func_151550_a(world, ModBlocks.concrete_smooth_stairs, this.getStairMeta(0) | 4, 5, 1, 4, box);
            this.func_151550_a(world, ModBlocks.deco_computer, this.getDecoModelMeta(1), 4, 2, 4, box);
            if (this.paths[0]) {
                this.func_74878_a(world, box, 7, 1, 2, 7, 2, 3);
            }
            if (this.paths[1]) {
                this.func_74878_a(world, box, 3, 1, 0, 4, 2, 0);
            }
            if (this.paths[2]) {
                this.func_74878_a(world, box, 0, 1, 2, 0, 2, 3);
            }
            return true;
        }
    }

    public static class BunkerStart
    extends ProceduralStructureStart {
        public BunkerStart() {
        }

        public BunkerStart(World world, Random rand, int chunkX, int chunkZ) {
            super(chunkX, chunkZ);
            this.sizeLimit = 7 + rand.nextInt(6);
            this.distanceLimit = 40;
            int x = chunkX * 16 + 8;
            int z = chunkZ * 16 + 8;
            ProceduralStructureStart.Weight[] weights = new ProceduralStructureStart.Weight[]{new ProceduralStructureStart.Weight(6, 3, Corridor::findValidPlacement), new ProceduralStructureStart.Weight(5, 4, BedroomL::findValidPlacement), new ProceduralStructureStart.Weight(10, 3, FunJunction::findValidPlacement), new ProceduralStructureStart.Weight(5, 2, BathroomL::findValidPlacement), new ProceduralStructureStart.Weight(7, 2, Laboratory::findValidPlacement), new ProceduralStructureStart.Weight(5, 1, PowerRoom::findValidPlacement)};
            StartingHub starter = new StartingHub(rand, x, z);
            this.buildStart(world, rand, starter, weights);
            this.func_75067_a(world, rand, 20);
        }
    }
}

