/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.gen;

import com.hbm.config.StructureConfig;
import com.hbm.world.gen.MapGenNTMFeatures;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.event.world.WorldEvent;

public class NTMWorldGenerator
implements IWorldGenerator {
    private MapGenNTMFeatures scatteredFeatureGenerator = new MapGenNTMFeatures();
    private final Random rand = new Random();
    private boolean hasPopulationEvent = false;

    @SubscribeEvent
    public void onLoad(WorldEvent.Load event) {
        this.scatteredFeatureGenerator = (MapGenNTMFeatures)TerrainGen.getModdedMapGen((MapGenBase)new MapGenNTMFeatures(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CUSTOM);
        this.hasPopulationEvent = false;
    }

    private void setRandomSeed(World world, int chunkX, int chunkZ) {
        this.rand.setSeed(world.func_72905_C());
        long i = this.rand.nextLong() / 2L * 2L + 1L;
        long j = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * i + (long)chunkZ * j ^ world.func_72905_C());
    }

    @SubscribeEvent
    public void generateStructures(PopulateChunkEvent.Pre event) {
        this.setRandomSeed(event.world, event.chunkX, event.chunkZ);
        this.hasPopulationEvent = true;
        if (!StructureConfig.enableStructures) {
            return;
        }
        switch (event.world.field_73011_w.field_76574_g) {
            case -1: {
                break;
            }
            case 0: {
                this.generateOverworldStructures(event.world, event.chunkProvider, event.chunkX, event.chunkZ);
                break;
            }
        }
    }

    protected void generateOverworldStructures(World world, IChunkProvider chunkProvider, int chunkX, int chunkZ) {
        Block[] ablock = new Block[65536];
        this.scatteredFeatureGenerator.func_151539_a(chunkProvider, world, chunkX, chunkZ, ablock);
        this.scatteredFeatureGenerator.func_75051_a(world, this.rand, chunkX, chunkZ);
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                this.generateNether(world, rand, chunkGenerator, chunkX, chunkZ);
                break;
            }
            case 0: {
                this.generateSurface(world, rand, chunkGenerator, chunkProvider, chunkX, chunkZ);
                break;
            }
            case 1: {
                this.generateEnd(world, rand, chunkGenerator, chunkX, chunkZ);
            }
        }
    }

    private void generateNether(World world, Random rand, IChunkProvider chunkGenerator, int chunkX, int chunkZ) {
    }

    private void generateSurface(World world, Random rand, IChunkProvider chunkGenerator, IChunkProvider chunkProvider, int chunkX, int chunkZ) {
        if (!this.hasPopulationEvent) {
            this.setRandomSeed(world, chunkX, chunkZ);
            if (StructureConfig.enableStructures) {
                this.generateOverworldStructures(world, chunkGenerator, chunkX, chunkZ);
            }
        }
        int posX = (chunkX << 4) + 8;
        int posZ = (chunkZ << 4) + 8;
        BiomeGenBase biome = world.func_72807_a(posX, posZ);
    }

    private void generateEnd(World world, Random rand, IChunkProvider chunkGenerator, int chunkX, int chunkZ) {
    }

    public static boolean isBiomeOfTypes(BiomeGenBase biome, BiomeDictionary.Type ... types) {
        for (BiomeDictionary.Type type : types) {
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)type)) continue;
            return false;
        }
        return true;
    }
}

