/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.feature;

import com.hbm.inventory.RecipesCommon;
import com.hbm.world.generator.DungeonToolbox;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;

public class OreLayer {
    private NoiseGeneratorPerlin noise;
    private RecipesCommon.MetaBlock ore;
    private Block target;
    private float density;
    private int threshold = 5;
    private int rangeMult = 3;
    private int maxRange = 4;
    private int yLevel = 30;
    int dim = 0;

    public OreLayer(Block ore, float density) {
        this(ore, 0, Blocks.field_150348_b, density);
    }

    public OreLayer(Block ore, int meta, Block target, float density) {
        this.ore = new RecipesCommon.MetaBlock(ore, meta);
        this.target = target;
        this.density = density;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public OreLayer setThreshold(int threshold) {
        this.threshold = threshold;
        return this;
    }

    public OreLayer setRangeMult(int rangeMult) {
        this.rangeMult = rangeMult;
        return this;
    }

    public OreLayer setMaxRange(int maxRange) {
        this.maxRange = maxRange;
        return this;
    }

    public OreLayer setYLevel(int yLevel) {
        this.yLevel = yLevel;
        return this;
    }

    public OreLayer setDimension(int dim) {
        this.dim = dim;
        return this;
    }

    @SubscribeEvent
    public void onDecorate(DecorateBiomeEvent.Pre event) {
        World world = event.world;
        if (world.field_73011_w == null || world.field_73011_w.field_76574_g != this.dim) {
            return;
        }
        if (this.noise == null) {
            this.noise = new NoiseGeneratorPerlin(new Random(event.world.func_72905_C() + (long)(this.ore.getID() * 31) + (long)this.yLevel), 4);
        }
        int cX = event.chunkX;
        int cZ = event.chunkZ;
        double scale = 0.01;
        for (int x = cX; x < cX + 16; ++x) {
            for (int z = cZ; z < cZ + 16; ++z) {
                double n = this.noise.func_151601_a((double)x * scale, (double)z * scale);
                if (!(n > (double)this.threshold)) continue;
                int range = (int)((n - (double)this.threshold) * (double)this.rangeMult);
                if (range > this.maxRange) {
                    range = this.maxRange * 2 - range;
                }
                if (range < 0) continue;
                for (int y = this.yLevel - range; y <= this.yLevel + range; ++y) {
                    Block genTarget;
                    if (!(event.rand.nextFloat() < this.density) || !(genTarget = world.func_147439_a(x, y, z)).isReplaceableOreGen(world, x, y, z, this.target) || !DungeonToolbox.allowedToReplace(genTarget)) continue;
                    world.func_147465_d(x, y, z, this.ore.block, this.ore.meta, 2);
                }
            }
        }
    }
}

