/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.feature;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockStalagmite;
import com.hbm.inventory.RecipesCommon;
import com.hbm.world.generator.DungeonToolbox;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;

public class OreCave {
    private NoiseGeneratorPerlin noise;
    private RecipesCommon.MetaBlock ore;
    private double threshold = 2.0;
    private int rangeMult = 3;
    private int maxRange = 4;
    private int yLevel = 30;
    private Block fluid;
    int dim = 0;

    public OreCave(Block ore) {
        this(ore, 0);
    }

    public OreCave(Block ore, int meta) {
        this.ore = new RecipesCommon.MetaBlock(ore, meta);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public OreCave setThreshold(double threshold) {
        this.threshold = threshold;
        return this;
    }

    public OreCave setRangeMult(int rangeMult) {
        this.rangeMult = rangeMult;
        return this;
    }

    public OreCave setMaxRange(int maxRange) {
        this.maxRange = maxRange;
        return this;
    }

    public OreCave setYLevel(int yLevel) {
        this.yLevel = yLevel;
        return this;
    }

    public OreCave withFluid(Block fluid) {
        this.fluid = fluid;
        return this;
    }

    public OreCave setDimension(int dim) {
        this.dim = dim;
        return this;
    }

    @SubscribeEvent
    public void onDecorate(DecorateBiomeEvent.Pre event) {
        World world = event.world;
        if (world.field_73011_w == null || world.field_73011_w.field_76574_g != this.dim) {
            return;
        }
        if (this.noise == null) {
            this.noise = new NoiseGeneratorPerlin(new Random(event.world.func_72905_C() + (long)(this.ore.getID() * 31) + (long)this.yLevel), 2);
        }
        int cX = event.chunkX;
        int cZ = event.chunkZ;
        double scale = 0.01;
        for (int x = cX + 8; x < cX + 24; ++x) {
            for (int z = cZ + 8; z < cZ + 24; ++z) {
                double n = this.noise.func_151601_a((double)x * scale, (double)z * scale);
                if (!(n > this.threshold)) continue;
                int range = (int)((n - this.threshold) * (double)this.rangeMult);
                if (range > this.maxRange) {
                    range = this.maxRange * 2 - range;
                }
                if (range < 0) continue;
                for (int y = this.yLevel - range; y <= this.yLevel + range; ++y) {
                    Block genTarget = world.func_147439_a(x, y, z);
                    if (genTarget.func_149721_r() && (genTarget.func_149688_o() == Material.field_151576_e || genTarget.func_149688_o() == Material.field_151578_c) && DungeonToolbox.allowedToReplace(genTarget)) {
                        Block neighbor;
                        boolean shouldGen = false;
                        boolean canGenFluid = event.rand.nextBoolean();
                        block8: for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                            neighbor = world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
                            if (neighbor.func_149688_o() == Material.field_151579_a || neighbor instanceof BlockStalagmite) {
                                shouldGen = true;
                            }
                            if (shouldGen && (this.fluid == null || !canGenFluid)) break;
                            if (this.fluid == null) continue;
                            switch (dir) {
                                case UP: {
                                    if (neighbor.func_149688_o() == Material.field_151579_a || neighbor instanceof BlockStalagmite) continue block8;
                                    canGenFluid = false;
                                    continue block8;
                                }
                                case DOWN: {
                                    if (neighbor.func_149721_r()) continue block8;
                                    canGenFluid = false;
                                    continue block8;
                                }
                                case NORTH: 
                                case SOUTH: 
                                case EAST: 
                                case WEST: {
                                    if (neighbor.func_149721_r() || neighbor == this.fluid) continue block8;
                                    canGenFluid = false;
                                }
                            }
                        }
                        if (this.fluid != null && canGenFluid) {
                            world.func_147465_d(x, y, z, this.fluid, 0, 2);
                            world.func_147465_d(x, y - 1, z, this.ore.block, this.ore.meta, 2);
                            for (int i = 2; i < 6; ++i) {
                                ForgeDirection dir = ForgeDirection.getOrientation((int)i);
                                int clX = x + dir.offsetX;
                                int clZ = z + dir.offsetZ;
                                neighbor = world.func_147439_a(clX, y, clZ);
                                if (!neighbor.func_149721_r()) continue;
                                world.func_147465_d(clX, y, clZ, this.ore.block, this.ore.meta, 2);
                            }
                            continue;
                        }
                        if (!shouldGen) continue;
                        world.func_147465_d(x, y, z, this.ore.block, this.ore.meta, 2);
                        continue;
                    }
                    if (genTarget.func_149688_o() != Material.field_151579_a && genTarget.func_149721_r() || event.rand.nextInt(5) != 0 || genTarget.func_149688_o().func_76224_d()) continue;
                    if (ModBlocks.stalactite.func_149742_c(world, x, y, z)) {
                        world.func_147465_d(x, y, z, ModBlocks.stalactite, BlockStalagmite.getMetaFromResource(this.ore.meta), 2);
                        continue;
                    }
                    if (!ModBlocks.stalagmite.func_149742_c(world, x, y, z)) continue;
                    world.func_147465_d(x, y, z, ModBlocks.stalagmite, BlockStalagmite.getMetaFromResource(this.ore.meta), 2);
                }
            }
        }
    }
}

