/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.feature;

import com.hbm.blocks.BlockEnums;
import com.hbm.blocks.ModBlocks;
import com.hbm.world.generator.DungeonToolbox;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;

public class BiomeCave {
    private NoiseGeneratorPerlin noise;
    private double threshold = 2.0;
    private int rangeMult = 3;
    private int maxRange = 4;
    private int yLevel = 30;

    public BiomeCave() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public BiomeCave setThreshold(double threshold) {
        this.threshold = threshold;
        return this;
    }

    public BiomeCave setRangeMult(int rangeMult) {
        this.rangeMult = rangeMult;
        return this;
    }

    public BiomeCave setMaxRange(int maxRange) {
        this.maxRange = maxRange;
        return this;
    }

    public BiomeCave setYLevel(int yLevel) {
        this.yLevel = yLevel;
        return this;
    }

    @SubscribeEvent
    public void onDecorate(DecorateBiomeEvent.Pre event) {
        World world = event.world;
        if (world.field_73011_w == null || world.field_73011_w.field_76574_g != 0) {
            return;
        }
        if (this.noise == null) {
            this.noise = new NoiseGeneratorPerlin(new Random(event.world.func_72905_C() - 1916169L + (long)this.yLevel), 2);
        }
        int cX = event.chunkX;
        int cZ = event.chunkZ;
        double scale = 0.01;
        for (int x = cX + 8; x < cX + 24; ++x) {
            for (int z = cZ + 8; z < cZ + 24; ++z) {
                BiomeGenBase biome = world.func_72807_a(x, z);
                BlockEnums.EnumBiomeType type = BiomeCave.getTypeFromBiome(biome);
                double n = this.noise.func_151601_a((double)x * scale, (double)z * scale);
                if (type == null || !(n > this.threshold)) continue;
                int range = (int)((n - this.threshold) * (double)this.rangeMult);
                if (range > this.maxRange) {
                    range = this.maxRange * 2 - range;
                }
                if (range < 0) continue;
                for (int y = this.yLevel - range; y <= this.yLevel + range; ++y) {
                    BiomeCave.handleBiome(world, x, y, z, type);
                }
            }
        }
    }

    private static void handleBiome(World world, int x, int y, int z, BlockEnums.EnumBiomeType type) {
        Block target = world.func_147439_a(x, y, z);
        if (target.func_149721_r() && DungeonToolbox.allowedToReplace(target)) {
            boolean shouldGen = false;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ).isAir((IBlockAccess)world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) {
                    shouldGen = true;
                    break;
                }
                if (!world.func_147439_a(x + dir.offsetX * 2, y + dir.offsetY * 2, z + dir.offsetZ * 2).isAir((IBlockAccess)world, x + dir.offsetX * 2, y + dir.offsetY * 2, z + dir.offsetZ * 2)) continue;
                shouldGen = true;
                break;
            }
            if (shouldGen) {
                world.func_147465_d(x, y, z, ModBlocks.stone_biome, type.ordinal(), 2);
            }
        }
    }

    private static BlockEnums.EnumBiomeType getTypeFromBiome(BiomeGenBase biome) {
        if (biome.field_76750_F >= 1.0f && (double)biome.field_76751_G < 0.25) {
            return BlockEnums.EnumBiomeType.DESERT;
        }
        if ((double)biome.field_76750_F >= 0.5 && (double)biome.field_76751_G > 0.25 && biome.func_150561_m() != BiomeGenBase.TempCategory.OCEAN) {
            return BlockEnums.EnumBiomeType.WOODLAND;
        }
        return null;
    }
}

