/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util.fauxpointtwelve;

import com.hbm.util.fauxpointtwelve.Rotation;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPos {
    private final int x;
    private final int y;
    private final int z;

    public BlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockPos(TileEntity te) {
        this(te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public BlockPos(double x, double y, double z) {
        this(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
    }

    public BlockPos add(int x, int y, int z) {
        return x == 0 && y == 0 && z == 0 ? this : new BlockPos(this.getX() + x, this.getY() + y, this.getZ() + z);
    }

    public BlockPos add(double x, double y, double z) {
        return x == 0.0 && y == 0.0 && z == 0.0 ? this : new BlockPos((double)this.getX() + x, (double)this.getY() + y, (double)this.getZ() + z);
    }

    public BlockPos add(BlockPos vec) {
        return this.add(vec.getX(), vec.getY(), vec.getZ());
    }

    public BlockPos rotate(Rotation rotationIn) {
        switch (rotationIn) {
            default: {
                return this;
            }
            case CLOCKWISE_90: {
                return new BlockPos(-this.getZ(), this.getY(), this.getX());
            }
            case CLOCKWISE_180: {
                return new BlockPos(-this.getX(), this.getY(), -this.getZ());
            }
            case COUNTERCLOCKWISE_90: 
        }
        return new BlockPos(this.getZ(), this.getY(), -this.getX());
    }

    public BlockPos offset(ForgeDirection dir) {
        return this.offset(dir, 1);
    }

    public BlockPos offset(ForgeDirection dir, int distance) {
        return new BlockPos(this.x + dir.offsetX * distance, this.y + dir.offsetY * distance, this.z + dir.offsetZ * distance);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int hashCode() {
        return (this.getY() + this.getZ() * 31) * 31 + this.getX();
    }

    public boolean equals(Object toCompare) {
        if (this == toCompare) {
            return true;
        }
        if (!(toCompare instanceof BlockPos)) {
            return false;
        }
        BlockPos pos = (BlockPos)toCompare;
        if (this.getX() != pos.getX()) {
            return false;
        }
        if (this.getY() != pos.getY()) {
            return false;
        }
        return this.getZ() == pos.getZ();
    }
}

