/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockLoot;
import com.hbm.items.ItemAmmoEnums;
import com.hbm.items.ModItems;
import com.hbm.items.special.ItemBookLore;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LootGenerator {
    public static void setBlock(World world, int x, int y, int z) {
        world.func_147449_b(x, y, z, ModBlocks.deco_loot);
    }

    public static void addItemWithDeviation(BlockLoot.TileEntityLoot loot, Random rand, ItemStack stack, double x, double y, double z) {
        loot.addItem(stack, x + rand.nextGaussian() * 0.02, y, z + rand.nextGaussian() * 0.02);
    }

    public static void lootBooklet(World world, int x, int y, int z) {
        BlockLoot.TileEntityLoot loot = (BlockLoot.TileEntityLoot)world.func_147438_o(x, y, z);
        if (loot != null && loot.items.isEmpty()) {
            loot.addItem(ItemBookLore.createBook("beacon", 12, 0x404040, 14038963), 0.0, 0.0, 0.0);
        }
    }

    public static void lootCapNuke(World world, int x, int y, int z) {
        BlockLoot.TileEntityLoot loot = (BlockLoot.TileEntityLoot)world.func_147438_o(x, y, z);
        if (loot != null && loot.items.isEmpty()) {
            int i;
            if (world.field_73012_v.nextInt(5) == 0) {
                loot.addItem(ModItems.ammo_nuke.stackFromEnum(ItemAmmoEnums.AmmoFatman.LOW), -0.25, 0.0, -0.125);
            } else {
                loot.addItem(new ItemStack((Item)ModItems.ammo_rocket), -0.25, 0.0, -0.25);
            }
            for (i = 0; i < 4; ++i) {
                LootGenerator.addItemWithDeviation(loot, world.field_73012_v, new ItemStack(ModItems.cap_nuka, 2), 0.125, (double)i * 0.03125, 0.25);
            }
            for (i = 0; i < 2; ++i) {
                LootGenerator.addItemWithDeviation(loot, world.field_73012_v, new ItemStack(ModItems.syringe_metal_stimpak, 1), -0.25, (double)i * 0.03125, 0.25);
            }
            for (i = 0; i < 6; ++i) {
                LootGenerator.addItemWithDeviation(loot, world.field_73012_v, new ItemStack(ModItems.cap_nuka, 2), 0.125, (double)i * 0.03125, -0.25);
            }
        }
    }

    public static void lootMedicine(World world, int x, int y, int z) {
        BlockLoot.TileEntityLoot loot = (BlockLoot.TileEntityLoot)world.func_147438_o(x, y, z);
        if (loot != null && loot.items.isEmpty()) {
            for (int i = 0; i < 4; ++i) {
                int type = world.field_73012_v.nextInt(4);
                Item syringe = type < 2 ? ModItems.syringe_metal_stimpak : (type == 2 ? ModItems.syringe_metal_medx : ModItems.syringe_metal_psycho);
                LootGenerator.addItemWithDeviation(loot, world.field_73012_v, new ItemStack(syringe), 0.125, (double)i * 0.03125, 0.25);
            }
            int type = world.field_73012_v.nextInt(8);
            Item syringe = type < 2 ? ModItems.radaway : (type < 4 ? ModItems.radx : (type < 7 ? ModItems.iv_blood : ModItems.siox));
            LootGenerator.addItemWithDeviation(loot, world.field_73012_v, new ItemStack(syringe), -0.25, 0.0, -0.125);
        }
    }

    public static void lootCapStash(World world, int x, int y, int z) {
        BlockLoot.TileEntityLoot loot = (BlockLoot.TileEntityLoot)world.func_147438_o(x, y, z);
        if (loot != null && loot.items.isEmpty()) {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    int r = world.field_73012_v.nextInt(3);
                    Item cap = r < 2 ? ModItems.cap_nuka : ModItems.cap_sunset;
                    int count = world.field_73012_v.nextInt(5) + 3;
                    for (int k = 0; k < count; ++k) {
                        if (cap == ModItems.cap_sunset && world.field_73012_v.nextInt(10) == 0) {
                            LootGenerator.addItemWithDeviation(loot, world.field_73012_v, new ItemStack(ModItems.cap_star, 1), (double)i * 0.3125, (double)k * 0.03125, (double)j * 0.3125);
                            continue;
                        }
                        LootGenerator.addItemWithDeviation(loot, world.field_73012_v, new ItemStack(cap, 4), (double)i * 0.3125, (double)k * 0.03125, (double)j * 0.3125);
                    }
                }
            }
        }
    }

    public static void lootMakeshiftGun(World world, int x, int y, int z) {
        BlockLoot.TileEntityLoot loot = (BlockLoot.TileEntityLoot)world.func_147438_o(x, y, z);
        if (loot != null && loot.items.isEmpty()) {
            int i;
            if (world.field_73012_v.nextInt(2) == 0) {
                LootGenerator.addItemWithDeviation(loot, world.field_73012_v, new ItemStack(ModItems.gun_lever_action), 0.0, 0.0, 0.125);
            }
            int count = world.field_73012_v.nextInt(2) + 1;
            for (i = 0; i < count; ++i) {
                int type = world.field_73012_v.nextInt(2);
                Item parts = type < 1 ? ModItems.plate_steel : ModItems.mechanism_rifle_1;
                LootGenerator.addItemWithDeviation(loot, world.field_73012_v, new ItemStack(parts), -0.3125, (double)i * 0.03125, 0.3125);
            }
            count = world.field_73012_v.nextInt(2) + 2;
            for (i = 0; i < count; ++i) {
                LootGenerator.addItemWithDeviation(loot, world.field_73012_v, new ItemStack(ModItems.wire_aluminium), 0.3125, (double)i * 0.03125, -0.125);
            }
            int type = world.field_73012_v.nextInt(4);
            Item tool = type > 2 ? ModItems.wrench : ModItems.screwdriver;
            LootGenerator.addItemWithDeviation(loot, world.field_73012_v, new ItemStack(tool), 0.005, 0.0, -0.3125);
        }
    }

    public static void lootNukeStorage(World world, int x, int y, int z) {
        BlockLoot.TileEntityLoot loot = (BlockLoot.TileEntityLoot)world.func_147438_o(x, y, z);
        if (loot != null && loot.items.isEmpty()) {
            boolean memes = world.field_73012_v.nextInt(10) == 0;
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    if (!world.field_73012_v.nextBoolean() && !memes) continue;
                    int type = world.field_73012_v.nextInt(11);
                    ItemAmmoEnums.AmmoFatman nuke = memes ? ItemAmmoEnums.AmmoFatman.PUMPKIN : (type == 0 ? ItemAmmoEnums.AmmoFatman.STOCK : (type <= 5 ? ItemAmmoEnums.AmmoFatman.LOW : ItemAmmoEnums.AmmoFatman.SAFE));
                    loot.addItem(ModItems.ammo_nuke.stackFromEnum(nuke), -0.375 + (double)i * 0.25, 0.0, -0.375 + (double)j * 0.25);
                }
            }
        }
    }
}

