/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import com.hbm.handler.ArmorModHandler;
import com.hbm.items.ModItems;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Method;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraftforge.common.ForgeHooks;

public class EntityDamageUtil {
    public static boolean wasAttackedByV1(DamageSource source) {
        Entity attacker;
        if (source instanceof EntityDamageSource && (attacker = ((EntityDamageSource)source).func_76346_g()) instanceof EntityPlayer) {
            ItemStack[] mods;
            EntityPlayer player = (EntityPlayer)attacker;
            ItemStack chestplate = player.field_71071_by.field_70460_b[2];
            if (chestplate != null && ArmorModHandler.hasMods(chestplate) && (mods = ArmorModHandler.pryMods(chestplate))[7] != null && mods[7].func_77973_b() == ModItems.v1) {
                return true;
            }
        }
        return false;
    }

    public static boolean attackEntityFromArmorPiercing(Entity victim, DamageSource src, float damage, float piercing) {
        if (src.func_76363_c() || piercing == 0.0f) {
            return victim.func_70097_a(src, damage);
        }
        if (piercing == 1.0f) {
            src.func_76348_h();
            return victim.func_70097_a(src, damage);
        }
        boolean ret = false;
        ret |= victim.func_70097_a(src, damage * (1.0f - piercing));
        src.func_76348_h();
        return ret |= victim.func_70097_a(src, damage * piercing);
    }

    public static boolean attackEntityFromIgnoreIFrame(Entity victim, DamageSource src, float damage) {
        if (!victim.func_70097_a(src, damage)) {
            if (victim instanceof EntityLivingBase) {
                damage += ((EntityLivingBase)victim).field_110153_bc;
            }
            return victim.func_70097_a(src, damage);
        }
        return true;
    }

    public static boolean attackEntityFromNT(EntityLivingBase living, DamageSource source, float amount) {
        String s;
        if (ForgeHooks.onLivingAttack((EntityLivingBase)living, (DamageSource)source, (float)amount)) {
            return false;
        }
        if (living.func_85032_ar()) {
            return false;
        }
        if (living.field_70170_p.field_72995_K) {
            return false;
        }
        living.field_70708_bq = 0;
        if (living.func_110143_aJ() <= 0.0f) {
            return false;
        }
        if (source.func_76347_k() && living.func_70644_a(Potion.field_76426_n)) {
            return false;
        }
        if ((source == DamageSource.field_82728_o || source == DamageSource.field_82729_p) && living.func_71124_b(4) != null) {
            living.func_71124_b(4).func_77972_a((int)(amount * 4.0f + living.func_70681_au().nextFloat() * amount * 2.0f), living);
            amount *= 0.75f;
        }
        living.field_70721_aZ = 1.5f;
        boolean flag = true;
        if ((float)living.field_70172_ad > (float)living.field_70771_an / 2.0f) {
            if (amount <= living.field_110153_bc) {
                return false;
            }
            EntityDamageUtil.damageEntity(living, source, amount - living.field_110153_bc);
            living.field_110153_bc = amount;
            flag = false;
        } else {
            living.field_110153_bc = amount;
            living.field_70735_aL = living.func_110143_aJ();
            living.field_70172_ad = living.field_70771_an;
            EntityDamageUtil.damageEntity(living, source, amount);
            living.field_70738_aO = 10;
            living.field_70737_aN = 10;
        }
        living.field_70739_aP = 0.0f;
        Entity entity = source.func_76346_g();
        if (entity != null) {
            EntityTameable entitywolf;
            if (entity instanceof EntityLivingBase) {
                living.func_70604_c((EntityLivingBase)entity);
            }
            if (entity instanceof EntityPlayer) {
                living.field_70718_bc = 100;
                living.field_70717_bb = (EntityPlayer)entity;
            } else if (entity instanceof EntityTameable && (entitywolf = (EntityTameable)entity).func_70909_n()) {
                living.field_70718_bc = 100;
                living.field_70717_bb = null;
            }
        }
        if (flag) {
            living.field_70170_p.func_72960_a((Entity)living, (byte)2);
            if (source != DamageSource.field_76369_e) {
                EntityDamageUtil.setBeenAttacked(living);
            }
            if (entity != null) {
                double d1 = entity.field_70165_t - living.field_70165_t;
                double d0 = entity.field_70161_v - living.field_70161_v;
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                living.field_70739_aP = (float)(Math.atan2(d0, d1) * 180.0 / Math.PI) - living.field_70177_z;
                living.func_70653_a(entity, amount, d1, d0);
            } else {
                living.field_70739_aP = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (living.func_110143_aJ() <= 0.0f) {
            s = EntityDamageUtil.getDeathSound(living);
            if (flag && s != null) {
                living.func_85030_a(s, EntityDamageUtil.getSoundVolume(living), EntityDamageUtil.getSoundPitch(living));
            }
            living.func_70645_a(source);
        } else {
            s = EntityDamageUtil.getHurtSound(living);
            if (flag && s != null) {
                living.func_85030_a(s, EntityDamageUtil.getSoundVolume(living), EntityDamageUtil.getSoundPitch(living));
            }
        }
        return true;
    }

    public static String getDeathSound(EntityLivingBase living) {
        Method m = ReflectionHelper.findMethod(EntityLivingBase.class, (Object)living, (String[])new String[]{"func_70673_aS", "getDeathSound"}, (Class[])new Class[0]);
        try {
            return (String)m.invoke((Object)living, new Object[0]);
        }
        catch (Exception exception) {
            return "game.neutral.die";
        }
    }

    public static String getHurtSound(EntityLivingBase living) {
        Method m = ReflectionHelper.findMethod(EntityLivingBase.class, (Object)living, (String[])new String[]{"func_70621_aR", "getHurtSound"}, (Class[])new Class[0]);
        try {
            return (String)m.invoke((Object)living, new Object[0]);
        }
        catch (Exception exception) {
            return "game.neutral.hurt";
        }
    }

    public static float getSoundVolume(EntityLivingBase living) {
        Method m = ReflectionHelper.findMethod(EntityLivingBase.class, (Object)living, (String[])new String[]{"func_70599_aP", "getSoundVolume"}, (Class[])new Class[0]);
        try {
            return ((Float)m.invoke((Object)living, new Object[0])).floatValue();
        }
        catch (Exception exception) {
            return 1.0f;
        }
    }

    public static float getSoundPitch(EntityLivingBase living) {
        Method m = ReflectionHelper.findMethod(EntityLivingBase.class, (Object)living, (String[])new String[]{"func_70647_i", "getSoundPitch"}, (Class[])new Class[0]);
        try {
            return ((Float)m.invoke((Object)living, new Object[0])).floatValue();
        }
        catch (Exception exception) {
            return 1.0f;
        }
    }

    public static void damageEntity(EntityLivingBase living, DamageSource source, float amount) {
        if (!living.func_85032_ar()) {
            if ((amount = ForgeHooks.onLivingHurt((EntityLivingBase)living, (DamageSource)source, (float)amount)) <= 0.0f) {
                return;
            }
            amount = EntityDamageUtil.applyArmorCalculations(living, source, amount);
            float f1 = amount = EntityDamageUtil.applyPotionDamageCalculations(living, source, amount);
            amount = Math.max(amount - living.func_110139_bj(), 0.0f);
            living.func_110149_m(living.func_110139_bj() - (f1 - amount));
            if (amount != 0.0f) {
                float f2 = living.func_110143_aJ();
                living.func_70606_j(f2 - amount);
                living.func_110142_aN().func_94547_a(source, f2, amount);
                living.func_110149_m(living.func_110139_bj() - amount);
            }
        }
    }

    public static float applyArmorCalculations(EntityLivingBase living, DamageSource source, float amount) {
        if (!source.func_76363_c()) {
            int i = 25 - living.func_70658_aO();
            float armor = amount * (float)i;
            amount = armor / 25.0f;
        }
        return amount;
    }

    public static float applyPotionDamageCalculations(EntityLivingBase living, DamageSource source, float amount) {
        float f1;
        int j;
        int resistance;
        if (source.func_151517_h()) {
            return amount;
        }
        if (living.func_70644_a(Potion.field_76429_m) && source != DamageSource.field_76380_i) {
            resistance = (living.func_70660_b(Potion.field_76429_m).func_76458_c() + 1) * 5;
            j = 25 - resistance;
            f1 = amount * (float)j;
            amount = f1 / 25.0f;
        }
        if (amount <= 0.0f) {
            return 0.0f;
        }
        resistance = EnchantmentHelper.func_77508_a((ItemStack[])living.func_70035_c(), (DamageSource)source);
        if (resistance > 20) {
            resistance = 20;
        }
        if (resistance > 0 && resistance <= 20) {
            j = 25 - resistance;
            f1 = amount * (float)j;
            amount = f1 / 25.0f;
        }
        return amount;
    }

    public static void setBeenAttacked(EntityLivingBase living) {
        living.field_70133_I = living.func_70681_au().nextDouble() >= living.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e();
    }
}

