/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import api.hbm.energy.IEnergyUser;
import api.hbm.fluid.IFluidUser;
import com.hbm.blocks.BlockDummyable;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.tileentity.machine.TileEntityDummy;
import com.hbm.tileentity.turret.TileEntityTurretSentry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CompatExternal {
    public static Set<Class> turretTargetPlayer = new HashSet<Class>();
    public static Set<Class> turretTargetFriendly = new HashSet<Class>();
    public static Set<Class> turretTargetHostile = new HashSet<Class>();
    public static Set<Class> turretTargetMachine = new HashSet<Class>();
    public static Set<Class> turretTargetBlacklist = new HashSet<Class>();
    public static HashMap<Class, BiFunction<Entity, Object, Integer>> turretTargetCondition = new HashMap();

    public static TileEntity getCoreFromPos(World world, int x, int y, int z) {
        BlockDummyable dummy;
        int[] pos;
        Block b = world.func_147439_a(x, y, z);
        if (b instanceof BlockDummyable && (pos = (dummy = (BlockDummyable)b).findCore(world, x, y, z)) != null) {
            return world.func_147438_o(pos[0], pos[1], pos[2]);
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityDummy) {
            TileEntityDummy dummy2 = (TileEntityDummy)tile;
            return world.func_147438_o(dummy2.targetX, dummy2.targetY, dummy2.targetZ);
        }
        return tile;
    }

    public static long getBufferedPowerFromTile(TileEntity tile) {
        if (tile instanceof IEnergyUser) {
            return ((IEnergyUser)tile).getPower();
        }
        return 0L;
    }

    public static long getMaxPowerFromTile(TileEntity tile) {
        if (tile instanceof IEnergyUser) {
            return ((IEnergyUser)tile).getMaxPower();
        }
        return 0L;
    }

    public static int getEnergyPriorityFromTile(TileEntity tile) {
        if (tile instanceof IEnergyUser) {
            return ((IEnergyUser)tile).getPriority().ordinal();
        }
        return -1;
    }

    public static ArrayList<Object[]> getFluidInfoFromTile(TileEntity tile) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        if (!(tile instanceof IFluidUser)) {
            return list;
        }
        IFluidUser container = (IFluidUser)tile;
        for (FluidTank tank : container.getAllTanks()) {
            FluidType type = tank.getTankType();
            list.add(new Object[]{type.getName(), type.getID(), type.getColor(), tank.getFill(), tank.getMaxFill()});
        }
        return list;
    }

    public static void registerTurretTargetSimple(Class clazz, int type) {
        switch (type) {
            case 0: {
                turretTargetPlayer.add(clazz);
                break;
            }
            case 1: {
                turretTargetFriendly.add(clazz);
                break;
            }
            case 2: {
                turretTargetHostile.add(clazz);
                break;
            }
            case 3: {
                turretTargetMachine.add(clazz);
            }
        }
    }

    public static void registerTurretTargetBlacklist(Class clazz) {
        turretTargetBlacklist.add(clazz);
    }

    public static void registerTurretTargetingCondition(Class clazz, BiFunction<Entity, Object, Integer> bi) {
        turretTargetBlacklist.add(clazz);
    }

    public static void compatExamples() {
        CompatExternal.registerTurretTargetSimple(EntityCow.class, 0);
        CompatExternal.registerTurretTargetBlacklist(EntityChicken.class);
        CompatExternal.registerTurretTargetingCondition(EntityPlayer.class, (entity, turret) -> {
            if (entity.func_70005_c_().equals("Target Practice")) {
                return 1;
            }
            if (turret instanceof TileEntityTurretSentry) {
                return -1;
            }
            return 0;
        });
    }
}

