/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.turret;

import com.hbm.entity.projectile.EntityBulletBaseNT;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.gui.GUITurretRichard;
import com.hbm.items.ItemAmmoEnums;
import com.hbm.items.ModItems;
import com.hbm.tileentity.turret.TileEntityTurretBaseNT;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TileEntityTurretRichard
extends TileEntityTurretBaseNT {
    static List<Integer> configs = new ArrayList<Integer>();
    int timer;
    public int loaded;
    int reload;

    @Override
    protected List<Integer> getAmmoList() {
        return configs;
    }

    @Override
    public String getName() {
        return "container.turretRichard";
    }

    @Override
    public double getTurretDepression() {
        return 25.0;
    }

    @Override
    public double getTurretElevation() {
        return 25.0;
    }

    @Override
    public double getBarrelLength() {
        return 1.25;
    }

    @Override
    public long getMaxPower() {
        return 10000L;
    }

    @Override
    public double getDecetorGrace() {
        return 8.0;
    }

    @Override
    public double getDecetorRange() {
        return 64.0;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.reload > 0) {
                --this.reload;
                if (this.reload == 0) {
                    this.loaded = 17;
                }
            }
            if (this.loaded <= 0 && this.reload <= 0 && this.getFirstConfigLoaded() != null) {
                this.reload = 100;
            }
            if (this.getFirstConfigLoaded() == null) {
                this.loaded = 0;
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("loaded", this.loaded);
            this.networkPack(data, 250);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        if (nbt.func_74764_b("loaded")) {
            this.loaded = nbt.func_74762_e("loaded");
        } else {
            super.networkUnpack(nbt);
        }
    }

    @Override
    public void updateFiringTick() {
        if (this.reload > 0) {
            return;
        }
        ++this.timer;
        if (this.timer > 0 && this.timer % 10 == 0) {
            BulletConfiguration conf = this.getFirstConfigLoaded();
            if (conf != null) {
                this.spawnBullet(conf);
                this.conusmeAmmo(conf.ammo);
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:turret.richard_fire", 2.0f, 1.0f);
                --this.loaded;
                if (conf.ammo.equals(new RecipesCommon.ComparableStack(ModItems.ammo_rocket.stackFromEnum(ItemAmmoEnums.AmmoRocket.NUCLEAR)))) {
                    this.timer = -50;
                }
            } else {
                this.loaded = 0;
            }
        }
    }

    @Override
    public void spawnBullet(BulletConfiguration bullet) {
        Vec3 pos = this.getTurretPos();
        Vec3 vec = Vec3.func_72443_a((double)this.getBarrelLength(), (double)0.0, (double)0.0);
        vec.func_72446_c((float)(-this.rotationPitch));
        vec.func_72442_b((float)(-(this.rotationYaw + 1.5707963267948966)));
        EntityBulletBaseNT proj = new EntityBulletBaseNT(this.field_145850_b, BulletConfigSyncingUtil.getKey(bullet));
        proj.func_70080_a(pos.field_72450_a + vec.field_72450_a, pos.field_72448_b + vec.field_72448_b, pos.field_72449_c + vec.field_72449_c, 0.0f, 0.0f);
        proj.func_70186_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, bullet.velocity * 0.75f, bullet.spread);
        this.field_145850_b.func_72838_d((Entity)proj);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.loaded = nbt.func_74762_e("loaded");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("loaded", this.loaded);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUITurretRichard(player.field_71071_by, this);
    }

    static {
        configs.add(BulletConfigSyncingUtil.ROCKET_NORMAL);
        configs.add(BulletConfigSyncingUtil.ROCKET_HE);
        configs.add(BulletConfigSyncingUtil.ROCKET_INCENDIARY);
        configs.add(BulletConfigSyncingUtil.ROCKET_SHRAPNEL);
        configs.add(BulletConfigSyncingUtil.ROCKET_EMP);
        configs.add(BulletConfigSyncingUtil.ROCKET_GLARE);
        configs.add(BulletConfigSyncingUtil.ROCKET_SLEEK);
        configs.add(BulletConfigSyncingUtil.ROCKET_NUKE);
        configs.add(BulletConfigSyncingUtil.ROCKET_CHAINSAW);
        configs.add(BulletConfigSyncingUtil.ROCKET_TOXIC);
        configs.add(BulletConfigSyncingUtil.ROCKET_PHOSPHORUS);
        configs.add(BulletConfigSyncingUtil.ROCKET_CANISTER);
    }
}

