/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.turret;

import com.hbm.entity.projectile.EntityArtilleryRocket;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.container.ContainerTurretBase;
import com.hbm.inventory.gui.GUITurretHIMARS;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.ItemAmmoHIMARS;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.turret.TileEntityTurretBaseArtillery;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TileEntityTurretHIMARS
extends TileEntityTurretBaseArtillery
implements IGUIProvider {
    public short mode = 0;
    public static final short MODE_AUTO = 0;
    public static final short MODE_MANUAL = 1;
    public int typeLoaded = -1;
    public int ammo = 0;
    public float crane;
    public float lastCrane;
    int timer;

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<ItemStack> getAmmoTypesForDisplay() {
        if (this.ammoStacks != null) {
            return this.ammoStacks;
        }
        this.ammoStacks = new ArrayList();
        ArrayList list = new ArrayList();
        ModItems.ammo_himars.func_150895_a(ModItems.ammo_himars, MainRegistry.weaponTab, list);
        this.ammoStacks.addAll(list);
        return this.ammoStacks;
    }

    @Override
    protected List<Integer> getAmmoList() {
        return new ArrayList<Integer>();
    }

    @Override
    public String getName() {
        return "container.turretHIMARS";
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    @Override
    public double getBarrelLength() {
        return 0.5;
    }

    @Override
    public double getAcceptableInaccuracy() {
        return 5.0;
    }

    @Override
    public double getHeightOffset() {
        return 5.0;
    }

    @Override
    public double getDecetorRange() {
        return 5000.0;
    }

    @Override
    public double getDecetorGrace() {
        return 32.0;
    }

    @Override
    public double getTurretYawSpeed() {
        return 1.0;
    }

    @Override
    public double getTurretPitchSpeed() {
        return 0.5;
    }

    @Override
    public boolean doLOSCheck() {
        return false;
    }

    @Override
    protected void alignTurret() {
        Vec3 pos = this.getTurretPos();
        Vec3 delta = Vec3.func_72443_a((double)(this.tPos.field_72450_a - pos.field_72450_a), (double)(this.tPos.field_72448_b - pos.field_72448_b), (double)(this.tPos.field_72449_c - pos.field_72449_c));
        double targetYaw = -Math.atan2(delta.field_72450_a, delta.field_72449_c);
        double targetPitch = 0.7853981633974483;
        this.turnTowardsAngle(targetPitch, targetYaw);
    }

    public int getSpareRocket() {
        for (int i = 1; i < 10; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.ammo_himars) continue;
            return this.slots[i].func_77960_j();
        }
        return -1;
    }

    @Override
    public void func_145845_h() {
        this.lastCrane = this.crane;
        if (this.mode == 1) {
            if (!this.targetQueue.isEmpty()) {
                this.tPos = (Vec3)this.targetQueue.get(0);
            }
        } else {
            this.targetQueue.clear();
        }
        if (this.field_145850_b.field_72995_K) {
            this.lastRotationPitch = this.rotationPitch;
            this.lastRotationYaw = this.rotationYaw;
        }
        this.aligned = false;
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            if (this.target != null && !this.target.func_70089_S()) {
                this.target = null;
                ++this.stattrak;
            }
        }
        if (this.target != null) {
            if (this.mode != 1 && !this.entityInLOS(this.target)) {
                this.target = null;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.target != null) {
                this.tPos = this.getEntityPos(this.target);
            } else if (this.mode != 1) {
                this.tPos = null;
            }
        }
        if (this.isOn() && this.hasPower()) {
            if (!this.hasAmmo() || this.crane > 0.0f) {
                this.turnTowardsAngle(0.0, this.rotationYaw);
                if (this.aligned) {
                    if (this.hasAmmo()) {
                        this.crane -= 0.0125f;
                    } else {
                        int available;
                        this.crane += 0.0125f;
                        if (this.crane >= 1.0f && !this.field_145850_b.field_72995_K && (available = this.getSpareRocket()) != -1) {
                            ItemAmmoHIMARS.HIMARSRocket type = ItemAmmoHIMARS.itemTypes[available];
                            this.typeLoaded = available;
                            this.ammo = type.amount;
                            this.conusmeAmmo(new RecipesCommon.ComparableStack(ModItems.ammo_himars, 1, available));
                        }
                    }
                }
                this.crane = MathHelper.func_76131_a((float)this.crane, (float)0.0f, (float)1.0f);
            } else if (this.tPos != null) {
                this.alignTurret();
            }
        } else {
            this.target = null;
            this.tPos = null;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.target != null && !this.target.func_70089_S()) {
                this.target = null;
                this.tPos = null;
                ++this.stattrak;
            }
            if (this.isOn() && this.hasPower()) {
                --this.searchTimer;
                this.setPower(this.getPower() - this.getConsumption());
                if (this.searchTimer <= 0) {
                    this.searchTimer = this.getDecetorInterval();
                    if (this.target == null) {
                        if (this.mode != 1) {
                            this.seekNewTarget();
                        }
                    }
                }
            } else {
                this.searchTimer = 0;
            }
            if (this.aligned && this.crane <= 0.0f) {
                this.updateFiringTick();
            }
            this.power = Library.chargeTEFromItems(this.slots, 10, this.power, this.getMaxPower());
            NBTTagCompound data = this.writePacket();
            this.networkPack(data, 250);
        } else {
            Vec3 vec = Vec3.func_72443_a((double)this.getBarrelLength(), (double)0.0, (double)0.0);
            vec.func_72446_c((float)(-this.rotationPitch));
            vec.func_72442_b((float)(-(this.rotationYaw + 1.5707963267948966)));
            if (Math.abs(this.lastRotationYaw - this.rotationYaw) > Math.PI) {
                this.lastRotationYaw = this.lastRotationYaw < this.rotationYaw ? (this.lastRotationYaw += Math.PI * 2) : (this.lastRotationYaw -= Math.PI * 2);
            }
        }
    }

    @Override
    protected NBTTagCompound writePacket() {
        NBTTagCompound data = super.writePacket();
        data.func_74777_a("mode", this.mode);
        data.func_74768_a("type", this.typeLoaded);
        data.func_74768_a("ammo", this.ammo);
        return data;
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        super.networkUnpack(nbt);
        this.mode = nbt.func_74765_d("mode");
        this.typeLoaded = nbt.func_74765_d("type");
        this.ammo = nbt.func_74762_e("ammo");
    }

    public boolean hasAmmo() {
        return this.typeLoaded >= 0 && this.ammo > 0;
    }

    @Override
    public void updateFiringTick() {
        ++this.timer;
        int delay = 40;
        if (this.timer % delay == 0) {
            if (this.hasAmmo() && this.tPos != null) {
                this.spawnShell(this.typeLoaded);
                --this.ammo;
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:weapon.rocketFlame", 25.0f, 1.0f);
            }
            if (this.mode == 1 && !this.targetQueue.isEmpty()) {
                this.targetQueue.remove(0);
                this.tPos = null;
            }
        }
    }

    public void spawnShell(int type) {
        Vec3 pos = this.getTurretPos();
        Vec3 vec = Vec3.func_72443_a((double)this.getBarrelLength(), (double)0.0, (double)0.0);
        vec.func_72446_c((float)(-this.rotationPitch));
        vec.func_72442_b((float)(-(this.rotationYaw + 1.5707963267948966)));
        EntityArtilleryRocket proj = new EntityArtilleryRocket(this.field_145850_b);
        proj.func_70080_a(pos.field_72450_a + vec.field_72450_a, pos.field_72448_b + vec.field_72448_b, pos.field_72449_c + vec.field_72449_c, 0.0f, 0.0f);
        proj.func_70186_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 25.0f, 0.0f);
        if (this.target != null) {
            proj.setTarget(this.target);
        } else {
            proj.setTarget(this.tPos.field_72450_a, this.tPos.field_72448_b, this.tPos.field_72449_c);
        }
        proj.setType(type);
        this.field_145850_b.func_72838_d((Entity)proj);
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        if (meta == 5) {
            this.mode = (short)(this.mode + 1);
            if (this.mode > 1) {
                this.mode = 0;
            }
            this.tPos = null;
            this.targetQueue.clear();
        } else {
            super.handleButtonPacket(value, meta);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.mode = nbt.func_74765_d("mode");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("mode", this.mode);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerTurretBase(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUITurretHIMARS(player.field_71071_by, this);
    }
}

