/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.turret;

import api.hbm.energy.IEnergyUser;
import com.hbm.entity.logic.EntityBomber;
import com.hbm.entity.missile.EntityMissileBaseAdvanced;
import com.hbm.entity.missile.EntityMissileCustom;
import com.hbm.entity.missile.EntitySiegeDropship;
import com.hbm.entity.projectile.EntityBulletBaseNT;
import com.hbm.entity.train.EntityRailCarBase;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.CasingEjector;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.container.ContainerTurretBase;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemTurretBiometry;
import com.hbm.lib.Library;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.particle.SpentCasing;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.CompatExternal;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityTurretBaseNT
extends TileEntityMachineBase
implements IEnergyUser,
IControlReceiver,
IGUIProvider {
    public double rotationYaw;
    public double rotationPitch;
    public double lastRotationYaw;
    public double lastRotationPitch;
    public boolean isOn = false;
    public boolean aligned = false;
    public int searchTimer;
    public long power;
    public boolean targetPlayers = false;
    public boolean targetAnimals = false;
    public boolean targetMobs = true;
    public boolean targetMachines = true;
    public Entity target;
    public Vec3 tPos;
    public int stattrak;
    public int casingDelay;
    protected SpentCasing cachedCasingConfig = null;
    @SideOnly(value=Side.CLIENT)
    protected List<ItemStack> ammoStacks;

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("del")) {
            this.removeName(data.func_74762_e("del"));
        } else if (data.func_74764_b("name")) {
            this.addName(data.func_74779_i("name"));
        }
    }

    public TileEntityTurretBaseNT() {
        super(11);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.isOn = nbt.func_74767_n("isOn");
        this.targetPlayers = nbt.func_74767_n("targetPlayers");
        this.targetAnimals = nbt.func_74767_n("targetAnimals");
        this.targetMobs = nbt.func_74767_n("targetMobs");
        this.targetMachines = nbt.func_74767_n("targetMachines");
        this.stattrak = nbt.func_74762_e("stattrak");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74757_a("isOn", this.isOn);
        nbt.func_74757_a("targetPlayers", this.targetPlayers);
        nbt.func_74757_a("targetAnimals", this.targetAnimals);
        nbt.func_74757_a("targetMobs", this.targetMobs);
        nbt.func_74757_a("targetMachines", this.targetMachines);
        nbt.func_74768_a("stattrak", this.stattrak);
    }

    public void manualSetup() {
    }

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            this.lastRotationPitch = this.rotationPitch;
            this.lastRotationYaw = this.rotationYaw;
        }
        this.aligned = false;
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            if (this.target != null && !this.target.func_70089_S()) {
                this.target = null;
                ++this.stattrak;
            }
        }
        if (this.target != null && !this.entityInLOS(this.target)) {
            this.target = null;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.tPos = this.target != null ? this.getEntityPos(this.target) : null;
        }
        if (this.isOn() && this.hasPower()) {
            if (this.tPos != null) {
                this.alignTurret();
            }
        } else {
            this.target = null;
            this.tPos = null;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.target != null && !this.target.func_70089_S()) {
                this.target = null;
                this.tPos = null;
                ++this.stattrak;
            }
            if (this.isOn() && this.hasPower()) {
                --this.searchTimer;
                this.setPower(this.getPower() - this.getConsumption());
                if (this.searchTimer <= 0) {
                    this.searchTimer = this.getDecetorInterval();
                    if (this.target == null) {
                        this.seekNewTarget();
                    }
                }
            } else {
                this.searchTimer = 0;
            }
            if (this.aligned) {
                this.updateFiringTick();
            }
            this.power = Library.chargeTEFromItems(this.slots, 10, this.power, this.getMaxPower());
            NBTTagCompound data = this.writePacket();
            this.networkPack(data, 250);
            if (this.usesCasings() && this.casingDelay() > 0) {
                if (this.casingDelay > 0) {
                    --this.casingDelay;
                } else {
                    this.spawnCasing();
                }
            }
        } else {
            Vec3 vec = Vec3.func_72443_a((double)this.getBarrelLength(), (double)0.0, (double)0.0);
            vec.func_72446_c((float)(-this.rotationPitch));
            vec.func_72442_b((float)(-(this.rotationYaw + 1.5707963267948966)));
            if (Math.abs(this.lastRotationYaw - this.rotationYaw) > Math.PI) {
                this.lastRotationYaw = this.lastRotationYaw < this.rotationYaw ? (this.lastRotationYaw += Math.PI * 2) : (this.lastRotationYaw -= Math.PI * 2);
            }
        }
    }

    protected NBTTagCompound writePacket() {
        NBTTagCompound data = new NBTTagCompound();
        if (this.tPos != null) {
            data.func_74780_a("tX", this.tPos.field_72450_a);
            data.func_74780_a("tY", this.tPos.field_72448_b);
            data.func_74780_a("tZ", this.tPos.field_72449_c);
        }
        data.func_74772_a("power", this.power);
        data.func_74757_a("isOn", this.isOn);
        data.func_74757_a("targetPlayers", this.targetPlayers);
        data.func_74757_a("targetAnimals", this.targetAnimals);
        data.func_74757_a("targetMobs", this.targetMobs);
        data.func_74757_a("targetMachines", this.targetMachines);
        data.func_74768_a("stattrak", this.stattrak);
        return data;
    }

    protected void updateConnections() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getOpposite();
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX * -1 + rot.offsetX * 0, this.field_145848_d, this.field_145849_e + dir.offsetZ * -1 + rot.offsetZ * 0, dir.getOpposite());
        this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX * -1 + rot.offsetX * -1, this.field_145848_d, this.field_145849_e + dir.offsetZ * -1 + rot.offsetZ * -1, dir.getOpposite());
        this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX * 0 + rot.offsetX * -2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 0 + rot.offsetZ * -2, rot.getOpposite());
        this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX * 1 + rot.offsetX * -2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 1 + rot.offsetZ * -2, rot.getOpposite());
        this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX * 0 + rot.offsetX * 1, this.field_145848_d, this.field_145849_e + dir.offsetZ * 0 + rot.offsetZ * 1, rot);
        this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX * 1 + rot.offsetX * 1, this.field_145848_d, this.field_145849_e + dir.offsetZ * 1 + rot.offsetZ * 1, rot);
        this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX * 2 + rot.offsetX * 0, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ * 0, dir);
        this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX * 2 + rot.offsetX * -1, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ * -1, dir);
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.isOn = nbt.func_74767_n("isOn");
        this.targetPlayers = nbt.func_74767_n("targetPlayers");
        this.targetAnimals = nbt.func_74767_n("targetAnimals");
        this.targetMobs = nbt.func_74767_n("targetMobs");
        this.targetMachines = nbt.func_74767_n("targetMachines");
        this.stattrak = nbt.func_74762_e("stattrak");
        this.tPos = nbt.func_74764_b("tX") ? Vec3.func_72443_a((double)nbt.func_74769_h("tX"), (double)nbt.func_74769_h("tY"), (double)nbt.func_74769_h("tZ")) : null;
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        switch (meta) {
            case 0: {
                this.isOn = !this.isOn;
                break;
            }
            case 1: {
                this.targetPlayers = !this.targetPlayers;
                break;
            }
            case 2: {
                this.targetAnimals = !this.targetAnimals;
                break;
            }
            case 3: {
                this.targetMobs = !this.targetMobs;
                break;
            }
            case 4: {
                this.targetMachines = !this.targetMachines;
            }
        }
    }

    public abstract void updateFiringTick();

    public boolean usesCasings() {
        return false;
    }

    public int casingDelay() {
        return 0;
    }

    public BulletConfiguration getFirstConfigLoaded() {
        List<Integer> list = this.getAmmoList();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (int i = 1; i < 10; ++i) {
            if (this.slots[i] == null) continue;
            for (Integer c : list) {
                BulletConfiguration conf = BulletConfigSyncingUtil.pullConfig(c);
                if (conf.ammo == null || !conf.ammo.matchesRecipe(this.slots[i], true)) continue;
                return conf;
            }
        }
        return null;
    }

    public void spawnBullet(BulletConfiguration bullet) {
        Vec3 pos = this.getTurretPos();
        Vec3 vec = Vec3.func_72443_a((double)this.getBarrelLength(), (double)0.0, (double)0.0);
        vec.func_72446_c((float)(-this.rotationPitch));
        vec.func_72442_b((float)(-(this.rotationYaw + 1.5707963267948966)));
        EntityBulletBaseNT proj = new EntityBulletBaseNT(this.field_145850_b, BulletConfigSyncingUtil.getKey(bullet));
        proj.func_70080_a(pos.field_72450_a + vec.field_72450_a, pos.field_72448_b + vec.field_72448_b, pos.field_72449_c + vec.field_72449_c, 0.0f, 0.0f);
        proj.func_70186_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, bullet.velocity, bullet.spread);
        this.field_145850_b.func_72838_d((Entity)proj);
        if (this.usesCasings()) {
            if (this.casingDelay() == 0) {
                this.spawnCasing();
            } else {
                this.casingDelay = this.casingDelay();
            }
        }
    }

    public void conusmeAmmo(RecipesCommon.ComparableStack ammo) {
        for (int i = 1; i < 10; ++i) {
            if (this.slots[i] == null || !ammo.matchesRecipe(this.slots[i], true)) continue;
            this.func_70298_a(i, 1);
            return;
        }
        this.func_70296_d();
    }

    public List<String> getWhitelist() {
        if (this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.turret_chip) {
            String[] array = ItemTurretBiometry.getNames(this.slots[0]);
            if (array == null) {
                return null;
            }
            return Arrays.asList(ItemTurretBiometry.getNames(this.slots[0]));
        }
        return null;
    }

    public void addName(String name) {
        if (this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.turret_chip) {
            ItemTurretBiometry.addName(this.slots[0], name);
        }
    }

    public void removeName(int index) {
        if (this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.turret_chip) {
            String[] array = ItemTurretBiometry.getNames(this.slots[0]);
            if (array == null) {
                return;
            }
            ArrayList<String> names = new ArrayList<String>(Arrays.asList(array));
            ItemTurretBiometry.clearNames(this.slots[0]);
            names.remove(index);
            for (String name : names) {
                ItemTurretBiometry.addName(this.slots[0], name);
            }
        }
    }

    protected void seekNewTarget() {
        Vec3 pos = this.getTurretPos();
        double range = this.getDecetorRange();
        List entities = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)pos.field_72450_a, (double)pos.field_72448_b, (double)pos.field_72449_c, (double)pos.field_72450_a, (double)pos.field_72448_b, (double)pos.field_72449_c).func_72314_b(range, range, range));
        Entity target = null;
        double closest = range;
        for (Entity entity : entities) {
            Vec3 ent = this.getEntityPos(entity);
            Vec3 delta = Vec3.func_72443_a((double)(ent.field_72450_a - pos.field_72450_a), (double)(ent.field_72448_b - pos.field_72448_b), (double)(ent.field_72449_c - pos.field_72449_c));
            double dist = delta.func_72433_c();
            if (dist > range || !this.entityAcceptableTarget(entity) || !this.entityInLOS(entity) || !(dist < closest)) continue;
            closest = dist;
            target = entity;
        }
        this.target = target;
        if (target != null) {
            this.tPos = this.getEntityPos(this.target);
        }
    }

    protected void alignTurret() {
        this.turnTowards(this.tPos);
    }

    public void turnTowards(Vec3 ent) {
        Vec3 pos = this.getTurretPos();
        Vec3 delta = Vec3.func_72443_a((double)(ent.field_72450_a - pos.field_72450_a), (double)(ent.field_72448_b - pos.field_72448_b), (double)(ent.field_72449_c - pos.field_72449_c));
        double targetPitch = Math.asin(delta.field_72448_b / delta.func_72433_c());
        double targetYaw = -Math.atan2(delta.field_72450_a, delta.field_72449_c);
        this.turnTowardsAngle(targetPitch, targetYaw);
    }

    public void turnTowardsAngle(double targetPitch, double targetYaw) {
        double turnYaw = Math.toRadians(this.getTurretYawSpeed());
        double turnPitch = Math.toRadians(this.getTurretPitchSpeed());
        double pi2 = Math.PI * 2;
        this.rotationPitch = Math.abs(this.rotationPitch - targetPitch) < turnPitch || Math.abs(this.rotationPitch - targetPitch) > pi2 - turnPitch ? targetPitch : (targetPitch > this.rotationPitch ? (this.rotationPitch += turnPitch) : (this.rotationPitch -= turnPitch));
        double deltaYaw = (targetYaw - this.rotationYaw) % pi2;
        int dir = 0;
        if (deltaYaw < -Math.PI) {
            dir = 1;
        } else if (deltaYaw < 0.0) {
            dir = -1;
        } else if (deltaYaw > Math.PI) {
            dir = -1;
        } else if (deltaYaw > 0.0) {
            dir = 1;
        }
        this.rotationYaw = Math.abs(this.rotationYaw - targetYaw) < turnYaw || Math.abs(this.rotationYaw - targetYaw) > pi2 - turnYaw ? targetYaw : (this.rotationYaw += turnYaw * (double)dir);
        double deltaPitch = targetPitch - this.rotationPitch;
        deltaYaw = targetYaw - this.rotationYaw;
        double deltaAngle = Math.sqrt(deltaYaw * deltaYaw + deltaPitch * deltaPitch);
        this.rotationYaw %= pi2;
        this.rotationPitch %= pi2;
        if (deltaAngle <= Math.toRadians(this.getAcceptableInaccuracy())) {
            this.aligned = true;
        }
    }

    public boolean entityInLOS(Entity e) {
        if (e.field_70128_L || !e.func_70089_S()) {
            return false;
        }
        if (!this.hasThermalVision() && e instanceof EntityLivingBase && ((EntityLivingBase)e).func_70644_a(Potion.field_76441_p)) {
            return false;
        }
        Vec3 pos = this.getTurretPos();
        Vec3 ent = this.getEntityPos(e);
        Vec3 delta = Vec3.func_72443_a((double)(ent.field_72450_a - pos.field_72450_a), (double)(ent.field_72448_b - pos.field_72448_b), (double)(ent.field_72449_c - pos.field_72449_c));
        double length = delta.func_72433_c();
        if (length < this.getDecetorGrace() || length > this.getDecetorRange() * 1.1) {
            return false;
        }
        double pitch = Math.asin(delta.field_72448_b / (delta = delta.func_72432_b()).func_72433_c());
        double pitchDeg = Math.toDegrees(pitch);
        if (pitchDeg < -this.getTurretDepression() || pitchDeg > this.getTurretElevation()) {
            return false;
        }
        return !Library.isObstructedOpaque(this.field_145850_b, ent.field_72450_a, ent.field_72448_b, ent.field_72449_c, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    public boolean entityAcceptableTarget(Entity e) {
        if (e.field_70128_L || !e.func_70089_S()) {
            return false;
        }
        for (Class c : CompatExternal.turretTargetBlacklist) {
            if (!c.isAssignableFrom(e.getClass())) continue;
            return false;
        }
        for (Class c : CompatExternal.turretTargetCondition.keySet()) {
            BiFunction<Entity, Object, Integer> lambda;
            if (!c.isAssignableFrom(e.getClass()) || (lambda = CompatExternal.turretTargetCondition.get(c)) == null) continue;
            int result = lambda.apply(e, this);
            if (result == -1) {
                return false;
            }
            if (result != 1) continue;
            return true;
        }
        List<String> wl = this.getWhitelist();
        if (wl != null && (e instanceof EntityPlayer ? wl.contains(((EntityPlayer)e).getDisplayName()) : e instanceof EntityLiving && wl.contains(((EntityLiving)e).func_94057_bL()))) {
            return false;
        }
        if (this.targetAnimals) {
            if (e instanceof IAnimals) {
                return true;
            }
            if (e instanceof INpc) {
                return true;
            }
            for (Class c : CompatExternal.turretTargetFriendly) {
                if (!c.isAssignableFrom(e.getClass())) continue;
                return true;
            }
        }
        if (this.targetMobs) {
            if (e instanceof EntityDragon) {
                return false;
            }
            if (e instanceof EntityDragonPart) {
                return true;
            }
            if (e instanceof IMob) {
                return true;
            }
            for (Class c : CompatExternal.turretTargetHostile) {
                if (!c.isAssignableFrom(e.getClass())) continue;
                return true;
            }
        }
        if (this.targetMachines) {
            if (e instanceof EntityMissileBaseAdvanced) {
                return true;
            }
            if (e instanceof EntityMissileCustom) {
                return true;
            }
            if (e instanceof EntityMinecart) {
                return true;
            }
            if (e instanceof EntityRailCarBase) {
                return true;
            }
            if (e instanceof EntityBomber) {
                return true;
            }
            if (e instanceof EntitySiegeDropship) {
                return true;
            }
            for (Class c : CompatExternal.turretTargetMachine) {
                if (!c.isAssignableFrom(e.getClass())) continue;
                return true;
            }
        }
        if (this.targetPlayers) {
            if (e instanceof FakePlayer) {
                return false;
            }
            if (e instanceof EntityPlayer) {
                return true;
            }
            for (Class c : CompatExternal.turretTargetPlayer) {
                if (!c.isAssignableFrom(e.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    public double getAcceptableInaccuracy() {
        return 5.0;
    }

    public double getTurretYawSpeed() {
        return 4.5;
    }

    public double getTurretPitchSpeed() {
        return 3.0;
    }

    public double getTurretDepression() {
        return 30.0;
    }

    public double getTurretElevation() {
        return 30.0;
    }

    public int getDecetorInterval() {
        return 10;
    }

    public double getDecetorRange() {
        return 32.0;
    }

    public double getDecetorGrace() {
        return 3.0;
    }

    public double getHeightOffset() {
        return 1.5;
    }

    public double getBarrelLength() {
        return 1.0;
    }

    public boolean hasThermalVision() {
        return true;
    }

    public Vec3 getTurretPos() {
        Vec3 offset = this.getHorizontalOffset();
        return Vec3.func_72443_a((double)((double)this.field_145851_c + offset.field_72450_a), (double)((double)this.field_145848_d + this.getHeightOffset()), (double)((double)this.field_145849_e + offset.field_72449_c));
    }

    public Vec3 getHorizontalOffset() {
        int meta = this.func_145832_p() - 10;
        if (meta == 2) {
            return Vec3.func_72443_a((double)1.0, (double)0.0, (double)1.0);
        }
        if (meta == 4) {
            return Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0);
        }
        if (meta == 5) {
            return Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0);
        }
        return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    }

    public Vec3 getEntityPos(Entity e) {
        return Vec3.func_72443_a((double)e.field_70165_t, (double)(e.field_70163_u + (double)e.field_70131_O * 0.5 - e.func_70033_W()), (double)e.field_70161_v);
    }

    protected abstract List<Integer> getAmmoList();

    @SideOnly(value=Side.CLIENT)
    public List<ItemStack> getAmmoTypesForDisplay() {
        if (this.ammoStacks != null) {
            return this.ammoStacks;
        }
        this.ammoStacks = new ArrayList<ItemStack>();
        for (Integer i : this.getAmmoList()) {
            BulletConfiguration config = BulletConfigSyncingUtil.pullConfig(i);
            if (config == null || config.ammo == null) continue;
            this.ammoStacks.add(config.ammo.toStack());
        }
        return this.ammoStacks;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    public boolean hasPower() {
        return this.getPower() >= this.getConsumption();
    }

    public boolean isOn() {
        return this.isOn;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    public int getPowerScaled(int scale) {
        return (int)(this.power * (long)scale / this.getMaxPower());
    }

    public long getConsumption() {
        return 100L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_70295_k_() {
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:block.openC", 1.0f, 1.0f);
    }

    @Override
    public void func_70305_f() {
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:block.closeC", 1.0f, 1.0f);
    }

    protected Vec3 getCasingSpawnPos() {
        return this.getTurretPos();
    }

    protected CasingEjector getEjector() {
        return null;
    }

    protected void spawnCasing() {
        if (this.cachedCasingConfig == null) {
            return;
        }
        CasingEjector ej = this.getEjector();
        Vec3 spawn = this.getCasingSpawnPos();
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("type", "casing");
        data.func_74776_a("pitch", (float)(-this.rotationPitch));
        data.func_74776_a("yaw", (float)this.rotationYaw);
        data.func_74757_a("crouched", false);
        data.func_74778_a("name", this.cachedCasingConfig.getName());
        if (ej != null) {
            data.func_74768_a("ej", ej.getId());
        }
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, spawn.field_72450_a, spawn.field_72448_b, spawn.field_72449_c), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
        this.cachedCasingConfig = null;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerTurretBase(player.field_71071_by, this);
    }
}

