/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import com.hbm.interfaces.IControlReceiver;
import com.hbm.module.ModulePatternMatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.network.RTTYSystem;
import com.hbm.util.Compat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityRadioTorchCounter
extends TileEntityMachineBase
implements IControlReceiver {
    public String[] channel = new String[3];
    public int[] lastCount;
    public boolean polling = false;
    public ModulePatternMatcher matcher;

    public TileEntityRadioTorchCounter() {
        super(3);
        for (int i = 0; i < 3; ++i) {
            this.channel[i] = "";
        }
        this.lastCount = new int[3];
        this.matcher = new ModulePatternMatcher(3);
    }

    @Override
    public String getName() {
        return "container.rttyCounter";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite();
            TileEntity tile = Compat.getTileStandard(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (tile instanceof IInventory) {
                int i;
                IInventory inv = (IInventory)tile;
                ItemStack[] invSlots = new ItemStack[inv.func_70302_i_()];
                for (i = 0; i < invSlots.length; ++i) {
                    invSlots[i] = inv.func_70301_a(i);
                }
                for (i = 0; i < 3; ++i) {
                    if (this.channel[i].isEmpty() || this.slots[i] == null) continue;
                    ItemStack pattern = this.slots[i];
                    int count = 0;
                    for (int j = 0; j < invSlots.length; ++j) {
                        if (invSlots[j] == null || !this.matcher.isValidForFilter(pattern, i, invSlots[j])) continue;
                        count += invSlots[j].field_77994_a;
                    }
                    if (this.polling || this.lastCount[i] != count) {
                        RTTYSystem.broadcast(this.field_145850_b, this.channel[i], count);
                    }
                    this.lastCount[i] = count;
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a("polling", this.polling);
            data.func_74783_a("last", this.lastCount);
            this.matcher.writeToNBT(data);
            for (int i = 0; i < 3; ++i) {
                if (this.channel[i] == null) continue;
                data.func_74778_a("c" + i, this.channel[i]);
            }
            this.networkPack(data, 15);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.polling = nbt.func_74767_n("polling");
        this.lastCount = nbt.func_74759_k("last");
        this.matcher.modes = new String[this.matcher.modes.length];
        this.matcher.readFromNBT(nbt);
        for (int i = 0; i < 3; ++i) {
            this.channel[i] = nbt.func_74779_i("c" + i);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.polling = nbt.func_74767_n("p");
        for (int i = 0; i < 3; ++i) {
            this.channel[i] = nbt.func_74779_i("c" + i);
            this.lastCount[i] = nbt.func_74762_e("l" + i);
        }
        this.matcher.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("p", this.polling);
        for (int i = 0; i < 3; ++i) {
            if (this.channel[i] != null) {
                nbt.func_74778_a("c" + i, this.channel[i]);
            }
            nbt.func_74768_a("l" + i, this.lastCount[i]);
        }
        this.matcher.writeToNBT(nbt);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("polling")) {
            this.polling = !this.polling;
            this.markChanged();
        } else {
            System.out.println("guh");
            for (int i = 0; i < 3; ++i) {
                this.channel[i] = data.func_74779_i("c" + i);
            }
            this.markChanged();
        }
    }
}

