/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import com.hbm.interfaces.IControlReceiver;
import com.hbm.tileentity.INBTPacketReceiver;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileEntityRadioTorchBase
extends TileEntity
implements INBTPacketReceiver,
IControlReceiver {
    public String channel = "";
    public int lastState = 0;
    public long lastUpdate;
    public boolean polling = false;
    public boolean customMap = false;
    public String[] mapping = new String[16];

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a("p", this.polling);
            data.func_74757_a("m", this.customMap);
            if (this.channel != null) {
                data.func_74778_a("c", this.channel);
            }
            for (int i = 0; i < 16; ++i) {
                if (this.mapping[i] == null) continue;
                data.func_74778_a("m" + i, this.mapping[i]);
            }
            INBTPacketReceiver.networkPack(this, data, 50);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.polling = nbt.func_74767_n("p");
        this.customMap = nbt.func_74767_n("m");
        this.lastState = nbt.func_74762_e("l");
        this.lastUpdate = nbt.func_74763_f("u");
        this.channel = nbt.func_74779_i("c");
        for (int i = 0; i < 16; ++i) {
            this.mapping[i] = nbt.func_74779_i("m" + i);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("p", this.polling);
        nbt.func_74757_a("m", this.customMap);
        nbt.func_74768_a("l", this.lastState);
        nbt.func_74772_a("u", this.lastUpdate);
        if (this.channel != null) {
            nbt.func_74778_a("c", this.channel);
        }
        for (int i = 0; i < 16; ++i) {
            if (this.mapping[i] == null) continue;
            nbt.func_74778_a("m" + i, this.mapping[i]);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.polling = nbt.func_74767_n("p");
        this.customMap = nbt.func_74767_n("m");
        this.channel = nbt.func_74779_i("c");
        for (int i = 0; i < 16; ++i) {
            this.mapping[i] = nbt.func_74779_i("m" + i);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("l", (byte)this.lastState);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        int last = this.lastState;
        this.lastState = pkt.func_148857_g().func_74771_c("l");
        if (this.lastState != last) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return player.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 16.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("p")) {
            this.polling = data.func_74767_n("p");
        }
        if (data.func_74764_b("m")) {
            this.customMap = data.func_74767_n("m");
        }
        if (data.func_74764_b("c")) {
            this.channel = data.func_74779_i("c");
        }
        for (int i = 0; i < 16; ++i) {
            if (!data.func_74764_b("m" + i)) continue;
            this.mapping[i] = data.func_74779_i("m" + i);
        }
        this.func_70296_d();
    }
}

