/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import api.hbm.energy.IEnergyConductor;
import com.hbm.tileentity.network.TileEntityCableBaseNT;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldServer;

public abstract class TileEntityPylonBase
extends TileEntityCableBaseNT {
    public List<int[]> connected = new ArrayList<int[]>();

    public static int canConnect(TileEntityPylonBase first, TileEntityPylonBase second) {
        if (first.getConnectionType() != second.getConnectionType()) {
            return 1;
        }
        if (first == second) {
            return 2;
        }
        double len = Math.min(first.getMaxWireLength(), second.getMaxWireLength());
        Vec3 firstPos = first.getConnectionPoint();
        Vec3 secondPos = second.getConnectionPoint();
        Vec3 delta = Vec3.func_72443_a((double)(secondPos.field_72450_a - firstPos.field_72450_a), (double)(secondPos.field_72448_b - firstPos.field_72448_b), (double)(secondPos.field_72449_c - firstPos.field_72449_c));
        return len >= delta.func_72433_c() ? 0 : 3;
    }

    public void addConnection(int x, int y, int z) {
        this.connected.add(new int[]{x, y, z});
        if (this.getPowerNet() != null) {
            this.getPowerNet().reevaluate();
            this.network = null;
        }
        this.func_70296_d();
        if (this.field_145850_b instanceof WorldServer) {
            WorldServer world = (WorldServer)this.field_145850_b;
            world.func_73040_p().func_151250_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void disconnectAll() {
        for (int[] pos : this.connected) {
            TileEntity te = this.field_145850_b.func_147438_o(pos[0], pos[1], pos[2]);
            if (te == this || !(te instanceof TileEntityPylonBase)) continue;
            TileEntityPylonBase pylon = (TileEntityPylonBase)te;
            for (int i = 0; i < pylon.connected.size(); ++i) {
                int[] conPos = pylon.connected.get(i);
                if (conPos[0] != this.field_145851_c || conPos[1] != this.field_145848_d || conPos[2] != this.field_145849_e) continue;
                pylon.connected.remove(i);
                --i;
            }
            pylon.func_70296_d();
            if (!(this.field_145850_b instanceof WorldServer)) continue;
            WorldServer world = (WorldServer)this.field_145850_b;
            world.func_73040_p().func_151250_a(pylon.field_145851_c, pylon.field_145848_d, pylon.field_145849_e);
        }
    }

    @Override
    protected void connect() {
        for (int[] pos : this.getConnectionPoints()) {
            TileEntity te = this.field_145850_b.func_147438_o(pos[0], pos[1], pos[2]);
            if (!(te instanceof IEnergyConductor)) continue;
            IEnergyConductor conductor = (IEnergyConductor)te;
            if (this.getPowerNet() == null && conductor.getPowerNet() != null) {
                conductor.getPowerNet().joinLink(this);
            }
            if (this.getPowerNet() == null || conductor.getPowerNet() == null || this.getPowerNet() == conductor.getPowerNet()) continue;
            conductor.getPowerNet().joinNetworks(this.getPowerNet());
        }
    }

    @Override
    public List<int[]> getConnectionPoints() {
        return new ArrayList<int[]>(this.connected);
    }

    public abstract ConnectionType getConnectionType();

    public abstract Vec3[] getMountPos();

    public abstract double getMaxWireLength();

    public Vec3 getConnectionPoint() {
        Vec3[] mounts = this.getMountPos();
        if (mounts == null || mounts.length == 0) {
            return Vec3.func_72443_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5));
        }
        return mounts[0].func_72441_c((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("conCount", this.connected.size());
        for (int i = 0; i < this.connected.size(); ++i) {
            nbt.func_74783_a("con" + i, this.connected.get(i));
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int count = nbt.func_74762_e("conCount");
        this.connected.clear();
        for (int i = 0; i < count; ++i) {
            this.connected.add(nbt.func_74759_k("con" + i));
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public static enum ConnectionType {
        SINGLE,
        QUAD;

    }
}

