/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import api.hbm.fluid.IFluidConductor;
import api.hbm.fluid.IPipeNet;
import api.hbm.fluid.PipeNet;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.util.Compat;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityPipeExhaust
extends TileEntity
implements IFluidConductor {
    public IPipeNet[] nets = new IPipeNet[3];

    public FluidType[] getSmokes() {
        return new FluidType[]{Fluids.SMOKE, Fluids.SMOKE_LEADED, Fluids.SMOKE_POISON};
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.canUpdate()) {
            for (int i = 0; i < 3; ++i) {
                this.nets[i] = null;
            }
            for (FluidType type : this.getSmokes()) {
                this.connect(type);
                if (this.getPipeNet(type) != null) continue;
                this.setPipeNet(type, new PipeNet(type).joinLink(this));
            }
        }
    }

    protected void connect(FluidType type) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IFluidConductor conductor;
            TileEntity te = Compat.getTileStandard(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (!(te instanceof IFluidConductor) || !(conductor = (IFluidConductor)te).canConnect(type, dir.getOpposite())) continue;
            if (this.getPipeNet(type) == null && conductor.getPipeNet(type) != null) {
                conductor.getPipeNet(type).joinLink(this);
            }
            if (this.getPipeNet(type) == null || conductor.getPipeNet(type) == null || this.getPipeNet(type) == conductor.getPipeNet(type)) continue;
            conductor.getPipeNet(type).joinNetworks(this.getPipeNet(type));
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 3; ++i) {
                if (this.nets[i] == null) continue;
                this.nets[i].destroy();
            }
        }
    }

    public boolean canUpdate() {
        if (this.func_145837_r()) {
            return false;
        }
        for (IPipeNet net : this.nets) {
            if (net != null && net.isValid()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN && (type == Fluids.SMOKE || type == Fluids.SMOKE_LEADED || type == Fluids.SMOKE_POISON);
    }

    @Override
    public long getDemand(FluidType type, int pressure) {
        return 0L;
    }

    @Override
    public IPipeNet getPipeNet(FluidType type) {
        if (type == Fluids.SMOKE) {
            return this.nets[0];
        }
        if (type == Fluids.SMOKE_LEADED) {
            return this.nets[1];
        }
        if (type == Fluids.SMOKE_POISON) {
            return this.nets[2];
        }
        return null;
    }

    @Override
    public void setPipeNet(FluidType type, IPipeNet network) {
        if (type == Fluids.SMOKE) {
            this.nets[0] = network;
        }
        if (type == Fluids.SMOKE_LEADED) {
            this.nets[1] = network;
        }
        if (type == Fluids.SMOKE_POISON) {
            this.nets[2] = network;
        }
    }
}

