/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import api.hbm.fluid.IFluidConductor;
import api.hbm.fluid.IPipeNet;
import api.hbm.fluid.PipeNet;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityPipeBaseNT
extends TileEntity
implements IFluidConductor {
    protected IPipeNet network;
    protected FluidType type = Fluids.NONE;
    protected FluidType lastType = Fluids.NONE;

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K && this.lastType != this.type) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.lastType = this.type;
        }
        if (!this.field_145850_b.field_72995_K && this.canUpdate()) {
            this.setPipeNet(this.type, null);
            this.connect();
            if (this.getPipeNet(this.type) == null) {
                this.setPipeNet(this.type, new PipeNet(this.type).joinLink(this));
            }
        }
    }

    public FluidType getType() {
        return this.type;
    }

    public void setType(FluidType type) {
        this.type = type;
        this.func_70296_d();
        if (this.field_145850_b instanceof WorldServer) {
            WorldServer world = (WorldServer)this.field_145850_b;
            world.func_73040_p().func_151250_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.network != null) {
            this.network.destroy();
        }
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN && type == this.type;
    }

    protected void connect() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IFluidConductor conductor;
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (!(te instanceof IFluidConductor) || !(conductor = (IFluidConductor)te).canConnect(this.type, dir.getOpposite())) continue;
            if (this.getPipeNet(this.type) == null && conductor.getPipeNet(this.type) != null) {
                conductor.getPipeNet(this.type).joinLink(this);
            }
            if (this.getPipeNet(this.type) == null || conductor.getPipeNet(this.type) == null || this.getPipeNet(this.type) == conductor.getPipeNet(this.type)) continue;
            conductor.getPipeNet(this.type).joinNetworks(this.getPipeNet(this.type));
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.network != null) {
            this.network.destroy();
        }
    }

    public boolean canUpdate() {
        return (this.network == null || !this.network.isValid()) && !this.func_145837_r();
    }

    @Override
    public long transferFluid(FluidType type, int pressure, long fluid) {
        if (this.network == null) {
            return fluid;
        }
        return this.network.transferFluid(fluid, pressure);
    }

    @Override
    public long getDemand(FluidType type, int pressure) {
        return 0L;
    }

    @Override
    public IPipeNet getPipeNet(FluidType type) {
        return type == this.type ? this.network : null;
    }

    @Override
    public void setPipeNet(FluidType type, IPipeNet network) {
        this.network = network;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.type = Fluids.fromID(nbt.func_74762_e("type"));
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("type", this.type.getID());
    }
}

