/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerCraneRouter;
import com.hbm.inventory.gui.GUICraneRouter;
import com.hbm.module.ModulePatternMatcher;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TileEntityCraneRouter
extends TileEntityMachineBase
implements IGUIProvider,
IControlReceiver {
    public ModulePatternMatcher[] patterns = new ModulePatternMatcher[6];
    public int[] modes = new int[6];
    public static final int MODE_NONE = 0;
    public static final int MODE_WHITELIST = 1;
    public static final int MODE_BLACKLIST = 2;
    public static final int MODE_WILDCARD = 3;

    public TileEntityCraneRouter() {
        super(30);
        for (int i = 0; i < this.patterns.length; ++i) {
            this.patterns[i] = new ModulePatternMatcher(5);
        }
    }

    @Override
    public String getName() {
        return "container.craneRouter";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            NBTTagCompound data = new NBTTagCompound();
            for (int i = 0; i < this.patterns.length; ++i) {
                NBTTagCompound compound = new NBTTagCompound();
                this.patterns[i].writeToNBT(compound);
                data.func_74782_a("pattern" + i, (NBTBase)compound);
            }
            data.func_74783_a("modes", this.modes);
            this.networkPack(data, 15);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        for (int i = 0; i < this.patterns.length; ++i) {
            NBTTagCompound compound = data.func_74775_l("pattern" + i);
            this.patterns[i].readFromNBT(compound);
        }
        this.modes = data.func_74759_k("modes");
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCraneRouter(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUICraneRouter(player.field_71071_by, this);
    }

    public void nextMode(int index) {
        int matcher = index / 5;
        int mIndex = index % 5;
        this.patterns[matcher].nextMode(this.field_145850_b, this.slots[index], mIndex);
    }

    public void initPattern(ItemStack stack, int index) {
        int matcher = index / 5;
        int mIndex = index % 5;
        this.patterns[matcher].initPatternSmart(this.field_145850_b, stack, mIndex);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (int i = 0; i < this.patterns.length; ++i) {
            NBTTagCompound compound = nbt.func_74775_l("pattern" + i);
            this.patterns[i].readFromNBT(compound);
        }
        this.modes = nbt.func_74759_k("modes");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        for (int i = 0; i < this.patterns.length; ++i) {
            NBTTagCompound compound = new NBTTagCompound();
            this.patterns[i].writeToNBT(compound);
            nbt.func_74782_a("pattern" + i, (NBTBase)compound);
        }
        nbt.func_74783_a("modes", this.modes);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return Vec3.func_72443_a((double)((double)this.field_145851_c - player.field_70165_t), (double)((double)this.field_145848_d - player.field_70163_u), (double)((double)this.field_145849_e - player.field_70161_v)).func_72433_c() < 20.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        int i;
        int n = i = data.func_74762_e("toggle");
        this.modes[n] = this.modes[n] + 1;
        if (this.modes[i] > 3) {
            this.modes[i] = 0;
        }
    }
}

