/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.network.CraneInserter;
import com.hbm.entity.item.EntityMovingItem;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerCraneGrabber;
import com.hbm.inventory.gui.GUICraneGrabber;
import com.hbm.items.ModItems;
import com.hbm.module.ModulePatternMatcher;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.network.TileEntityCraneBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCraneGrabber
extends TileEntityCraneBase
implements IGUIProvider,
IControlReceiver {
    public boolean isWhitelist = false;
    public ModulePatternMatcher matcher = new ModulePatternMatcher(9);

    public TileEntityCraneGrabber() {
        super(11);
    }

    public void nextMode(int i) {
        this.matcher.nextMode(this.field_145850_b, this.slots[i], i);
    }

    @Override
    public String getName() {
        return "container.craneGrabber";
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            int delay = 20;
            if (this.slots[10] != null && this.slots[10].func_77973_b() == ModItems.upgrade_ejector) {
                switch (this.slots[10].func_77960_j()) {
                    case 0: {
                        delay = 10;
                        break;
                    }
                    case 1: {
                        delay = 5;
                        break;
                    }
                    case 2: {
                        delay = 2;
                    }
                }
            }
            if (this.field_145850_b.func_82737_E() % (long)delay == 0L && !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                int amount = 1;
                if (this.slots[9] != null && this.slots[9].func_77973_b() == ModItems.upgrade_stack) {
                    switch (this.slots[9].func_77960_j()) {
                        case 0: {
                            amount = 4;
                            break;
                        }
                        case 1: {
                            amount = 16;
                            break;
                        }
                        case 2: {
                            amount = 64;
                        }
                    }
                }
                ForgeDirection inputSide = this.getInputSide();
                ForgeDirection outputSide = this.getOutputSide();
                TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + outputSide.offsetX, this.field_145848_d + outputSide.offsetY, this.field_145849_e + outputSide.offsetZ);
                int[] access = null;
                ISidedInventory sided = null;
                if (te instanceof ISidedInventory) {
                    sided = (ISidedInventory)te;
                    access = CraneInserter.masquerade(sided, outputSide.getOpposite().ordinal());
                }
                if (te instanceof IInventory) {
                    double reach = 1.0;
                    if (this.func_145832_p() > 1) {
                        Block b = this.field_145850_b.func_147439_a(this.field_145851_c + inputSide.offsetX, this.field_145848_d + inputSide.offsetY, this.field_145849_e + inputSide.offsetZ);
                        if (b == ModBlocks.conveyor_double) {
                            reach = 0.5;
                        }
                        if (b == ModBlocks.conveyor_triple) {
                            reach = 0.33;
                        }
                    }
                    double x = (double)this.field_145851_c + (double)inputSide.offsetX * reach;
                    double y = (double)this.field_145848_d + (double)inputSide.offsetY * reach;
                    double z = (double)this.field_145849_e + (double)inputSide.offsetZ * reach;
                    List items = this.field_145850_b.func_72872_a(EntityMovingItem.class, AxisAlignedBB.func_72330_a((double)(x + 0.1875), (double)(y + 0.1875), (double)(z + 0.1875), (double)(x + 0.8125), (double)(y + 0.8125), (double)(z + 0.8125)));
                    for (EntityMovingItem item : items) {
                        int toAdd;
                        ItemStack stack = item.getItemStack();
                        boolean match = this.matchesFilter(stack);
                        if (this.isWhitelist && !match || !this.isWhitelist && match) continue;
                        ItemStack copy = stack.func_77946_l();
                        copy.field_77994_a = toAdd = Math.min(stack.field_77994_a, amount);
                        ItemStack ret = CraneInserter.addToInventory((IInventory)te, access, copy, outputSide.getOpposite().ordinal());
                        int didAdd = toAdd - (ret != null ? ret.field_77994_a : 0);
                        stack.field_77994_a -= didAdd;
                        if (stack.field_77994_a <= 0) {
                            item.func_70106_y();
                        }
                        if ((amount -= didAdd) > 0) continue;
                        break;
                    }
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a("isWhitelist", this.isWhitelist);
            this.matcher.writeToNBT(data);
            this.networkPack(data, 15);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.isWhitelist = nbt.func_74767_n("isWhitelist");
        this.matcher.modes = new String[this.matcher.modes.length];
        this.matcher.readFromNBT(nbt);
    }

    public boolean matchesFilter(ItemStack stack) {
        for (int i = 0; i < 9; ++i) {
            ItemStack filter = this.slots[i];
            if (filter == null || !this.matcher.isValidForFilter(filter, i, stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCraneGrabber(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUICraneGrabber(player.field_71071_by, this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isWhitelist = nbt.func_74767_n("isWhitelist");
        this.matcher.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("isWhitelist", this.isWhitelist);
        this.matcher.writeToNBT(nbt);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return Vec3.func_72443_a((double)((double)this.field_145851_c - player.field_70165_t), (double)((double)this.field_145848_d - player.field_70163_u), (double)((double)this.field_145849_e - player.field_70161_v)).func_72433_c() < 20.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("whitelist")) {
            this.isWhitelist = !this.isWhitelist;
        }
    }
}

