/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import api.hbm.conveyor.IConveyorBelt;
import com.hbm.entity.item.EntityMovingItem;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerCraneExtractor;
import com.hbm.inventory.gui.GUICraneExtractor;
import com.hbm.items.ModItems;
import com.hbm.module.ModulePatternMatcher;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.network.TileEntityCraneBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCraneExtractor
extends TileEntityCraneBase
implements IGUIProvider,
IControlReceiver {
    public boolean isWhitelist = false;
    public ModulePatternMatcher matcher = new ModulePatternMatcher(9);

    public TileEntityCraneExtractor() {
        super(20);
    }

    @Override
    public String getName() {
        return "container.craneExtractor";
    }

    @Override
    public void func_70299_a(int i, ItemStack stack) {
        super.func_70299_a(i, stack);
        if (stack != null && (stack.func_77973_b() == ModItems.upgrade_ejector && i == 19 || stack.func_77973_b() == ModItems.upgrade_stack && i == 18)) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:item.upgradePlug", 1.0f, 1.0f);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            int delay = 20;
            if (this.slots[19] != null && this.slots[19].func_77973_b() == ModItems.upgrade_ejector) {
                switch (this.slots[19].func_77960_j()) {
                    case 0: {
                        delay = 10;
                        break;
                    }
                    case 1: {
                        delay = 5;
                        break;
                    }
                    case 2: {
                        delay = 2;
                    }
                }
            }
            if (this.field_145850_b.func_82737_E() % (long)delay == 0L && !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                int amount = 1;
                if (this.slots[18] != null && this.slots[18].func_77973_b() == ModItems.upgrade_stack) {
                    switch (this.slots[18].func_77960_j()) {
                        case 0: {
                            amount = 4;
                            break;
                        }
                        case 1: {
                            amount = 16;
                            break;
                        }
                        case 2: {
                            amount = 64;
                        }
                    }
                }
                ForgeDirection inputSide = this.getOutputSide();
                ForgeDirection outputSide = this.getInputSide();
                TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + inputSide.offsetX, this.field_145848_d + inputSide.offsetY, this.field_145849_e + inputSide.offsetZ);
                Block b = this.field_145850_b.func_147439_a(this.field_145851_c + outputSide.offsetX, this.field_145848_d + outputSide.offsetY, this.field_145849_e + outputSide.offsetZ);
                int[] access = null;
                ISidedInventory sided = null;
                if (te instanceof ISidedInventory) {
                    sided = (ISidedInventory)te;
                    access = TileEntityCraneExtractor.masquerade(sided, inputSide.getOpposite().ordinal());
                }
                boolean hasSent = false;
                if (b instanceof IConveyorBelt) {
                    IConveyorBelt belt = (IConveyorBelt)b;
                    if (te instanceof IInventory) {
                        IInventory inv = (IInventory)te;
                        int size = access == null ? inv.func_70302_i_() : access.length;
                        for (int i = 0; i < size; ++i) {
                            int index = access == null ? i : access[i];
                            ItemStack stack = inv.func_70301_a(index);
                            if (stack == null || sided != null && !sided.func_102008_b(index, stack, inputSide.getOpposite().ordinal())) continue;
                            boolean match = this.matchesFilter(stack);
                            if ((!this.isWhitelist || !match) && (this.isWhitelist || match)) continue;
                            stack = stack.func_77946_l();
                            int toSend = Math.min(amount, stack.field_77994_a);
                            inv.func_70298_a(index, toSend);
                            stack.field_77994_a = toSend;
                            EntityMovingItem moving = new EntityMovingItem(this.field_145850_b);
                            Vec3 pos = Vec3.func_72443_a((double)((double)this.field_145851_c + 0.5 + (double)outputSide.offsetX * 0.55), (double)((double)this.field_145848_d + 0.5 + (double)outputSide.offsetY * 0.55), (double)((double)this.field_145849_e + 0.5 + (double)outputSide.offsetZ * 0.55));
                            Vec3 snap = belt.getClosestSnappingPosition(this.field_145850_b, this.field_145851_c + outputSide.offsetX, this.field_145848_d + outputSide.offsetY, this.field_145849_e + outputSide.offsetZ, pos);
                            moving.func_70107_b(snap.field_72450_a, snap.field_72448_b, snap.field_72449_c);
                            moving.setItemStack(stack);
                            this.field_145850_b.func_72838_d((Entity)moving);
                            hasSent = true;
                            break;
                        }
                    }
                    if (!hasSent) {
                        for (int i = 9; i < 18; ++i) {
                            ItemStack stack = this.slots[i];
                            if (stack == null) continue;
                            stack = stack.func_77946_l();
                            int toSend = Math.min(amount, stack.field_77994_a);
                            this.func_70298_a(i, toSend);
                            stack.field_77994_a = toSend;
                            EntityMovingItem moving = new EntityMovingItem(this.field_145850_b);
                            Vec3 pos = Vec3.func_72443_a((double)((double)this.field_145851_c + 0.5 + (double)outputSide.offsetX * 0.55), (double)((double)this.field_145848_d + 0.5 + (double)outputSide.offsetY * 0.55), (double)((double)this.field_145849_e + 0.5 + (double)outputSide.offsetZ * 0.55));
                            Vec3 snap = belt.getClosestSnappingPosition(this.field_145850_b, this.field_145851_c + outputSide.offsetX, this.field_145848_d + outputSide.offsetY, this.field_145849_e + outputSide.offsetZ, pos);
                            moving.func_70107_b(snap.field_72450_a, snap.field_72448_b, snap.field_72449_c);
                            moving.setItemStack(stack);
                            this.field_145850_b.func_72838_d((Entity)moving);
                            break;
                        }
                    }
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a("isWhitelist", this.isWhitelist);
            this.matcher.writeToNBT(data);
            this.networkPack(data, 15);
        }
    }

    public static int[] masquerade(ISidedInventory sided, int side) {
        if (sided instanceof TileEntityFurnace) {
            return new int[]{2};
        }
        return sided.func_94128_d(side);
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.isWhitelist = nbt.func_74767_n("isWhitelist");
        this.matcher.modes = new String[this.matcher.modes.length];
        this.matcher.readFromNBT(nbt);
    }

    public boolean matchesFilter(ItemStack stack) {
        for (int i = 0; i < 9; ++i) {
            ItemStack filter = this.slots[i];
            if (filter == null || !this.matcher.isValidForFilter(filter, i, stack)) continue;
            return true;
        }
        return false;
    }

    public void nextMode(int i) {
        this.matcher.nextMode(this.field_145850_b, this.slots[i], i);
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17};
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        return i > 8 && i < 18;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i > 8 && i < 18;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCraneExtractor(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUICraneExtractor(player.field_71071_by, this);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isWhitelist = nbt.func_74767_n("isWhitelist");
        this.matcher.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("isWhitelist", this.isWhitelist);
        this.matcher.writeToNBT(nbt);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return Vec3.func_72443_a((double)((double)this.field_145851_c - player.field_70165_t), (double)((double)this.field_145848_d - player.field_70163_u), (double)((double)this.field_145849_e - player.field_70161_v)).func_72433_c() < 20.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("whitelist")) {
            this.isWhitelist = !this.isWhitelist;
        }
    }
}

