/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.storage;

import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerMassStorage;
import com.hbm.inventory.gui.GUIMassStorage;
import com.hbm.items.ModItems;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.machine.storage.TileEntityCrateBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TileEntityMassStorage
extends TileEntityCrateBase
implements INBTPacketReceiver,
IControlReceiver {
    private int stack = 0;
    public boolean output = false;
    private int capacity;
    public int redstone = 0;
    @SideOnly(value=Side.CLIENT)
    public ItemStack type;

    public TileEntityMassStorage() {
        super(3);
    }

    public TileEntityMassStorage(int capacity) {
        this();
        this.capacity = capacity;
    }

    public String func_145825_b() {
        return "container.massStorage";
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int newRed = this.getStockpile() * 15 / this.capacity;
            if (newRed != this.redstone) {
                this.redstone = newRed;
                this.func_70296_d();
            }
            if (this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.fluid_barrel_infinite) {
                this.stack = this.getCapacity();
            }
            if (this.getType() == null) {
                this.stack = 0;
            }
            if (this.getType() != null && this.getStockpile() < this.getCapacity() && this.slots[0] != null && this.slots[0].func_77969_a(this.getType()) && ItemStack.func_77970_a((ItemStack)this.slots[0], (ItemStack)this.getType())) {
                int remaining = this.getCapacity() - this.getStockpile();
                int toRemove = Math.min(remaining, this.slots[0].field_77994_a);
                this.func_70298_a(0, toRemove);
                this.stack += toRemove;
                this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
            }
            if (this.output && this.getType() != null) {
                if (!(this.slots[2] == null || this.slots[2].func_77969_a(this.getType()) && ItemStack.func_77970_a((ItemStack)this.slots[2], (ItemStack)this.getType()))) {
                    return;
                }
                int amount = Math.min(this.getStockpile(), this.getType().func_77976_d());
                if (amount > 0) {
                    if (this.slots[2] == null) {
                        this.slots[2] = this.slots[1].func_77946_l();
                        this.slots[2].field_77994_a = amount;
                        this.stack -= amount;
                    } else {
                        amount = Math.min(amount, this.slots[2].func_77976_d() - this.slots[2].field_77994_a);
                        this.slots[2].field_77994_a += amount;
                        this.stack -= amount;
                    }
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("stack", this.getStockpile());
            data.func_74757_a("output", this.output);
            if (this.slots[1] != null) {
                this.slots[1].func_77955_b(data);
            }
            INBTPacketReceiver.networkPack(this, data, 15);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.stack = nbt.func_74762_e("stack");
        this.output = nbt.func_74767_n("output");
        this.type = ItemStack.func_77949_a((NBTTagCompound)nbt);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public ItemStack getType() {
        return this.slots[1] == null ? null : this.slots[1].func_77946_l();
    }

    public int getStockpile() {
        return this.stack;
    }

    public void setStockpile(int stack) {
        this.stack = stack;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return Vec3.func_72443_a((double)((double)this.field_145851_c - player.field_70165_t), (double)((double)this.field_145848_d - player.field_70163_u), (double)((double)this.field_145849_e - player.field_70161_v)).func_72433_c() < 20.0;
    }

    @Override
    public void func_70295_k_() {
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:block.storageOpen", 1.0f, 1.0f);
    }

    @Override
    public void func_70305_f() {
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:block.storageClose", 1.0f, 1.0f);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.stack = nbt.func_74762_e("stack");
        this.output = nbt.func_74767_n("output");
        this.capacity = nbt.func_74762_e("capacity");
        this.redstone = nbt.func_74771_c("redstone");
        if (this.capacity <= 0) {
            this.capacity = 10000;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("stack", this.stack);
        nbt.func_74757_a("output", this.output);
        nbt.func_74768_a("capacity", this.capacity);
        nbt.func_74774_a("redstone", (byte)this.redstone);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("provide") && this.slots[1] != null) {
            if (this.getStockpile() == 0) {
                return;
            }
            int amount = data.func_74767_n("provide") ? this.slots[1].func_77976_d() : 1;
            amount = Math.min(amount, this.getStockpile());
            if (!(this.slots[2] == null || this.slots[2].func_77969_a(this.getType()) && ItemStack.func_77970_a((ItemStack)this.slots[2], (ItemStack)this.getType()))) {
                return;
            }
            if (this.slots[2] == null) {
                this.slots[2] = this.slots[1].func_77946_l();
                this.slots[2].field_77994_a = amount;
                this.stack -= amount;
            } else {
                amount = Math.min(amount, this.slots[2].func_77976_d() - this.slots[2].field_77994_a);
                this.slots[2].field_77994_a += amount;
                this.stack -= amount;
            }
        }
        if (data.func_74764_b("toggle")) {
            this.output = !this.output;
        }
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return !this.isLocked() && i == 0 && (this.getType() == null || this.getType().func_77969_a(itemStack) && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)this.getType()));
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return !this.isLocked() && i == 2;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0, 2};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMassStorage(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMassStorage(player.field_71071_by, this);
    }
}

