/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.storage;

import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ModBlocks;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.handler.MultiblockHandlerXR;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.interfaces.IFluidSource;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.container.ContainerMachineFluidTank;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Corrosive;
import com.hbm.inventory.fluid.trait.FT_Flammable;
import com.hbm.inventory.fluid.trait.FluidTraitSimple;
import com.hbm.inventory.gui.GUIMachineFluidTank;
import com.hbm.lib.Library;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IOverpressurable;
import com.hbm.tileentity.IPersistentNBT;
import com.hbm.tileentity.IRepairable;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.storage.TileEntityBarrel;
import com.hbm.util.ParticleUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")})
public class TileEntityMachineFluidTank
extends TileEntityMachineBase
implements IFluidContainer,
SimpleComponent,
IFluidSource,
IFluidAcceptor,
IFluidStandardTransceiver,
IPersistentNBT,
IOverpressurable,
IGUIProvider,
IRepairable {
    public FluidTank tank;
    public short mode = 0;
    public static final short modes = 4;
    public boolean hasExploded = false;
    protected boolean sendingBrake = false;
    public boolean onFire = false;
    public byte lastRedstone = 0;
    public Explosion lastExplosion = null;
    public int age = 0;
    public List<IFluidAcceptor> list = new ArrayList<IFluidAcceptor>();
    AxisAlignedBB bb = null;
    List<RecipesCommon.AStack> repair = new ArrayList<RecipesCommon.AStack>();

    public TileEntityMachineFluidTank() {
        super(6);
        this.tank = new FluidTank(Fluids.NONE, 256000);
    }

    @Override
    public String getName() {
        return "container.fluidtank";
    }

    public byte getComparatorPower() {
        if (this.tank.getFill() == 0) {
            return 0;
        }
        double frac = (double)this.tank.getFill() / (double)this.tank.getMaxFill() * 15.0;
        return (byte)MathHelper.func_76125_a((int)((int)frac + 1), (int)0, (int)15);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            byte comp;
            if (this.func_145832_p() < 12) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p()).getRotation(ForgeDirection.DOWN);
                this.field_145850_b.func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, ModBlocks.machine_fluidtank, dir.ordinal() + 10, 3);
                MultiblockHandlerXR.fillSpace(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ((BlockDummyable)ModBlocks.machine_fluidtank).getDimensions(), ModBlocks.machine_fluidtank, dir);
                NBTTagCompound data = new NBTTagCompound();
                this.func_145841_b(data);
                this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e).func_145839_a(data);
                return;
            }
            if (!this.hasExploded) {
                ++this.age;
                if (this.age >= 20) {
                    this.age = 0;
                }
                this.sendingBrake = true;
                this.tank.setFill(TileEntityBarrel.transmitFluidFairly(this.field_145850_b, this.tank, this, this.tank.getFill(), this.mode == 0 || this.mode == 1, this.mode == 1 || this.mode == 2, this.getConPos()));
                this.sendingBrake = false;
                if (!(this.mode != 1 && this.mode != 2 || this.age != 9 && this.age != 19)) {
                    this.fillFluidInit(this.tank.getTankType());
                }
                this.tank.loadTank(2, 3, this.slots);
                this.tank.setType(0, 1, this.slots);
            }
            if ((comp = this.getComparatorPower()) != this.lastRedstone) {
                this.func_70296_d();
            }
            this.lastRedstone = comp;
            if (this.tank.getFill() > 0) {
                if (this.tank.getTankType().isAntimatter()) {
                    new ExplosionVNT(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, 5.0f).makeAmat().setBlockAllocator(null).setBlockProcessor(null).explode();
                    this.explode();
                    this.tank.setFill(0);
                }
                if (this.tank.getTankType().hasTrait(FT_Corrosive.class) && this.tank.getTankType().getTrait(FT_Corrosive.class).isHighlyCorrosive()) {
                    this.explode();
                }
                if (this.hasExploded) {
                    int leaking = 0;
                    leaking = this.tank.getTankType().isAntimatter() ? this.tank.getFill() : (this.tank.getTankType().hasTrait(FluidTraitSimple.FT_Gaseous.class) || this.tank.getTankType().hasTrait(FluidTraitSimple.FT_Gaseous_ART.class) ? Math.min(this.tank.getFill(), this.tank.getMaxFill() / 100) : Math.min(this.tank.getFill(), this.tank.getMaxFill() / 10000));
                    this.updateLeak(leaking);
                }
            }
            this.tank.unloadTank(4, 5, this.slots);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74777_a("mode", this.mode);
            data.func_74757_a("hasExploded", this.hasExploded);
            this.tank.writeToNBT(data, "t");
            this.networkPack(data, 150);
        }
    }

    public void explode() {
        this.hasExploded = true;
        this.onFire = this.tank.getTankType().hasTrait(FT_Flammable.class);
        this.markChanged();
    }

    public void updateLeak(int amount) {
        if (!this.hasExploded) {
            return;
        }
        if (amount <= 0) {
            return;
        }
        this.tank.getTankType().onFluidRelease(this, this.tank, amount);
        this.tank.setFill(Math.max(0, this.tank.getFill() - amount));
        FluidType type = this.tank.getTankType();
        if (type.hasTrait(FluidTraitSimple.FT_Amat.class)) {
            new ExplosionVNT(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, 5.0f).makeAmat().setBlockAllocator(null).setBlockProcessor(null).explode();
        } else if (type.hasTrait(FT_Flammable.class) && this.onFire) {
            List affected = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 1.5), (double)this.field_145848_d, (double)((double)this.field_145849_e - 1.5), (double)((double)this.field_145851_c + 2.5), (double)(this.field_145848_d + 5), (double)((double)this.field_145849_e + 2.5)));
            for (Entity e : affected) {
                e.func_70015_d(5);
            }
            Random rand = this.field_145850_b.field_73012_v;
            ParticleUtil.spawnGasFlame(this.field_145850_b, (double)this.field_145851_c + rand.nextDouble(), (double)this.field_145848_d + 0.5 + rand.nextDouble(), (double)this.field_145849_e + rand.nextDouble(), rand.nextGaussian() * 0.2, 0.1, rand.nextGaussian() * 0.2);
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.SOOT, 2.0f);
                if (type.hasTrait(FluidTraitSimple.FT_Leaded.class)) {
                    PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.HEAVYMETAL, 1.0f);
                }
            }
        } else if ((type.hasTrait(FluidTraitSimple.FT_Gaseous.class) || type.hasTrait(FluidTraitSimple.FT_Gaseous_ART.class)) && this.field_145850_b.func_82737_E() % 5L == 0L) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "tower");
            data.func_74776_a("lift", 1.0f);
            data.func_74776_a("base", 1.0f);
            data.func_74776_a("max", 5.0f);
            data.func_74768_a("life", 100 + this.field_145850_b.field_73012_v.nextInt(20));
            data.func_74768_a("color", this.tank.getTankType().getColor());
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, (double)this.field_145851_c + 0.5, this.field_145848_d + 1, (double)this.field_145849_e + 0.5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 150.0));
        }
    }

    @Override
    public void explode(World world, int x, int y, int z) {
        if (this.hasExploded) {
            return;
        }
        this.onFire = this.tank.getTankType().hasTrait(FT_Flammable.class);
        this.hasExploded = true;
        this.markChanged();
    }

    @Override
    public void tryExtinguish(World world, int x, int y, int z, IRepairable.EnumExtinguishType type) {
        if (!this.hasExploded || !this.onFire) {
            return;
        }
        if (type == IRepairable.EnumExtinguishType.WATER) {
            if (this.tank.getTankType().hasTrait(FluidTraitSimple.FT_Liquid.class)) {
                this.field_145850_b.func_72885_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, 5.0f, true, true);
            } else {
                this.onFire = false;
                this.markChanged();
                return;
            }
        }
        if (type == IRepairable.EnumExtinguishType.FOAM || type == IRepairable.EnumExtinguishType.CO2) {
            this.onFire = false;
            this.markChanged();
        }
    }

    protected DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 1, Library.POS_X), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 1, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 1, Library.NEG_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 1, Library.NEG_X), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z)};
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.mode = data.func_74765_d("mode");
        this.hasExploded = data.func_74767_n("hasExploded");
        this.tank.readFromNBT(data, "t");
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        this.mode = (short)((this.mode + 1) % 4);
        this.markChanged();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 3));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void setFillForSync(int fill, int index) {
        this.tank.setFill(fill);
    }

    @Override
    public void setTypeForSync(FluidType type, int index) {
        this.tank.setTankType(type);
    }

    @Override
    public int getMaxFluidFill(FluidType type) {
        if (this.mode == 2 || this.mode == 3 || this.sendingBrake) {
            return 0;
        }
        return type.name().equals(this.tank.getTankType().name()) ? this.tank.getMaxFill() : 0;
    }

    @Override
    public void fillFluidInit(FluidType type) {
        this.fillFluid(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 1, this.getTact(), type);
        this.fillFluid(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 1, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 1, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 1, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 2, this.getTact(), type);
        this.fillFluid(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 2, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 2, this.getTact(), type);
        this.fillFluid(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 2, this.getTact(), type);
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    @Override
    public int getFluidFill(FluidType type) {
        return type.name().equals(this.tank.getTankType().name()) ? this.tank.getFill() : 0;
    }

    @Override
    public void setFluidFill(int i, FluidType type) {
        if (type.name().equals(this.tank.getTankType().name())) {
            this.tank.setFill(i);
        }
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidType type) {
        return this.list;
    }

    @Override
    public void clearFluidList(FluidType type) {
        this.list.clear();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.mode = nbt.func_74765_d("mode");
        this.tank.readFromNBT(nbt, "tank");
        this.hasExploded = nbt.func_74767_n("exploded");
        this.onFire = nbt.func_74767_n("onFire");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("mode", this.mode);
        this.tank.writeToNBT(nbt, "tank");
        nbt.func_74757_a("exploded", this.hasExploded);
        nbt.func_74757_a("onFire", this.onFire);
    }

    @Override
    public long transferFluid(FluidType type, int pressure, long fluid) {
        long toTransfer = Math.min(this.getDemand(type, pressure), fluid);
        this.tank.setFill(this.tank.getFill() + (int)toTransfer);
        return fluid - toTransfer;
    }

    @Override
    public long getDemand(FluidType type, int pressure) {
        if (this.mode == 2 || this.mode == 3 || this.sendingBrake) {
            return 0L;
        }
        if (this.tank.getPressure() != pressure) {
            return 0L;
        }
        return type == this.tank.getTankType() ? (long)(this.tank.getMaxFill() - this.tank.getFill()) : 0L;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public void writeNBT(NBTTagCompound nbt) {
        if (this.tank.getFill() == 0 && !this.hasExploded) {
            return;
        }
        NBTTagCompound data = new NBTTagCompound();
        this.tank.writeToNBT(data, "tank");
        data.func_74777_a("mode", this.mode);
        data.func_74757_a("hasExploded", this.hasExploded);
        data.func_74757_a("onFire", this.onFire);
        nbt.func_74782_a("persistent", (NBTBase)data);
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        NBTTagCompound data = nbt.func_74775_l("persistent");
        this.tank.readFromNBT(data, "tank");
        this.mode = data.func_74765_d("mode");
        this.hasExploded = data.func_74767_n("hasExploded");
        this.onFire = data.func_74767_n("onFire");
    }

    @Override
    public FluidTank[] getSendingTanks() {
        FluidTank[] fluidTankArray;
        if (this.hasExploded) {
            return new FluidTank[0];
        }
        if (this.mode == 1 || this.mode == 2) {
            FluidTank[] fluidTankArray2 = new FluidTank[1];
            fluidTankArray = fluidTankArray2;
            fluidTankArray2[0] = this.tank;
        } else {
            fluidTankArray = new FluidTank[]{};
        }
        return fluidTankArray;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        FluidTank[] fluidTankArray;
        if (this.hasExploded || this.sendingBrake) {
            return new FluidTank[0];
        }
        if (this.mode == 0 || this.mode == 1) {
            FluidTank[] fluidTankArray2 = new FluidTank[1];
            fluidTankArray = fluidTankArray2;
            fluidTankArray2[0] = this.tank;
        } else {
            fluidTankArray = new FluidTank[]{};
        }
        return fluidTankArray;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineFluidTank(player.field_71071_by, (TileEntityMachineFluidTank)world.func_147438_o(x, y, z));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineFluidTank(player.field_71071_by, (TileEntityMachineFluidTank)world.func_147438_o(x, y, z));
    }

    @Override
    public boolean isDamaged() {
        return this.hasExploded;
    }

    @Override
    public List<RecipesCommon.AStack> getRepairMaterials() {
        if (!this.repair.isEmpty()) {
            return this.repair;
        }
        this.repair.add(new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 6));
        return this.repair;
    }

    @Override
    public void repair() {
        this.hasExploded = false;
        this.markChanged();
    }

    public String getComponentName() {
        return "ntm_tank";
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] getFluidStored(Context context, Arguments args) {
        return new Object[]{this.tank.getFill()};
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] getMaxStored(Context context, Arguments args) {
        return new Object[]{this.tank.getMaxFill()};
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] getTypeStored(Context context, Arguments args) {
        return new Object[]{this.tank.getTankType().getName()};
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.tank.getFill(), this.tank.getMaxFill(), this.tank.getTankType().getName()};
    }
}

