/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.storage;

import api.hbm.energy.IEnergyConductor;
import api.hbm.energy.IEnergyConnector;
import api.hbm.energy.IPowerNet;
import api.hbm.energy.PowerNet;
import com.hbm.lib.Library;
import com.hbm.tileentity.machine.storage.TileEntityMachineBattery;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineFENSU
extends TileEntityMachineBattery {
    public float prevRotation = 0.0f;
    public float rotation = 0.0f;
    public static final long maxTransfer = 10000000000000000L;

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            long prevPower = this.power;
            this.power = Library.chargeItemsFromTE(this.slots, 1, this.power, this.getMaxPower());
            this.transmitPower();
            byte comp = this.getComparatorPower();
            if (comp != this.lastRedstone) {
                this.func_70296_d();
            }
            this.lastRedstone = comp;
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, this.getMaxPower());
            long avg = this.power / 2L + prevPower / 2L;
            this.delta = avg - this.log[0];
            for (int i = 1; i < this.log.length; ++i) {
                this.log[i - 1] = this.log[i];
            }
            this.log[19] = avg;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74772_a("power", avg);
            nbt.func_74772_a("delta", this.delta);
            nbt.func_74777_a("redLow", this.redLow);
            nbt.func_74777_a("redHigh", this.redHigh);
            nbt.func_74774_a("priority", (byte)this.priority.ordinal());
            this.networkPack(nbt, 20);
        }
        if (this.field_145850_b.field_72995_K) {
            this.prevRotation = this.rotation;
            this.rotation += this.getSpeed();
            if (this.rotation >= 360.0f) {
                this.rotation -= 360.0f;
                this.prevRotation -= 360.0f;
            }
        }
    }

    @Override
    @Deprecated
    protected void transmitPower() {
        short mode = this.getRelevantMode();
        HashSet<IPowerNet> nets = new HashSet<IPowerNet>();
        HashSet<IEnergyConnector> consumers = new HashSet<IEnergyConnector>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IEnergyConnector con;
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (te instanceof IEnergyConductor) {
                con = (IEnergyConductor)te;
                if (!con.canConnect(dir.getOpposite()) || con.getPowerNet() == null) continue;
                nets.add(con.getPowerNet());
                con.getPowerNet().unsubscribe(this);
                consumers.addAll(con.getPowerNet().getSubscribers());
                continue;
            }
            if (!(te instanceof IEnergyConnector) || !(con = (IEnergyConnector)te).canConnect(dir.getOpposite())) continue;
            consumers.add((IEnergyConnector)te);
        }
        if (this.power > 0L && (mode == 1 || mode == 2)) {
            ArrayList<IEnergyConnector> con = new ArrayList<IEnergyConnector>();
            con.addAll(consumers);
            if (PowerNet.trackingInstances == null) {
                PowerNet.trackingInstances = new ArrayList<PowerNet>();
            }
            PowerNet.trackingInstances.clear();
            nets.forEach(x -> {
                if (x instanceof PowerNet) {
                    PowerNet.trackingInstances.add((PowerNet)x);
                }
            });
            long toSend = Math.min(this.power, 10000000000000000L);
            long powerRemaining = this.power - toSend;
            this.power = PowerNet.fairTransfer(con, toSend) + powerRemaining;
        }
        if (mode == 1 || mode == 0) {
            nets.forEach(x -> x.subscribe(this));
        }
    }

    @Override
    public long getPowerRemainingScaled(long i) {
        double powerScaled = (double)this.power / (double)this.getMaxPower();
        return (long)((double)i * powerScaled);
    }

    @Override
    public long getMaxPower() {
        return Long.MAX_VALUE;
    }

    @Override
    public long getTransferWeight() {
        return Math.min(Math.max(this.getMaxPower() - this.getPower(), 0L), 10000000000000000L);
    }

    public float getSpeed() {
        return (float)Math.pow(Math.log((double)this.power * 0.75 + 1.0) * (double)0.05f, 5.0);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public long transferPower(long power) {
        long freespace;
        long overshoot = 0L;
        if (power > 10000000000000000L) {
            overshoot += power - 10000000000000000L;
            power = 10000000000000000L;
        }
        if ((freespace = this.getMaxPower() - this.getPower()) < power) {
            overshoot += power - freespace;
            power = freespace;
        }
        this.setPower(this.getPower() + power);
        return overshoot;
    }
}

