/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.storage;

import api.hbm.energy.IBatteryItem;
import api.hbm.energy.IEnergyConductor;
import api.hbm.energy.IEnergyConnector;
import api.hbm.energy.IEnergyUser;
import api.hbm.energy.IPowerNet;
import api.hbm.energy.PowerNet;
import com.hbm.blocks.machine.MachineBattery;
import com.hbm.inventory.container.ContainerMachineBattery;
import com.hbm.inventory.gui.GUIMachineBattery;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IPersistentNBT;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")})
public class TileEntityMachineBattery
extends TileEntityMachineBase
implements IEnergyUser,
IPersistentNBT,
SimpleComponent,
IGUIProvider {
    public long[] log = new long[20];
    public long delta = 0L;
    public long power = 0L;
    public static final int mode_input = 0;
    public static final int mode_buffer = 1;
    public static final int mode_output = 2;
    public static final int mode_none = 3;
    public short redLow = 0;
    public short redHigh = (short)2;
    public IEnergyConnector.ConnectionPriority priority = IEnergyConnector.ConnectionPriority.LOW;
    public byte lastRedstone = 0;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{0, 1};
    private static final int[] slots_side = new int[]{1};
    private String customName;
    private long bufferedMax;

    public TileEntityMachineBattery() {
        super(2);
        this.slots = new ItemStack[2];
    }

    @Override
    public String getName() {
        return "container.battery";
    }

    @Override
    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : this.getName();
    }

    @Override
    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    @Override
    public void setCustomName(String name) {
        this.customName = name;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        switch (i) {
            case 0: 
            case 1: {
                if (!(stack.func_77973_b() instanceof IBatteryItem)) break;
                return true;
            }
        }
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.redLow = nbt.func_74765_d("redLow");
        this.redHigh = nbt.func_74765_d("redHigh");
        this.lastRedstone = nbt.func_74771_c("lastRedstone");
        this.priority = IEnergyConnector.ConnectionPriority.values()[nbt.func_74771_c("priority")];
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74777_a("redLow", this.redLow);
        nbt.func_74777_a("redHigh", this.redHigh);
        nbt.func_74774_a("lastRedstone", this.lastRedstone);
        nbt.func_74774_a("priority", (byte)this.priority.ordinal());
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        if (itemStack.func_77973_b() instanceof IBatteryItem) {
            if (i == 0 && ((IBatteryItem)itemStack.func_77973_b()).getCharge(itemStack) == 0L) {
                return true;
            }
            if (i == 1 && ((IBatteryItem)itemStack.func_77973_b()).getCharge(itemStack) == ((IBatteryItem)itemStack.func_77973_b()).getMaxCharge()) {
                return true;
            }
        }
        return false;
    }

    public long getPowerRemainingScaled(long i) {
        return this.power * i / this.getMaxPower();
    }

    public byte getComparatorPower() {
        if (this.power == 0L) {
            return 0;
        }
        double frac = (double)this.power / (double)this.getMaxPower() * 15.0;
        return (byte)MathHelper.func_76125_a((int)((int)frac + 1), (int)0, (int)15);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) instanceof MachineBattery) {
            long prevPower = this.power;
            this.power = Library.chargeItemsFromTE(this.slots, 1, this.power, this.getMaxPower());
            this.transmitPowerFairly();
            byte comp = this.getComparatorPower();
            if (comp != this.lastRedstone) {
                this.func_70296_d();
            }
            this.lastRedstone = comp;
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, this.getMaxPower());
            long avg = (this.power + prevPower) / 2L;
            this.delta = avg - this.log[0];
            for (int i = 1; i < this.log.length; ++i) {
                this.log[i - 1] = this.log[i];
            }
            this.log[19] = avg;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74772_a("power", avg);
            nbt.func_74772_a("delta", this.delta);
            nbt.func_74777_a("redLow", this.redLow);
            nbt.func_74777_a("redHigh", this.redHigh);
            nbt.func_74774_a("priority", (byte)this.priority.ordinal());
            this.networkPack(nbt, 20);
        }
    }

    protected void transmitPowerFairly() {
        short mode = this.getRelevantMode();
        HashSet<IPowerNet> nets = new HashSet<IPowerNet>();
        HashSet<IEnergyConnector> consumers = new HashSet<IEnergyConnector>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IEnergyConnector con;
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (te instanceof IEnergyConductor) {
                con = (IEnergyConductor)te;
                if (!con.canConnect(dir.getOpposite()) || con.getPowerNet() == null) continue;
                nets.add(con.getPowerNet());
                con.getPowerNet().unsubscribe(this);
                consumers.addAll(con.getPowerNet().getSubscribers());
                continue;
            }
            if (!(te instanceof IEnergyConnector) || !(con = (IEnergyConnector)te).canConnect(dir.getOpposite())) continue;
            consumers.add((IEnergyConnector)te);
        }
        if (this.power > 0L && (mode == 1 || mode == 2)) {
            ArrayList<IEnergyConnector> con = new ArrayList<IEnergyConnector>();
            con.addAll(consumers);
            if (PowerNet.trackingInstances == null) {
                PowerNet.trackingInstances = new ArrayList<PowerNet>();
            }
            PowerNet.trackingInstances.clear();
            nets.forEach(x -> {
                if (x instanceof PowerNet) {
                    PowerNet.trackingInstances.add((PowerNet)x);
                }
            });
            this.power = PowerNet.fairTransfer(con, this.power);
        }
        if (mode == 1 || mode == 0) {
            nets.forEach(x -> x.subscribe(this));
        }
    }

    protected void transmitPower() {
        short mode = this.getRelevantMode();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IEnergyConnector con;
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (te instanceof IEnergyConductor && (con = (IEnergyConductor)te).getPowerNet() != null && con.getPowerNet().isSubscribed(this)) {
                con.getPowerNet().unsubscribe(this);
            }
            if ((mode == 1 || mode == 2) && te instanceof IEnergyConnector) {
                con = (IEnergyConnector)te;
                long max = this.getMaxTransfer();
                long toTransfer = Math.min(max, this.power);
                long remainder = this.power - toTransfer;
                long oldPower = this.power = toTransfer;
                long transfer = this.power - con.transferPower(this.power);
                this.power = oldPower - transfer;
                this.power += remainder;
            }
            if (!(te instanceof IEnergyConductor) || (con = (IEnergyConductor)te).getPowerNet() == null) continue;
            if (mode == 2 || mode == 3) {
                if (!con.getPowerNet().isSubscribed(this)) continue;
                con.getPowerNet().unsubscribe(this);
                continue;
            }
            if (con.getPowerNet().isSubscribed(this)) continue;
            con.getPowerNet().subscribe(this);
        }
    }

    public long getMaxTransfer() {
        return this.getMaxPower();
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.delta = nbt.func_74763_f("delta");
        this.redLow = nbt.func_74765_d("redLow");
        this.redHigh = nbt.func_74765_d("redHigh");
        this.priority = IEnergyConnector.ConnectionPriority.values()[nbt.func_74771_c("priority")];
    }

    @Override
    public long getPower() {
        return this.power;
    }

    public short getRelevantMode() {
        if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return this.redHigh;
        }
        return this.redLow;
    }

    @Override
    public long getMaxPower() {
        if (this.bufferedMax == 0L) {
            this.bufferedMax = ((MachineBattery)this.field_145850_b.func_147439_a((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e)).maxPower;
        }
        return this.bufferedMax;
    }

    @Override
    public long transferPower(long power) {
        short mode = this.getRelevantMode();
        if (mode == 2 || mode == 3) {
            return power;
        }
        this.power += power;
        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
        if (this.power > this.getMaxPower()) {
            long overshoot = this.power - this.getMaxPower();
            this.power = this.getMaxPower();
            return overshoot;
        }
        return 0L;
    }

    @Override
    public long getTransferWeight() {
        short mode = this.getRelevantMode();
        if (mode == 2 || mode == 3) {
            return 0L;
        }
        return Math.max(this.getMaxPower() - this.getPower(), 0L);
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return true;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public IEnergyConnector.ConnectionPriority getPriority() {
        return this.priority;
    }

    public String getComponentName() {
        return "ntm_energy_storage";
    }

    @Callback(direct=true, limit=8)
    @Optional.Method(modid="OpenComputers")
    public Object[] getEnergyInfo(Context context, Arguments args) {
        return new Object[]{this.getPower(), this.getMaxPower()};
    }

    @Callback(direct=true, limit=8)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.getPower(), this.getMaxPower()};
    }

    @Override
    public void writeNBT(NBTTagCompound nbt) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74772_a("power", this.power);
        data.func_74777_a("redLow", this.redLow);
        data.func_74777_a("redHigh", this.redHigh);
        data.func_74768_a("priority", this.priority.ordinal());
        nbt.func_74782_a("persistent", (NBTBase)data);
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        NBTTagCompound data = nbt.func_74775_l("persistent");
        this.power = data.func_74763_f("power");
        this.redLow = data.func_74765_d("redLow");
        this.redHigh = data.func_74765_d("redHigh");
        this.priority = IEnergyConnector.ConnectionPriority.values()[data.func_74762_e("priority")];
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineBattery(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineBattery(player.field_71071_by, this);
    }
}

