/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.storage;

import api.hbm.fluid.IFluidConductor;
import api.hbm.fluid.IFluidConnector;
import api.hbm.fluid.IFluidStandardTransceiver;
import api.hbm.fluid.IPipeNet;
import api.hbm.fluid.PipeNet;
import com.hbm.blocks.ModBlocks;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidSource;
import com.hbm.inventory.FluidContainerRegistry;
import com.hbm.inventory.container.ContainerBarrel;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Corrosive;
import com.hbm.inventory.gui.GUIBarrel;
import com.hbm.lib.Library;
import com.hbm.saveddata.TomSaveData;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IPersistentNBT;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")})
public class TileEntityBarrel
extends TileEntityMachineBase
implements IFluidAcceptor,
IFluidSource,
SimpleComponent,
IFluidStandardTransceiver,
IPersistentNBT,
IGUIProvider {
    public FluidTank tank;
    public short mode = 0;
    public static final short modes = 4;
    public int age = 0;
    public List<IFluidAcceptor> list = new ArrayList<IFluidAcceptor>();
    protected boolean sendingBrake = false;
    public byte lastRedstone = 0;

    public TileEntityBarrel() {
        super(6);
        this.tank = new FluidTank(Fluids.NONE, 0, 0);
    }

    public TileEntityBarrel(int capacity) {
        super(6);
        this.tank = new FluidTank(Fluids.NONE, capacity, 0);
    }

    @Override
    public String getName() {
        return "container.barrel";
    }

    public byte getComparatorPower() {
        if (this.tank.getFill() == 0) {
            return 0;
        }
        double frac = (double)this.tank.getFill() / (double)this.tank.getMaxFill() * 15.0;
        return (byte)MathHelper.func_76125_a((int)((int)frac + 1), (int)0, (int)15);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            byte comp = this.getComparatorPower();
            if (comp != this.lastRedstone) {
                this.func_70296_d();
            }
            this.lastRedstone = comp;
            this.tank.setType(0, 1, this.slots);
            this.tank.loadTank(2, 3, this.slots);
            this.tank.unloadTank(4, 5, this.slots);
            this.tank.updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            this.sendingBrake = true;
            this.tank.setFill(TileEntityBarrel.transmitFluidFairly(this.field_145850_b, this.tank, this, this.tank.getFill(), this.mode == 0 || this.mode == 1, this.mode == 1 || this.mode == 2, this.getConPos()));
            this.sendingBrake = false;
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (!(this.mode != 1 && this.mode != 2 || this.age != 9 && this.age != 19)) {
                this.fillFluidInit(this.tank.getTankType());
            }
            if (this.tank.getFill() > 0) {
                this.checkFluidInteraction();
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74777_a("mode", this.mode);
            this.networkPack(data, 50);
        }
    }

    protected DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, Library.POS_Y), new DirPos(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, Library.NEG_Y), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, Library.NEG_Z)};
    }

    protected static int transmitFluidFairly(World world, FluidTank tank, IFluidConnector that, int fill, boolean connect, boolean send, DirPos[] connections) {
        HashSet<IPipeNet> nets = new HashSet<IPipeNet>();
        HashSet<IFluidConnector> consumers = new HashSet<IFluidConnector>();
        FluidType type = tank.getTankType();
        int pressure = tank.getPressure();
        for (DirPos pos : connections) {
            TileEntity te = world.func_147438_o(pos.getX(), pos.getY(), pos.getZ());
            if (te instanceof IFluidConductor) {
                IFluidConductor con = (IFluidConductor)te;
                if (con.getPipeNet(type) == null) continue;
                nets.add(con.getPipeNet(type));
                con.getPipeNet(type).unsubscribe(that);
                consumers.addAll(con.getPipeNet(type).getSubscribers());
                continue;
            }
            if (!(te instanceof IFluidConnector)) continue;
            consumers.add((IFluidConnector)te);
        }
        consumers.remove(that);
        if (fill > 0 && send) {
            ArrayList<IFluidConnector> con = new ArrayList<IFluidConnector>();
            con.addAll(consumers);
            con.removeIf(x -> x == null || !(x instanceof TileEntity) || ((TileEntity)x).func_145837_r());
            if (PipeNet.trackingInstances == null) {
                PipeNet.trackingInstances = new ArrayList<PipeNet>();
            }
            PipeNet.trackingInstances.clear();
            nets.forEach(x -> {
                if (x instanceof PipeNet) {
                    PipeNet.trackingInstances.add((PipeNet)x);
                }
            });
            fill = (int)PipeNet.fairTransfer(con, type, pressure, fill);
        }
        if (connect) {
            nets.forEach(x -> x.subscribe(that));
        }
        return fill;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        ItemStack full = FluidContainerRegistry.getFullContainer(itemStack, this.tank.getTankType());
        if (i == 4 && full != null && FluidContainerRegistry.getFluidContent(full, this.tank.getTankType()) <= this.tank.getMaxFill()) {
            return true;
        }
        int content = FluidContainerRegistry.getFluidContent(itemStack, this.tank.getTankType());
        return i == 2 && content > 0 && content <= this.tank.getMaxFill();
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i == 3 || i == 5;
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{2, 3, 4, 5};
    }

    public void checkFluidInteraction() {
        int light;
        Block b = this.func_145838_q();
        if (b != ModBlocks.barrel_antimatter && this.tank.getTankType().isAntimatter()) {
            this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
            this.field_145850_b.func_72885_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 5.0f, true, true);
        }
        if (b == ModBlocks.barrel_plastic && (this.tank.getTankType().isCorrosive() || this.tank.getTankType().isHot())) {
            this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.fizz", 1.0f, 1.0f);
        }
        if (b == ModBlocks.barrel_iron && this.tank.getTankType().isCorrosive() || b == ModBlocks.barrel_steel && this.tank.getTankType().hasTrait(FT_Corrosive.class) && this.tank.getTankType().getTrait(FT_Corrosive.class).getRating() > 50) {
            ItemStack[] copy = (ItemStack[])this.slots.clone();
            this.slots = new ItemStack[6];
            this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, ModBlocks.barrel_corroded);
            TileEntityBarrel barrel = (TileEntityBarrel)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (barrel != null) {
                barrel.tank.setTankType(this.tank.getTankType());
                barrel.tank.setFill(Math.min(barrel.tank.getMaxFill(), this.tank.getFill()));
                barrel.slots = copy;
            }
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.fizz", 1.0f, 1.0f);
        }
        if (b == ModBlocks.barrel_corroded && this.field_145850_b.field_73012_v.nextInt(3) == 0) {
            this.tank.setFill(this.tank.getFill() - 1);
        }
        if (this.tank.getTankType() == Fluids.WATER && (double)TomSaveData.forWorld((World)this.field_145850_b).fire > 1.0E-5 && (light = this.field_145850_b.func_72972_b(EnumSkyBlock.Sky, this.field_145851_c, this.field_145848_d, this.field_145849_e)) > 7) {
            this.field_145850_b.func_72885_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 5.0f, true, true);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.mode = data.func_74765_d("mode");
    }

    @Override
    public void setFillForSync(int fill, int index) {
        this.tank.setFill(fill);
    }

    @Override
    public void setTypeForSync(FluidType type, int index) {
        this.tank.setTankType(type);
    }

    @Override
    public int getMaxFluidFill(FluidType type) {
        if (this.mode == 2 || this.mode == 3) {
            return 0;
        }
        return type == this.tank.getTankType() ? this.tank.getMaxFill() : 0;
    }

    @Override
    public void fillFluidInit(FluidType type) {
        this.fillFluid(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, this.getTact(), type);
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    @Override
    public int getFluidFill(FluidType type) {
        return type == this.tank.getTankType() ? this.tank.getFill() : 0;
    }

    @Override
    public void setFluidFill(int i, FluidType type) {
        if (type == this.tank.getTankType()) {
            this.tank.setFill(i);
        }
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidType type) {
        return this.list;
    }

    @Override
    public void clearFluidList(FluidType type) {
        this.list.clear();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.mode = nbt.func_74765_d("mode");
        this.tank.readFromNBT(nbt, "tank");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("mode", this.mode);
        this.tank.writeToNBT(nbt, "tank");
    }

    @Override
    public FluidTank[] getSendingTanks() {
        FluidTank[] fluidTankArray;
        if (this.mode == 1 || this.mode == 2) {
            FluidTank[] fluidTankArray2 = new FluidTank[1];
            fluidTankArray = fluidTankArray2;
            fluidTankArray2[0] = this.tank;
        } else {
            fluidTankArray = new FluidTank[]{};
        }
        return fluidTankArray;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        FluidTank[] fluidTankArray;
        if (!(this.mode != 0 && this.mode != 1 || this.sendingBrake)) {
            FluidTank[] fluidTankArray2 = new FluidTank[1];
            fluidTankArray = fluidTankArray2;
            fluidTankArray2[0] = this.tank;
        } else {
            fluidTankArray = new FluidTank[]{};
        }
        return fluidTankArray;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public void writeNBT(NBTTagCompound nbt) {
        if (this.tank.getFill() == 0) {
            return;
        }
        NBTTagCompound data = new NBTTagCompound();
        this.tank.writeToNBT(data, "tank");
        data.func_74777_a("mode", this.mode);
        nbt.func_74782_a("persistent", (NBTBase)data);
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        NBTTagCompound data = nbt.func_74775_l("persistent");
        this.tank.readFromNBT(data, "tank");
        this.mode = data.func_74765_d("nbt");
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerBarrel(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIBarrel(player.field_71071_by, this);
    }

    public String getComponentName() {
        return "ntm_fluid_tank";
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] getFluidStored(Context context, Arguments args) {
        return new Object[]{this.tank.getFill()};
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] getMaxStored(Context context, Arguments args) {
        return new Object[]{this.tank.getMaxFill()};
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] getTypeStored(Context context, Arguments args) {
        return new Object[]{this.tank.getTankType().getName()};
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.tank.getFill(), this.tank.getMaxFill(), this.tank.getTankType().getName()};
    }
}

