/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.rbmk.RBMKBase;
import com.hbm.blocks.machine.rbmk.RBMKRod;
import com.hbm.entity.projectile.EntityRBMKDebris;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.inventory.container.ContainerRBMKRod;
import com.hbm.inventory.gui.GUIRBMKRod;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemRBMKRod;
import com.hbm.tileentity.machine.rbmk.IRBMKFluxReceiver;
import com.hbm.tileentity.machine.rbmk.IRBMKLoadable;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKAbsorber;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKBase;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKConsole;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKControl;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKModerator;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKOutgasser;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKReflector;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKSlottedBase;
import com.hbm.util.Compat;
import com.hbm.util.ParticleUtil;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityRBMKRod
extends TileEntityRBMKSlottedBase
implements IRBMKFluxReceiver,
IRBMKLoadable,
SimpleComponent {
    public double fluxFast;
    public double fluxSlow;
    public boolean hasRod;
    public static final ForgeDirection[] fluxDirs = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST};
    protected static IRBMKFluxReceiver.NType stream;

    public TileEntityRBMKRod() {
        super(1);
    }

    @Override
    public String getName() {
        return "container.rbmkRod";
    }

    @Override
    public boolean isModerated() {
        return ((RBMKRod)this.func_145838_q()).moderated;
    }

    @Override
    public void receiveFlux(IRBMKFluxReceiver.NType type, double flux) {
        switch (type) {
            case FAST: {
                this.fluxFast += flux;
                break;
            }
            case SLOW: {
                this.fluxSlow += flux;
            }
        }
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemRBMKRod) {
                ItemRBMKRod rod = (ItemRBMKRod)this.slots[0].func_77973_b();
                double fluxIn = this.fluxFromType(rod.nType);
                double fluxOut = rod.burn(this.field_145850_b, this.slots[0], fluxIn);
                IRBMKFluxReceiver.NType rType = rod.rType;
                rod.updateHeat(this.field_145850_b, this.slots[0], 1.0);
                this.heat += rod.provideHeat(this.field_145850_b, this.slots[0], this.heat, 1.0);
                if (!this.hasLid()) {
                    ChunkRadiationManager.proxy.incrementRad(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, (float)((this.fluxFast + this.fluxSlow) * (double)0.05f));
                }
                super.func_145845_h();
                if (this.heat > this.maxHeat()) {
                    if (RBMKDials.getMeltdownsDisabled(this.field_145850_b)) {
                        ParticleUtil.spawnGasFlame(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + RBMKDials.getColumnHeight(this.field_145850_b)) + 0.5, (double)this.field_145849_e + 0.5, 0.0, 0.2, 0.0);
                    } else {
                        this.meltdown();
                    }
                    this.fluxFast = 0.0;
                    this.fluxSlow = 0.0;
                    return;
                }
                if (this.heat > 10000.0) {
                    this.heat = 10000.0;
                }
                this.fluxFast = 0.0;
                this.fluxSlow = 0.0;
                this.field_145850_b.field_72984_F.func_76320_a("rbmkRod_flux_spread");
                this.spreadFlux(rType, fluxOut);
                this.field_145850_b.field_72984_F.func_76319_b();
                this.hasRod = true;
            } else {
                this.fluxFast = 0.0;
                this.fluxSlow = 0.0;
                this.hasRod = false;
                super.func_145845_h();
            }
        }
    }

    private double fluxFromType(IRBMKFluxReceiver.NType type) {
        switch (type) {
            case SLOW: {
                return this.fluxFast * 0.5 + this.fluxSlow;
            }
            case FAST: {
                return this.fluxFast + this.fluxSlow * 0.3;
            }
            case ANY: {
                return this.fluxFast + this.fluxSlow;
            }
        }
        return 0.0;
    }

    protected void spreadFlux(IRBMKFluxReceiver.NType type, double fluxOut) {
        int range = RBMKDials.getFluxRange(this.field_145850_b);
        for (ForgeDirection dir : fluxDirs) {
            stream = type;
            double flux = fluxOut;
            for (int i = 1; i <= range && !((flux = this.runInteraction(this.field_145851_c + dir.offsetX * i, this.field_145848_d, this.field_145849_e + dir.offsetZ * i, flux)) <= 0.0); ++i) {
            }
        }
    }

    protected double runInteraction(int x, int y, int z, double flux) {
        IRBMKFluxReceiver rod;
        TileEntity te = Compat.getTileStandard(this.field_145850_b, x, y, z);
        if (te instanceof TileEntityRBMKBase) {
            TileEntityRBMKBase base = (TileEntityRBMKBase)te;
            if (!base.hasLid()) {
                ChunkRadiationManager.proxy.incrementRad(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, (float)(flux * (double)0.05f));
            }
            if (base.isModerated()) {
                stream = IRBMKFluxReceiver.NType.SLOW;
            }
        }
        if (te instanceof TileEntityRBMKRod) {
            rod = (TileEntityRBMKRod)te;
            if (((TileEntityRBMKSlottedBase)((Object)rod)).func_70301_a(0) != null && ((TileEntityRBMKSlottedBase)((Object)rod)).func_70301_a(0).func_77973_b() instanceof ItemRBMKRod) {
                ((TileEntityRBMKRod)rod).receiveFlux(stream, flux);
                return 0.0;
            }
            return flux;
        }
        if (te instanceof TileEntityRBMKOutgasser && !((TileEntityRBMKOutgasser)(rod = (TileEntityRBMKOutgasser)te)).canProcess()) {
            return flux;
        }
        if (te instanceof IRBMKFluxReceiver) {
            rod = (IRBMKFluxReceiver)te;
            rod.receiveFlux(stream, flux);
            return 0.0;
        }
        if (te instanceof TileEntityRBMKControl) {
            TileEntityRBMKControl control = (TileEntityRBMKControl)te;
            if (control.getMult() == 0.0) {
                return 0.0;
            }
            return flux *= control.getMult();
        }
        if (te instanceof TileEntityRBMKModerator) {
            stream = IRBMKFluxReceiver.NType.SLOW;
            return flux;
        }
        if (te instanceof TileEntityRBMKReflector) {
            this.receiveFlux(this.isModerated() ? IRBMKFluxReceiver.NType.SLOW : stream, flux);
            return 0.0;
        }
        if (te instanceof TileEntityRBMKAbsorber) {
            return 0.0;
        }
        if (te instanceof TileEntityRBMKBase) {
            return flux;
        }
        int limit = RBMKDials.getColumnHeight(this.field_145850_b);
        int hits = 0;
        for (int h = 0; h <= limit; ++h) {
            if (this.field_145850_b.func_147439_a(x, y + h, z).func_149662_c()) continue;
            ++hits;
        }
        if (hits > 0) {
            ChunkRadiationManager.proxy.incrementRad(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, (float)(flux * (double)0.05f * (double)hits / (double)limit));
        }
        return 0.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.fluxFast = nbt.func_74769_h("fluxFast");
        this.fluxSlow = nbt.func_74769_h("fluxSlow");
        this.hasRod = nbt.func_74767_n("hasRod");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74780_a("fluxFast", this.fluxFast);
        nbt.func_74780_a("fluxSlow", this.fluxSlow);
        nbt.func_74757_a("hasRod", this.hasRod);
    }

    @Override
    public void getDiagData(NBTTagCompound nbt) {
        this.func_145841_b(nbt);
        if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemRBMKRod) {
            ItemRBMKRod rod = (ItemRBMKRod)this.slots[0].func_77973_b();
            nbt.func_74778_a("f_yield", ItemRBMKRod.getYield(this.slots[0]) + " / " + rod.yield + " (" + ItemRBMKRod.getEnrichment(this.slots[0]) * 100.0 + "%)");
            nbt.func_74778_a("f_xenon", ItemRBMKRod.getPoison(this.slots[0]) + "%");
            nbt.func_74778_a("f_heat", ItemRBMKRod.getCoreHeat(this.slots[0]) + " / " + ItemRBMKRod.getHullHeat(this.slots[0]) + " / " + rod.meltingPoint);
        }
    }

    @Override
    public void onMelt(int reduce) {
        int i;
        int count;
        boolean corium;
        boolean moderated = this.isModerated();
        int h = RBMKDials.getColumnHeight(this.field_145850_b);
        reduce = MathHelper.func_76125_a((int)reduce, (int)1, (int)h);
        if (this.field_145850_b.field_73012_v.nextInt(3) == 0) {
            ++reduce;
        }
        boolean bl = corium = this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemRBMKRod;
        if (corium && this.slots[0].func_77973_b() == ModItems.rbmk_fuel_drx) {
            RBMKBase.digamma = true;
        }
        this.slots[0] = null;
        if (corium) {
            for (int i2 = h; i2 >= 0; --i2) {
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d + i2, this.field_145849_e, ModBlocks.corium_block, 5, 3);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d + i2, this.field_145849_e);
            }
            count = 1 + this.field_145850_b.field_73012_v.nextInt(RBMKDials.getColumnHeight(this.field_145850_b));
            for (i = 0; i < count; ++i) {
                this.spawnDebris(EntityRBMKDebris.DebrisType.FUEL);
            }
        } else {
            this.standardMelt(reduce);
        }
        if (moderated) {
            count = 2 + this.field_145850_b.field_73012_v.nextInt(2);
            for (i = 0; i < count; ++i) {
                this.spawnDebris(EntityRBMKDebris.DebrisType.GRAPHITE);
            }
        }
        this.spawnDebris(EntityRBMKDebris.DebrisType.ELEMENT);
        if (this.func_145832_p() == RBMKBase.DIR_NORMAL_LID.ordinal() + 10) {
            this.spawnDebris(EntityRBMKDebris.DebrisType.LID);
        }
    }

    @Override
    public TileEntityRBMKConsole.ColumnType getConsoleType() {
        return TileEntityRBMKConsole.ColumnType.FUEL;
    }

    @Override
    public NBTTagCompound getNBTForConsole() {
        NBTTagCompound data = new NBTTagCompound();
        if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemRBMKRod) {
            ItemRBMKRod rod = (ItemRBMKRod)this.slots[0].func_77973_b();
            data.func_74780_a("enrichment", ItemRBMKRod.getEnrichment(this.slots[0]));
            data.func_74780_a("xenon", ItemRBMKRod.getPoison(this.slots[0]));
            data.func_74780_a("c_heat", ItemRBMKRod.getHullHeat(this.slots[0]));
            data.func_74780_a("c_coreHeat", ItemRBMKRod.getCoreHeat(this.slots[0]));
            data.func_74780_a("c_maxHeat", rod.meltingPoint);
        }
        return data;
    }

    @Override
    public boolean canLoad(ItemStack toLoad) {
        return toLoad != null && this.slots[0] == null;
    }

    @Override
    public void load(ItemStack toLoad) {
        this.slots[0] = toLoad.func_77946_l();
        this.func_70296_d();
    }

    @Override
    public boolean canUnload() {
        return this.slots[0] != null;
    }

    @Override
    public ItemStack provideNext() {
        return this.slots[0];
    }

    @Override
    public void unload() {
        this.slots[0] = null;
        this.func_70296_d();
    }

    public String getComponentName() {
        return "rbmk_fuel_rod";
    }

    @Callback(direct=true, limit=16)
    @Optional.Method(modid="OpenComputers")
    public Object[] getHeat(Context context, Arguments args) {
        return new Object[]{this.heat};
    }

    @Callback(direct=true, limit=16)
    @Optional.Method(modid="OpenComputers")
    public Object[] getFluxSlow(Context context, Arguments args) {
        return new Object[]{this.fluxSlow};
    }

    @Callback(direct=true, limit=16)
    @Optional.Method(modid="OpenComputers")
    public Object[] getFluxFast(Context context, Arguments args) {
        return new Object[]{this.fluxFast};
    }

    @Callback(direct=true, limit=16)
    @Optional.Method(modid="OpenComputers")
    public Object[] getDepletion(Context context, Arguments args) {
        if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemRBMKRod) {
            return new Object[]{ItemRBMKRod.getEnrichment(this.slots[0])};
        }
        return new Object[]{"N/A"};
    }

    @Callback(direct=true, limit=16)
    @Optional.Method(modid="OpenComputers")
    public Object[] getXenonPoison(Context context, Arguments args) {
        if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemRBMKRod) {
            return new Object[]{ItemRBMKRod.getPoison(this.slots[0])};
        }
        return new Object[]{"N/A"};
    }

    @Callback(direct=true, limit=16)
    @Optional.Method(modid="OpenComputers")
    public Object[] getCoreHeat(Context context, Arguments args) {
        if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemRBMKRod) {
            return new Object[]{ItemRBMKRod.getCoreHeat(this.slots[0])};
        }
        return new Object[]{"N/A"};
    }

    @Callback(direct=true, limit=16)
    @Optional.Method(modid="OpenComputers")
    public Object[] getSkinHeat(Context context, Arguments args) {
        if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemRBMKRod) {
            return new Object[]{ItemRBMKRod.getHullHeat(this.slots[0])};
        }
        return new Object[]{"N/A"};
    }

    @Callback(direct=true, limit=16)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        Object OC_core_buf;
        Object OC_hull_buf;
        Object OC_poison_buf;
        Object OC_enrich_buf;
        if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemRBMKRod) {
            OC_enrich_buf = ItemRBMKRod.getEnrichment(this.slots[0]);
            OC_poison_buf = ItemRBMKRod.getPoison(this.slots[0]);
            OC_hull_buf = ItemRBMKRod.getHullHeat(this.slots[0]);
            OC_core_buf = ItemRBMKRod.getCoreHeat(this.slots[0]);
        } else {
            OC_enrich_buf = "N/A";
            OC_poison_buf = "N/A";
            OC_hull_buf = "N/A";
            OC_core_buf = "N/A";
        }
        return new Object[]{this.heat, OC_hull_buf, OC_core_buf, this.fluxSlow, this.fluxFast, OC_enrich_buf, OC_poison_buf, ((RBMKRod)this.func_145838_q()).moderated, this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    @Callback(direct=true, limit=16)
    @Optional.Method(modid="OpenComputers")
    public Object[] getModerated(Context context, Arguments args) {
        return new Object[]{((RBMKRod)this.func_145838_q()).moderated};
    }

    @Callback(direct=true, limit=16)
    @Optional.Method(modid="OpenComputers")
    public Object[] getCoordinates(Context context, Arguments args) {
        return new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerRBMKRod(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIRBMKRod(player.field_71071_by, this);
    }
}

