/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.gui.GUIRBMKConsole;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKBase;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKControlManual;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKRod;
import com.hbm.util.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TileEntityRBMKConsole
extends TileEntityMachineBase
implements IControlReceiver,
IGUIProvider {
    private int targetX;
    private int targetY;
    private int targetZ;
    public int[] fluxBuffer = new int[20];
    public RBMKColumn[] columns = new RBMKColumn[225];
    public RBMKScreen[] screens = new RBMKScreen[6];

    public TileEntityRBMKConsole() {
        super(0);
        for (int i = 0; i < this.screens.length; ++i) {
            this.screens[i] = new RBMKScreen();
        }
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                this.field_145850_b.field_72984_F.func_76320_a("rbmkConsole_rescan");
                this.rescan();
                this.field_145850_b.field_72984_F.func_76319_b();
                this.prepareScreenInfo();
            }
            this.prepareNetworkPack();
        }
    }

    private void rescan() {
        int i;
        double flux = 0.0;
        for (i = -7; i <= 7; ++i) {
            for (int j = -7; j <= 7; ++j) {
                TileEntity te = this.field_145850_b.func_147438_o(this.targetX + i, this.targetY, this.targetZ + j);
                int index = i + 7 + (j + 7) * 15;
                if (te instanceof TileEntityRBMKBase) {
                    TileEntityRBMKBase rbmk = (TileEntityRBMKBase)te;
                    this.columns[index] = new RBMKColumn(rbmk.getConsoleType(), rbmk.getNBTForConsole());
                    this.columns[index].data.func_74780_a("heat", rbmk.heat);
                    this.columns[index].data.func_74780_a("maxHeat", rbmk.maxHeat());
                    if (rbmk.isModerated()) {
                        this.columns[index].data.func_74757_a("moderated", true);
                    }
                    if (!(te instanceof TileEntityRBMKRod)) continue;
                    TileEntityRBMKRod fuel = (TileEntityRBMKRod)te;
                    flux += fuel.fluxFast + fuel.fluxSlow;
                    continue;
                }
                this.columns[index] = null;
            }
        }
        for (i = 0; i < this.fluxBuffer.length - 1; ++i) {
            this.fluxBuffer[i] = this.fluxBuffer[i + 1];
        }
        this.fluxBuffer[19] = (int)flux;
    }

    private void prepareScreenInfo() {
        for (RBMKScreen screen : this.screens) {
            if (screen.type == ScreenType.NONE) {
                screen.display = null;
                continue;
            }
            double value = 0.0;
            int count = 0;
            block15: for (Integer i : screen.columns) {
                RBMKColumn col = this.columns[i];
                if (col == null) continue;
                switch (screen.type) {
                    case COL_TEMP: {
                        ++count;
                        value += col.data.func_74769_h("heat");
                        continue block15;
                    }
                    case FUEL_DEPLETION: {
                        if (!col.data.func_74764_b("enrichment")) continue block15;
                        ++count;
                        value += 100.0 - col.data.func_74769_h("enrichment") * 100.0;
                        continue block15;
                    }
                    case FUEL_POISON: {
                        if (!col.data.func_74764_b("xenon")) continue block15;
                        ++count;
                        value += col.data.func_74769_h("xenon");
                        continue block15;
                    }
                    case FUEL_TEMP: {
                        if (!col.data.func_74764_b("c_heat")) continue block15;
                        ++count;
                        value += col.data.func_74769_h("c_heat");
                        continue block15;
                    }
                    case ROD_EXTRACTION: {
                        if (!col.data.func_74764_b("level")) continue block15;
                        ++count;
                        value += col.data.func_74769_h("level") * 100.0;
                    }
                }
            }
            double result = value / (double)count;
            String text = (double)((int)(result * 10.0)) / 10.0 + "";
            switch (screen.type) {
                case COL_TEMP: {
                    text = "rbmk.screen.temp=" + text + "\u00b0C";
                    break;
                }
                case FUEL_DEPLETION: {
                    text = "rbmk.screen.depletion=" + text + "%";
                    break;
                }
                case FUEL_POISON: {
                    text = "rbmk.screen.xenon=" + text + "%";
                    break;
                }
                case FUEL_TEMP: {
                    text = "rbmk.screen.core=" + text + "\u00b0C";
                    break;
                }
                case ROD_EXTRACTION: {
                    text = "rbmk.screen.rod=" + text + "%";
                }
            }
            screen.display = text;
        }
    }

    private void prepareNetworkPack() {
        RBMKScreen screen;
        int i;
        NBTTagCompound data = new NBTTagCompound();
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            data.func_74757_a("full", true);
            for (i = 0; i < this.columns.length; ++i) {
                if (this.columns[i] == null) continue;
                data.func_74782_a("column_" + i, (NBTBase)this.columns[i].data);
                data.func_74777_a("type_" + i, (short)this.columns[i].type.ordinal());
            }
            data.func_74783_a("flux", this.fluxBuffer);
            for (i = 0; i < this.screens.length; ++i) {
                screen = this.screens[i];
                if (screen.display == null) continue;
                data.func_74778_a("t" + i, screen.display);
            }
        }
        for (i = 0; i < this.screens.length; ++i) {
            screen = this.screens[i];
            data.func_74774_a("s" + i, (byte)screen.type.ordinal());
        }
        this.networkPack(data, 50);
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        RBMKScreen screen;
        int i;
        if (data.func_74767_n("full")) {
            this.columns = new RBMKColumn[225];
            for (i = 0; i < this.columns.length; ++i) {
                if (!data.func_74764_b("type_" + i)) continue;
                this.columns[i] = new RBMKColumn(ColumnType.values()[data.func_74765_d("type_" + i)], (NBTTagCompound)data.func_74781_a("column_" + i));
            }
            this.fluxBuffer = data.func_74759_k("flux");
            for (i = 0; i < this.screens.length; ++i) {
                screen = this.screens[i];
                screen.display = data.func_74779_i("t" + i);
            }
        }
        for (i = 0; i < this.screens.length; ++i) {
            screen = this.screens[i];
            screen.type = ScreenType.values()[data.func_74771_c("s" + i)];
        }
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return Vec3.func_72443_a((double)((double)this.field_145851_c - player.field_70165_t), (double)((double)this.field_145848_d - player.field_70163_u), (double)((double)this.field_145849_e - player.field_70161_v)).func_72433_c() < 20.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("level")) {
            Set keys = data.func_150296_c();
            for (String key : keys) {
                int z;
                int x;
                TileEntity te;
                if (!key.startsWith("sel_") || !((te = this.field_145850_b.func_147438_o(this.targetX + (x = data.func_74762_e(key) % 15 - 7), this.targetY, this.targetZ + (z = data.func_74762_e(key) / 15 - 7))) instanceof TileEntityRBMKControlManual)) continue;
                TileEntityRBMKControlManual rod = (TileEntityRBMKControlManual)te;
                rod.startingLevel = rod.level;
                rod.setTarget(MathHelper.func_151237_a((double)data.func_74769_h("level"), (double)0.0, (double)1.0));
                te.func_70296_d();
            }
        }
        if (data.func_74764_b("toggle")) {
            ScreenType type;
            byte slot = data.func_74771_c("toggle");
            int next = this.screens[slot].type.ordinal() + 1;
            this.screens[slot].type = type = ScreenType.values()[next % ScreenType.values().length];
        }
        if (data.func_74764_b("id")) {
            byte slot = data.func_74771_c("id");
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i = 0; i < 225; ++i) {
                if (!data.func_74767_n("s" + i)) continue;
                list.add(i);
            }
            Integer[] cols = list.toArray(new Integer[0]);
            this.screens[slot].columns = cols;
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 3));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public void setTarget(int x, int y, int z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.targetX = nbt.func_74762_e("tX");
        this.targetY = nbt.func_74762_e("tY");
        this.targetZ = nbt.func_74762_e("tZ");
        for (int i = 0; i < this.screens.length; ++i) {
            this.screens[i].type = ScreenType.values()[nbt.func_74771_c("t" + i)];
            this.screens[i].columns = (Integer[])Arrays.stream(nbt.func_74759_k("s" + i)).boxed().toArray(Integer[]::new);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("tX", this.targetX);
        nbt.func_74768_a("tY", this.targetY);
        nbt.func_74768_a("tZ", this.targetZ);
        for (int i = 0; i < this.screens.length; ++i) {
            nbt.func_74774_a("t" + i, (byte)this.screens[i].type.ordinal());
            nbt.func_74783_a("s" + i, Arrays.stream(this.screens[i].columns).mapToInt(Integer::intValue).toArray());
        }
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIRBMKConsole(player.field_71071_by, this);
    }

    public static enum ScreenType {
        NONE(0),
        COL_TEMP(18),
        ROD_EXTRACTION(36),
        FUEL_DEPLETION(54),
        FUEL_POISON(72),
        FUEL_TEMP(90);

        public int offset;

        private ScreenType(int offset) {
            this.offset = offset;
        }
    }

    public class RBMKScreen {
        public ScreenType type = ScreenType.NONE;
        public Integer[] columns = new Integer[0];
        public String display = null;

        public RBMKScreen() {
        }

        public RBMKScreen(ScreenType type, Integer[] columns, String display) {
            this.type = type;
            this.columns = columns;
            this.display = display;
        }
    }

    public static enum ColumnType {
        BLANK(0),
        FUEL(10),
        FUEL_SIM(90),
        CONTROL(20),
        CONTROL_AUTO(30),
        BOILER(40),
        MODERATOR(50),
        ABSORBER(60),
        REFLECTOR(70),
        OUTGASSER(80),
        BREEDER(100),
        STORAGE(110),
        COOLER(120),
        HEATEX(130);

        public int offset;

        private ColumnType(int offset) {
            this.offset = offset;
        }
    }

    public static class RBMKColumn {
        public ColumnType type;
        public NBTTagCompound data;

        public RBMKColumn(ColumnType type) {
            this.type = type;
        }

        public RBMKColumn(ColumnType type, NBTTagCompound data) {
            this.type = type;
            this.data = data != null ? data : new NBTTagCompound();
        }

        @SideOnly(value=Side.CLIENT)
        public List<String> getFancyStats() {
            if (this.data == null) {
                return null;
            }
            ArrayList<String> stats = new ArrayList<String>();
            stats.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("rbmk.heat", (double)((int)(this.data.func_74769_h("heat") * 10.0)) / 10.0 + "\u00b0C"));
            switch (this.type) {
                case FUEL: 
                case FUEL_SIM: {
                    stats.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("rbmk.rod.depletion", (double)((int)((1.0 - this.data.func_74769_h("enrichment")) * 100000.0)) / 1000.0 + "%"));
                    stats.add(EnumChatFormatting.DARK_PURPLE + I18nUtil.resolveKey("rbmk.rod.xenon", (double)((int)(this.data.func_74769_h("xenon") * 1000.0)) / 1000.0 + "%"));
                    stats.add(EnumChatFormatting.DARK_RED + I18nUtil.resolveKey("rbmk.rod.coreTemp", (double)((int)(this.data.func_74769_h("c_coreHeat") * 10.0)) / 10.0 + "\u00b0C"));
                    stats.add(EnumChatFormatting.RED + I18nUtil.resolveKey("rbmk.rod.skinTemp", (double)((int)(this.data.func_74769_h("c_heat") * 10.0)) / 10.0 + "\u00b0C", (double)((int)(this.data.func_74769_h("c_maxHeat") * 10.0)) / 10.0 + "\u00b0C"));
                    break;
                }
                case BOILER: {
                    stats.add(EnumChatFormatting.BLUE + I18nUtil.resolveKey("rbmk.boiler.water", this.data.func_74762_e("water"), this.data.func_74762_e("maxWater")));
                    stats.add(EnumChatFormatting.WHITE + I18nUtil.resolveKey("rbmk.boiler.steam", this.data.func_74762_e("steam"), this.data.func_74762_e("maxSteam")));
                    stats.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("rbmk.boiler.type", I18nUtil.resolveKey(Fluids.fromID(this.data.func_74765_d("type")).getUnlocalizedName(), new Object[0])));
                    break;
                }
                case CONTROL: {
                    short col;
                    if (this.data.func_74764_b("color") && (col = this.data.func_74765_d("color")) >= 0 && col < TileEntityRBMKControlManual.RBMKColor.values().length) {
                        stats.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("rbmk.control." + TileEntityRBMKControlManual.RBMKColor.values()[col].name().toLowerCase(Locale.US), new Object[0]));
                    }
                }
                case CONTROL_AUTO: {
                    stats.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("rbmk.control.level", (int)(this.data.func_74769_h("level") * 100.0) + "%"));
                    break;
                }
                case HEATEX: {
                    stats.add(EnumChatFormatting.BLUE + I18nUtil.resolveKey(I18nUtil.resolveKey(Fluids.fromID(this.data.func_74765_d("type")).getUnlocalizedName(), new Object[0]) + " " + this.data.func_74762_e("water") + "/" + this.data.func_74762_e("maxWater") + "mB", new Object[0]));
                    stats.add(EnumChatFormatting.RED + I18nUtil.resolveKey(I18nUtil.resolveKey(Fluids.fromID(this.data.func_74765_d("hottype")).getUnlocalizedName(), new Object[0]) + " " + this.data.func_74762_e("steam") + "/" + this.data.func_74762_e("maxSteam") + "mB", new Object[0]));
                }
            }
            if (this.data.func_74767_n("moderated")) {
                stats.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("rbmk.moderated", new Object[0]));
            }
            return stats;
        }
    }
}

