/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import com.hbm.config.GeneralConfig;
import com.hbm.util.GameRuleHelper;
import net.minecraft.util.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class RBMKDials {
    public static final String KEY_SAVE_DIALS = "dialSaveDials";
    public static final String KEY_PASSIVE_COOLING = "dialPassiveCooling";
    public static final String KEY_COLUMN_HEAT_FLOW = "dialColumnHeatFlow";
    public static final String KEY_FUEL_DIFFUSION_MOD = "dialDiffusionMod";
    public static final String KEY_HEAT_PROVISION = "dialHeatProvision";
    public static final String KEY_COLUMN_HEIGHT = "dialColumnHeight";
    public static final String KEY_PERMANENT_SCRAP = "dialEnablePermaScrap";
    public static final String KEY_BOILER_HEAT_CONSUMPTION = "dialBoilerHeatConsumption";
    public static final String KEY_CONTROL_SPEED_MOD = "dialControlSpeed";
    public static final String KEY_REACTIVITY_MOD = "dialReactivityMod";
    public static final String KEY_OUTGASSER_MOD = "dialOutgasserSpeedMod";
    public static final String KEY_SURGE_MOD = "dialControlSurgeMod";
    public static final String KEY_FLUX_RANGE = "dialFluxRange";
    public static final String KEY_REASIM_RANGE = "dialReasimRange";
    public static final String KEY_REASIM_COUNT = "dialReasimCount";
    public static final String KEY_REASIM_MOD = "dialReasimOutputMod";
    public static final String KEY_REASIM_BOILERS = "dialReasimBoilers";
    public static final String KEY_REASIM_BOILER_SPEED = "dialReasimBoilerSpeed";
    public static final String KEY_DISABLE_MELTDOWNS = "dialDisableMeltdowns";
    public static final String KEY_ENABLE_MELTDOWN_OVERPRESSURE = "dialEnableMeltdownOverpressure";

    public static void createDials(World world) {
        GameRules rules = world.func_82736_K();
        if (!rules.func_82766_b(KEY_SAVE_DIALS)) {
            rules.func_82764_b(KEY_PASSIVE_COOLING, "1.0");
            rules.func_82764_b(KEY_COLUMN_HEAT_FLOW, "0.2");
            rules.func_82764_b(KEY_FUEL_DIFFUSION_MOD, "1.0");
            rules.func_82764_b(KEY_HEAT_PROVISION, "0.2");
            rules.func_82764_b(KEY_COLUMN_HEIGHT, "4");
            rules.func_82764_b(KEY_PERMANENT_SCRAP, "true");
            rules.func_82764_b(KEY_BOILER_HEAT_CONSUMPTION, "0.1");
            rules.func_82764_b(KEY_CONTROL_SPEED_MOD, "1.0");
            rules.func_82764_b(KEY_REACTIVITY_MOD, "1.0");
            rules.func_82764_b(KEY_SAVE_DIALS, "true");
            rules.func_82764_b(KEY_OUTGASSER_MOD, "1.0");
            rules.func_82764_b(KEY_SURGE_MOD, "1.0");
            rules.func_82764_b(KEY_FLUX_RANGE, "5");
            rules.func_82764_b(KEY_REASIM_RANGE, "10");
            rules.func_82764_b(KEY_REASIM_COUNT, "6");
            rules.func_82764_b(KEY_REASIM_MOD, "1.0");
            rules.func_82764_b(KEY_REASIM_BOILERS, "false");
            rules.func_82764_b(KEY_REASIM_BOILER_SPEED, "0.05");
            rules.func_82764_b(KEY_DISABLE_MELTDOWNS, "false");
            rules.func_82764_b(KEY_ENABLE_MELTDOWN_OVERPRESSURE, "false");
        }
    }

    public static double getPassiveCooling(World world) {
        return Math.max(GameRuleHelper.parseDouble(world.func_82736_K().func_82767_a(KEY_PASSIVE_COOLING), 1.0), 0.0);
    }

    public static double getColumnHeatFlow(World world) {
        return MathHelper.func_151237_a((double)GameRuleHelper.parseDouble(world.func_82736_K().func_82767_a(KEY_COLUMN_HEAT_FLOW), 0.2), (double)0.0, (double)1.0);
    }

    public static double getFuelDiffusionMod(World world) {
        return Math.max(GameRuleHelper.parseDouble(world.func_82736_K().func_82767_a(KEY_FUEL_DIFFUSION_MOD), 1.0), 0.0);
    }

    public static double getFuelHeatProvision(World world) {
        return MathHelper.func_151237_a((double)GameRuleHelper.parseDouble(world.func_82736_K().func_82767_a(KEY_HEAT_PROVISION), 0.2), (double)0.0, (double)1.0);
    }

    public static int getColumnHeight(World world) {
        return MathHelper.func_76125_a((int)GameRuleHelper.parseInt(world.func_82736_K().func_82767_a(KEY_COLUMN_HEIGHT), 4), (int)2, (int)16) - 1;
    }

    public static boolean getPermaScrap(World world) {
        return world.func_82736_K().func_82766_b(KEY_PERMANENT_SCRAP);
    }

    public static double getBoilerHeatConsumption(World world) {
        return Math.max(GameRuleHelper.parseDouble(world.func_82736_K().func_82767_a(KEY_BOILER_HEAT_CONSUMPTION), 0.1), 0.0);
    }

    public static double getControlSpeed(World world) {
        return Math.max(GameRuleHelper.parseDouble(world.func_82736_K().func_82767_a(KEY_CONTROL_SPEED_MOD), 1.0), 0.0);
    }

    public static double getReactivityMod(World world) {
        return Math.max(GameRuleHelper.parseDouble(world.func_82736_K().func_82767_a(KEY_REACTIVITY_MOD), 1.0), 0.0);
    }

    public static double getOutgasserMod(World world) {
        return Math.max(GameRuleHelper.parseDouble(world.func_82736_K().func_82767_a(KEY_OUTGASSER_MOD), 1.0), 0.0);
    }

    public static double getSurgeMod(World world) {
        return Math.max(GameRuleHelper.parseDouble(world.func_82736_K().func_82767_a(KEY_SURGE_MOD), 1.0), 0.0);
    }

    public static int getFluxRange(World world) {
        return MathHelper.func_76125_a((int)GameRuleHelper.parseInt(world.func_82736_K().func_82767_a(KEY_FLUX_RANGE), 5), (int)1, (int)100);
    }

    public static int getReaSimRange(World world) {
        return MathHelper.func_76125_a((int)GameRuleHelper.parseInt(world.func_82736_K().func_82767_a(KEY_REASIM_RANGE), 10), (int)1, (int)100);
    }

    public static int getReaSimCount(World world) {
        return MathHelper.func_76125_a((int)GameRuleHelper.parseInt(world.func_82736_K().func_82767_a(KEY_REASIM_COUNT), 6), (int)1, (int)24);
    }

    public static double getReaSimOutputMod(World world) {
        return Math.max(GameRuleHelper.parseDouble(world.func_82736_K().func_82767_a(KEY_REASIM_MOD), 1.0), 0.0);
    }

    public static boolean getReasimBoilers(World world) {
        return world.func_82736_K().func_82766_b(KEY_REASIM_BOILERS) || GeneralConfig.enable528 && GeneralConfig.enable528ReasimBoilers;
    }

    public static double getReaSimBoilerSpeed(World world) {
        return MathHelper.func_151237_a((double)GameRuleHelper.parseDouble(world.func_82736_K().func_82767_a(KEY_REASIM_BOILER_SPEED), 0.05), (double)0.0, (double)1.0);
    }

    public static boolean getMeltdownsDisabled(World world) {
        return world.func_82736_K().func_82766_b(KEY_DISABLE_MELTDOWNS);
    }

    public static boolean getOverpressure(World world) {
        return world.func_82736_K().func_82766_b(KEY_ENABLE_MELTDOWN_OVERPRESSURE);
    }
}

