/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import api.hbm.energy.IEnergyUser;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.blocks.ModBlocks;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidSource;
import com.hbm.inventory.UpgradeManager;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IPersistentNBT;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.Tuple;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityOilDrillBase
extends TileEntityMachineBase
implements IEnergyUser,
IFluidSource,
IFluidStandardTransceiver,
IConfigurableMachine,
IPersistentNBT,
IGUIProvider {
    public int indicator = 0;
    public long power;
    public List<IFluidAcceptor> list1 = new ArrayList<IFluidAcceptor>();
    public List<IFluidAcceptor> list2 = new ArrayList<IFluidAcceptor>();
    public FluidTank[] tanks;
    public int speedLevel;
    public int energyLevel;
    public int overLevel;
    protected HashSet<Tuple.Triplet<Integer, Integer, Integer>> trace = new HashSet();

    public TileEntityOilDrillBase() {
        super(8);
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(Fluids.OIL, 64000, 0);
        this.tanks[1] = new FluidTank(Fluids.GAS, 64000, 1);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(nbt, "t" + i);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].writeToNBT(nbt, "t" + i);
        }
    }

    @Override
    public void writeNBT(NBTTagCompound nbt) {
        boolean empty = this.power == 0L;
        for (FluidTank tank : this.tanks) {
            if (tank.getFill() <= 0) continue;
            empty = false;
        }
        if (!empty) {
            nbt.func_74772_a("power", this.power);
            for (int i = 0; i < this.tanks.length; ++i) {
                this.tanks[i].writeToNBT(nbt, "t" + i);
            }
        }
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(nbt, "t" + i);
        }
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            this.tanks[0].unloadTank(1, 2, this.slots);
            this.tanks[1].unloadTank(3, 4, this.slots);
            UpgradeManager.eval(this.slots, 5, 7);
            this.speedLevel = Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3);
            this.energyLevel = Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER), 3);
            this.overLevel = Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE), 3) + 1;
            int abLevel = Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.AFTERBURN), 3);
            for (int i = 0; i < this.tanks.length; ++i) {
                this.tanks[i].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            }
            int toBurn = Math.min(this.tanks[1].getFill(), abLevel * 10);
            if (toBurn > 0) {
                this.tanks[1].setFill(this.tanks[1].getFill() - toBurn);
                this.power += (long)(toBurn * 5);
                if (this.power > this.getMaxPower()) {
                    this.power = this.getMaxPower();
                }
            }
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, this.getMaxPower());
            if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                this.fillFluidInit(this.tanks[0].getTankType());
            }
            if (this.field_145850_b.func_82737_E() % 10L == 5L) {
                this.fillFluidInit(this.tanks[1].getTankType());
            }
            for (DirPos pos : this.getConPos()) {
                if (this.tanks[0].getFill() > 0) {
                    this.sendFluid(this.tanks[0], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
                if (this.tanks[1].getFill() <= 0) continue;
                this.sendFluid(this.tanks[1], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            if (this.power >= (long)this.getPowerReqEff() && this.tanks[0].getFill() < this.tanks[0].getMaxFill() && this.tanks[1].getFill() < this.tanks[1].getMaxFill()) {
                this.power -= (long)this.getPowerReqEff();
                if (this.field_145850_b.func_82737_E() % (long)this.getDelayEff() == 0L) {
                    this.indicator = 0;
                    for (int y = this.field_145848_d - 1; y >= this.getDrillDepth(); --y) {
                        if (this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e) != ModBlocks.oil_pipe) {
                            if (!this.trySuck(y)) {
                                this.tryDrill(y);
                            }
                            break;
                        }
                        if (y != this.getDrillDepth()) continue;
                        this.indicator = 1;
                    }
                }
            } else {
                this.indicator = 2;
            }
            this.sendUpdate();
        }
    }

    public void sendUpdate() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74772_a("power", this.power);
        data.func_74768_a("indicator", this.indicator);
        this.networkPack(data, 25);
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.indicator = nbt.func_74762_e("indicator");
    }

    public boolean canPump() {
        return true;
    }

    @Override
    public void func_70299_a(int i, ItemStack stack) {
        super.func_70299_a(i, stack);
        if (stack != null && i >= 5 && i <= 7 && stack.func_77973_b() instanceof ItemMachineUpgrade) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, "hbm:item.upgradePlug", 1.0f, 1.0f);
        }
    }

    public int getPowerReqEff() {
        int req = this.getPowerReq();
        return (req + req / 4 * this.speedLevel - req / 4 * this.energyLevel) * this.overLevel;
    }

    public int getDelayEff() {
        int delay = this.getDelay();
        return Math.max((delay - delay / 4 * this.speedLevel + delay / 10 * this.energyLevel) / this.overLevel, 1);
    }

    public abstract int getPowerReq();

    public abstract int getDelay();

    public void tryDrill(int y) {
        Block b = this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e);
        if (b.func_149638_a(null) < 1000.0f) {
            this.onDrill(y);
            this.field_145850_b.func_147449_b(this.field_145851_c, y, this.field_145849_e, ModBlocks.oil_pipe);
        } else {
            this.indicator = 2;
        }
    }

    public void onDrill(int y) {
    }

    public int getDrillDepth() {
        return 5;
    }

    public boolean trySuck(int y) {
        Block b = this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e);
        if (!this.canSuckBlock(b)) {
            return false;
        }
        if (!this.canPump()) {
            return true;
        }
        this.trace.clear();
        return this.suckRec(this.field_145851_c, y, this.field_145849_e, 0);
    }

    public boolean canSuckBlock(Block b) {
        return b == ModBlocks.ore_oil || b == ModBlocks.ore_oil_empty;
    }

    public boolean suckRec(int x, int y, int z, int layer) {
        Tuple.Triplet<Integer, Integer, Integer> pos = new Tuple.Triplet<Integer, Integer, Integer>(x, y, z);
        if (this.trace.contains(pos)) {
            return false;
        }
        this.trace.add(pos);
        if (layer > 64) {
            return false;
        }
        Block b = this.field_145850_b.func_147439_a(x, y, z);
        if (b == ModBlocks.ore_oil || b == ModBlocks.ore_bedrock_oil) {
            this.doSuck(x, y, z);
            return true;
        }
        if (b == ModBlocks.ore_oil_empty) {
            ForgeDirection[] dirs;
            for (ForgeDirection dir : dirs = BobMathUtil.getShuffledDirs()) {
                if (!this.suckRec(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, layer + 1)) continue;
                return true;
            }
        }
        return false;
    }

    public void doSuck(int x, int y, int z) {
        if (this.field_145850_b.func_147439_a(x, y, z) == ModBlocks.ore_oil) {
            this.onSuck(x, y, z);
        }
    }

    public abstract void onSuck(int var1, int var2, int var3);

    @Override
    public boolean getTact() {
        return this.field_145850_b.func_82737_E() % 20L < 10L;
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public int getFluidFill(FluidType type) {
        for (FluidTank tank : this.tanks) {
            if (type != tank.getTankType()) continue;
            return tank.getFill();
        }
        return 0;
    }

    @Override
    public void setFluidFill(int i, FluidType type) {
        for (FluidTank tank : this.tanks) {
            if (type != tank.getTankType()) continue;
            tank.setFill(i);
            return;
        }
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidType type) {
        if (type == this.tanks[0].getTankType()) {
            return this.list1;
        }
        if (type == this.tanks[1].getTankType()) {
            return this.list2;
        }
        return new ArrayList<IFluidAcceptor>();
    }

    @Override
    public void clearFluidList(FluidType type) {
        if (type == this.tanks[0].getTankType()) {
            this.list1.clear();
        }
        if (type == this.tanks[1].getTankType()) {
            this.list2.clear();
        }
    }

    @Override
    public void setFillForSync(int fill, int index) {
        if (index < this.tanks.length && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
    }

    @Override
    public void setTypeForSync(FluidType type, int index) {
        if (index < this.tanks.length && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[0];
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    public abstract DirPos[] getConPos();

    protected void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }
}

