/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import api.hbm.energy.IEnergyUser;
import api.hbm.fluid.IFluidStandardReceiver;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.inventory.UpgradeManager;
import com.hbm.inventory.container.ContainerSolidifier;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUISolidifier;
import com.hbm.inventory.recipes.SolidificationRecipes;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.Tuple;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityMachineSolidifier
extends TileEntityMachineBase
implements IEnergyUser,
IFluidAcceptor,
IFluidStandardReceiver,
IGUIProvider {
    public long power;
    public static final long maxPower = 100000L;
    public static final int usageBase = 500;
    public int usage;
    public int progress;
    public static final int processTimeBase = 200;
    public int processTime;
    public FluidTank tank = new FluidTank(Fluids.NONE, 24000, 0);
    AxisAlignedBB bb = null;

    public TileEntityMachineSolidifier() {
        super(5);
    }

    @Override
    public String getName() {
        return "container.machineSolidifier";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems(this.slots, 1, this.power, 100000L);
            this.tank.setType(4, this.slots);
            this.tank.updateTank(this);
            this.updateConnections();
            UpgradeManager.eval(this.slots, 2, 3);
            int speed = Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3);
            int power = Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER), 3);
            this.processTime = 200 - 50 * speed;
            this.usage = (500 + 500 * speed) / (power + 1);
            if (this.canProcess()) {
                this.process();
            } else {
                this.progress = 0;
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74768_a("progress", this.progress);
            data.func_74768_a("usage", this.usage);
            data.func_74768_a("processTime", this.processTime);
            this.networkPack(data, 50);
        }
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.tank.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    private DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c, this.field_145848_d + 4, this.field_145849_e, Library.POS_Y), new DirPos(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, Library.NEG_Y), new DirPos(this.field_145851_c + 2, this.field_145848_d + 1, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d + 1, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e - 2, Library.NEG_Z)};
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 0;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean canProcess() {
        if (this.power < (long)this.usage) {
            return false;
        }
        Tuple.Pair<Integer, ItemStack> out = SolidificationRecipes.getOutput(this.tank.getTankType());
        if (out == null) {
            return false;
        }
        int req = out.getKey();
        ItemStack stack = out.getValue();
        if (req > this.tank.getFill()) {
            return false;
        }
        if (this.slots[0] != null) {
            if (this.slots[0].func_77973_b() != stack.func_77973_b()) {
                return false;
            }
            if (this.slots[0].func_77960_j() != stack.func_77960_j()) {
                return false;
            }
            if (this.slots[0].field_77994_a + stack.field_77994_a > this.slots[0].func_77976_d()) {
                return false;
            }
        }
        return true;
    }

    public void process() {
        this.power -= (long)this.usage;
        ++this.progress;
        if (this.progress >= this.processTime) {
            Tuple.Pair<Integer, ItemStack> out = SolidificationRecipes.getOutput(this.tank.getTankType());
            int req = out.getKey();
            ItemStack stack = out.getValue();
            this.tank.setFill(this.tank.getFill() - req);
            if (this.slots[0] == null) {
                this.slots[0] = stack.func_77946_l();
            } else {
                this.slots[0].field_77994_a += stack.field_77994_a;
            }
            this.progress = 0;
            this.func_70296_d();
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74762_e("progress");
        this.usage = nbt.func_74762_e("usage");
        this.processTime = nbt.func_74762_e("processTime");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt, "tank");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tank.writeToNBT(nbt, "tank");
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    @Override
    public void setFillForSync(int fill, int index) {
        this.tank.setFill(fill);
    }

    @Override
    public void setFluidFill(int fill, FluidType type) {
        if (type == this.tank.getTankType()) {
            this.tank.setFill(fill);
        }
    }

    @Override
    public void setTypeForSync(FluidType type, int index) {
        this.tank.setTankType(type);
    }

    @Override
    public int getFluidFill(FluidType type) {
        return this.tank.getTankType() == type ? this.tank.getFill() : 0;
    }

    @Override
    public int getMaxFluidFill(FluidType type) {
        return this.tank.getTankType() == type ? this.tank.getMaxFill() : 0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerSolidifier(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUISolidifier(player.field_71071_by, this);
    }
}

