/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import api.hbm.energy.IEnergyUser;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.MultiblockHandlerXR;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.interfaces.IFluidSource;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.container.ContainerMachineRefinery;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachineRefinery;
import com.hbm.inventory.recipes.RefineryRecipes;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IOverpressurable;
import com.hbm.tileentity.IPersistentNBT;
import com.hbm.tileentity.IRepairable;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.ParticleUtil;
import com.hbm.util.Tuple;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineRefinery
extends TileEntityMachineBase
implements IEnergyUser,
IFluidContainer,
IFluidAcceptor,
IFluidSource,
IControlReceiver,
IOverpressurable,
IPersistentNBT,
IRepairable,
IFluidStandardTransceiver,
IGUIProvider {
    public long power = 0L;
    public int sulfur = 0;
    public static final int maxSulfur = 100;
    public static final long maxPower = 1000L;
    public FluidTank[] tanks;
    public List<IFluidAcceptor> list1 = new ArrayList<IFluidAcceptor>();
    public List<IFluidAcceptor> list2 = new ArrayList<IFluidAcceptor>();
    public List<IFluidAcceptor> list3 = new ArrayList<IFluidAcceptor>();
    public List<IFluidAcceptor> list4 = new ArrayList<IFluidAcceptor>();
    public boolean hasExploded = false;
    public boolean onFire = false;
    public Explosion lastExplosion = null;
    private AudioWrapper audio;
    private int audioTime;
    public boolean isOn;
    private static final int[] slot_access = new int[]{11};
    List<RecipesCommon.AStack> repair = new ArrayList<RecipesCommon.AStack>();

    public TileEntityMachineRefinery() {
        super(12);
        this.tanks = new FluidTank[5];
        this.tanks[0] = new FluidTank(Fluids.HOTOIL, 64000, 0);
        this.tanks[1] = new FluidTank(Fluids.HEAVYOIL, 24000, 1);
        this.tanks[2] = new FluidTank(Fluids.NAPHTHA, 24000, 2);
        this.tanks[3] = new FluidTank(Fluids.LIGHTOIL, 24000, 3);
        this.tanks[4] = new FluidTank(Fluids.PETROLEUM, 24000, 4);
    }

    @Override
    public String getName() {
        return "container.machineRefinery";
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.tanks[0].readFromNBT(nbt, "input");
        this.tanks[1].readFromNBT(nbt, "heavy");
        this.tanks[2].readFromNBT(nbt, "naphtha");
        this.tanks[3].readFromNBT(nbt, "light");
        this.tanks[4].readFromNBT(nbt, "petroleum");
        this.sulfur = nbt.func_74762_e("sulfur");
        this.hasExploded = nbt.func_74767_n("exploded");
        this.onFire = nbt.func_74767_n("onFire");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.tanks[0].writeToNBT(nbt, "input");
        this.tanks[1].writeToNBT(nbt, "heavy");
        this.tanks[2].writeToNBT(nbt, "naphtha");
        this.tanks[3].writeToNBT(nbt, "light");
        this.tanks[4].writeToNBT(nbt, "petroleum");
        nbt.func_74768_a("sulfur", this.sulfur);
        nbt.func_74757_a("exploded", this.hasExploded);
        nbt.func_74757_a("onFire", this.onFire);
    }

    @Override
    public int[] func_94128_d(int side) {
        return slot_access;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i == 11;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.isOn = false;
            if (this.func_145832_p() < 12) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p()).getRotation(ForgeDirection.DOWN);
                this.field_145850_b.func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, ModBlocks.machine_refinery, dir.ordinal() + 10, 3);
                MultiblockHandlerXR.fillSpace(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ((BlockDummyable)ModBlocks.machine_refinery).getDimensions(), ModBlocks.machine_refinery, dir);
                NBTTagCompound data = new NBTTagCompound();
                this.func_145841_b(data);
                this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e).func_145839_a(data);
                return;
            }
            if (!this.hasExploded) {
                this.updateConnections();
                this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 1000L);
                if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                    this.fillFluidInit(this.tanks[1].getTankType());
                    this.fillFluidInit(this.tanks[2].getTankType());
                    this.fillFluidInit(this.tanks[3].getTankType());
                    this.fillFluidInit(this.tanks[4].getTankType());
                }
                this.tanks[0].loadTank(1, 2, this.slots);
                this.refine();
                this.tanks[1].unloadTank(3, 4, this.slots);
                this.tanks[2].unloadTank(5, 6, this.slots);
                this.tanks[3].unloadTank(7, 8, this.slots);
                this.tanks[4].unloadTank(9, 10, this.slots);
                for (DirPos pos : this.getConPos()) {
                    for (int i = 1; i < 5; ++i) {
                        if (this.tanks[i].getFill() <= 0) continue;
                        this.sendFluid(this.tanks[i], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                    }
                }
            } else if (this.onFire) {
                boolean hasFuel = false;
                for (int i = 0; i < 5; ++i) {
                    if (this.tanks[i].getFill() <= 0) continue;
                    this.tanks[i].setFill(Math.max(this.tanks[i].getFill() - 10, 0));
                    hasFuel = true;
                }
                if (hasFuel) {
                    List affected = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 1.5), (double)this.field_145848_d, (double)((double)this.field_145849_e - 1.5), (double)((double)this.field_145851_c + 2.5), (double)(this.field_145848_d + 8), (double)((double)this.field_145849_e + 2.5)));
                    for (Entity e : affected) {
                        e.func_70015_d(5);
                    }
                    Random rand = this.field_145850_b.field_73012_v;
                    ParticleUtil.spawnGasFlame(this.field_145850_b, (double)this.field_145851_c + rand.nextDouble(), (double)this.field_145848_d + 1.5 + rand.nextDouble() * 3.0, (double)this.field_145849_e + rand.nextDouble(), rand.nextGaussian() * 0.05, 0.1, rand.nextGaussian() * 0.05);
                    if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                        PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.SOOT, 2.8f);
                    }
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            for (int i = 0; i < 5; ++i) {
                this.tanks[i].writeToNBT(data, "" + i);
            }
            data.func_74757_a("exploded", this.hasExploded);
            data.func_74757_a("onFire", this.onFire);
            data.func_74757_a("isOn", this.isOn);
            this.networkPack(data, 150);
        } else {
            if (this.isOn) {
                this.audioTime = 20;
            }
            if (this.audioTime > 0) {
                --this.audioTime;
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.startSound();
                } else if (!this.audio.isPlaying()) {
                    this.audio = this.rebootAudio(this.audio);
                }
                this.audio.keepAlive();
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
        }
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:block.boiler", this.field_145851_c, this.field_145848_d, this.field_145849_e, 0.25f, 15.0f, 1.0f, 20);
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        for (int i = 0; i < 5; ++i) {
            this.tanks[i].readFromNBT(nbt, "" + i);
        }
        this.hasExploded = nbt.func_74767_n("exploded");
        this.onFire = nbt.func_74767_n("onFire");
        this.isOn = nbt.func_74767_n("isOn");
    }

    private void refine() {
        int i;
        Tuple.Quintet<FluidStack, FluidStack, FluidStack, FluidStack, ItemStack> refinery = RefineryRecipes.getRefinery(this.tanks[0].getTankType());
        if (refinery == null) {
            return;
        }
        FluidStack[] stacks = new FluidStack[]{refinery.getV(), refinery.getW(), refinery.getX(), refinery.getY()};
        for (i = 0; i < stacks.length; ++i) {
            this.tanks[i + 1].setTankType(stacks[i].type);
        }
        if (this.power < 5L || this.tanks[0].getFill() < 100) {
            return;
        }
        for (i = 0; i < stacks.length; ++i) {
            if (this.tanks[i + 1].getFill() + stacks[i].fill <= this.tanks[i + 1].getMaxFill()) continue;
            return;
        }
        this.isOn = true;
        this.tanks[0].setFill(this.tanks[0].getFill() - 100);
        for (i = 0; i < stacks.length; ++i) {
            this.tanks[i + 1].setFill(this.tanks[i + 1].getFill() + stacks[i].fill);
        }
        ++this.sulfur;
        if (this.sulfur >= 100) {
            this.sulfur -= 100;
            ItemStack out = refinery.getZ();
            if (out != null) {
                if (this.slots[11] == null) {
                    this.slots[11] = out.func_77946_l();
                } else if (out.func_77973_b() == this.slots[11].func_77973_b() && out.func_77960_j() == this.slots[11].func_77960_j() && this.slots[11].field_77994_a + out.field_77994_a <= this.slots[11].func_77976_d()) {
                    this.slots[11].field_77994_a += out.field_77994_a;
                }
            }
            this.func_70296_d();
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.SOOT, 0.19999999f);
        }
        this.power -= 5L;
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 1, Library.POS_X), new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 1, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 1, Library.NEG_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 1, Library.NEG_X), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z)};
    }

    public long getPowerScaled(long i) {
        return this.power * i / 1000L;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 1000L;
    }

    @Override
    public void fillFluidInit(FluidType type) {
        this.fillFluid(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 2, this.getTact(), type);
        this.fillFluid(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 2, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 2, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 2, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 1, this.getTact(), type);
        this.fillFluid(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 1, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 1, this.getTact(), type);
        this.fillFluid(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 1, this.getTact(), type);
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public boolean getTact() {
        return this.field_145850_b.func_82737_E() % 20L < 10L;
    }

    @Override
    public int getFluidFill(FluidType type) {
        for (int i = 0; i < 5; ++i) {
            if (type != this.tanks[i].getTankType()) continue;
            return this.tanks[i].getFill();
        }
        return 0;
    }

    @Override
    public void setFluidFill(int fill, FluidType type) {
        for (int i = 0; i < 5; ++i) {
            if (type != this.tanks[i].getTankType()) continue;
            this.tanks[i].setFill(fill);
        }
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidType type) {
        if (type == this.tanks[1].getTankType()) {
            return this.list1;
        }
        if (type == this.tanks[2].getTankType()) {
            return this.list2;
        }
        if (type == this.tanks[3].getTankType()) {
            return this.list3;
        }
        if (type == this.tanks[4].getTankType()) {
            return this.list4;
        }
        return new ArrayList<IFluidAcceptor>();
    }

    @Override
    public void clearFluidList(FluidType type) {
        if (type == this.tanks[1].getTankType()) {
            this.list1.clear();
        }
        if (type == this.tanks[2].getTankType()) {
            this.list2.clear();
        }
        if (type == this.tanks[3].getTankType()) {
            this.list3.clear();
        }
        if (type == this.tanks[4].getTankType()) {
            this.list4.clear();
        }
    }

    @Override
    public int getMaxFluidFill(FluidType type) {
        if (type == this.tanks[0].getTankType()) {
            return this.tanks[0].getMaxFill();
        }
        return 0;
    }

    @Override
    public void setFillForSync(int fill, int index) {
        if (index < 5 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
    }

    @Override
    public void setTypeForSync(FluidType type, int index) {
        if (index < 5 && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return Vec3.func_72443_a((double)((double)this.field_145851_c - player.field_70165_t), (double)((double)this.field_145848_d - player.field_70163_u), (double)((double)this.field_145849_e - player.field_70161_v)).func_72433_c() < 25.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("toggle")) {
            for (DirPos pos : this.getConPos()) {
                this.tryUnsubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ());
            }
            if (this.tanks[0].getTankType() == Fluids.HOTOIL) {
                this.tanks[0].setTankType(Fluids.HOTCRACKOIL);
            } else {
                this.tanks[0].setTankType(Fluids.HOTOIL);
            }
        }
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1], this.tanks[2], this.tanks[3], this.tanks[4]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN && dir != ForgeDirection.DOWN;
    }

    @Override
    public void explode(World world, int x, int y, int z) {
        if (this.hasExploded) {
            return;
        }
        this.hasExploded = true;
        this.onFire = true;
        this.markChanged();
    }

    @Override
    public void tryExtinguish(World world, int x, int y, int z, IRepairable.EnumExtinguishType type) {
        if (!this.hasExploded || !this.onFire) {
            return;
        }
        if (type == IRepairable.EnumExtinguishType.FOAM || type == IRepairable.EnumExtinguishType.CO2) {
            this.onFire = false;
            this.markChanged();
            return;
        }
        if (type == IRepairable.EnumExtinguishType.WATER) {
            for (FluidTank tank : this.tanks) {
                if (tank.getFill() <= 0) continue;
                this.field_145850_b.func_72885_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, 5.0f, true, true);
                return;
            }
        }
    }

    @Override
    public boolean isDamaged() {
        return this.hasExploded;
    }

    @Override
    public List<RecipesCommon.AStack> getRepairMaterials() {
        if (!this.repair.isEmpty()) {
            return this.repair;
        }
        this.repair.add(new RecipesCommon.OreDictStack(OreDictManager.STEEL.plate(), 8));
        this.repair.add(new RecipesCommon.ComparableStack(ModItems.ducttape, 4));
        return this.repair;
    }

    @Override
    public void repair() {
        this.hasExploded = false;
        this.markChanged();
    }

    @Override
    public void writeNBT(NBTTagCompound nbt) {
        if (this.tanks[0].getFill() == 0 && this.tanks[1].getFill() == 0 && this.tanks[2].getFill() == 0 && this.tanks[3].getFill() == 0 && this.tanks[4].getFill() == 0 && !this.hasExploded) {
            return;
        }
        NBTTagCompound data = new NBTTagCompound();
        for (int i = 0; i < 5; ++i) {
            this.tanks[i].writeToNBT(data, "" + i);
        }
        data.func_74757_a("hasExploded", this.hasExploded);
        data.func_74757_a("onFire", this.onFire);
        nbt.func_74782_a("persistent", (NBTBase)data);
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        NBTTagCompound data = nbt.func_74775_l("persistent");
        for (int i = 0; i < 5; ++i) {
            this.tanks[i].readFromNBT(data, "" + i);
        }
        this.hasExploded = data.func_74767_n("hasExploded");
        this.onFire = data.func_74767_n("onFire");
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineRefinery(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineRefinery(player.field_71071_by, this);
    }
}

