/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.container.ContainerMachineOilWell;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.gui.GUIMachineOilWell;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.machine.oil.TileEntityOilDrillBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityMachinePumpjack
extends TileEntityOilDrillBase {
    protected static int maxPower = 250000;
    protected static int consumption = 200;
    protected static int delay = 25;
    protected static int oilPerDepsoit = 750;
    protected static int gasPerDepositMin = 50;
    protected static int gasPerDepositMax = 250;
    protected static double drainChance = 0.025;
    public float rot = 0.0f;
    public float prevRot = 0.0f;
    public float speed = 0.0f;
    AxisAlignedBB bb = null;

    @Override
    public String getName() {
        return "container.pumpjack";
    }

    @Override
    public long getMaxPower() {
        return maxPower;
    }

    @Override
    public int getPowerReq() {
        return consumption;
    }

    @Override
    public int getDelay() {
        return delay;
    }

    @Override
    public void onDrill(int y) {
        int[] ids;
        Block b = this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e);
        ItemStack stack = new ItemStack(b);
        int[] nArray = ids = OreDictionary.getOreIDs((ItemStack)stack);
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            ForgeDirection dir;
            int j;
            Integer i2 = nArray[i];
            String name = OreDictionary.getOreName((int)i2);
            if ("oreUranium".equals(name)) {
                for (j = 2; j < 6; ++j) {
                    dir = ForgeDirection.getOrientation((int)j);
                    if (!this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ).isReplaceable((IBlockAccess)this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ)) continue;
                    this.field_145850_b.func_147449_b(this.field_145851_c + dir.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ, ModBlocks.gas_radon_dense);
                }
            }
            if (!"oreAsbestos".equals(name)) continue;
            for (j = 2; j < 6; ++j) {
                dir = ForgeDirection.getOrientation((int)j);
                if (!this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ).isReplaceable((IBlockAccess)this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ)) continue;
                this.field_145850_b.func_147449_b(this.field_145851_c + dir.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ, ModBlocks.gas_asbestos);
            }
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            this.prevRot = this.rot;
            if (this.indicator == 0) {
                this.rot += this.speed;
            }
            if (this.rot >= 360.0f) {
                this.prevRot -= 360.0f;
                this.rot -= 360.0f;
            }
        }
    }

    @Override
    public void sendUpdate() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74772_a("power", this.power);
        data.func_74768_a("indicator", this.indicator);
        data.func_74776_a("speed", this.indicator == 0 ? 5.0f + 2.0f * (float)this.speedLevel + ((float)this.overLevel - 1.0f) * 10.0f : 0.0f);
        this.networkPack(data, 25);
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.indicator = nbt.func_74762_e("indicator");
        this.speed = nbt.func_74760_g("speed");
    }

    @Override
    public void onSuck(int x, int y, int z) {
        this.tanks[0].setFill(this.tanks[0].getFill() + oilPerDepsoit);
        if (this.tanks[0].getFill() > this.tanks[0].getMaxFill()) {
            this.tanks[0].setFill(this.tanks[0].getMaxFill());
        }
        this.tanks[1].setFill(this.tanks[1].getFill() + (gasPerDepositMin + this.field_145850_b.field_73012_v.nextInt(gasPerDepositMax - gasPerDepositMin + 1)));
        if (this.tanks[1].getFill() > this.tanks[1].getMaxFill()) {
            this.tanks[1].setFill(this.tanks[1].getMaxFill());
        }
        if (this.field_145850_b.field_73012_v.nextDouble() < drainChance) {
            this.field_145850_b.func_147449_b(x, y, z, ModBlocks.ore_oil_empty);
        }
    }

    @Override
    public void fillFluidInit(FluidType type) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
        int pX2 = this.field_145851_c + rot.offsetX * 2;
        int pZ2 = this.field_145849_e + rot.offsetZ * 2;
        int pX4 = this.field_145851_c + rot.offsetX * 4;
        int pZ4 = this.field_145849_e + rot.offsetZ * 4;
        int oX = Math.abs(dir.offsetX) * 2;
        int oZ = Math.abs(dir.offsetZ) * 2;
        this.fillFluid(pX2 + oX, this.field_145848_d, pZ2 + oZ, this.getTact(), type);
        this.fillFluid(pX2 - oX, this.field_145848_d, pZ2 - oZ, this.getTact(), type);
        this.fillFluid(pX4 + oX, this.field_145848_d, pZ4 + oZ, this.getTact(), type);
        this.fillFluid(pX4 - oX, this.field_145848_d, pZ4 - oZ, this.getTact(), type);
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 7), (double)this.field_145848_d, (double)(this.field_145849_e - 7), (double)(this.field_145851_c + 8), (double)(this.field_145848_d + 6), (double)(this.field_145849_e + 8));
        }
        return this.bb;
    }

    @Override
    public DirPos[] getConPos() {
        this.func_145832_p();
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.field_145847_g - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
        return new DirPos[]{new DirPos(this.field_145851_c + rot.offsetX * 2 + dir.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ * 2 + dir.offsetZ * 2, dir), new DirPos(this.field_145851_c + rot.offsetX * 2 + dir.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ * 4 - dir.offsetZ * 2, dir.getOpposite()), new DirPos(this.field_145851_c + rot.offsetX * 4 - dir.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ * 4 + dir.offsetZ * 2, dir), new DirPos(this.field_145851_c + rot.offsetX * 4 - dir.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ * 2 - dir.offsetZ * 2, dir.getOpposite())};
    }

    @Override
    public String getConfigName() {
        return "pumpjack";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        maxPower = IConfigurableMachine.grab(obj, "I:powerCap", maxPower);
        consumption = IConfigurableMachine.grab(obj, "I:consumption", consumption);
        delay = IConfigurableMachine.grab(obj, "I:delay", delay);
        oilPerDepsoit = IConfigurableMachine.grab(obj, "I:oilPerDeposit", oilPerDepsoit);
        gasPerDepositMin = IConfigurableMachine.grab(obj, "I:gasPerDepositMin", gasPerDepositMin);
        gasPerDepositMax = IConfigurableMachine.grab(obj, "I:gasPerDepositMax", gasPerDepositMax);
        drainChance = IConfigurableMachine.grab(obj, "D:drainChance", drainChance);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("I:powerCap").value((long)maxPower);
        writer.name("I:consumption").value((long)consumption);
        writer.name("I:delay").value((long)delay);
        writer.name("I:oilPerDeposit").value((long)oilPerDepsoit);
        writer.name("I:gasPerDepositMin").value((long)gasPerDepositMin);
        writer.name("I:gasPerDepositMax").value((long)gasPerDepositMax);
        writer.name("D:drainChance").value(drainChance);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineOilWell(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineOilWell(player.field_71071_by, this);
    }
}

