/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import api.hbm.energy.IEnergyGenerator;
import api.hbm.fluid.IFluidStandardReceiver;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.inventory.UpgradeManager;
import com.hbm.inventory.container.ContainerMachineGasFlare;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Flammable;
import com.hbm.inventory.fluid.trait.FluidTraitSimple;
import com.hbm.inventory.gui.GUIMachineGasFlare;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.ParticleUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class TileEntityMachineGasFlare
extends TileEntityMachineBase
implements IEnergyGenerator,
IFluidContainer,
IFluidAcceptor,
IFluidStandardReceiver,
IControlReceiver,
IGUIProvider {
    public long power;
    public static final long maxPower = 100000L;
    public FluidTank tank = new FluidTank(Fluids.GAS, 64000, 0);
    public boolean isOn = false;
    public boolean doesBurn = false;

    public TileEntityMachineGasFlare() {
        super(6);
    }

    @Override
    public String getName() {
        return "container.gasFlare";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("powerTime");
        this.tank.readFromNBT(nbt, "gas");
        this.isOn = nbt.func_74767_n("isOn");
        this.doesBurn = nbt.func_74767_n("doesBurn");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("powerTime", this.power);
        this.tank.writeToNBT(nbt, "gas");
        nbt.func_74757_a("isOn", this.isOn);
        nbt.func_74757_a("doesBurn", this.doesBurn);
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000L;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return player.func_70092_e((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) <= 256.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("valve")) {
            boolean bl = this.isOn = !this.isOn;
        }
        if (data.func_74764_b("dial")) {
            this.doesBurn = !this.doesBurn;
        }
        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            for (DirPos pos : this.getConPos()) {
                this.sendPower(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                this.trySubscribe(this.tank.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            this.tank.setType(3, this.slots);
            this.tank.loadTank(1, 2, this.slots);
            this.tank.updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            int maxVent = 50;
            int maxBurn = 10;
            if (this.isOn && this.tank.getFill() > 0) {
                UpgradeManager.eval(this.slots, 4, 5);
                int burn = Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3);
                int yield = Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.EFFECT), 3);
                maxVent += maxVent * burn;
                maxBurn += maxBurn * burn;
                if (!this.doesBurn || !this.tank.getTankType().hasTrait(FT_Flammable.class)) {
                    if (this.tank.getTankType().hasTrait(FluidTraitSimple.FT_Gaseous.class) || this.tank.getTankType().hasTrait(FluidTraitSimple.FT_Gaseous_ART.class)) {
                        int eject = Math.min(maxVent, this.tank.getFill());
                        this.tank.setFill(this.tank.getFill() - eject);
                        this.tank.getTankType().onFluidRelease(this, this.tank, eject);
                        if (this.field_145850_b.func_82737_E() % 7L == 0L) {
                            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)(this.field_145848_d + 11), (double)this.field_145849_e, "random.fizz", 1.5f, 0.5f);
                        }
                    }
                } else if (this.tank.getTankType().hasTrait(FT_Flammable.class)) {
                    int eject = Math.min(maxBurn, this.tank.getFill());
                    this.tank.setFill(this.tank.getFill() - eject);
                    int penalty = 2;
                    if (!this.tank.getTankType().hasTrait(FluidTraitSimple.FT_Gaseous.class) && !this.tank.getTankType().hasTrait(FluidTraitSimple.FT_Gaseous_ART.class)) {
                        penalty = 10;
                    }
                    long powerProd = this.tank.getTankType().getTrait(FT_Flammable.class).getHeatEnergy() * (long)eject / 1000L;
                    powerProd /= (long)penalty;
                    powerProd += powerProd * (long)yield / 3L;
                    this.power += powerProd;
                    if (this.power > 100000L) {
                        this.power = 100000L;
                    }
                    ParticleUtil.spawnGasFlame(this.field_145850_b, (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 11.75f, (float)this.field_145849_e + 0.5f, this.field_145850_b.field_73012_v.nextGaussian() * 0.15, 0.2, this.field_145850_b.field_73012_v.nextGaussian() * 0.15);
                    List list = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)(this.field_145848_d + 12), (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 17), (double)(this.field_145849_e + 2)));
                    for (Entity e : list) {
                        e.func_70015_d(5);
                        e.func_70097_a(DamageSource.field_76370_b, 5.0f);
                    }
                    if (this.field_145850_b.func_82737_E() % 3L == 0L) {
                        this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)(this.field_145848_d + 11), (double)this.field_145849_e, "hbm:weapon.flamethrowerShoot", 1.5f, 0.75f);
                    }
                    if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                        PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.SOOT, 0.19999999f);
                        if (this.tank.getTankType().hasTrait(FluidTraitSimple.FT_Leaded.class)) {
                            PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.HEAVYMETAL, 0.099999994f);
                        }
                    }
                }
            }
            this.power = Library.chargeItemsFromTE(this.slots, 0, this.power, 100000L);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74757_a("isOn", this.isOn);
            data.func_74757_a("doesBurn", this.doesBurn);
            this.networkPack(data, 50);
        } else if (this.isOn && this.tank.getFill() > 0) {
            NBTTagCompound data;
            if (!(this.doesBurn && this.tank.getTankType().hasTrait(FT_Flammable.class) || !this.tank.getTankType().hasTrait(FluidTraitSimple.FT_Gaseous.class) && !this.tank.getTankType().hasTrait(FluidTraitSimple.FT_Gaseous_ART.class))) {
                data = new NBTTagCompound();
                data.func_74778_a("type", "tower");
                data.func_74776_a("lift", 1.0f);
                data.func_74776_a("base", 0.25f);
                data.func_74776_a("max", 3.0f);
                data.func_74768_a("life", 150 + this.field_145850_b.field_73012_v.nextInt(20));
                data.func_74768_a("color", this.tank.getTankType().getColor());
                data.func_74780_a("posX", (double)this.field_145851_c + 0.5);
                data.func_74780_a("posZ", (double)this.field_145849_e + 0.5);
                data.func_74780_a("posY", (double)(this.field_145848_d + 11));
                MainRegistry.proxy.effectNT(data);
            }
            if (this.doesBurn && this.tank.getTankType().hasTrait(FT_Flammable.class) && MainRegistry.proxy.me().func_70092_e((double)this.field_145851_c, (double)(this.field_145848_d + 10), (double)this.field_145849_e) <= 1024.0) {
                data = new NBTTagCompound();
                data.func_74778_a("type", "vanillaExt");
                data.func_74778_a("mode", "smoke");
                data.func_74757_a("noclip", true);
                data.func_74768_a("overrideAge", 50);
                if (this.field_145850_b.func_82737_E() % 2L == 0L) {
                    data.func_74780_a("posX", (double)this.field_145851_c + 1.5);
                    data.func_74780_a("posZ", (double)this.field_145849_e + 1.5);
                    data.func_74780_a("posY", (double)this.field_145848_d + 10.75);
                } else {
                    data.func_74780_a("posX", (double)this.field_145851_c + 1.125);
                    data.func_74780_a("posZ", (double)this.field_145849_e - 0.5);
                    data.func_74780_a("posY", (double)this.field_145848_d + 11.75);
                }
                MainRegistry.proxy.effectNT(data);
            }
        }
    }

    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z)};
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.isOn = nbt.func_74767_n("isOn");
        this.doesBurn = nbt.func_74767_n("doesBurn");
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public void setFillForSync(int fill, int index) {
        this.tank.setFill(fill);
    }

    @Override
    public void setTypeForSync(FluidType type, int index) {
        this.tank.setTankType(type);
    }

    @Override
    public int getMaxFluidFill(FluidType type) {
        return type.name().equals(this.tank.getTankType().name()) ? this.tank.getMaxFill() : 0;
    }

    @Override
    public int getFluidFill(FluidType type) {
        return type.name().equals(this.tank.getTankType().name()) ? this.tank.getFill() : 0;
    }

    @Override
    public void setFluidFill(int i, FluidType type) {
        if (type.name().equals(this.tank.getTankType().name())) {
            this.tank.setFill(i);
        }
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineGasFlare(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineGasFlare(player.field_71071_by, this);
    }
}

