/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import api.hbm.energy.IEnergyUser;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.container.ContainerMachineCatalyticReformer;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMachineCatalyticReformer;
import com.hbm.inventory.recipes.ReformingRecipes;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IPersistentNBT;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.Tuple;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineCatalyticReformer
extends TileEntityMachineBase
implements IEnergyUser,
IFluidStandardTransceiver,
IPersistentNBT,
IGUIProvider {
    public long power;
    public static final long maxPower = 1000000L;
    public FluidTank[] tanks = new FluidTank[4];
    AxisAlignedBB bb = null;

    public TileEntityMachineCatalyticReformer() {
        super(11);
        this.tanks[0] = new FluidTank(Fluids.NAPHTHA, 64000);
        this.tanks[1] = new FluidTank(Fluids.REFORMATE, 24000);
        this.tanks[2] = new FluidTank(Fluids.PETROLEUM, 24000);
        this.tanks[3] = new FluidTank(Fluids.HYDROGEN, 24000);
    }

    @Override
    public String getName() {
        return "container.catalyticReformer";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnections();
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 1000000L);
            this.tanks[0].setType(9, this.slots);
            this.tanks[0].loadTank(1, 2, this.slots);
            this.reform();
            this.tanks[1].unloadTank(3, 4, this.slots);
            this.tanks[2].unloadTank(5, 6, this.slots);
            this.tanks[3].unloadTank(7, 8, this.slots);
            for (DirPos pos : this.getConPos()) {
                for (int i = 1; i < 4; ++i) {
                    if (this.tanks[i].getFill() <= 0) continue;
                    this.sendFluid(this.tanks[i], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            for (int i = 0; i < 4; ++i) {
                this.tanks[i].writeToNBT(data, "" + i);
            }
            this.networkPack(data, 150);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        for (int i = 0; i < 4; ++i) {
            this.tanks[i].readFromNBT(nbt, "" + i);
        }
    }

    private void reform() {
        Tuple.Triplet<FluidStack, FluidStack, FluidStack> out = ReformingRecipes.getOutput(this.tanks[0].getTankType());
        if (out == null) {
            this.tanks[1].setTankType(Fluids.NONE);
            this.tanks[2].setTankType(Fluids.NONE);
            this.tanks[3].setTankType(Fluids.NONE);
            return;
        }
        this.tanks[1].setTankType(out.getX().type);
        this.tanks[2].setTankType(out.getY().type);
        this.tanks[3].setTankType(out.getZ().type);
        if (this.power < 20000L) {
            return;
        }
        if (this.tanks[0].getFill() < 100) {
            return;
        }
        if (this.slots[10] == null || this.slots[10].func_77973_b() != ModItems.catalytic_converter) {
            return;
        }
        if (this.tanks[1].getFill() + out.getX().fill > this.tanks[1].getMaxFill()) {
            return;
        }
        if (this.tanks[2].getFill() + out.getY().fill > this.tanks[2].getMaxFill()) {
            return;
        }
        if (this.tanks[3].getFill() + out.getZ().fill > this.tanks[3].getMaxFill()) {
            return;
        }
        this.tanks[0].setFill(this.tanks[0].getFill() - 100);
        this.tanks[1].setFill(this.tanks[1].getFill() + out.getX().fill);
        this.tanks[2].setFill(this.tanks[2].getFill() + out.getY().fill);
        this.tanks[3].setFill(this.tanks[3].getFill() + out.getZ().fill);
        this.power -= 20000L;
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 2 + rot.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ, dir), new DirPos(this.field_145851_c + dir.offsetX * 2 - rot.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 - rot.offsetZ, dir), new DirPos(this.field_145851_c - dir.offsetX * 2 + rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ, dir.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 2 - rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 - rot.offsetZ, dir.getOpposite()), new DirPos(this.field_145851_c + rot.offsetX * 3, this.field_145848_d, this.field_145849_e + rot.offsetZ * 3, rot), new DirPos(this.field_145851_c - rot.offsetX * 3, this.field_145848_d, this.field_145849_e - rot.offsetZ * 3, rot.getOpposite())};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.tanks[0].readFromNBT(nbt, "input");
        this.tanks[1].readFromNBT(nbt, "o1");
        this.tanks[2].readFromNBT(nbt, "o2");
        this.tanks[3].readFromNBT(nbt, "o3");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.tanks[0].writeToNBT(nbt, "input");
        this.tanks[1].writeToNBT(nbt, "o1");
        this.tanks[2].writeToNBT(nbt, "o2");
        this.tanks[3].writeToNBT(nbt, "o3");
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 7), (double)(this.field_145849_e + 3));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1], this.tanks[2], this.tanks[3]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN && dir != ForgeDirection.DOWN;
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN && dir != ForgeDirection.DOWN;
    }

    @Override
    public void writeNBT(NBTTagCompound nbt) {
        if (this.tanks[0].getFill() == 0 && this.tanks[1].getFill() == 0 && this.tanks[2].getFill() == 0 && this.tanks[3].getFill() == 0) {
            return;
        }
        NBTTagCompound data = new NBTTagCompound();
        for (int i = 0; i < 4; ++i) {
            this.tanks[i].writeToNBT(data, "" + i);
        }
        nbt.func_74782_a("persistent", (NBTBase)data);
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        NBTTagCompound data = nbt.func_74775_l("persistent");
        for (int i = 0; i < 4; ++i) {
            this.tanks[i].readFromNBT(data, "" + i);
        }
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineCatalyticReformer(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineCatalyticReformer(player.field_71071_by, this);
    }
}

