/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyGenerator;
import api.hbm.tile.IHeatSource;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.blocks.ModBlocks;
import com.hbm.entity.projectile.EntityCog;
import com.hbm.lib.Library;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityStirling
extends TileEntityLoadedBase
implements INBTPacketReceiver,
IEnergyGenerator,
IConfigurableMachine {
    public long powerBuffer;
    public int heat;
    private int warnCooldown = 0;
    private int overspeed = 0;
    public boolean hasCog = true;
    public float spin;
    public float lastSpin;
    public static double diffusion = 0.1;
    public static double efficiency = 0.5;
    public static int maxHeatNormal = 300;
    public static int maxHeatSteel = 1500;
    public static int overspeedLimit = 300;
    AxisAlignedBB bb = null;

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.hasCog) {
                this.tryPullHeat();
                this.powerBuffer = (long)((double)this.heat * (this.isCreative() ? 1.0 : efficiency));
                if (this.warnCooldown > 0) {
                    --this.warnCooldown;
                }
                if (this.heat > this.maxHeat() && !this.isCreative()) {
                    ++this.overspeed;
                    if (this.overspeed > 60 && this.warnCooldown == 0) {
                        this.warnCooldown = 100;
                        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, "hbm:block.warnOverspeed", 2.0f, 1.0f);
                    }
                    if (this.overspeed > overspeedLimit) {
                        this.hasCog = false;
                        this.field_145850_b.func_72885_a(null, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, 5.0f, false, false);
                        int orientation = this.func_145832_p() - 10;
                        ForgeDirection dir = ForgeDirection.getOrientation((int)orientation);
                        EntityCog cog = new EntityCog(this.field_145850_b, (double)this.field_145851_c + 0.5 + (double)dir.offsetX, this.field_145848_d + 1, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ).setOrientation(orientation).setMeta(this.getGeatMeta());
                        ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
                        cog.field_70159_w = rot.offsetX;
                        cog.field_70181_x = 1.0 + (double)(this.heat - this.maxHeat()) * 1.0E-4;
                        cog.field_70179_y = rot.offsetZ;
                        this.field_145850_b.func_72838_d((Entity)cog);
                        this.func_70296_d();
                    }
                } else {
                    this.overspeed = 0;
                }
            } else {
                this.overspeed = 0;
                this.warnCooldown = 0;
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.powerBuffer);
            data.func_74768_a("heat", this.heat);
            data.func_74757_a("hasCog", this.hasCog);
            INBTPacketReceiver.networkPack(this, data, 150);
            if (this.hasCog) {
                for (DirPos pos : this.getConPos()) {
                    this.sendPower(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
                this.powerBuffer = 0L;
            } else if (this.powerBuffer > 0L) {
                --this.powerBuffer;
            }
            this.heat = 0;
        } else {
            float momentum = (float)this.powerBuffer * 50.0f / (float)this.maxHeat();
            if (this.isCreative()) {
                momentum = Math.min(momentum, 45.0f);
            }
            this.lastSpin = this.spin;
            this.spin += momentum;
            if (this.spin >= 360.0f) {
                this.spin -= 360.0f;
                this.lastSpin -= 360.0f;
            }
        }
    }

    public int getGeatMeta() {
        return this.func_145838_q() == ModBlocks.machine_stirling ? 0 : (this.func_145838_q() == ModBlocks.machine_stirling_creative ? 2 : 1);
    }

    public int maxHeat() {
        return this.func_145838_q() == ModBlocks.machine_stirling ? 300 : 1500;
    }

    public boolean isCreative() {
        return this.func_145838_q() == ModBlocks.machine_stirling_creative;
    }

    protected DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z)};
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.powerBuffer = nbt.func_74763_f("power");
        this.heat = nbt.func_74762_e("heat");
        this.hasCog = nbt.func_74767_n("hasCog");
    }

    protected void tryPullHeat() {
        IHeatSource source;
        int heatSrc;
        TileEntity con = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (con instanceof IHeatSource && (heatSrc = (int)((double)(source = (IHeatSource)con).getHeatStored() * diffusion)) > 0) {
            source.useUpHeat(heatSrc);
            this.heat += heatSrc;
            return;
        }
        this.heat = Math.max(this.heat - Math.max(this.heat / 1000, 1), 0);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.powerBuffer = nbt.func_74763_f("powerBuffer");
        this.hasCog = nbt.func_74767_n("hasCog");
        this.overspeed = nbt.func_74762_e("overspeed");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("powerBuffer", this.powerBuffer);
        nbt.func_74757_a("hasCog", this.hasCog);
        nbt.func_74768_a("overspeed", this.overspeed);
    }

    @Override
    public void setPower(long power) {
        this.powerBuffer = power;
    }

    @Override
    public long getPower() {
        return this.powerBuffer;
    }

    @Override
    public long getMaxPower() {
        return this.powerBuffer;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public String getConfigName() {
        return "stirling";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        diffusion = IConfigurableMachine.grab(obj, "D:diffusion", diffusion);
        efficiency = IConfigurableMachine.grab(obj, "D:efficiency", efficiency);
        maxHeatNormal = IConfigurableMachine.grab(obj, "I:maxHeatNormal", maxHeatNormal);
        maxHeatSteel = IConfigurableMachine.grab(obj, "I:maxHeatSteel", maxHeatSteel);
        overspeedLimit = IConfigurableMachine.grab(obj, "I:overspeedLimit", overspeedLimit);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("D:diffusion").value(diffusion);
        writer.name("D:efficiency").value(efficiency);
        writer.name("I:maxHeatNormal").value((long)maxHeatNormal);
        writer.name("I:maxHeatSteel").value((long)maxHeatSteel);
        writer.name("I:overspeedLimit").value((long)overspeedLimit);
    }
}

