/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyGenerator;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidSource;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Coolable;
import com.hbm.lib.Library;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySteamEngine
extends TileEntityLoadedBase
implements IFluidAcceptor,
IFluidSource,
IEnergyGenerator,
IFluidStandardTransceiver,
INBTPacketReceiver,
IConfigurableMachine {
    public long powerBuffer;
    public float rotor;
    public float lastRotor;
    private float syncRotor;
    public List<IFluidAcceptor> list2 = new ArrayList<IFluidAcceptor>();
    public FluidTank[] tanks = new FluidTank[2];
    private int turnProgress;
    private float acceleration = 0.0f;
    private static int steamCap = 2000;
    private static int ldsCap = 20;
    private static double efficiency = 0.85;

    public TileEntitySteamEngine() {
        this.tanks[0] = new FluidTank(Fluids.STEAM, steamCap, 0);
        this.tanks[1] = new FluidTank(Fluids.SPENTSTEAM, ldsCap, 1);
    }

    @Override
    public String getConfigName() {
        return "steamengine";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        steamCap = IConfigurableMachine.grab(obj, "I:steamCap", steamCap);
        ldsCap = IConfigurableMachine.grab(obj, "I:ldsCap", ldsCap);
        efficiency = IConfigurableMachine.grab(obj, "D:efficiency", efficiency);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("I:steamCap").value((long)steamCap);
        writer.name("I:ldsCap").value((long)ldsCap);
        writer.name("D:efficiency").value(efficiency);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.powerBuffer = 0L;
            this.tanks[0].setTankType(Fluids.STEAM);
            this.tanks[1].setTankType(Fluids.SPENTSTEAM);
            NBTTagCompound data = new NBTTagCompound();
            this.tanks[0].writeToNBT(data, "s");
            FT_Coolable trait = this.tanks[0].getTankType().getTrait(FT_Coolable.class);
            double eff = trait.getEfficiency(FT_Coolable.CoolingType.TURBINE) * efficiency;
            int inputOps = this.tanks[0].getFill() / trait.amountReq;
            int outputOps = (this.tanks[1].getMaxFill() - this.tanks[1].getFill()) / trait.amountProduced;
            int ops = Math.min(inputOps, outputOps);
            this.tanks[0].setFill(this.tanks[0].getFill() - ops * trait.amountReq);
            this.tanks[1].setFill(this.tanks[1].getFill() + ops * trait.amountProduced);
            this.powerBuffer = (long)((double)this.powerBuffer + (double)(ops * trait.heatEnergy) * eff);
            this.acceleration = ops > 0 ? (this.acceleration += 0.1f) : (this.acceleration -= 0.1f);
            this.acceleration = MathHelper.func_76131_a((float)this.acceleration, (float)0.0f, (float)40.0f);
            this.rotor += this.acceleration;
            if ((double)this.rotor >= 360.0) {
                this.rotor = (float)((double)this.rotor - 360.0);
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:block.steamEngineOperate", 1.0f, 0.5f + this.acceleration / 80.0f);
            }
            data.func_74772_a("power", this.powerBuffer);
            data.func_74776_a("rotor", this.rotor);
            this.tanks[1].writeToNBT(data, "w");
            for (DirPos pos : this.getConPos()) {
                if (this.powerBuffer > 0L) {
                    this.sendPower(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
                this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                this.sendFluid(this.tanks[1], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            if (this.tanks[1].getFill() > 0) {
                this.fillFluidInit(this.tanks[1].getTankType());
            }
            INBTPacketReceiver.networkPack(this, data, 150);
        } else {
            this.lastRotor = this.rotor;
            if (this.turnProgress > 0) {
                double d = MathHelper.func_76138_g((double)((double)this.syncRotor - (double)this.rotor));
                this.rotor = (float)((double)this.rotor + d / (double)this.turnProgress);
                --this.turnProgress;
            } else {
                this.rotor = this.syncRotor;
            }
        }
    }

    protected DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + rot.offsetX * 2, this.field_145848_d + 1, this.field_145849_e + rot.offsetZ * 2, rot), new DirPos(this.field_145851_c + rot.offsetX * 2 + dir.offsetX, this.field_145848_d + 1, this.field_145849_e + rot.offsetZ * 2 + dir.offsetZ, rot), new DirPos(this.field_145851_c + rot.offsetX * 2 - dir.offsetX, this.field_145848_d + 1, this.field_145849_e + rot.offsetZ * 2 - dir.offsetZ, rot)};
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.powerBuffer = nbt.func_74763_f("powerBuffer");
        this.acceleration = nbt.func_74760_g("acceleration");
        this.tanks[0].readFromNBT(nbt, "s");
        this.tanks[1].readFromNBT(nbt, "w");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("powerBuffer", this.powerBuffer);
        nbt.func_74776_a("acceleration", this.acceleration);
        this.tanks[0].writeToNBT(nbt, "s");
        this.tanks[1].writeToNBT(nbt, "w");
    }

    @Override
    public void fillFluidInit(FluidType type) {
        for (DirPos pos : this.getConPos()) {
            this.fillFluid(pos.getX(), pos.getY(), pos.getZ(), this.getTact(), type);
        }
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public boolean getTact() {
        return this.field_145850_b.func_82737_E() % 2L == 0L;
    }

    @Override
    public void setFluidFill(int i, FluidType type) {
        if (type == this.tanks[0].getTankType()) {
            this.tanks[0].setFill(i);
        } else if (type == this.tanks[1].getTankType()) {
            this.tanks[1].setFill(i);
        }
    }

    @Override
    public int getFluidFill(FluidType type) {
        if (type == this.tanks[0].getTankType()) {
            return this.tanks[0].getFill();
        }
        if (type == this.tanks[1].getTankType()) {
            return this.tanks[1].getFill();
        }
        return 0;
    }

    @Override
    public int getMaxFluidFill(FluidType type) {
        if (type == this.tanks[0].getTankType()) {
            return this.tanks[0].getMaxFill();
        }
        return 0;
    }

    @Override
    public void setFillForSync(int fill, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
    }

    @Override
    public void setTypeForSync(FluidType type, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidType type) {
        return this.list2;
    }

    @Override
    public void clearFluidList(FluidType type) {
        this.list2.clear();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.UP && dir != ForgeDirection.DOWN && dir != ForgeDirection.UNKNOWN;
    }

    @Override
    public long getPower() {
        return this.powerBuffer;
    }

    @Override
    public long getMaxPower() {
        return this.powerBuffer;
    }

    @Override
    public void setPower(long power) {
        this.powerBuffer = power;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.powerBuffer = nbt.func_74763_f("power");
        this.syncRotor = nbt.func_74760_g("rotor");
        this.turnProgress = 3;
        this.tanks[0].readFromNBT(nbt, "s");
        this.tanks[1].readFromNBT(nbt, "w");
    }
}

