/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidSource;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.lib.Library;
import com.hbm.tileentity.TileEntityLoadedBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;

public class TileEntitySolarBoiler
extends TileEntityLoadedBase
implements IFluidAcceptor,
IFluidSource,
IFluidStandardTransceiver {
    private FluidTank water;
    private FluidTank steam;
    public List<IFluidAcceptor> list = new ArrayList<IFluidAcceptor>();
    public int heat;
    public HashSet<ChunkCoordinates> primary = new HashSet();
    public HashSet<ChunkCoordinates> secondary = new HashSet();
    AxisAlignedBB bb = null;

    public TileEntitySolarBoiler() {
        this.water = new FluidTank(Fluids.WATER, 16000, 0);
        this.steam = new FluidTank(Fluids.STEAM, 1600000, 1);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.fillFluidInit(Fluids.STEAM);
            this.trySubscribe(this.water.getTankType(), this.field_145850_b, this.field_145851_c, this.field_145848_d + 3, this.field_145849_e, Library.POS_Y);
            this.trySubscribe(this.water.getTankType(), this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, Library.NEG_Y);
            int process = this.heat / 50;
            process = Math.min(process, this.water.getFill());
            process = Math.min(process, (this.steam.getMaxFill() - this.steam.getFill()) / 100);
            if (process < 0) {
                process = 0;
            }
            this.water.setFill(this.water.getFill() - process);
            this.steam.setFill(this.steam.getFill() + process * 100);
            this.sendFluid(this.steam, this.field_145850_b, this.field_145851_c, this.field_145848_d + 3, this.field_145849_e, Library.POS_Y);
            this.sendFluid(this.steam, this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, Library.NEG_Y);
            this.heat = 0;
        } else {
            this.secondary.clear();
            this.secondary.addAll(this.primary);
            this.primary.clear();
        }
    }

    @Override
    public void setFillForSync(int fill, int index) {
        if (index == 0) {
            this.water.setFill(fill);
        }
        if (index == 1) {
            this.steam.setFill(fill);
        }
    }

    @Override
    public void setFluidFill(int fill, FluidType type) {
        if (type == Fluids.WATER) {
            this.water.setFill(fill);
        }
        if (type == Fluids.STEAM) {
            this.steam.setFill(fill);
        }
    }

    @Override
    public void setTypeForSync(FluidType type, int index) {
        if (index == 0) {
            this.water.setTankType(type);
        }
        if (index == 1) {
            this.steam.setTankType(type);
        }
    }

    @Override
    public int getFluidFill(FluidType type) {
        if (type == Fluids.WATER) {
            return this.water.getFill();
        }
        if (type == Fluids.STEAM) {
            return this.steam.getFill();
        }
        return 0;
    }

    @Override
    public void fillFluidInit(FluidType type) {
        this.fillFluid(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.getTact(), type);
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public boolean getTact() {
        return this.field_145850_b.func_82737_E() % 2L == 0L;
    }

    @Override
    public int getMaxFluidFill(FluidType type) {
        if (type == Fluids.WATER) {
            return this.water.getMaxFill();
        }
        if (type == Fluids.STEAM) {
            return this.steam.getMaxFill();
        }
        return 0;
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidType type) {
        return this.list;
    }

    @Override
    public void clearFluidList(FluidType type) {
        this.list.clear();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.water.readFromNBT(nbt, "water");
        this.steam.readFromNBT(nbt, "steam");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.water.writeToNBT(nbt, "water");
        this.steam.writeToNBT(nbt, "steam");
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.steam};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.water};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.water, this.steam};
    }
}

