/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.tile.IHeatSource;
import com.hbm.blocks.BlockDummyable;
import com.hbm.entity.projectile.EntitySawblade;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import com.hbm.lib.ModDamageSource;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityMachineAutocrafter;
import com.hbm.util.ItemStackUtil;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySawmill
extends TileEntityMachineBase {
    public int heat;
    public static final double diffusion = 0.1;
    private int warnCooldown = 0;
    private int overspeed = 0;
    public boolean hasBlade = true;
    public int progress = 0;
    public static final int processingTime = 600;
    public float spin;
    public float lastSpin;
    protected TileEntityMachineAutocrafter.InventoryCraftingAuto craftingInventory = new TileEntityMachineAutocrafter.InventoryCraftingAuto(1, 1);
    AxisAlignedBB bb = null;

    public TileEntitySawmill() {
        super(3);
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.hasBlade) {
                this.tryPullHeat();
                if (this.warnCooldown > 0) {
                    --this.warnCooldown;
                }
                if (this.heat >= 100) {
                    ItemStack result = this.getOutput(this.slots[0]);
                    if (result != null) {
                        this.progress += this.heat / 10;
                        if (this.progress >= 600) {
                            this.progress = 0;
                            this.slots[0] = null;
                            this.slots[1] = result;
                            if (result.func_77973_b() != ModItems.powder_sawdust) {
                                float chance;
                                float f = chance = result.func_77973_b() == Items.field_151055_y ? 0.1f : 0.5f;
                                if (this.field_145850_b.field_73012_v.nextFloat() < chance) {
                                    this.slots[2] = new ItemStack(ModItems.powder_sawdust);
                                }
                            }
                            this.func_70296_d();
                        }
                    } else {
                        this.progress = 0;
                    }
                    AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)-1.0, (double)0.375, (double)-1.0, (double)-0.875, (double)2.375, (double)1.0);
                    aabb = BlockDummyable.getAABBRotationOffset(aabb, (double)this.field_145851_c + 0.5, this.field_145848_d, (double)this.field_145849_e + 0.5, ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getRotation(ForgeDirection.UP));
                    for (Object o : this.field_145850_b.func_72872_a(EntityLivingBase.class, aabb)) {
                        EntityLivingBase e = (EntityLivingBase)o;
                        if (!e.func_70089_S() || !e.func_70097_a(ModDamageSource.turbofan, 100.0f)) continue;
                        this.field_145850_b.func_72908_a(e.field_70165_t, e.field_70163_u, e.field_70161_v, "mob.zombie.woodbreak", 2.0f, 0.95f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f);
                        int count = Math.min((int)Math.ceil(e.func_110138_aP() / 4.0f), 250);
                        NBTTagCompound data = new NBTTagCompound();
                        data.func_74778_a("type", "vanillaburst");
                        data.func_74768_a("count", count * 4);
                        data.func_74780_a("motion", 0.1);
                        data.func_74778_a("mode", "blockdust");
                        data.func_74768_a("block", Block.func_149682_b((Block)Blocks.field_150451_bX));
                        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, e.field_70165_t, e.field_70163_u + (double)e.field_70131_O * 0.5, e.field_70161_v), new NetworkRegistry.TargetPoint(e.field_71093_bK, e.field_70165_t, e.field_70163_u, e.field_70161_v, 50.0));
                    }
                } else {
                    this.progress = 0;
                }
                if (this.heat > 300) {
                    ++this.overspeed;
                    if (this.overspeed > 60 && this.warnCooldown == 0) {
                        this.warnCooldown = 100;
                        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, "hbm:block.warnOverspeed", 2.0f, 1.0f);
                    }
                    if (this.overspeed > 300) {
                        this.hasBlade = false;
                        this.field_145850_b.func_72885_a(null, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, 5.0f, false, false);
                        int orientation = this.func_145832_p() - 10;
                        ForgeDirection dir = ForgeDirection.getOrientation((int)orientation);
                        EntitySawblade cog = new EntitySawblade(this.field_145850_b, (double)this.field_145851_c + 0.5 + (double)dir.offsetX, this.field_145848_d + 1, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ).setOrientation(orientation);
                        ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
                        cog.field_70159_w = rot.offsetX;
                        cog.field_70181_x = 1.0 + (double)(this.heat - 100) * 1.0E-4;
                        cog.field_70179_y = rot.offsetZ;
                        this.field_145850_b.func_72838_d((Entity)cog);
                        this.func_70296_d();
                    }
                } else {
                    this.overspeed = 0;
                }
            } else {
                this.overspeed = 0;
                this.warnCooldown = 0;
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("heat", this.heat);
            data.func_74768_a("progress", this.progress);
            data.func_74757_a("hasBlade", this.hasBlade);
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < this.slots.length; ++i) {
                if (this.slots[i] == null) continue;
                NBTTagCompound nbt1 = new NBTTagCompound();
                nbt1.func_74774_a("slot", (byte)i);
                this.slots[i].func_77955_b(nbt1);
                list.func_74742_a((NBTBase)nbt1);
            }
            data.func_74782_a("items", (NBTBase)list);
            INBTPacketReceiver.networkPack(this, data, 150);
            this.heat = 0;
        } else {
            float momentum = (float)this.heat * 25.0f / 300.0f;
            this.lastSpin = this.spin;
            this.spin += momentum;
            if (this.spin >= 360.0f) {
                this.spin -= 360.0f;
                this.lastSpin -= 360.0f;
            }
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.heat = nbt.func_74762_e("heat");
        this.progress = nbt.func_74762_e("progress");
        this.hasBlade = nbt.func_74767_n("hasBlade");
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.slots = new ItemStack[3];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.hasBlade = nbt.func_74767_n("hasBlade");
        this.progress = nbt.func_74762_e("progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("hasBlade", this.hasBlade);
        nbt.func_74768_a("progress", this.progress);
    }

    protected void tryPullHeat() {
        IHeatSource source;
        int heatSrc;
        TileEntity con = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (con instanceof IHeatSource && (heatSrc = (int)((double)(source = (IHeatSource)con).getHeatStored() * 0.1)) > 0) {
            source.useUpHeat(heatSrc);
            this.heat += heatSrc;
            return;
        }
        this.heat = Math.max(this.heat - Math.max(this.heat / 1000, 1), 0);
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        return i == 0 && this.slots[0] == null && this.slots[1] == null && this.slots[2] == null && stack.field_77994_a == 1 && this.getOutput(stack) != null;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i > 0;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2};
    }

    public ItemStack getOutput(ItemStack input) {
        if (input == null) {
            return null;
        }
        this.craftingInventory.func_70299_a(0, input);
        List<String> names = ItemStackUtil.getOreDictNames(input);
        if (names.contains("stickWood")) {
            return new ItemStack(ModItems.powder_sawdust);
        }
        if (names.contains("logWood")) {
            for (Object o : CraftingManager.func_77594_a().func_77592_b()) {
                ItemStack out;
                IRecipe recipe = (IRecipe)o;
                if (!recipe.func_77569_a((InventoryCrafting)this.craftingInventory, this.field_145850_b) || (out = recipe.func_77572_b((InventoryCrafting)this.craftingInventory)) == null) continue;
                out = out.func_77946_l();
                out.field_77994_a = out.field_77994_a * 6 / 4;
                return out;
            }
        }
        if (names.contains("plankWood")) {
            return new ItemStack(Items.field_151055_y, 6);
        }
        if (names.contains("treeSapling")) {
            return new ItemStack(Items.field_151055_y, 1);
        }
        return null;
    }

    public static HashMap getRecipes() {
        HashMap<RecipesCommon.OreDictStack, ItemStack[]> recipes = new HashMap<RecipesCommon.OreDictStack, ItemStack[]>();
        recipes.put(new RecipesCommon.OreDictStack("logWood"), new ItemStack[]{new ItemStack(Blocks.field_150344_f, 6), ItemStackUtil.addTooltipToStack(new ItemStack(ModItems.powder_sawdust), EnumChatFormatting.RED + "50%")});
        recipes.put(new RecipesCommon.OreDictStack("plankWood"), new ItemStack[]{new ItemStack(Items.field_151055_y, 6), ItemStackUtil.addTooltipToStack(new ItemStack(ModItems.powder_sawdust), EnumChatFormatting.RED + "10%")});
        recipes.put(new RecipesCommon.OreDictStack("stickWood"), new ItemStack[]{new ItemStack(ModItems.powder_sawdust)});
        recipes.put(new RecipesCommon.OreDictStack("treeSapling"), new ItemStack[]{new ItemStack(Items.field_151055_y, 1), ItemStackUtil.addTooltipToStack(new ItemStack(ModItems.powder_sawdust), EnumChatFormatting.RED + "10%")});
        return recipes;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

