/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.ReactorResearch;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerReactorControl;
import com.hbm.inventory.gui.GUIReactorControl;
import com.hbm.items.ModItems;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityReactorResearch;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityReactorControl
extends TileEntityMachineBase
implements IControlReceiver,
IGUIProvider,
SimpleComponent {
    public TileEntityReactorResearch reactor;
    public boolean isLinked;
    public int flux;
    public double level;
    public int heat;
    public double levelLower;
    public double levelUpper;
    public double heatLower;
    public double heatUpper;
    public RodFunction function = RodFunction.LINEAR;

    public TileEntityReactorControl() {
        super(1);
    }

    @Override
    public String getName() {
        return "container.reactorControl";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.isLinked = nbt.func_74767_n("isLinked");
        this.levelLower = nbt.func_74769_h("levelLower");
        this.levelUpper = nbt.func_74769_h("levelUpper");
        this.heatLower = nbt.func_74769_h("heatLower");
        this.heatUpper = nbt.func_74769_h("heatUpper");
        this.function = RodFunction.values()[nbt.func_74762_e("function")];
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList list = new NBTTagList();
        nbt.func_74757_a("isLinked", this.isLinked);
        nbt.func_74780_a("levelLower", this.levelLower);
        nbt.func_74780_a("levelUpper", this.levelUpper);
        nbt.func_74780_a("heatLower", this.heatLower);
        nbt.func_74780_a("heatUpper", this.heatUpper);
        nbt.func_74768_a("function", this.function.ordinal());
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.isLinked = this.establishLink();
            if (this.isLinked) {
                double fauxLevel = 0.0;
                double lowerBound = Math.min(this.heatLower, this.heatUpper);
                double upperBound = Math.max(this.heatLower, this.heatUpper);
                fauxLevel = (double)this.heat < lowerBound ? this.levelLower : ((double)this.heat > upperBound ? this.levelUpper : this.getTargetLevel(this.function, this.heat));
                double level = MathHelper.func_151237_a((double)(fauxLevel * 0.01), (double)0.0, (double)1.0);
                if (level != this.level) {
                    this.reactor.setTarget(level);
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("heat", this.heat);
            data.func_74780_a("level", this.level);
            data.func_74768_a("flux", this.flux);
            data.func_74757_a("isLinked", this.isLinked);
            data.func_74780_a("levelLower", this.levelLower);
            data.func_74780_a("levelUpper", this.levelUpper);
            data.func_74780_a("heatLower", this.heatLower);
            data.func_74780_a("heatUpper", this.heatUpper);
            data.func_74768_a("function", this.function.ordinal());
            this.networkPack(data, 150);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.heat = data.func_74762_e("heat");
        this.level = data.func_74769_h("level");
        this.flux = data.func_74762_e("flux");
        this.isLinked = data.func_74767_n("isLinked");
        this.levelLower = data.func_74769_h("levelLower");
        this.levelUpper = data.func_74769_h("levelUpper");
        this.heatLower = data.func_74769_h("heatLower");
        this.heatUpper = data.func_74769_h("heatUpper");
        this.function = RodFunction.values()[data.func_74762_e("function")];
    }

    private boolean establishLink() {
        TileEntity tile;
        int[] pos;
        int zCoord;
        int yCoord;
        int xCoord;
        Block b;
        if (this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.reactor_sensor && this.slots[0].field_77990_d != null && (b = this.field_145850_b.func_147439_a(xCoord = this.slots[0].field_77990_d.func_74762_e("x"), yCoord = this.slots[0].field_77990_d.func_74762_e("y"), zCoord = this.slots[0].field_77990_d.func_74762_e("z"))) == ModBlocks.reactor_research && (pos = ((ReactorResearch)ModBlocks.reactor_research).findCore(this.field_145850_b, xCoord, yCoord, zCoord)) != null && (tile = this.field_145850_b.func_147438_o(pos[0], pos[1], pos[2])) instanceof TileEntityReactorResearch) {
            this.reactor = (TileEntityReactorResearch)tile;
            this.flux = this.reactor.totalFlux;
            this.level = this.reactor.level;
            this.heat = this.reactor.heat;
            return true;
        }
        return false;
    }

    public double getTargetLevel(RodFunction function, int heat) {
        double fauxLevel = 0.0;
        switch (function) {
            case LINEAR: {
                fauxLevel = ((double)heat - this.heatLower) * ((this.levelUpper - this.levelLower) / (this.heatUpper - this.heatLower)) + this.levelLower;
                return fauxLevel;
            }
            case LOG: {
                fauxLevel = Math.pow(((double)heat - this.heatUpper) / (this.heatLower - this.heatUpper), 2.0) * (this.levelLower - this.levelUpper) + this.levelUpper;
                return fauxLevel;
            }
            case QUAD: {
                fauxLevel = Math.pow(((double)heat - this.heatLower) / (this.heatUpper - this.heatLower), 2.0) * (this.levelUpper - this.levelLower) + this.levelLower;
                return fauxLevel;
            }
        }
        return 0.0;
    }

    public int[] getDisplayData() {
        if (this.isLinked) {
            int[] data = new int[]{(int)(this.level * 100.0), this.flux, (int)Math.round((double)this.heat * 2.0E-5 * 980.0 + 20.0)};
            return data;
        }
        return new int[]{0, 0, 0};
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("function")) {
            this.function = RodFunction.values()[data.func_74762_e("function")];
        } else {
            this.levelLower = data.func_74769_h("levelLower");
            this.levelUpper = data.func_74769_h("levelUpper");
            this.heatLower = data.func_74769_h("heatLower");
            this.heatUpper = data.func_74769_h("heatUpper");
        }
        this.func_70296_d();
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return Vec3.func_72443_a((double)((double)this.field_145851_c - player.field_70165_t), (double)((double)this.field_145848_d - player.field_70163_u), (double)((double)this.field_145849_e - player.field_70161_v)).func_72433_c() < 20.0;
    }

    public String getComponentName() {
        return "reactor_control";
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] isLinked(Context context, Arguments args) {
        return new Object[]{this.isLinked};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getReactor(Context context, Arguments args) {
        return new Object[]{this.getDisplayData()};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] setParams(Context context, Arguments args) {
        int newFunction = args.checkInteger(0);
        double newMaxheat = args.checkDouble(1);
        double newMinheat = args.checkDouble(2);
        double newMaxlevel = args.checkDouble(3) / 100.0;
        double newMinlevel = args.checkDouble(4) / 100.0;
        if (newFunction > 2) {
            newFunction = 0;
        } else if (newFunction < 0) {
            newFunction = 0;
        }
        if (newMaxheat < 0.0) {
            newMaxheat = 0.0;
        }
        if (newMinheat < 0.0) {
            newMinheat = 0.0;
        }
        if (newMaxlevel < 0.0) {
            newMaxlevel = 0.0;
        } else if (newMaxlevel > 1.0) {
            newMaxlevel = 1.0;
        }
        if (newMinlevel < 0.0) {
            newMinlevel = 0.0;
        } else if (newMinlevel > 1.0) {
            newMinlevel = 1.0;
        }
        this.function = RodFunction.values()[newFunction];
        this.heatUpper = newMaxheat;
        this.heatLower = newMinheat;
        this.levelUpper = newMaxlevel;
        this.levelLower = newMinlevel;
        return new Object[0];
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getParams(Context context, Arguments args) {
        return new Object[]{this.function.ordinal(), this.heatUpper, this.heatLower, this.levelUpper, this.levelLower};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerReactorControl(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIReactorControl(player.field_71071_by, this);
    }

    public static enum RodFunction {
        LINEAR,
        QUAD,
        LOG;

    }
}

