/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.blocks.ModBlocks;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerPWR;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Heatable;
import com.hbm.inventory.fluid.trait.FT_PWRModerator;
import com.hbm.inventory.gui.GUIPWR;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemPWRFuel;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.EnumUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityPWRController
extends TileEntityMachineBase
implements IGUIProvider,
IControlReceiver,
IFluidStandardTransceiver {
    public FluidTank[] tanks;
    public int coreHeat;
    public static final int coreHeatCapacity = 10000000;
    public int hullHeat;
    public static final int hullHeatCapacity = 10000000;
    public double flux;
    public int rodLevel = 100;
    public int rodTarget = 100;
    public int typeLoaded;
    public int amountLoaded;
    public double progress;
    public double processTime;
    public int rodCount;
    public int connections;
    public int connectionsControlled;
    public int heatexCount;
    public int channelCount;
    public int sourceCount;
    public boolean assembled;
    private AudioWrapper audio;
    protected List<BlockPos> ports = new ArrayList<BlockPos>();
    protected List<BlockPos> rods = new ArrayList<BlockPos>();

    public TileEntityPWRController() {
        super(3);
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(Fluids.COOLANT, 128000);
        this.tanks[1] = new FluidTank(Fluids.COOLANT_HOT, 128000);
    }

    public void setup(HashMap<BlockPos, Block> partMap, HashMap<BlockPos, Block> rodMap) {
        this.rodCount = 0;
        this.connections = 0;
        this.connectionsControlled = 0;
        this.heatexCount = 0;
        this.channelCount = 0;
        this.sourceCount = 0;
        this.ports.clear();
        this.rods.clear();
        int connectionsDouble = 0;
        int connectionsControlledDouble = 0;
        for (Map.Entry<BlockPos, Block> entry : partMap.entrySet()) {
            Block block = entry.getValue();
            if (block == ModBlocks.pwr_fuel) {
                ++this.rodCount;
            }
            if (block == ModBlocks.pwr_heatex) {
                ++this.heatexCount;
            }
            if (block == ModBlocks.pwr_channel) {
                ++this.channelCount;
            }
            if (block == ModBlocks.pwr_neutron_source) {
                ++this.sourceCount;
            }
            if (block != ModBlocks.pwr_port) continue;
            this.ports.add(entry.getKey());
        }
        for (Map.Entry<BlockPos, Block> entry : rodMap.entrySet()) {
            BlockPos fuelPos = entry.getKey();
            this.rods.add(fuelPos);
            block2: for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                BlockPos checkPos;
                Block atPos;
                boolean controlled = false;
                for (int i = 1; i < 16 && (atPos = partMap.get(checkPos = fuelPos.offset(dir, i))) != null && atPos != ModBlocks.pwr_casing; ++i) {
                    if (atPos == ModBlocks.pwr_control) {
                        controlled = true;
                    }
                    if (atPos == ModBlocks.pwr_fuel) {
                        if (controlled) {
                            ++connectionsControlledDouble;
                            continue block2;
                        }
                        ++connectionsDouble;
                        continue block2;
                    }
                    if (atPos != ModBlocks.pwr_reflector) continue;
                    if (controlled) {
                        connectionsControlledDouble += 2;
                        continue block2;
                    }
                    connectionsDouble += 2;
                    continue block2;
                }
            }
        }
        this.connections = connectionsDouble / 2;
        this.connectionsControlled = connectionsControlledDouble / 2;
    }

    @Override
    public String getName() {
        return "container.pwrController";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.tanks[0].setType(2, this.slots);
            this.setupTanks();
            if (this.assembled) {
                for (BlockPos pos : this.ports) {
                    for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                        BlockPos portPos = pos.offset(dir);
                        if (this.tanks[1].getFill() > 0) {
                            this.sendFluid(this.tanks[1], this.field_145850_b, portPos.getX(), portPos.getY(), portPos.getZ(), dir);
                        }
                        if (this.field_145850_b.func_82737_E() % 20L != 0L) continue;
                        this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, portPos.getX(), portPos.getY(), portPos.getZ(), dir);
                    }
                }
                if ((this.typeLoaded == -1 || this.amountLoaded <= 0) && this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.pwr_fuel) {
                    this.typeLoaded = this.slots[0].func_77960_j();
                    ++this.amountLoaded;
                    this.func_70298_a(0, 1);
                    this.markChanged();
                } else if (this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.pwr_fuel && this.slots[0].func_77960_j() == this.typeLoaded && this.amountLoaded < this.rodCount) {
                    ++this.amountLoaded;
                    this.func_70298_a(0, 1);
                    this.markChanged();
                }
                if (this.rodTarget > this.rodLevel) {
                    ++this.rodLevel;
                }
                if (this.rodTarget < this.rodLevel) {
                    --this.rodLevel;
                }
                int newFlux = this.sourceCount * 20;
                if (this.typeLoaded != -1 && this.amountLoaded > 0) {
                    ItemPWRFuel.EnumPWRFuel fuel = (ItemPWRFuel.EnumPWRFuel)((Object)EnumUtil.grabEnumSafely(ItemPWRFuel.EnumPWRFuel.class, this.typeLoaded));
                    double usedRods = this.getTotalProcessMultiplier();
                    double fluxPerRod = this.flux / (double)this.rodCount;
                    double outputPerRod = fuel.function.effonix(fluxPerRod);
                    double totalOutput = outputPerRod * (double)this.amountLoaded * usedRods;
                    double totalHeatOutput = totalOutput * fuel.heatEmission;
                    this.coreHeat = (int)((double)this.coreHeat + totalHeatOutput);
                    newFlux = (int)((double)newFlux + totalOutput);
                    this.processTime = (int)fuel.yield;
                    this.progress += totalOutput;
                    if (this.progress >= this.processTime) {
                        this.progress -= this.processTime;
                        if (this.slots[1] == null) {
                            this.slots[1] = new ItemStack(ModItems.pwr_fuel_hot, 1, this.typeLoaded);
                        } else if (this.slots[1].func_77973_b() == ModItems.pwr_fuel_hot && this.slots[1].func_77960_j() == this.typeLoaded && this.slots[1].field_77994_a < this.slots[1].func_77976_d()) {
                            ++this.slots[1].field_77994_a;
                        }
                        --this.amountLoaded;
                        this.markChanged();
                    }
                }
                if (this.amountLoaded <= 0) {
                    this.typeLoaded = -1;
                }
                if (this.amountLoaded > this.rodCount) {
                    this.amountLoaded = this.rodCount;
                }
                double coreCoolingApproachNum = this.getXOverE((double)this.heatexCount * 5.0 / (double)this.rodCount, 2.0) / 2.0;
                int averageCoreHeat = (this.coreHeat + this.hullHeat) / 2;
                this.coreHeat = (int)((double)this.coreHeat - (double)(this.coreHeat - averageCoreHeat) * coreCoolingApproachNum);
                this.hullHeat = (int)((double)this.hullHeat - (double)(this.hullHeat - averageCoreHeat) * coreCoolingApproachNum);
                this.updateCoolant();
                this.coreHeat = (int)((double)this.coreHeat * 0.999);
                this.hullHeat = (int)((double)this.hullHeat * 0.999);
                this.flux = newFlux;
                if (this.tanks[0].getTankType().hasTrait(FT_PWRModerator.class) && this.tanks[0].getFill() > 0) {
                    this.flux *= this.tanks[0].getTankType().getTrait(FT_PWRModerator.class).getMultiplier();
                }
                if (this.coreHeat > 10000000) {
                    this.meltDown();
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            this.tanks[0].writeToNBT(data, "t0");
            this.tanks[1].writeToNBT(data, "t1");
            data.func_74768_a("rodCount", this.rodCount);
            data.func_74768_a("coreHeat", this.coreHeat);
            data.func_74768_a("hullHeat", this.hullHeat);
            data.func_74780_a("flux", this.flux);
            data.func_74780_a("processTime", this.processTime);
            data.func_74780_a("progress", this.progress);
            data.func_74768_a("typeLoaded", this.typeLoaded);
            data.func_74768_a("amountLoaded", this.amountLoaded);
            data.func_74768_a("rodLevel", this.rodLevel);
            data.func_74768_a("rodTarget", this.rodTarget);
            this.networkPack(data, 150);
        } else if (this.amountLoaded > 0) {
            if (this.audio == null) {
                this.audio = this.createAudioLoop();
                this.audio.startSound();
            } else if (!this.audio.isPlaying()) {
                this.audio = this.rebootAudio(this.audio);
            }
            this.audio.keepAlive();
        } else if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    protected void meltDown() {
        this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (BlockPos pos : this.rods) {
            Block b = this.field_145850_b.func_147439_a(pos.getX(), pos.getY(), pos.getZ());
            b.func_149749_a(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), b, this.field_145850_b.func_72805_g(pos.getX(), pos.getY(), pos.getZ()));
            this.field_145850_b.func_147465_d(pos.getX(), pos.getY(), pos.getZ(), ModBlocks.corium_block, 5, 3);
            x += (double)pos.getX() + 0.5;
            y += (double)pos.getY() + 0.5;
            z += (double)pos.getZ() + 0.5;
        }
        this.field_145850_b.func_72885_a(null, x /= (double)this.rods.size(), y /= (double)this.rods.size(), z /= (double)this.rods.size(), 15.0f, true, true);
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:block.reactorLoop", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 10.0f, 1.0f, 20);
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    protected void updateCoolant() {
        FT_Heatable trait = this.tanks[0].getTankType().getTrait(FT_Heatable.class);
        if (trait == null || trait.getEfficiency(FT_Heatable.HeatingType.PWR) <= 0.0) {
            return;
        }
        double coolingEff = (double)this.channelCount / (double)this.rodCount * 0.1;
        if (coolingEff > 1.0) {
            coolingEff = 1.0;
        }
        int heatToUse = Math.min(this.hullHeat, (int)((double)this.hullHeat * coolingEff * trait.getEfficiency(FT_Heatable.HeatingType.PWR)));
        FT_Heatable.HeatingStep step = trait.getFirstStep();
        int coolCycles = this.tanks[0].getFill() / step.amountReq;
        int hotCycles = (this.tanks[1].getMaxFill() - this.tanks[1].getFill()) / step.amountProduced;
        int heatCycles = heatToUse / step.heatReq;
        int cycles = Math.min(coolCycles, Math.min(hotCycles, heatCycles));
        this.hullHeat -= step.heatReq * cycles;
        this.tanks[0].setFill(this.tanks[0].getFill() - step.amountReq * cycles);
        this.tanks[1].setFill(this.tanks[1].getFill() + step.amountProduced * cycles);
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.tanks[0].readFromNBT(nbt, "t0");
        this.tanks[1].readFromNBT(nbt, "t1");
        this.rodCount = nbt.func_74762_e("rodCount");
        this.coreHeat = nbt.func_74762_e("coreHeat");
        this.hullHeat = nbt.func_74762_e("hullHeat");
        this.flux = nbt.func_74769_h("flux");
        this.processTime = nbt.func_74769_h("processTime");
        this.progress = nbt.func_74769_h("progress");
        this.typeLoaded = nbt.func_74762_e("typeLoaded");
        this.amountLoaded = nbt.func_74762_e("amountLoaded");
        this.rodLevel = nbt.func_74762_e("rodLevel");
        this.rodTarget = nbt.func_74762_e("rodTarget");
    }

    protected void setupTanks() {
        FT_Heatable trait = this.tanks[0].getTankType().getTrait(FT_Heatable.class);
        if (trait == null || trait.getEfficiency(FT_Heatable.HeatingType.PWR) <= 0.0) {
            this.tanks[0].setTankType(Fluids.NONE);
            this.tanks[1].setTankType(Fluids.NONE);
            return;
        }
        this.tanks[1].setTankType(trait.getFirstStep().typeProduced);
    }

    public double getTotalProcessMultiplier() {
        double totalConnections = (double)this.connections + (double)this.connectionsControlled * (1.0 - (double)this.rodLevel / 100.0);
        double connectionsEff = this.connectinFunc(totalConnections);
        return connectionsEff;
    }

    public double connectinFunc(double connections) {
        return connections / 10.0 * (1.0 - this.getXOverE(connections, 300.0)) + connections / 150.0 * this.getXOverE(connections, 300.0);
    }

    public double getXOverE(double x, double d) {
        return 1.0 - Math.pow(Math.E, -x / d);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return stack.func_77973_b() == ModItems.pwr_fuel;
        }
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0, 1};
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return slot == 1;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "t0");
        this.tanks[1].readFromNBT(nbt, "t1");
        this.assembled = nbt.func_74767_n("assembled");
        this.coreHeat = nbt.func_74762_e("coreHeat");
        this.hullHeat = nbt.func_74762_e("hullHeat");
        this.flux = nbt.func_74769_h("flux");
        this.rodLevel = nbt.func_74762_e("rodLevel");
        this.rodTarget = nbt.func_74762_e("rodTarget");
        this.typeLoaded = nbt.func_74762_e("typeLoaded");
        this.amountLoaded = nbt.func_74762_e("amountLoaded");
        this.progress = nbt.func_74769_h("progress");
        this.processTime = nbt.func_74769_h("processTime");
        this.rodCount = nbt.func_74762_e("rodCount");
        this.connections = nbt.func_74762_e("connections");
        this.connectionsControlled = nbt.func_74762_e("connectionsControlled");
        this.heatexCount = nbt.func_74762_e("heatexCount");
        this.channelCount = nbt.func_74762_e("channelCount");
        this.sourceCount = nbt.func_74762_e("sourceCount");
        this.ports.clear();
        int portCount = nbt.func_74762_e("portCount");
        for (int i = 0; i < portCount; ++i) {
            int[] port = nbt.func_74759_k("p" + i);
            this.ports.add(new BlockPos(port[0], port[1], port[2]));
        }
        this.rods.clear();
        int rodCount = nbt.func_74762_e("rodCount");
        for (int i = 0; i < rodCount; ++i) {
            if (!nbt.func_74764_b("r" + i)) continue;
            int[] port = nbt.func_74759_k("r" + i);
            this.rods.add(new BlockPos(port[0], port[1], port[2]));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        BlockPos pos;
        int i;
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "t0");
        this.tanks[1].writeToNBT(nbt, "t1");
        nbt.func_74757_a("assembled", this.assembled);
        nbt.func_74768_a("coreHeat", this.coreHeat);
        nbt.func_74768_a("hullHeat", this.hullHeat);
        nbt.func_74780_a("flux", this.flux);
        nbt.func_74768_a("rodLevel", this.rodLevel);
        nbt.func_74768_a("rodTarget", this.rodTarget);
        nbt.func_74768_a("typeLoaded", this.typeLoaded);
        nbt.func_74768_a("amountLoaded", this.amountLoaded);
        nbt.func_74780_a("progress", this.progress);
        nbt.func_74780_a("processTime", this.processTime);
        nbt.func_74768_a("rodCount", this.rodCount);
        nbt.func_74768_a("connections", this.connections);
        nbt.func_74768_a("connectionsControlled", this.connectionsControlled);
        nbt.func_74768_a("heatexCount", this.heatexCount);
        nbt.func_74768_a("channelCount", this.channelCount);
        nbt.func_74768_a("sourceCount", this.sourceCount);
        nbt.func_74768_a("portCount", this.ports.size());
        for (i = 0; i < this.ports.size(); ++i) {
            pos = this.ports.get(i);
            nbt.func_74783_a("p" + i, new int[]{pos.getX(), pos.getY(), pos.getZ()});
        }
        nbt.func_74768_a("rodCount", this.rods.size());
        for (i = 0; i < this.rods.size(); ++i) {
            pos = this.rods.get(i);
            nbt.func_74783_a("r" + i, new int[]{pos.getX(), pos.getY(), pos.getZ()});
        }
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("control")) {
            this.rodTarget = MathHelper.func_76125_a((int)data.func_74762_e("control"), (int)0, (int)100);
            this.markChanged();
        }
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerPWR(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIPWR(player.field_71071_by, this);
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }
}

