/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyGenerator;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.MultiblockHandlerXR;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.inventory.UpgradeManager;
import com.hbm.inventory.container.ContainerMachineTurbofan;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Combustible;
import com.hbm.inventory.gui.GUIMachineTurbofan;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachinePolluting;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineTurbofan
extends TileEntityMachinePolluting
implements IEnergyGenerator,
IFluidContainer,
IFluidAcceptor,
IFluidStandardTransceiver,
IGUIProvider {
    public long power;
    public static final long maxPower = 1000000L;
    public FluidTank tank = new FluidTank(Fluids.KEROSENE, 24000);
    public FluidTank blood = new FluidTank(Fluids.BLOOD, 24000);
    public int afterburner;
    public boolean wasOn;
    public boolean showBlood = false;
    public float spin;
    public float lastSpin;
    public int momentum = 0;
    private AudioWrapper audio;

    public TileEntityMachineTurbofan() {
        super(5, 150);
    }

    @Override
    public String getName() {
        return "container.machineTurbofan";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("powerTime");
        this.tank.readFromNBT(nbt, "fuel");
        this.blood.readFromNBT(nbt, "blood");
        this.showBlood = nbt.func_74767_n("showBlood");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("powerTime", this.power);
        this.tank.writeToNBT(nbt, "fuel");
        this.blood.writeToNBT(nbt, "blood");
        nbt.func_74757_a("showBlood", this.showBlood);
    }

    public long getPowerScaled(long i) {
        return this.power * i / 1000000L;
    }

    protected DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getRotation(ForgeDirection.UP);
        ForgeDirection rot = dir.getRotation(ForgeDirection.DOWN);
        return new DirPos[]{new DirPos(this.field_145851_c + rot.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ * 2, rot), new DirPos(this.field_145851_c + rot.offsetX * 2 - dir.offsetX, this.field_145848_d, this.field_145849_e + rot.offsetZ * 2 - dir.offsetZ, rot), new DirPos(this.field_145851_c - rot.offsetX * 2, this.field_145848_d, this.field_145849_e - rot.offsetZ * 2, rot.getOpposite()), new DirPos(this.field_145851_c - rot.offsetX * 2 - dir.offsetX, this.field_145848_d, this.field_145849_e - rot.offsetZ * 2 - dir.offsetZ, rot.getOpposite())};
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int amountToBurn;
            if (this.func_145832_p() < 12) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p());
                this.field_145850_b.func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, ModBlocks.machine_turbofan, dir.ordinal() + 10, 3);
                MultiblockHandlerXR.fillSpace(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ((BlockDummyable)ModBlocks.machine_turbofan).getDimensions(), ModBlocks.machine_turbofan, dir);
                ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
                ((BlockDummyable)ModBlocks.machine_turbofan).makeExtra(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ);
                ((BlockDummyable)ModBlocks.machine_turbofan).makeExtra(this.field_145850_b, this.field_145851_c + dir.offsetX - rot.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ - rot.offsetZ);
                ((BlockDummyable)ModBlocks.machine_turbofan).makeExtra(this.field_145850_b, this.field_145851_c - dir.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ);
                ((BlockDummyable)ModBlocks.machine_turbofan).makeExtra(this.field_145850_b, this.field_145851_c - dir.offsetX - rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ - rot.offsetZ);
                NBTTagCompound data = new NBTTagCompound();
                this.func_145841_b(data);
                this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e).func_145839_a(data);
                return;
            }
            this.tank.setType(4, this.slots);
            this.tank.loadTank(0, 1, this.slots);
            this.blood.setTankType(Fluids.BLOOD);
            this.wasOn = false;
            UpgradeManager.eval(this.slots, 2, 2);
            this.afterburner = UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.AFTERBURN);
            if (this.slots[2] != null && this.slots[2].func_77973_b() == ModItems.flame_pony) {
                this.afterburner = 100;
            }
            long burnValue = 0L;
            int amount = 1 + this.afterburner;
            if (this.tank.getTankType().hasTrait(FT_Combustible.class) && this.tank.getTankType().getTrait(FT_Combustible.class).getGrade() == FT_Combustible.FuelGrade.AERO) {
                burnValue = this.tank.getTankType().getTrait(FT_Combustible.class).getCombustionEnergy() / 1000L;
            }
            if ((amountToBurn = Math.min(amount, this.tank.getFill())) > 0) {
                this.wasOn = true;
                this.tank.setFill(this.tank.getFill() - amountToBurn);
                this.power += burnValue * (long)amountToBurn;
                if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                    PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.SOOT, 0.04f * (float)amountToBurn);
                }
            }
            this.power = Library.chargeItemsFromTE(this.slots, 3, this.power, this.power);
            for (DirPos pos : this.getConPos()) {
                this.sendPower(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                this.trySubscribe(this.tank.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                if (this.blood.getFill() > 0) {
                    this.sendFluid(this.blood, this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
                this.sendSmoke(pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            if (burnValue > 0L && amountToBurn > 0) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getRotation(ForgeDirection.UP);
                ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
                if (this.afterburner > 0) {
                    for (int i = 0; i < 2; ++i) {
                        double speed = 2.0 + this.field_145850_b.field_73012_v.nextDouble() * 3.0;
                        double deviation = this.field_145850_b.field_73012_v.nextGaussian() * 0.2;
                        NBTTagCompound data = new NBTTagCompound();
                        data.func_74778_a("type", "gasfire");
                        data.func_74780_a("mX", (double)(-dir.offsetX) * speed + deviation);
                        data.func_74780_a("mZ", (double)(-dir.offsetZ) * speed + deviation);
                        data.func_74776_a("scale", 8.0f);
                        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, (float)this.field_145851_c + 0.5f - (float)(dir.offsetX * (3 - i)), (float)this.field_145848_d + 1.5f, (float)this.field_145849_e + 0.5f - (float)(dir.offsetZ * (3 - i))), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 150.0));
                    }
                    if (this.afterburner > 90 && this.field_145850_b.field_73012_v.nextInt(30) == 0) {
                        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, "hbm:block.damage", 3.0f, 0.95f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f);
                    }
                    if (this.afterburner > 90) {
                        NBTTagCompound data = new NBTTagCompound();
                        data.func_74778_a("type", "gasfire");
                        data.func_74780_a("mY", 0.1 * this.field_145850_b.field_73012_v.nextDouble());
                        data.func_74776_a("scale", 4.0f);
                        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, (double)((float)this.field_145851_c + 0.5f) + (double)dir.offsetX * (this.field_145850_b.field_73012_v.nextDouble() * 4.0 - 2.0) + (double)rot.offsetX * (this.field_145850_b.field_73012_v.nextDouble() * 2.0 - 1.0), (double)((float)this.field_145848_d + 1.0f) + this.field_145850_b.field_73012_v.nextDouble() * 2.0, (double)((float)this.field_145849_e + 0.5f) - (double)dir.offsetZ * (this.field_145850_b.field_73012_v.nextDouble() * 4.0 - 2.0) + (double)rot.offsetZ * (this.field_145850_b.field_73012_v.nextDouble() * 2.0 - 1.0)), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 150.0));
                    }
                }
                double minX = (double)this.field_145851_c + 0.5 - (double)dir.offsetX * 3.5 - (double)rot.offsetX * 1.5;
                double maxX = (double)this.field_145851_c + 0.5 - (double)dir.offsetX * 19.5 + (double)rot.offsetX * 1.5;
                double minZ = (double)this.field_145849_e + 0.5 - (double)dir.offsetZ * 3.5 - (double)rot.offsetZ * 1.5;
                double maxZ = (double)this.field_145849_e + 0.5 - (double)dir.offsetZ * 19.5 + (double)rot.offsetZ * 1.5;
                List list = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)Math.min(minX, maxX), (double)this.field_145848_d, (double)Math.min(minZ, maxZ), (double)Math.max(minX, maxX), (double)(this.field_145848_d + 3), (double)Math.max(minZ, maxZ)));
                for (Entity e : list) {
                    if (this.afterburner > 0) {
                        e.func_70015_d(5);
                        e.func_70097_a(DamageSource.field_76370_b, 5.0f);
                    }
                    e.field_70159_w -= (double)dir.offsetX * 0.2;
                    e.field_70179_y -= (double)dir.offsetZ * 0.2;
                }
                minX = (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 3.5 - (double)rot.offsetX * 1.5;
                maxX = (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 8.5 + (double)rot.offsetX * 1.5;
                minZ = (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 3.5 - (double)rot.offsetZ * 1.5;
                maxZ = (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 8.5 + (double)rot.offsetZ * 1.5;
                list = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)Math.min(minX, maxX), (double)this.field_145848_d, (double)Math.min(minZ, maxZ), (double)Math.max(minX, maxX), (double)(this.field_145848_d + 3), (double)Math.max(minZ, maxZ)));
                for (Entity e : list) {
                    e.field_70159_w -= (double)dir.offsetX * 0.2;
                    e.field_70179_y -= (double)dir.offsetZ * 0.2;
                }
                minX = (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 3.5 - (double)rot.offsetX * 1.5;
                maxX = (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 3.75 + (double)rot.offsetX * 1.5;
                minZ = (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 3.5 - (double)rot.offsetZ * 1.5;
                maxZ = (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 3.75 + (double)rot.offsetZ * 1.5;
                list = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)Math.min(minX, maxX), (double)this.field_145848_d, (double)Math.min(minZ, maxZ), (double)Math.max(minX, maxX), (double)(this.field_145848_d + 3), (double)Math.max(minZ, maxZ)));
                for (Entity e : list) {
                    e.func_70097_a(ModDamageSource.turbofan, 1000.0f);
                    e.func_70110_aj();
                    if (e.func_70089_S() || !(e instanceof EntityLivingBase)) continue;
                    NBTTagCompound vdat = new NBTTagCompound();
                    vdat.func_74778_a("type", "giblets");
                    vdat.func_74768_a("ent", e.func_145782_y());
                    vdat.func_74768_a("cDiv", 5);
                    PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(vdat, e.field_70165_t, e.field_70163_u + (double)e.field_70131_O * 0.5, e.field_70161_v), new NetworkRegistry.TargetPoint(e.field_71093_bK, e.field_70165_t, e.field_70163_u + (double)e.field_70131_O * 0.5, e.field_70161_v, 150.0));
                    this.field_145850_b.func_72908_a(e.field_70165_t, e.field_70163_u, e.field_70161_v, "mob.zombie.woodbreak", 2.0f, 0.95f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f);
                    this.blood.setFill(this.blood.getFill() + 50);
                    if (this.blood.getFill() > this.blood.getMaxFill()) {
                        this.blood.setFill(this.blood.getMaxFill());
                    }
                    this.showBlood = true;
                }
            }
            if (this.power > 1000000L) {
                this.power = 1000000L;
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74774_a("after", (byte)this.afterburner);
            data.func_74757_a("wasOn", this.wasOn);
            data.func_74757_a("showBlood", this.showBlood);
            this.tank.writeToNBT(data, "tank");
            this.blood.writeToNBT(data, "blood");
            this.networkPack(data, 150);
        } else {
            this.lastSpin = this.spin;
            if (this.wasOn) {
                if ((float)this.momentum < 100.0f) {
                    ++this.momentum;
                }
            } else if (this.momentum > 0) {
                --this.momentum;
            }
            this.spin += (float)(this.momentum / 2);
            if (this.spin >= 360.0f) {
                this.spin -= 360.0f;
                this.lastSpin -= 360.0f;
            }
            if (this.momentum > 0) {
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.startSound();
                } else if (!this.audio.isPlaying()) {
                    this.audio = this.rebootAudio(this.audio);
                }
                this.audio.keepAlive();
                this.audio.updateVolume(this.momentum);
                this.audio.updatePitch((float)this.momentum / 200.0f + 0.5f + (float)this.afterburner * 0.16f);
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
            if (this.tank.getFill() > 0 && !MainRegistry.proxy.me().field_71075_bZ.field_75098_d) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getRotation(ForgeDirection.UP);
                ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
                double minX = (double)this.field_145851_c + 0.5 - (double)dir.offsetX * 3.5 - (double)rot.offsetX * 1.5;
                double maxX = (double)this.field_145851_c + 0.5 - (double)dir.offsetX * 19.5 + (double)rot.offsetX * 1.5;
                double minZ = (double)this.field_145849_e + 0.5 - (double)dir.offsetZ * 3.5 - (double)rot.offsetZ * 1.5;
                double maxZ = (double)this.field_145849_e + 0.5 - (double)dir.offsetZ * 19.5 + (double)rot.offsetZ * 1.5;
                List list = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)Math.min(minX, maxX), (double)this.field_145848_d, (double)Math.min(minZ, maxZ), (double)Math.max(minX, maxX), (double)(this.field_145848_d + 3), (double)Math.max(minZ, maxZ)));
                for (Entity e : list) {
                    if (e != MainRegistry.proxy.me()) continue;
                    e.field_70159_w -= (double)dir.offsetX * 0.2;
                    e.field_70179_y -= (double)dir.offsetZ * 0.2;
                }
                minX = (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 3.5 - (double)rot.offsetX * 1.5;
                maxX = (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 8.5 + (double)rot.offsetX * 1.5;
                minZ = (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 3.5 - (double)rot.offsetZ * 1.5;
                maxZ = (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 8.5 + (double)rot.offsetZ * 1.5;
                list = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)Math.min(minX, maxX), (double)this.field_145848_d, (double)Math.min(minZ, maxZ), (double)Math.max(minX, maxX), (double)(this.field_145848_d + 3), (double)Math.max(minZ, maxZ)));
                for (Entity e : list) {
                    if (e != MainRegistry.proxy.me()) continue;
                    e.field_70159_w -= (double)dir.offsetX * 0.2;
                    e.field_70179_y -= (double)dir.offsetZ * 0.2;
                }
                minX = (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 3.5 - (double)rot.offsetX * 1.5;
                maxX = (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 3.75 + (double)rot.offsetX * 1.5;
                minZ = (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 3.5 - (double)rot.offsetZ * 1.5;
                maxZ = (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 3.75 + (double)rot.offsetZ * 1.5;
                list = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)Math.min(minX, maxX), (double)this.field_145848_d, (double)Math.min(minZ, maxZ), (double)Math.max(minX, maxX), (double)(this.field_145848_d + 3), (double)Math.max(minZ, maxZ)));
                for (Entity e : list) {
                    if (e != MainRegistry.proxy.me()) continue;
                    e.func_70110_aj();
                }
            }
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.afterburner = nbt.func_74771_c("after");
        this.wasOn = nbt.func_74767_n("wasOn");
        this.showBlood = nbt.func_74767_n("showBlood");
        this.tank.readFromNBT(nbt, "tank");
        this.blood.readFromNBT(nbt, "blood");
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:block.turbofanOperate", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 50.0f, 1.0f, 20);
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public void setFillForSync(int fill, int index) {
        this.tank.setFill(fill);
    }

    @Override
    public void setTypeForSync(FluidType type, int index) {
        this.tank.setTankType(type);
    }

    @Override
    public int getMaxFluidFill(FluidType type) {
        return type == this.tank.getTankType() ? this.tank.getMaxFill() : 0;
    }

    @Override
    public int getFluidFill(FluidType type) {
        return type == this.tank.getTankType() ? this.tank.getFill() : 0;
    }

    @Override
    public void setFluidFill(int i, FluidType type) {
        if (type == this.tank.getTankType()) {
            this.tank.setFill(i);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.blood};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank, this.blood, this.smoke, this.smoke_leaded, this.smoke_poison};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineTurbofan(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineTurbofan(player.field_71071_by, this);
    }
}

