/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyGenerator;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerMachineTurbineGas;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Combustible;
import com.hbm.inventory.gui.GUIMachineTurbineGas;
import com.hbm.items.machine.IItemFluidIdentifier;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachinePolluting;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineTurbineGas
extends TileEntityMachinePolluting
implements IFluidStandardTransceiver,
IEnergyGenerator,
IControlReceiver,
IGUIProvider {
    public long power;
    public static final long maxPower = 1000000L;
    public int rpm;
    public int temp;
    public int rpmIdle = 10;
    public int tempIdle = 300;
    public int powerSliderPos;
    public int throttle;
    public boolean autoMode;
    public int state = 0;
    public int counter = 0;
    public int instantPowerOutput;
    public FluidTank[] tanks = new FluidTank[4];
    private AudioWrapper audio;
    public static HashMap<FluidType, Double> fuelMaxCons = new HashMap();
    int rpmLast;
    int tempLast;
    double fuelToConsume;
    double waterToBoil;
    double waterPerTick = 0.0;
    AxisAlignedBB bb = null;

    public TileEntityMachineTurbineGas() {
        super(2, 200);
        this.tanks[0] = new FluidTank(Fluids.GAS, 100000);
        this.tanks[1] = new FluidTank(Fluids.LUBRICANT, 16000);
        this.tanks[2] = new FluidTank(Fluids.WATER, 16000);
        this.tanks[3] = new FluidTank(Fluids.HOTSTEAM, 160000);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            FluidType fluid;
            this.throttle = this.powerSliderPos * 100 / 60;
            if (this.slots[1] != null && this.slots[1].func_77973_b() instanceof IItemFluidIdentifier && (fluid = ((IItemFluidIdentifier)this.slots[1].func_77973_b()).getType(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.slots[1])).hasTrait(FT_Combustible.class) && fluid.getTrait(FT_Combustible.class).getGrade() == FT_Combustible.FuelGrade.GAS) {
                this.tanks[0].setTankType(fluid);
            }
            switch (this.state) {
                case 0: {
                    this.shutdown();
                    break;
                }
                case -1: {
                    this.stopIfNotReady();
                    this.startup();
                    break;
                }
                case 1: {
                    this.stopIfNotReady();
                    this.run();
                    break;
                }
            }
            if (this.autoMode) {
                int powerSliderTarget = 60 - (int)(60L * this.power / 1000000L);
                if (powerSliderTarget > this.powerSliderPos) {
                    ++this.powerSliderPos;
                } else if (powerSliderTarget < this.powerSliderPos) {
                    --this.powerSliderPos;
                }
            }
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
            ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", Math.min(this.power, 1000000L));
            this.power = Library.chargeItemsFromTE(this.slots, 0, this.power, 1000000L);
            this.sendPower(this.field_145850_b, this.field_145851_c - dir.offsetZ * 5, this.field_145848_d + 1, this.field_145849_e + dir.offsetX * 5, rot);
            if (this.power > 1000000L) {
                this.power = 1000000L;
            }
            for (int i = 0; i < 2; ++i) {
                this.trySubscribe(this.tanks[i].getTankType(), this.field_145850_b, this.field_145851_c - dir.offsetX * 2 + rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ, dir.getOpposite());
                this.trySubscribe(this.tanks[i].getTankType(), this.field_145850_b, this.field_145851_c + dir.offsetX * 2 + rot.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ, dir);
                this.sendSmoke(this.field_145851_c - dir.offsetX * 2 + rot.offsetX, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ, dir.getOpposite());
                this.sendSmoke(this.field_145851_c + dir.offsetX * 2 + rot.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ, dir);
            }
            this.trySubscribe(this.tanks[2].getTankType(), this.field_145850_b, this.field_145851_c - dir.offsetX * 2 + rot.offsetX * -4, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ * -4, dir.getOpposite());
            this.trySubscribe(this.tanks[2].getTankType(), this.field_145850_b, this.field_145851_c + dir.offsetX * 2 + rot.offsetX * -4, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ * -4, dir);
            this.sendFluid(this.tanks[3], this.field_145850_b, this.field_145851_c + dir.offsetZ * 6, this.field_145848_d + 1, this.field_145849_e - dir.offsetX * 6, rot.getOpposite());
            data.func_74768_a("rpm", this.rpm);
            data.func_74768_a("temp", this.temp);
            data.func_74768_a("state", this.state);
            data.func_74757_a("automode", this.autoMode);
            data.func_74768_a("throttle", this.throttle);
            data.func_74768_a("slidpos", this.powerSliderPos);
            if (this.state != 1) {
                data.func_74768_a("counter", this.counter);
            } else {
                data.func_74768_a("instantPow", this.instantPowerOutput);
            }
            this.tanks[0].writeToNBT(data, "fuel");
            this.tanks[1].writeToNBT(data, "lube");
            this.tanks[2].writeToNBT(data, "water");
            this.tanks[3].writeToNBT(data, "steam");
            this.networkPack(data, 150);
        } else if (this.rpm >= 10 && this.state != -1) {
            if (this.audio == null) {
                this.audio = MainRegistry.proxy.getLoopedSound("hbm:block.turbinegasRunning", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 20.0f, 1.0f);
                this.audio.startSound();
            } else if (!this.audio.isPlaying()) {
                this.audio.stopSound();
                this.audio = MainRegistry.proxy.getLoopedSound("hbm:block.turbinegasRunning", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 20.0f, 1.0f);
                this.audio.startSound();
            }
            this.audio.updatePitch((float)(0.55 + 0.1 * (double)this.rpm / 10.0));
            this.audio.updateVolume(100.0f);
        } else if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    private void stopIfNotReady() {
        if (this.tanks[0].getFill() == 0 || this.tanks[1].getFill() == 0) {
            this.state = 0;
        }
        if (!this.hasAcceptableFuel()) {
            this.state = 0;
        }
    }

    public boolean hasAcceptableFuel() {
        if (this.tanks[0].getTankType().hasTrait(FT_Combustible.class)) {
            return this.tanks[0].getTankType().getTrait(FT_Combustible.class).getGrade() == FT_Combustible.FuelGrade.GAS;
        }
        return false;
    }

    private void startup() {
        ++this.counter;
        if (this.counter <= 20) {
            this.rpm = 5 * this.counter;
        } else if (this.counter > 20 && this.counter <= 40) {
            this.rpm = 100 - 5 * (this.counter - 20);
        } else if (this.counter > 50) {
            this.rpm = this.rpmIdle * (this.counter - 50) / 530;
            this.temp = this.tempIdle * (this.counter - 50) / 530;
        }
        if (this.counter == 50) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)(this.field_145848_d + 2), (double)this.field_145849_e, "hbm:block.turbinegasStartup", 1.0f, 1.0f);
        }
        if (this.counter == 580) {
            this.state = 1;
        }
    }

    private void shutdown() {
        this.autoMode = false;
        this.instantPowerOutput = 0;
        if (this.powerSliderPos > 0) {
            --this.powerSliderPos;
        }
        if (this.rpm <= 10 && this.counter > 0) {
            if (this.counter == 225) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)(this.field_145848_d + 2), (double)this.field_145849_e, "hbm:block.turbinegasShutdown", 1.0f, 1.0f);
                this.rpmLast = this.rpm;
                this.tempLast = this.temp;
            }
            --this.counter;
            this.rpm = this.rpmLast * this.counter / 225;
            this.temp = this.tempLast * this.counter / 225;
        } else if (this.rpm > 11) {
            this.counter = 42069;
            --this.rpm;
        } else if (this.rpm == 11) {
            this.counter = 225;
            --this.rpm;
        }
    }

    protected int getFluidBurnTemp(FluidType type) {
        double dFuel = type.hasTrait(FT_Combustible.class) ? (double)type.getTrait(FT_Combustible.class).getCombustionEnergy() : 0.0;
        return (int)Math.floor(800.0 - Math.pow(Math.E, -dFuel / 100000.0) * 300.0);
    }

    private void run() {
        double consumption;
        int maxTemp;
        if ((int)((double)this.throttle * 0.9) > this.rpm - this.rpmIdle) {
            if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                ++this.rpm;
            }
        } else if ((int)((double)this.throttle * 0.9) < this.rpm - this.rpmIdle && this.field_145850_b.func_82737_E() % 2L == 0L) {
            --this.rpm;
        }
        if (this.throttle * 5 * ((maxTemp = this.getFluidBurnTemp(this.tanks[0].getTankType())) - this.tempIdle) / 500 > this.temp - this.tempIdle) {
            if (this.field_145850_b.func_82737_E() % 2L == 0L) {
                ++this.temp;
            }
        } else if (this.throttle * 5 * (maxTemp - this.tempIdle) / 500 < this.temp - this.tempIdle && this.field_145850_b.func_82737_E() % 2L == 0L) {
            --this.temp;
        }
        double d = consumption = fuelMaxCons.containsKey(this.tanks[0].getTankType()) ? fuelMaxCons.get(this.tanks[0].getTankType()) : 5.0;
        if (this.field_145850_b.func_82737_E() % 20L == 0L && this.tanks[0].getTankType() != Fluids.OXYHYDROGEN) {
            this.pollute(PollutionHandler.PollutionType.SOOT, 0.04f * (float)consumption * 0.25f);
        }
        this.makePower(consumption, this.throttle);
    }

    private void makePower(double consMax, int throttle) {
        int rpmEff;
        double idleConsumption = consMax * 0.05;
        double consumption = idleConsumption + consMax * (double)throttle / 100.0;
        this.fuelToConsume += consumption;
        this.tanks[0].setFill(this.tanks[0].getFill() - (int)Math.floor(this.fuelToConsume));
        this.fuelToConsume -= (double)((int)Math.floor(this.fuelToConsume));
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            this.tanks[1].setFill(this.tanks[1].getFill() - 1);
        }
        if (this.tanks[0].getFill() < 0) {
            this.tanks[0].setFill(0);
            this.state = 0;
        }
        if (this.tanks[1].getFill() < 0) {
            this.tanks[1].setFill(0);
            this.state = 0;
        }
        long energy = 0L;
        if (this.tanks[0].getTankType().hasTrait(FT_Combustible.class)) {
            energy = this.tanks[0].getTankType().getTrait(FT_Combustible.class).getCombustionEnergy() / 1000L;
        }
        if ((double)this.instantPowerOutput < consMax * (double)energy * (double)(rpmEff = this.rpm - this.rpmIdle) / 90.0) {
            this.instantPowerOutput = (int)((double)this.instantPowerOutput + Math.random() * 0.005 * consMax * (double)energy);
            if ((double)this.instantPowerOutput > consMax * (double)energy * (double)rpmEff / 90.0) {
                this.instantPowerOutput = (int)(consMax * (double)energy * (double)rpmEff / 90.0);
            }
        } else if ((double)this.instantPowerOutput > consMax * (double)energy * (double)rpmEff / 90.0) {
            this.instantPowerOutput = (int)((double)this.instantPowerOutput - Math.random() * 0.011 * consMax * (double)energy);
            if ((double)this.instantPowerOutput < consMax * (double)energy * (double)rpmEff / 90.0) {
                this.instantPowerOutput = (int)(consMax * (double)energy * (double)rpmEff / 90.0);
            }
        }
        this.power += (long)this.instantPowerOutput;
        this.waterPerTick = consMax * (double)energy * (double)(this.temp - this.tempIdle) / 220000.0;
        if ((double)this.tanks[2].getFill() >= Math.ceil(this.waterPerTick)) {
            this.waterToBoil += this.waterPerTick;
            if ((double)this.tanks[3].getFill() <= 160000.0 - this.waterToBoil * 10.0) {
                this.tanks[2].setFill(this.tanks[2].getFill() - (int)Math.floor(this.waterToBoil));
                this.tanks[3].setFill(this.tanks[3].getFill() + 10 * (int)Math.floor(this.waterToBoil));
                this.waterToBoil -= (double)((int)Math.floor(this.waterToBoil));
            }
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.rpm = nbt.func_74762_e("rpm");
        this.temp = nbt.func_74762_e("temp");
        this.state = nbt.func_74762_e("state");
        this.autoMode = nbt.func_74767_n("automode");
        this.powerSliderPos = nbt.func_74762_e("slidpos");
        this.throttle = nbt.func_74762_e("throttle");
        if (nbt.func_74764_b("counter")) {
            this.counter = nbt.func_74762_e("counter");
        } else {
            this.instantPowerOutput = nbt.func_74762_e("instantPow");
        }
        this.tanks[0].readFromNBT(nbt, "fuel");
        this.tanks[1].readFromNBT(nbt, "lube");
        this.tanks[2].readFromNBT(nbt, "water");
        this.tanks[3].readFromNBT(nbt, "steam");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "gas");
        this.tanks[1].readFromNBT(nbt, "lube");
        this.tanks[2].readFromNBT(nbt, "water");
        this.tanks[3].readFromNBT(nbt, "densesteam");
        this.autoMode = nbt.func_74767_n("automode");
        this.power = nbt.func_74763_f("power");
        this.state = nbt.func_74762_e("state");
        this.rpm = nbt.func_74762_e("rpm");
        this.temp = nbt.func_74762_e("temperature");
        this.powerSliderPos = nbt.func_74762_e("slidPos");
        this.instantPowerOutput = nbt.func_74762_e("instPwr");
        this.counter = nbt.func_74762_e("counter");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "gas");
        this.tanks[1].writeToNBT(nbt, "lube");
        this.tanks[2].writeToNBT(nbt, "water");
        this.tanks[3].writeToNBT(nbt, "densesteam");
        nbt.func_74757_a("automode", this.autoMode);
        nbt.func_74772_a("power", this.power);
        if (this.state == 1) {
            nbt.func_74768_a("state", this.state);
            nbt.func_74768_a("rpm", this.rpm);
            nbt.func_74768_a("temperature", this.temp);
            nbt.func_74768_a("slidPos", this.powerSliderPos);
            nbt.func_74768_a("instPwr", this.instantPowerOutput);
            nbt.func_74768_a("counter", 225);
        } else {
            nbt.func_74768_a("state", 0);
            nbt.func_74768_a("rpm", 0);
            nbt.func_74768_a("temperature", 20);
            nbt.func_74768_a("slidPos", 0);
            nbt.func_74768_a("instpwr", 0);
            nbt.func_74768_a("counter", 0);
        }
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("slidPos")) {
            this.powerSliderPos = data.func_74762_e("slidPos");
        }
        if (data.func_74764_b("autoMode")) {
            this.autoMode = data.func_74767_n("autoMode");
        }
        if (data.func_74764_b("state")) {
            this.state = data.func_74762_e("state");
        }
        this.func_70296_d();
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return Vec3.func_72443_a((double)((double)this.field_145851_c - player.field_70165_t), (double)((double)this.field_145848_d - player.field_70163_u), (double)((double)this.field_145849_e - player.field_70161_v)).func_72433_c() < 25.0;
    }

    @Override
    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 5), (double)this.field_145848_d, (double)(this.field_145849_e - 5), (double)(this.field_145851_c + 6), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 6));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public String getName() {
        return "container.turbinegas";
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0], this.tanks[1], this.tanks[2]};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[3], this.smoke, this.smoke_leaded, this.smoke_poison};
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir != ForgeDirection.DOWN;
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return dir != ForgeDirection.DOWN;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineTurbineGas(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineTurbineGas(player.field_71071_by, this);
    }

    static {
        fuelMaxCons.put(Fluids.GAS, 50.0);
        fuelMaxCons.put(Fluids.SYNGAS, 10.0);
        fuelMaxCons.put(Fluids.OXYHYDROGEN, 100.0);
        fuelMaxCons.put(Fluids.REFORMGAS, 2.5);
    }
}

