/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import api.hbm.energy.IEnergyGenerator;
import api.hbm.fluid.IFluidStandardReceiver;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.inventory.FluidContainerRegistry;
import com.hbm.inventory.container.ContainerMachineSelenium;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Combustible;
import com.hbm.inventory.gui.GUIMachineSelenium;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityLoadedBase;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineSeleniumEngine
extends TileEntityLoadedBase
implements ISidedInventory,
IEnergyGenerator,
IFluidContainer,
IFluidAcceptor,
IFluidStandardReceiver,
IConfigurableMachine,
IGUIProvider {
    private ItemStack[] slots = new ItemStack[14];
    public long power;
    public int soundCycle = 0;
    public long powerCap = 250000L;
    public FluidTank tank = new FluidTank(Fluids.DIESEL, fluidCap, 0);
    public int pistonCount = 0;
    public static long maxPower = 250000L;
    public static int fluidCap = 16000;
    public static double pistonExp = 1.0;
    public static boolean shutUp = false;
    public static HashMap<FT_Combustible.FuelGrade, Double> fuelEfficiency = new HashMap();
    private static final int[] slots_top;
    private static final int[] slots_bottom;
    private static final int[] slots_side;
    private String customName;

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.machineSelenium";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (i == 9 && FluidContainerRegistry.getFluidContent(stack, this.tank.getTankType()) > 0) {
            return true;
        }
        return i == 13 && stack.func_77973_b() instanceof IBatteryItem;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("powerTime");
        this.powerCap = nbt.func_74763_f("powerCap");
        this.tank.readFromNBT(nbt, "fuel");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("powerTime", this.power);
        nbt.func_74772_a("powerCap", this.powerCap);
        this.tank.writeToNBT(nbt, "fuel");
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        if (i == 1 && (itemStack.func_77973_b() == ModItems.canister_empty || itemStack.func_77973_b() == ModItems.tank_steel)) {
            return true;
        }
        return i == 2 && itemStack.func_77973_b() instanceof IBatteryItem && ((IBatteryItem)itemStack.func_77973_b()).getCharge(itemStack) == ((IBatteryItem)itemStack.func_77973_b()).getMaxCharge();
    }

    public long getPowerScaled(long i) {
        return this.power * i / this.powerCap;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.subscribeToAllAround(this.tank.getTankType(), this);
            this.sendPower(this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, ForgeDirection.DOWN);
            this.pistonCount = this.countPistons();
            this.tank.setType(11, 12, this.slots);
            this.tank.loadTank(9, 10, this.slots);
            this.tank.updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            FluidType type = this.tank.getTankType();
            this.powerCap = type == Fluids.NITAN ? maxPower * 10L : maxPower;
            this.power = Library.chargeItemsFromTE(this.slots, 13, this.power, this.powerCap);
            if (this.pistonCount > 2) {
                this.generate();
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.pistonCount, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 150.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, (int)this.powerCap, 1), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
        }
    }

    public int countPistons() {
        int count = 0;
        for (int i = 0; i < 9; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.piston_selenium) continue;
            ++count;
        }
        return count;
    }

    public boolean hasAcceptableFuel() {
        return this.getHEFromFuel() > 0L;
    }

    public long getHEFromFuel() {
        return TileEntityMachineSeleniumEngine.getHEFromFuel(this.tank.getTankType());
    }

    public static long getHEFromFuel(FluidType type) {
        if (type.hasTrait(FT_Combustible.class)) {
            FT_Combustible fuel = type.getTrait(FT_Combustible.class);
            FT_Combustible.FuelGrade grade = fuel.getGrade();
            double efficiency = fuelEfficiency.containsKey((Object)grade) ? fuelEfficiency.get((Object)grade) : 0.0;
            return (long)((double)(fuel.getCombustionEnergy() / 1000L) * efficiency);
        }
        return 0L;
    }

    public void generate() {
        if (this.hasAcceptableFuel() && this.tank.getFill() > 0) {
            if (!shutUp) {
                if (this.soundCycle == 0) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "fireworks.blast", 1.0f, 0.5f);
                }
                ++this.soundCycle;
                if (this.soundCycle >= 3) {
                    this.soundCycle = 0;
                }
            }
            this.tank.setFill(this.tank.getFill() - this.pistonCount);
            if (this.tank.getFill() < 0) {
                this.tank.setFill(0);
            }
            this.power = (long)((double)this.power + (double)this.getHEFromFuel() * Math.pow(this.pistonCount, pistonExp));
            if (this.power > this.powerCap) {
                this.power = this.powerCap;
            }
        }
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return maxPower;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public void setFillForSync(int fill, int index) {
        this.tank.setFill(fill);
    }

    @Override
    public void setTypeForSync(FluidType type, int index) {
        this.tank.setTankType(type);
    }

    @Override
    public int getMaxFluidFill(FluidType type) {
        return type == this.tank.getTankType() ? this.tank.getMaxFill() : 0;
    }

    @Override
    public int getFluidFill(FluidType type) {
        return type == this.tank.getTankType() ? this.tank.getFill() : 0;
    }

    @Override
    public void setFluidFill(int i, FluidType type) {
        if (type == this.tank.getTankType()) {
            this.tank.setFill(i);
        }
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir == ForgeDirection.DOWN;
    }

    @Override
    public String getConfigName() {
        return "radialengine";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        maxPower = IConfigurableMachine.grab(obj, "L:powerCap", maxPower);
        fluidCap = IConfigurableMachine.grab(obj, "I:fuelCap", fluidCap);
        pistonExp = IConfigurableMachine.grab(obj, "D:pistonGenExponent", pistonExp);
        if (obj.has("D[:efficiency")) {
            JsonArray array = obj.get("D[:efficiency").getAsJsonArray();
            for (FT_Combustible.FuelGrade grade : FT_Combustible.FuelGrade.values()) {
                fuelEfficiency.put(grade, array.get(grade.ordinal()).getAsDouble());
            }
        }
        shutUp = IConfigurableMachine.grab(obj, "B:shutUp", shutUp);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("L:powerCap").value(maxPower);
        writer.name("I:fuelCap").value((long)fluidCap);
        writer.name("D:pistonGenExponent").value(pistonExp);
        String info = "Fuel grades in order: ";
        for (FT_Combustible.FuelGrade grade : FT_Combustible.FuelGrade.values()) {
            info = info + grade.name() + " ";
        }
        info = info.trim();
        writer.name("INFO").value(info);
        writer.name("D[:efficiency").beginArray().setIndent("");
        for (FT_Combustible.FuelGrade grade : FT_Combustible.FuelGrade.values()) {
            double d = fuelEfficiency.containsKey((Object)grade) ? fuelEfficiency.get((Object)grade) : 0.0;
            writer.value(d);
        }
        writer.endArray().setIndent("  ");
        writer.name("B:shutUp").value(shutUp);
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineSelenium(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineSelenium(player.field_71071_by, this);
    }

    static {
        fuelEfficiency.put(FT_Combustible.FuelGrade.LOW, 0.75);
        fuelEfficiency.put(FT_Combustible.FuelGrade.MEDIUM, 0.5);
        fuelEfficiency.put(FT_Combustible.FuelGrade.HIGH, 0.25);
        fuelEfficiency.put(FT_Combustible.FuelGrade.AERO, 0.0);
        slots_top = new int[]{0};
        slots_bottom = new int[]{1, 2};
        slots_side = new int[]{2};
    }
}

