/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.entity.missile.EntityMinerRocket;
import com.hbm.explosion.ExplosionNukeSmall;
import com.hbm.inventory.container.ContainerSatDock;
import com.hbm.inventory.gui.GUISatDock;
import com.hbm.items.ISatChip;
import com.hbm.saveddata.SatelliteSavedData;
import com.hbm.saveddata.satellites.Satellite;
import com.hbm.saveddata.satellites.SatelliteMiner;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.util.WeightedRandomObject;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;

public class TileEntityMachineSatDock
extends TileEntity
implements ISidedInventory,
IGUIProvider {
    private ItemStack[] slots = new ItemStack[16];
    private static final int[] access = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14};
    private String customName;
    private AxisAlignedBB renderBoundingBox;

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.satDock";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return i != 2 && i != 3 && i != 4 && i != 5;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return access;
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return true;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            SatelliteSavedData data = SatelliteSavedData.getData(this.field_145850_b);
            if (this.slots[15] != null) {
                int freq = ISatChip.getFreqS(this.slots[15]);
                Satellite sat = data.getSatFromFreq(freq);
                int delay = 600000;
                if (sat instanceof SatelliteMiner) {
                    SatelliteMiner miner = (SatelliteMiner)sat;
                    if (miner.lastOp + (long)delay < System.currentTimeMillis()) {
                        EntityMinerRocket rocket = new EntityMinerRocket(this.field_145850_b);
                        rocket.field_70165_t = (double)this.field_145851_c + 0.5;
                        rocket.field_70163_u = 300.0;
                        rocket.field_70161_v = (double)this.field_145849_e + 0.5;
                        rocket.func_70096_w().func_75692_b(17, (Object)freq);
                        this.field_145850_b.func_72838_d((Entity)rocket);
                        miner.lastOp = System.currentTimeMillis();
                        data.func_76185_a();
                    }
                }
            }
            List list = this.field_145850_b.func_94576_a(null, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 0.25 + 0.5), (double)((double)this.field_145848_d + 0.75), (double)((double)this.field_145849_e - 0.25 + 0.5), (double)((double)this.field_145851_c + 0.25 + 0.5), (double)(this.field_145848_d + 2), (double)((double)this.field_145849_e + 0.25 + 0.5)), entity -> entity instanceof EntityMinerRocket);
            for (EntityMinerRocket rocket : list) {
                if (this.slots[15] != null && ISatChip.getFreqS(this.slots[15]) != rocket.func_70096_w().func_75679_c(17)) {
                    rocket.func_70106_y();
                    ExplosionNukeSmall.explode(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, ExplosionNukeSmall.PARAMS_TOTS);
                    break;
                }
                if (rocket.func_70096_w().func_75679_c(16) != 1 || rocket.timer != 50) continue;
                Satellite sat = data.getSatFromFreq(ISatChip.getFreqS(this.slots[15]));
                this.unloadCargo((SatelliteMiner)sat);
            }
            this.ejectInto(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e);
            this.ejectInto(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e);
            this.ejectInto(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2);
            this.ejectInto(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2);
        }
    }

    private void unloadCargo(SatelliteMiner satellite) {
        int itemAmount = this.field_145850_b.field_73012_v.nextInt(6) + 10;
        WeightedRandom.Item[] cargo = satellite.getCargo();
        for (int i = 0; i < itemAmount; ++i) {
            ItemStack stack = ((WeightedRandomObject)WeightedRandom.func_76274_a((Random)this.field_145850_b.field_73012_v, (WeightedRandom.Item[])cargo)).asStack();
            this.addToInv(stack.func_77946_l());
        }
    }

    private void addToInv(ItemStack stack) {
        int i;
        for (i = 0; i < 15; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != stack.func_77973_b() || this.slots[i].func_77960_j() != stack.func_77960_j() || this.slots[i].field_77994_a >= this.slots[i].func_77976_d()) continue;
            int toAdd = Math.min(this.slots[i].func_77976_d() - this.slots[i].field_77994_a, stack.field_77994_a);
            this.slots[i].field_77994_a += toAdd;
            stack.field_77994_a -= toAdd;
            if (stack.field_77994_a > 0) continue;
            return;
        }
        for (i = 0; i < 15; ++i) {
            if (this.slots[i] != null) continue;
            this.slots[i] = new ItemStack(stack.func_77973_b(), 1, stack.func_77960_j());
            return;
        }
    }

    private void ejectInto(int x, int y, int z) {
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        if (te instanceof IInventory) {
            ItemStack sta;
            int j;
            int i;
            IInventory chest = (IInventory)te;
            for (i = 0; i < 15; ++i) {
                if (this.slots[i] == null) continue;
                for (j = 0; j < chest.func_70302_i_(); ++j) {
                    sta = this.slots[i].func_77946_l();
                    sta.field_77994_a = 1;
                    if (chest.func_70301_a(j) == null || !chest.func_70301_a(j).func_77969_a(this.slots[i]) || !ItemStack.func_77970_a((ItemStack)chest.func_70301_a(j), (ItemStack)this.slots[i]) || chest.func_70301_a((int)j).field_77994_a >= chest.func_70301_a(j).func_77976_d()) continue;
                    --this.slots[i].field_77994_a;
                    if (this.slots[i].field_77994_a <= 0) {
                        this.slots[i] = null;
                    }
                    ++chest.func_70301_a((int)j).field_77994_a;
                    return;
                }
            }
            for (i = 0; i < 15; ++i) {
                if (this.slots[i] == null) continue;
                for (j = 0; j < chest.func_70302_i_(); ++j) {
                    sta = this.slots[i].func_77946_l();
                    sta.field_77994_a = 1;
                    if (chest.func_70301_a(j) != null || !chest.func_94041_b(j, sta)) continue;
                    --this.slots[i].field_77994_a;
                    if (this.slots[i].field_77994_a <= 0) {
                        this.slots[i] = null;
                    }
                    chest.func_70299_a(j, sta);
                    return;
                }
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderBoundingBox == null) {
            this.renderBoundingBox = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 2));
        }
        return this.renderBoundingBox;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerSatDock(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUISatDock(player.field_71071_by, this);
    }
}

