/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.ReactorResearch;
import com.hbm.inventory.container.ContainerMachineReactorBreeding;
import com.hbm.inventory.gui.GUIMachineReactorBreeding;
import com.hbm.inventory.recipes.BreederRecipes;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityReactorResearch;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityMachineReactorBreeding
extends TileEntityMachineBase
implements SimpleComponent,
IGUIProvider {
    public int flux;
    public float progress;
    private static final int[] slots_io = new int[]{0, 1};
    AxisAlignedBB bb = null;

    public TileEntityMachineReactorBreeding() {
        super(2);
    }

    @Override
    public String getName() {
        return "container.reactorBreeding";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.flux = 0;
            this.getInteractions();
            if (this.canProcess()) {
                this.progress += 0.0025f * (float)(this.flux / BreederRecipes.getOutput((ItemStack)this.slots[0]).flux);
                if (this.progress >= 1.0f) {
                    this.progress = 0.0f;
                    this.processItem();
                    this.func_70296_d();
                }
            } else {
                this.progress = 0.0f;
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("flux", this.flux);
            data.func_74776_a("progress", this.progress);
            this.networkPack(data, 20);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.flux = data.func_74762_e("flux");
        this.progress = data.func_74760_g("progress");
    }

    public void getInteractions() {
        for (int d = 2; d < 6; d = (int)((byte)(d + 1))) {
            TileEntity tile;
            int[] pos;
            ForgeDirection dir = ForgeDirection.getOrientation((int)d);
            Block b = this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ);
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ);
            if (b != ModBlocks.reactor_research || (pos = ((ReactorResearch)ModBlocks.reactor_research).findCore(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ)) == null || !((tile = this.field_145850_b.func_147438_o(pos[0], pos[1], pos[2])) instanceof TileEntityReactorResearch)) continue;
            TileEntityReactorResearch reactor = (TileEntityReactorResearch)tile;
            this.flux += reactor.totalFlux;
        }
    }

    public boolean canProcess() {
        if (this.slots[0] == null) {
            return false;
        }
        BreederRecipes.BreederRecipe recipe = BreederRecipes.getOutput(this.slots[0]);
        if (recipe == null) {
            return false;
        }
        if (this.flux < recipe.flux) {
            return false;
        }
        if (this.slots[1] == null) {
            return true;
        }
        if (!this.slots[1].func_77969_a(recipe.output)) {
            return false;
        }
        return this.slots[1].field_77994_a < this.slots[1].func_77976_d();
    }

    private void processItem() {
        if (this.canProcess()) {
            BreederRecipes.BreederRecipe rec = BreederRecipes.getOutput(this.slots[0]);
            if (rec == null) {
                return;
            }
            ItemStack itemStack = rec.output;
            if (this.slots[1] == null) {
                this.slots[1] = itemStack.func_77946_l();
            } else if (this.slots[1].func_77969_a(itemStack)) {
                this.slots[1].field_77994_a += itemStack.field_77994_a;
            }
            --this.slots[0].field_77994_a;
            if (this.slots[0].field_77994_a <= 0) {
                this.slots[0] = null;
            }
        }
    }

    @Override
    public int[] func_94128_d(int side) {
        return slots_io;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        return i == 0;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i == 1;
    }

    public int getProgressScaled(int i) {
        return (int)(this.progress * (float)i);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.flux = nbt.func_74762_e("flux");
        this.progress = nbt.func_74760_g("progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("flux", this.flux);
        nbt.func_74776_a("progress", this.progress);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 1));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public String getComponentName() {
        return "breeding_reactor";
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getFlux(Context context, Arguments args) {
        return new Object[]{this.flux};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getProgress(Context context, Arguments args) {
        return new Object[]{Float.valueOf(this.progress)};
    }

    @Callback
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.flux, Float.valueOf(this.progress)};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineReactorBreeding(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineReactorBreeding(player.field_71071_by, this);
    }
}

