/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyGenerator;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.interfaces.IFluidSource;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.container.ContainerRadiolysis;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIRadiolysis;
import com.hbm.inventory.recipes.RadiolysisRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemRTGPellet;
import com.hbm.items.machine.ItemRTGPelletDepleted;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.RTGUtil;
import com.hbm.util.Tuple;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineRadiolysis
extends TileEntityMachineBase
implements IEnergyGenerator,
IFluidAcceptor,
IFluidSource,
IFluidContainer,
IFluidStandardTransceiver,
IGUIProvider {
    public long power;
    public static final int maxPower = 1000000;
    public int heat;
    public FluidTank[] tanks;
    public List<IFluidAcceptor> list1 = new ArrayList<IFluidAcceptor>();
    public List<IFluidAcceptor> list2 = new ArrayList<IFluidAcceptor>();
    private static final int[] slot_io = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 13};
    private static final int[] slot_rtg = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};

    public TileEntityMachineRadiolysis() {
        super(15);
        this.tanks = new FluidTank[3];
        this.tanks[0] = new FluidTank(Fluids.NONE, 2000, 0);
        this.tanks[1] = new FluidTank(Fluids.NONE, 2000, 1);
        this.tanks[2] = new FluidTank(Fluids.NONE, 2000, 2);
    }

    @Override
    public String getName() {
        return "container.radiolysis";
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        return i == 12 || i < 10 && itemStack.func_77973_b() instanceof ItemRTGPellet;
    }

    @Override
    public int[] func_94128_d(int side) {
        return slot_io;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i < 10 && itemStack.func_77973_b() instanceof ItemRTGPelletDepleted || i == 13;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.heat = nbt.func_74762_e("heat");
        this.tanks[0].readFromNBT(nbt, "input");
        this.tanks[1].readFromNBT(nbt, "output1");
        this.tanks[2].readFromNBT(nbt, "output2");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("heat", this.heat);
        this.tanks[0].writeToNBT(nbt, "input");
        this.tanks[1].writeToNBT(nbt, "output1");
        this.tanks[2].writeToNBT(nbt, "output2");
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.heat = data.func_74762_e("heat");
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeItemsFromTE(this.slots, 14, this.power, 1000000L);
            this.heat = RTGUtil.updateRTGs(this.slots, slot_rtg);
            this.power += (long)(this.heat * 10);
            if (this.power > 1000000L) {
                this.power = 1000000L;
            }
            this.tanks[0].setType(10, 11, this.slots);
            this.setupTanks();
            if (this.heat > 100) {
                int crackTime = (int)Math.max(-0.1 * (double)(this.heat - 100) + 30.0, 5.0);
                if (this.field_145850_b.func_82737_E() % (long)crackTime == 0L) {
                    this.crack();
                }
                if (this.heat >= 200 && this.field_145850_b.func_82737_E() % 100L == 0L) {
                    this.sterilize();
                }
            }
            if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                this.fillFluidInit(this.tanks[1].getTankType());
                this.fillFluidInit(this.tanks[2].getTankType());
            }
            for (DirPos pos : this.getConPos()) {
                this.sendPower(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                if (this.tanks[1].getFill() > 0) {
                    this.sendFluid(this.tanks[1], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
                if (this.tanks[2].getFill() <= 0) continue;
                this.sendFluid(this.tanks[2], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74768_a("heat", this.heat);
            this.networkPack(data, 50);
            for (int i = 0; i < 3; i = (int)((byte)(i + 1))) {
                this.tanks[i].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            }
        }
    }

    protected DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z)};
    }

    private void crack() {
        Tuple.Pair<FluidStack, FluidStack> quart = RadiolysisRecipes.getRadiolysis(this.tanks[0].getTankType());
        if (quart != null) {
            int left = quart.getKey().fill;
            int right = quart.getValue().fill;
            if (this.tanks[0].getFill() >= 100 && this.hasSpace(left, right)) {
                this.tanks[0].setFill(this.tanks[0].getFill() - 100);
                this.tanks[1].setFill(this.tanks[1].getFill() + left);
                this.tanks[2].setFill(this.tanks[2].getFill() + right);
            }
        }
    }

    private boolean hasSpace(int left, int right) {
        return this.tanks[1].getFill() + left <= this.tanks[1].getMaxFill() && this.tanks[2].getFill() + right <= this.tanks[2].getMaxFill();
    }

    private void setupTanks() {
        Tuple.Pair<FluidStack, FluidStack> quart = RadiolysisRecipes.getRadiolysis(this.tanks[0].getTankType());
        if (quart != null) {
            this.tanks[1].setTankType(quart.getKey().type);
            this.tanks[2].setTankType(quart.getValue().type);
        } else {
            this.tanks[0].setTankType(Fluids.NONE);
            this.tanks[1].setTankType(Fluids.NONE);
            this.tanks[2].setTankType(Fluids.NONE);
        }
    }

    private void sterilize() {
        if (this.slots[12] != null) {
            if (this.slots[12].func_77973_b() instanceof ItemFood && this.slots[12].func_77973_b() != ModItems.pancake) {
                --this.slots[12].field_77994_a;
                if (this.slots[12].field_77994_a <= 0) {
                    this.slots[12] = null;
                }
            }
            if (!this.checkIfValid()) {
                return;
            }
            ItemStack output = this.slots[12].func_77946_l();
            output.field_77994_a = 1;
            if (this.slots[13] == null) {
                this.slots[12].field_77994_a -= output.field_77994_a;
                if (this.slots[12].field_77994_a <= 0) {
                    this.slots[12] = null;
                }
                this.slots[13] = output;
                this.slots[13].field_77990_d.func_82580_o("ntmContagion");
                if (this.slots[13].field_77990_d.func_82582_d()) {
                    this.slots[13].field_77990_d = null;
                }
            } else if (this.slots[13].func_77969_a(output) && this.slots[13].field_77994_a + output.field_77994_a <= this.slots[13].func_77976_d()) {
                this.slots[12].field_77994_a -= output.field_77994_a;
                if (this.slots[12].field_77994_a <= 0) {
                    this.slots[12] = null;
                }
                this.slots[13].field_77994_a += output.field_77994_a;
                this.slots[13].field_77990_d.func_82580_o("ntmContagion");
                if (this.slots[13].field_77990_d.func_82582_d()) {
                    this.slots[13].field_77990_d = null;
                }
            }
        }
    }

    private boolean checkIfValid() {
        if (this.slots[12] == null) {
            return false;
        }
        if (!this.slots[12].func_77942_o()) {
            return false;
        }
        return this.slots[12].func_77978_p().func_74767_n("ntmContagion");
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    @Override
    public void setFillForSync(int fill, int index) {
        if (index < 3 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
    }

    @Override
    public void setFluidFill(int fill, FluidType type) {
        for (FluidTank tank : this.tanks) {
            if (tank.getTankType() != type) continue;
            tank.setFill(fill);
        }
    }

    @Override
    public void setTypeForSync(FluidType type, int index) {
        this.tanks[index].setTankType(type);
    }

    @Override
    public int getFluidFill(FluidType type) {
        for (FluidTank tank : this.tanks) {
            if (tank.getTankType() != type) continue;
            return tank.getFill();
        }
        return 0;
    }

    @Override
    public int getMaxFluidFill(FluidType type) {
        if (this.tanks[0].getTankType() == type) {
            return this.tanks[0].getMaxFill();
        }
        return 0;
    }

    @Override
    public void fillFluidInit(FluidType type) {
        this.fillFluid(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2, this.getTact(), type);
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public boolean getTact() {
        return this.field_145850_b.func_82737_E() % 20L < 10L;
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidType type) {
        if (type == this.tanks[1].getTankType()) {
            return this.list1;
        }
        if (type == this.tanks[2].getTankType()) {
            return this.list2;
        }
        return new ArrayList<IFluidAcceptor>();
    }

    @Override
    public void clearFluidList(FluidType type) {
        if (type == this.tanks[1].getTankType()) {
            this.list1.clear();
        }
        if (type == this.tanks[2].getTankType()) {
            this.list2.clear();
        }
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1], this.tanks[2]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN && dir != ForgeDirection.DOWN;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 2));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerRadiolysis(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIRadiolysis(player.field_71071_by, this);
    }
}

