/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.UpgradeManager;
import com.hbm.inventory.container.ContainerMixer;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIMixer;
import com.hbm.inventory.recipes.MixerRecipes;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityMachineMixer
extends TileEntityMachineBase
implements INBTPacketReceiver,
IControlReceiver,
IGUIProvider,
IEnergyUser,
IFluidStandardTransceiver {
    public long power;
    public static final long maxPower = 10000L;
    public int progress;
    public int processTime;
    public int recipeIndex;
    public float rotation;
    public float prevRotation;
    public boolean wasOn = false;
    private int consumption = 50;
    public FluidTank[] tanks = new FluidTank[3];
    AxisAlignedBB aabb;

    public TileEntityMachineMixer() {
        super(5);
        this.tanks[0] = new FluidTank(Fluids.NONE, 16000);
        this.tanks[1] = new FluidTank(Fluids.NONE, 16000);
        this.tanks[2] = new FluidTank(Fluids.NONE, 24000);
    }

    @Override
    public String getName() {
        return "container.machineMixer";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 10000L);
            this.tanks[2].setType(2, this.slots);
            UpgradeManager.eval(this.slots, 3, 4);
            int speedLevel = Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED), 3);
            int powerLevel = Math.min(UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER), 3);
            int overLevel = UpgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE);
            this.consumption = 50;
            this.consumption += speedLevel * 150;
            this.consumption = (int)((double)this.consumption - (double)(this.consumption * powerLevel) * 0.25);
            this.consumption *= overLevel * 3 + 1;
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                if (this.tanks[0].getTankType() != Fluids.NONE) {
                    this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                }
                if (this.tanks[1].getTankType() == Fluids.NONE) continue;
                this.trySubscribe(this.tanks[1].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            this.wasOn = this.canProcess();
            if (this.wasOn) {
                ++this.progress;
                this.power -= (long)this.getConsumption();
                this.processTime -= this.processTime * speedLevel / 4;
                this.processTime /= overLevel + 1;
                if (this.processTime <= 0) {
                    this.processTime = 1;
                }
                if (this.progress >= this.processTime) {
                    this.process();
                    this.progress = 0;
                }
            } else {
                this.progress = 0;
            }
            for (DirPos pos : this.getConPos()) {
                if (this.tanks[2].getFill() <= 0) continue;
                this.sendFluid(this.tanks[2], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74768_a("processTime", this.processTime);
            data.func_74768_a("progress", this.progress);
            data.func_74768_a("recipe", this.recipeIndex);
            data.func_74757_a("wasOn", this.wasOn);
            for (int i = 0; i < 3; ++i) {
                this.tanks[i].writeToNBT(data, i + "");
            }
            this.networkPack(data, 50);
        } else {
            this.prevRotation = this.rotation;
            if (this.wasOn) {
                this.rotation += 20.0f;
            }
            if (this.rotation >= 360.0f) {
                this.rotation -= 360.0f;
                this.prevRotation -= 360.0f;
            }
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.processTime = nbt.func_74762_e("processTime");
        this.progress = nbt.func_74762_e("progress");
        this.recipeIndex = nbt.func_74762_e("recipe");
        this.wasOn = nbt.func_74767_n("wasOn");
        for (int i = 0; i < 3; ++i) {
            this.tanks[i].readFromNBT(nbt, i + "");
        }
    }

    public boolean canProcess() {
        MixerRecipes.MixerRecipe[] recipes = MixerRecipes.getOutput(this.tanks[2].getTankType());
        if (recipes == null || recipes.length <= 0) {
            this.recipeIndex = 0;
            return false;
        }
        this.recipeIndex %= recipes.length;
        MixerRecipes.MixerRecipe recipe = recipes[this.recipeIndex];
        if (recipe == null) {
            this.recipeIndex = 0;
            return false;
        }
        this.tanks[0].setTankType(recipe.input1 != null ? recipe.input1.type : Fluids.NONE);
        this.tanks[1].setTankType(recipe.input2 != null ? recipe.input2.type : Fluids.NONE);
        if (recipe.input1 != null && this.tanks[0].getFill() < recipe.input1.fill) {
            return false;
        }
        if (recipe.input2 != null && this.tanks[1].getFill() < recipe.input2.fill) {
            return false;
        }
        if (this.power < (long)this.getConsumption()) {
            return false;
        }
        if (recipe.output + this.tanks[2].getFill() > this.tanks[2].getMaxFill()) {
            return false;
        }
        if (recipe.solidInput != null) {
            if (this.slots[1] == null) {
                return false;
            }
            if (!recipe.solidInput.matchesRecipe(this.slots[1], true) || recipe.solidInput.stacksize > this.slots[1].field_77994_a) {
                return false;
            }
        }
        this.processTime = recipe.processTime;
        return true;
    }

    protected void process() {
        MixerRecipes.MixerRecipe[] recipes = MixerRecipes.getOutput(this.tanks[2].getTankType());
        MixerRecipes.MixerRecipe recipe = recipes[this.recipeIndex % recipes.length];
        if (recipe.input1 != null) {
            this.tanks[0].setFill(this.tanks[0].getFill() - recipe.input1.fill);
        }
        if (recipe.input2 != null) {
            this.tanks[1].setFill(this.tanks[1].getFill() - recipe.input2.fill);
        }
        if (recipe.solidInput != null) {
            this.func_70298_a(1, recipe.solidInput.stacksize);
        }
        this.tanks[2].setFill(this.tanks[2].getFill() + recipe.output);
    }

    public int getConsumption() {
        return this.consumption;
    }

    protected DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, Library.NEG_Y), new DirPos(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, Library.NEG_Z)};
    }

    @Override
    public int[] func_94128_d(int meta) {
        return new int[]{1};
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        MixerRecipes.MixerRecipe[] recipes = MixerRecipes.getOutput(this.tanks[2].getTankType());
        if (recipes == null || recipes.length <= 0) {
            return false;
        }
        MixerRecipes.MixerRecipe recipe = recipes[this.recipeIndex % recipes.length];
        if (recipe == null || recipe.solidInput == null) {
            return false;
        }
        return recipe.solidInput.matchesRecipe(itemStack, true);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74762_e("progress");
        this.processTime = nbt.func_74762_e("processTime");
        this.recipeIndex = nbt.func_74762_e("recipe");
        for (int i = 0; i < 3; ++i) {
            this.tanks[i].readFromNBT(nbt, i + "");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74768_a("processTime", this.processTime);
        nbt.func_74768_a("recipe", this.recipeIndex);
        for (int i = 0; i < 3; ++i) {
            this.tanks[i].writeToNBT(nbt, i + "");
        }
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return 10000L;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[2]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0], this.tanks[1]};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMixer(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMixer(player.field_71071_by, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.aabb != null) {
            return this.aabb;
        }
        this.aabb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 1));
        return this.aabb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return player.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 16.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("toggle")) {
            ++this.recipeIndex;
        }
    }
}

